/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.transformation;

import java.sql.Date;
import java.util.HashMap;
import javax.persistence.EntityManager;
import rs.pezar.core.transformation.DefaultDokumentTransformer;
import rs.pezar.core.transformation.DokumentTransformer;
import rs.pezar.db.PzDokument;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Lista;
import rs.pezar.prodaja.gui.PzDialogFaktureArhiva;
import rs.pezar.prodaja.gui.PzDialogIzradaFaktureZaProdajuRobe;
import rs.pezar.prodaja.transformation.FakturaTransformerParametri;
import rs.pezar.prodaja.util.PzProdajaUtil;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogChoice;
import rs.pezar.util.PzDateUtility;

public class FakturaTransformer
extends DokumentTransformer {
    public static final String PARAMETER_RJ = "RJ";
    public static final String PARAMETER_TIP = "TIP_DOKUMENTA";
    public static final String TRANSFORMER = "FAKTURA_TRANSFORMER";
    public static final String PARAMETER_KOMITENT = "KOMITENT";
    public static final String PARAMETER_DATUM_IZRADE = "DATUM_IZRADE";
    public static final String PARAMETER_DATUM_PROMETA = "DATUM_PROMETA";
    public static final String PARAMETER_DATUM_VALUTE = "DATUM_VALUTE";
    public static final String PARAMETER_KURS = "KURS";
    public boolean priprema = false;

    public HashMap<String, Object> getDokumentParameters(PzDialog parent, Lista l) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parent.getSession().putParameter(TRANSFORMER, parameters);
        parent.getSession().putParameter(PARAMETER_TIP, (Object)"FAKTURA");
        parent.showDialog(FakturaTransformerParametri.class);
        parent.getSession().putParameter(TRANSFORMER, null);
        if (parameters.get(PARAMETER_RJ) == null) {
            return null;
        }
        return parameters;
    }

    public PzDokument getDokumentToTransform(PzDialog parent) {
        PzChoice[] choices = new PzChoice[]{new PzChoice("Faktura iz arhive", (Object)"ARHIVA"), new PzChoice("Faktura u pripremi", (Object)"U_PRIPREMI")};
        String choice = (String)PzDialogChoice.showPzDialogChoice((PzDialog)parent, (PzChoice[])choices, (String)"Izabor fakture");
        if (choice == null) {
            return null;
        }
        if (choice.equals("ARHIVA")) {
            return PzDialogFaktureArhiva.getFakturaIzArhive(parent, "faktura");
        }
        this.priprema = true;
        return PzDialogIzradaFaktureZaProdajuRobe.getFakturaUPripermi(parent, "izradaFaktureZaProdajuRobe");
    }

    public PzDokument toDokument(Lista l, HashMap<String, Object> parameters, EntityManager em) throws Exception {
        Faktura rez = null;
        Faktura f = (Faktura)PzProdajaUtil.toFaktura(l, parameters, em);
        if (f != null) {
            rez = f;
        }
        return rez;
    }

    public Lista toLista(PzDokument dokument, HashMap<String, Object> parameters, EntityManager em) throws Exception {
        Lista l = new DefaultDokumentTransformer(Faktura.class, Artikalfaktura.class).toLista(dokument, parameters, em);
        if (this.priprema) {
            l.setNaslov("Faktura za komitenta " + dokument.getKomitent().getSfrKomitent() + " od " + PzDateUtility.formatDate((Date)dokument.getDatum()));
        } else {
            l.setNaslov("Faktura za komitenta " + dokument.getKomitent().getSfrKomitent() + " od " + PzDateUtility.formatDate((Date)dokument.getDatum()) + " broj " + dokument.getrBroj());
        }
        return l;
    }

    public String getName() {
        return "Transformator fakture";
    }

    public String getDescription() {
        return null;
    }
}

