/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.faktureZaProdajuRobe.arhivaStampa;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.text.DefaultFormatterFactory;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntityManager;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.swing.util.RegexFormatter;

public class UnosOznake
extends PzDialog {
    private static final long serialVersionUID = -4734471008231143192L;
    private PzPanel mainPanel;
    private JLabel labelOznaka;
    private PzTextField tfOznaka;
    private PzFieldIndikator indOznaka;
    private PzButton btnOk;

    public UnosOznake(PzDialog dialog) {
        super(dialog);
        this.initGUI();
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        this.mainPanel = new PzPanel();
        this.mainPanel.setLayout((LayoutManager)new BorderLayout());
        try {
            this.setContentPane((Container)this.mainPanel);
            GridBagLayout thisLayout = new GridBagLayout();
            thisLayout.columnWidths = new int[]{60, 130, 150};
            thisLayout.columnWeights = new double[]{0.0, 0.0, 0.0};
            thisLayout.rowWeights = new double[]{0.0, 0.0};
            thisLayout.rowHeights = new int[]{25, 35};
            this.setTitle("Unos oznake fakture");
            this.mainPanel.setLayout((LayoutManager)thisLayout);
            this.labelOznaka = new JLabel();
            this.mainPanel.add((Component)this.labelOznaka, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.labelOznaka.setText("Oznaka:");
            this.tfOznaka = new PzTextField();
            this.tfOznaka.setMaxLength(30);
            this.mainPanel.add((Component)this.tfOznaka, (Object)new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 30), 0, 0));
            RegexFormatter formatter = new RegexFormatter("(\\d+\\W*)+");
            DefaultFormatterFactory factory = new DefaultFormatterFactory((JFormattedTextField.AbstractFormatter)formatter, (JFormattedTextField.AbstractFormatter)formatter, (JFormattedTextField.AbstractFormatter)formatter);
            formatter.setAllowsInvalid(false);
            formatter.setCommitsOnValidEdit(true);
            this.tfOznaka.setFormatterFactory((JFormattedTextField.AbstractFormatterFactory)factory);
            this.indOznaka = new PzFieldIndikator();
            this.mainPanel.add((Component)this.indOznaka, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 1, 10), 0, 0));
            this.tfOznaka.setStateIndikator(this.indOznaka);
            this.tfOznaka.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    String ret = UnosOznake.this.postojiOznaka(UnosOznake.this.tfOznaka.getText());
                    UnosOznake.this.indOznaka.setState(PzFieldIndikator.STATE_INVALID);
                    if (!ret.equals("")) {
                        PzSwingUtility.showInformationMessage((Component)UnosOznake.this.tfOznaka, (String)ret);
                        return false;
                    }
                    if (UnosOznake.this.tfOznaka.getVal().trim().length() == 0) {
                        return false;
                    }
                    UnosOznake.this.indOznaka.setState(PzFieldIndikator.STATE_VALID);
                    return true;
                }
            });
            this.btnOk = new PzButton();
            this.mainPanel.add((Component)this.btnOk, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
            this.btnOk.setText("Potvrdi");
            this.btnOk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check.png")));
            this.btnOk.addActionListener((ActionListener)((Object)this));
            this.btnOk.setActionCommand("potvrdi");
            this.pack();
            this.paintPanel();
            this.setResizable(false);
            this.mainPanel.updateAllFieldsState();
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        System.out.println("stanje " + this.tfOznaka.getState());
        if (this.mainPanel.validateForm(true)) {
            this.getSession().putParameter("oznaka", (Object)this.tfOznaka.getVal().trim());
            this.dispose();
        }
    }

    public static Object getGUIBuilderInstance() {
        return new UnosOznake(Boolean.FALSE);
    }

    public UnosOznake(Boolean initGUI) {
    }

    private String postojiOznaka(String oznaka) {
        EntityManager em = PzEntityManager.getEm();
        try {
            em.createQuery("select f.idDok from Faktura f where f.oznDokumenta =:oznaka").setParameter("oznaka", (Object)oznaka.trim()).getSingleResult();
            return "Postoji faktura sa unetom oznakom!";
        }
        catch (Exception ex) {
            if (ex instanceof NoResultException) {
                return "";
            }
            return "Gre\u0161ka prilikom provere postojanja fakture sa unetom oznakom! Poku\u0161tajte ponovo.";
        }
        finally {
            em.close();
        }
    }
}

