/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui.faktureZaProdajuRobe;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.jdesktop.application.Application;
import rs.pezar.core.PzApplication;
import rs.pezar.core.PzGenericService;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzDefaultDokumentCustomizer;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentCustomizer;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikalfaktura;
import rs.pezar.db.entity.Artikalnivelacija;
import rs.pezar.db.entity.EDokument;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturaparameter;
import rs.pezar.db.entity.Fakturaservisa;
import rs.pezar.db.entity.Fizickolice;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Tekuciracun;
import rs.pezar.db.entity.Uplata;
import rs.pezar.db.management.PzPorukeManager;
import rs.pezar.efaktura.EDokumentAttachments;
import rs.pezar.efaktura.EDokumentTransport;
import rs.pezar.efaktura.EDokumentValidator;
import rs.pezar.efaktura.gui.PzDialogAttachments;
import rs.pezar.efaktura.gui.PzDialogTaxExemption;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.prodaja.gui.PzDialogFakturaAutomobila;
import rs.pezar.prodaja.gui.PzDialogInterniRacun;
import rs.pezar.prodaja.gui.faktureServisa.PodaciOServisiranomSredstvu;
import rs.pezar.prodaja.gui.faktureZaProdajuRobe.IzradaFaktureIzRJ;
import rs.pezar.prodaja.gui.faktureZaProdajuRobe.ZatvoriFakturuKupcaAvansom;
import rs.pezar.prodaja.gui.faktureZaProdajuRobe.arhivaStampa.UnosOznake;
import rs.pezar.prodaja.gui.fakturisanjeOtpremnica.FakturisanjeOtpremnica;
import rs.pezar.prodaja.util.PzProdajaUtil;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.rf.FakturaRF;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.komintenti.PzDialogLokacije;
import rs.pezar.sifarnici.util.KomitentPrometUtility;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzTextAreaPanel;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class ArhivaStampa
extends PzDialog {
    public static final String SA_POREZOM = "Sa porezom";
    public static final String BEZ_POREZA = "Bez poreza";
    public static final String SA_PRAVOM = "Sa pravom na odbitak";
    public static final String BEZ_PRAVA = "Bez prava na odbitak";
    public static final String SA_NIVELACIJOM = "Sa nivelacijom";
    public static final String BEZ_NIVELACIJE = "Bez nivelacije";
    public static final String UKUPNA_KOLICINA = "Na ukupnu koli\u010dinu";
    public static final String KOLICINA_ZA_PRODAJU = "Na koli\u010dinu za prodaju";
    public static final String RACUN = "Ra\u010dun";
    public static final String OTPREMNICA_RACUN = "Ra\u010dun-otpremnica";
    public static final String KLASICNA_FAKTURA = "Klasi\u010dna faktura";
    public static final String FAKTURA_ZA_IZVOZ = "Faktura za izvoz";
    public static final String OTPREMNICA_SA_CENAMA = "Sa cenama stavki";
    public static final String OTPREMNICA_BEZ_CENA = "Bez cena stavki";
    public static final String PROPERTIES_OTPREMNICE = "OTPREMNICA_SA";
    public static final String PROPERTIES_ROBU_IZDAO = "ROBU_IZDAO";
    public static final String PROPERTIES_ROBU_PRIMIO = "ROBU_PRIMIO";
    public static final String PROPERTIES_LICNA_KARTA = "LICNA_KARTA";
    private static final String LOKACIJA = "lokacija";
    private static final long serialVersionUID = 1L;
    private PzPanel pnlDugmad;
    private PzPanel pnlGlavni;
    private JLabel lblKupac;
    private JLabel lblLicnaKarta;
    private JLabel lblRobuPrimio;
    private JLabel lblRobuIzdao;
    private JLabel lblSifraKomercijaliste;
    private JLabel lblNacinOtpreme;
    private PzTextField nazivKupca;
    private JLabel lblPoruka;
    private PzTextField tfOtpremnica;
    private PzTextField tfFaktura;
    private JLabel lblOtpremnica;
    private JLabel lblFaktura;
    private PzTextAreaPanel jTextArea1;
    private PzPanel panelRoba;
    private PzPanel panelOtpremnica;
    private PzPanel panelAvans;
    private PzButton btnAvans;
    private PzPanel panelDatumi;
    private PzPanel panelRBs;
    private PzTable tblTabela;
    private JScrollPane scTabela;
    private PzPanel plTabela;
    private JCheckBox cbEfaktura;
    private PzPanel panelTabela;
    private PzDoubleField ostatakA;
    private JLabel jlAvans;
    private JLabel jLabel1;
    private PzDateField dfDatumValute;
    private PzRadioGroup<String> panelTipDok;
    private PzButton btnSacuvajPodesavanja;
    private PzTextField tfJMBG;
    private PzTextField tfMesto;
    private PzTextField tfAdresa;
    private PzTextField tfImePrezime;
    private JLabel jlJMBG;
    private JLabel jlMesto;
    private JLabel jlAdresa;
    private JLabel jlImePrezime;
    private PzPanel panelFL;
    private PzRadioGroup<String> panelFaktura;
    private PzRadioGroup<String> panelNaslov;
    private PzRadioGroup<String> panelTipOtpremnice;
    private PzRadioGroup<String> panelTipN;
    private PzRadioGroup<String> panelNivelacija;
    private PzRadioGroup<String> panelBezP;
    private PzTextField tfSifraKomercijaliste;
    private PzButton btnPotvrdi;
    private PzTextField tfLicnaKarta;
    private PzTextField tfRobuPrimio;
    private PzTextField tfRobuIzdao;
    private PzTextField tfNacinOtpreme;
    private PzDateField dfDatumPrometa;
    private JLabel lblDatumPrometa;
    private PzDateField dfDatumIzrade;
    private PzTextField nfSifraKupca;
    private JLabel lblDatumIzrade;
    private Faktura f;
    private Komitent komitent;
    private boolean unoseSeSredstva;
    private PropertiesConfiguration props;
    private File confFile;
    boolean saNivel = false;
    private PzPanel mainPanel;
    private Vector<Uplata> uplataList;
    private boolean fakAutomobila = false;
    private String taxExemption;
    private JCheckBox cbPrilozi;
    private EDokumentAttachments eAttachments;

    public ArhivaStampa(PzDialog dialog) {
        super(dialog);
        this.f = (Faktura)this.getSession().getParameter("faktura");
        this.fakAutomobila = this.f.getPodTip() != null && this.f.getPodTip().equals(TipDokumentConfig.get().PODTIP_FAKTURA_AUTOMOBILA);
        if (this.f.getTip().equals("FAKTURA_IZ_SERVISA")) {
            this.unoseSeSredstva = Boolean.valueOf(this.getSession().getParameter("sredstva").toString());
        }
        this.loadProperties();
        this.initGUI();
        this.setEnabledComponents(this.f);
        this.postInit();
        if (!(this.f.getTip().equals("FAKTURA_INTERNI_RACUN") || this.f.getTip().equals("FAKTURA_IZ_SERVISA") || this.fakAutomobila || this.f.getKomitent().getTip() != 2)) {
            this.enablePodaciOFizickomLicu(true);
        } else {
            this.enablePodaciOFizickomLicu(false);
        }
        this.enableFromProperties();
        if (!(this.f.getTip().equals("FAKTURA_INTERNI_RACUN") || this.f.getTip().equals("FAKTURA_IZ_SERVISA") || this.fakAutomobila || this.f.getKomitent().getDomaciKomitent() != 0)) {
            this.panelTipDok.setSelectedValue((Object)BEZ_POREZA);
        }
        if (this.f.izMaloprodaje()) {
            this.panelNivelacija.setSelectedValue((Object)SA_NIVELACIJOM);
            this.panelTipN.setSelectedValue((Object)KOLICINA_ZA_PRODAJU);
            if (this.f.getRadnajedinica().getTip().equals("EV")) {
                this.panelTipN.setEnabled(false);
            }
        }
        if (!Arrays.asList("FAKTURA", "AVANSNI_RACUN", "FAKTURA_IZ_SERVISA").contains(this.f.getTip())) {
            this.cbEfaktura.setSelected(false);
            this.cbEfaktura.setEnabled(false);
        }
        this.cbPrilozi.setEnabled(this.cbEfaktura.isSelected());
    }

    public ArhivaStampa() {
        this.initGUI();
    }

    public void postInit() {
        if (!(this.f.getTip().equals("FAKTURA_INTERNI_RACUN") || this.f.getTip().equals("FAKTURA_IZ_SERVISA") || this.fakAutomobila)) {
            this.nfSifraKupca.setVal((Object)this.f.getKomitent().getSfrKomitent());
            this.nazivKupca.setVal((Object)this.f.getKomitent().getNaziv());
        }
        if (this.f.getTip().equals("FAKTURA_IZ_SERVISA") || this.fakAutomobila) {
            this.nfSifraKupca.setFocusable(true);
            this.nfSifraKupca.setEditable(true);
            this.setFirstComponentInFocus((Component)this.nfSifraKupca);
            if (this.f.getKomitent() != null) {
                this.nfSifraKupca.setVal((Object)this.f.getKomitent().getSfrKomitent());
                this.nazivKupca.setVal((Object)this.f.getKomitent().getNaziv());
            }
        } else if (!this.f.getTip().equals("PRENOSNICA_SA_KONSIGNACIJE")) {
            this.dfDatumIzrade.setVal((Object)this.f.getDatum());
            this.dfDatumPrometa.setVal((Object)this.f.getDatPrometa());
            this.dfDatumValute.setVal((Object)this.f.getDatValute());
            this.setFirstComponentInFocus((Component)this.dfDatumIzrade);
        }
        if (this.f.getZaOtpremnice() == 1) {
            String otpremnice = new String();
            for (Faktura faktura : this.f.getFakturas()) {
                otpremnice = String.valueOf(otpremnice) + faktura.getOznDokumenta() + "; ";
            }
            this.tfOtpremnica.setVal((Object)otpremnice);
        }
        if (this.f.getKomitent() != null && this.f.getTip().equals("FAKTURA")) {
            this.ostatakA.setEnabled(true);
            this.jlAvans.setEnabled(true);
            try {
                this.ostatakA.setVal((Object)KomitentPrometUtility.getOstatakAvansaKupci((String)this.f.getKomitent().getSfrKomitent()));
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        }
    }

    public void setDisabledComponents(Faktura f) {
        this.panelTipDok.setEnabled(false);
        this.panelBezP.setEnabled(false);
        if (f.getTip().equals("FAKTURA_TRANZITA")) {
            this.panelFaktura.setEnabled(false);
            this.lblPoruka.setEnabled(false);
        }
        if (!f.getRadnajedinica().getgTip().equals("E")) {
            this.tfNacinOtpreme.setEnabled(false);
            this.lblNacinOtpreme.setEnabled(false);
        }
        if (f.getTip().equals("OTPREMNICA")) {
            this.panelTipOtpremnice.setEnabled(false);
        }
        this.tfSifraKomercijaliste.setEnabled(false);
        this.lblSifraKomercijaliste.setEnabled(false);
        this.tfOtpremnica.setEnabled(false);
        this.lblOtpremnica.setEnabled(false);
        this.panelNivelacija.setEnabled(false);
        this.panelTipN.setEnabled(false);
        this.panelNaslov.setEnabled(false);
        this.dfDatumIzrade.setEnabled(false);
        this.dfDatumPrometa.setEnabled(false);
        this.dfDatumValute.setEnabled(false);
        this.tfRobuIzdao.setEnabled(false);
        this.tfRobuPrimio.setEnabled(false);
        this.tfLicnaKarta.setEnabled(false);
    }

    public void setEnabledComponents(Faktura f) {
        this.panelTipDok.setEnabled(true);
        if (f.getTip().equals("AVANSNI_RACUN")) {
            this.setTitle("Setup za arhiviranje avansnog ra\u010duna");
            this.panelNivelacija.setEnabled(false);
            this.panelTipN.setEnabled(false);
            this.cbEfaktura.setSelected(true);
        } else if (f.getTip().equals("PROFAKTURA")) {
            this.panelTipDok.setEnabled(true);
            this.setTitle("Setup za arhiviranje profakture");
            this.panelNivelacija.setEnabled(false);
            this.panelTipN.setEnabled(false);
        } else if (f.getTip().equals("FAKTURA_INTERNI_RACUN")) {
            this.setTitle("Setup za arhiviranje internog ra\u010duna (kupi za sebe)");
            this.nfSifraKupca.setVisible(false);
            this.nazivKupca.setVisible(false);
            this.dfDatumPrometa.setVisible(false);
            this.lblDatumPrometa.setVisible(false);
            this.jLabel1.setVisible(false);
            this.dfDatumValute.setVisible(false);
            this.lblKupac.setVisible(false);
            this.tfRobuIzdao.setEnabled(false);
            this.tfRobuPrimio.setEnabled(false);
            this.tfLicnaKarta.setEnabled(false);
        } else if (f.getTip().equals("OTPREMNICA") || f.getTip().equals("PRENOSNICA_SA_KONSIGNACIJE")) {
            this.tfNacinOtpreme.setEnabled(true);
            this.lblNacinOtpreme.setEnabled(true);
            this.tfSifraKomercijaliste.setEnabled(true);
            this.lblSifraKomercijaliste.setEnabled(true);
            this.tfRobuIzdao.setEnabled(true);
            this.lblRobuIzdao.setEnabled(true);
            this.tfRobuPrimio.setEnabled(true);
            this.lblRobuPrimio.setEnabled(true);
            this.tfLicnaKarta.setEnabled(true);
            this.lblLicnaKarta.setEnabled(true);
            this.panelNivelacija.setEnabled(false);
            this.panelTipN.setEnabled(false);
            if (f.getTip().equals("OTPREMNICA")) {
                this.setTitle("Setup za arhiviranje otpremnice");
                this.panelTipOtpremnice.setEnabled(true);
            } else {
                this.setTitle("Setup za arhiviranje prenosnice sa konsignacije");
            }
        } else if (f.getTip().equals("FAKTURA_TRANZITA")) {
            this.tfFaktura.setEnabled(true);
            this.lblFaktura.setEnabled(true);
            this.tfOtpremnica.setEnabled(true);
            this.lblOtpremnica.setEnabled(true);
            this.panelFaktura.setEnabled(true);
            this.lblPoruka.setEnabled(true);
            this.setTitle("Setup za arhiviranje fakture tranzita");
            this.panelNivelacija.setEnabled(false);
            this.panelTipN.setEnabled(false);
        } else if (f.getZaOtpremnice() == 1) {
            this.panelNaslov.setEnabled(true);
            this.tfNacinOtpreme.setEnabled(true);
            this.lblNacinOtpreme.setEnabled(true);
            this.tfSifraKomercijaliste.setEnabled(true);
            this.lblSifraKomercijaliste.setEnabled(true);
            this.tfOtpremnica.setEnabled(true);
            this.lblOtpremnica.setEnabled(true);
            this.setTitle("Setup za arhiviranje fakture");
            this.cbEfaktura.setSelected(!f.izMaloprodaje());
        } else if (f.getTip().equals("FAKTURA") || f.getTip().equals("FAKTURA_IZ_SERVISA")) {
            if (f.getRadnajedinica().getgTip().equals("V") || f.getRadnajedinica().getgTip().equals("T") || f.getRadnajedinica().getgTip().equals("K") || f.getRadnajedinica().getgTip().equals("G")) {
                if (!this.fakAutomobila) {
                    this.panelNaslov.setEnabled(true);
                }
                this.tfNacinOtpreme.setEnabled(true);
                this.lblNacinOtpreme.setEnabled(true);
                this.tfSifraKomercijaliste.setEnabled(true);
                this.lblSifraKomercijaliste.setEnabled(true);
                this.tfOtpremnica.setEnabled(true);
                this.lblOtpremnica.setEnabled(true);
                this.cbEfaktura.setSelected(true);
            } else {
                this.panelTipDok.setEnabled(false);
                this.panelBezP.setEnabled(false);
                this.panelNaslov.setEnabled(true);
                this.tfNacinOtpreme.setEnabled(true);
                this.lblNacinOtpreme.setEnabled(true);
                this.tfSifraKomercijaliste.setEnabled(true);
                this.lblSifraKomercijaliste.setEnabled(true);
                this.tfOtpremnica.setEnabled(true);
                this.lblOtpremnica.setEnabled(true);
            }
            this.setTitle("Setup za arhiviranje fakture");
        }
        if (f.izMaloprodaje()) {
            this.panelTipDok.setEnabled(false);
        }
        if (this.fakAutomobila) {
            this.panelNaslov.setSelectedValue((Object)OTPREMNICA_RACUN);
        }
        this.cbEfaktura.setEnabled(PzParameter.getBoolean((String)"EFAKTURA", (boolean)false));
        if (!this.cbEfaktura.isEnabled() || f.izMaloprodaje()) {
            this.cbEfaktura.setSelected(false);
        }
    }

    private void enablePodaciOFizickomLicu(boolean enabled) {
        this.tfAdresa.setEnabled(enabled);
        this.tfImePrezime.setEnabled(enabled);
        this.tfMesto.setEnabled(enabled);
        this.tfJMBG.setEnabled(enabled);
        this.jlAdresa.setEnabled(enabled);
        this.jlImePrezime.setEnabled(enabled);
        this.jlMesto.setEnabled(enabled);
        this.jlJMBG.setEnabled(enabled);
        if (enabled) {
            this.tfImePrezime.setVal((Object)(this.komitent == null ? this.f.getKomitent().getNaziv() : this.komitent.getNaziv()));
            this.tfAdresa.setVal((Object)(this.komitent == null ? this.f.getKomitent().getAdresa() : this.komitent.getAdresa()));
            this.tfMesto.setVal((Object)(this.komitent == null ? this.f.getKomitent().getGrad() : this.komitent.getGrad()));
            this.tfJMBG.setVal((Object)(this.komitent == null ? this.f.getKomitent().getMatBroj() : this.komitent.getMatBroj()));
        }
    }

    private void enableFromProperties() {
        boolean pom;
        if (this.panelTipDok.isEnabled()) {
            pom = Boolean.parseBoolean(this.props.getProperty("SA_POREZOM").toString());
            this.panelTipDok.setSelectedValue((Object)(pom ? SA_POREZOM : BEZ_POREZA));
            pom = Boolean.parseBoolean(this.props.getProperty("SA_PRAVOM").toString());
            this.panelBezP.setSelectedValue((Object)(pom ? SA_PRAVOM : BEZ_PRAVA));
        }
        if (this.panelNivelacija.isEnabled()) {
            pom = Boolean.parseBoolean(this.props.getProperty("SA_NIVELACIJOM").toString());
            this.panelNivelacija.setSelectedValue((Object)(pom ? SA_NIVELACIJOM : BEZ_NIVELACIJE));
            pom = Boolean.parseBoolean(this.props.getProperty("UKUPNA_KOLICINA").toString());
            this.panelTipN.setSelectedValue((Object)(pom ? UKUPNA_KOLICINA : KOLICINA_ZA_PRODAJU));
        }
        if (this.panelNaslov.isEnabled()) {
            pom = Boolean.parseBoolean(this.props.getProperty("RACUN").toString());
            this.panelNaslov.setSelectedValue((Object)(pom ? RACUN : OTPREMNICA_RACUN));
        }
        if (this.panelFaktura.isEnabled()) {
            pom = Boolean.parseBoolean(this.props.getProperty("KLASICNA_FAKTURA").toString());
            this.panelFaktura.setSelectedValue((Object)(pom ? KLASICNA_FAKTURA : FAKTURA_ZA_IZVOZ));
        }
        if (this.panelTipOtpremnice.isEnabled()) {
            pom = true;
            try {
                pom = Boolean.parseBoolean(this.props.getProperty(PROPERTIES_OTPREMNICE).toString());
            }
            catch (Exception exception) {}
            this.panelTipOtpremnice.setSelectedValue((Object)(pom ? OTPREMNICA_SA_CENAMA : OTPREMNICA_BEZ_CENA));
        }
    }

    private void paintPanel() {
        this.mainPanel.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.mainPanel.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.mainPanel.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        this.mainPanel = new PzPanel();
        this.mainPanel.setLayout((LayoutManager)new BorderLayout());
        try {
            this.setContentPane((Container)this.mainPanel);
            this.pnlDugmad = new PzPanel();
            this.pnlDugmad.setOpaque(false);
            GridBagLayout pnlDugmadLayout = new GridBagLayout();
            pnlDugmadLayout.rowWeights = new double[]{0.1};
            pnlDugmadLayout.rowHeights = new int[]{7};
            pnlDugmadLayout.columnWeights = new double[]{0.0, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1};
            pnlDugmadLayout.columnWidths = new int[]{135, 7, 7, 7, 7, 7, 7, 7, 7, 7};
            this.pnlDugmad.setLayout((LayoutManager)pnlDugmadLayout);
            this.getContentPane().add((Component)this.pnlDugmad, "South");
            this.pnlDugmad.setPreferredSize(new Dimension(892, 45));
            this.btnPotvrdi = new PzButton();
            this.pnlDugmad.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(0, 0, 8, 1, 0.0, 0.0, 11, 3, new Insets(0, 0, 5, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi|(Ctrl+W)");
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(160, 30));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.setShortcut("ctrl+w");
            this.btnPotvrdi.setName("btnPotvrdi");
            this.btnSacuvajPodesavanja = new PzButton();
            this.pnlDugmad.add((Component)this.btnSacuvajPodesavanja, (Object)new GridBagConstraints(2, 0, 9, 1, 0.0, 0.0, 11, 3, new Insets(0, 0, 5, 0), 0, 0));
            this.btnSacuvajPodesavanja.setText("Snimi pode\u0161avanja|(Ctrl+S)");
            this.btnSacuvajPodesavanja.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/save.png")));
            this.btnSacuvajPodesavanja.setPreferredSize(new Dimension(160, 30));
            this.btnSacuvajPodesavanja.addActionListener((ActionListener)((Object)this));
            this.btnSacuvajPodesavanja.setActionCommand("sacuvaj");
            this.btnSacuvajPodesavanja.setShortcut("CTRL+S");
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setOpaque(false);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            pnlGlavniLayout.rowHeights = new int[]{35, 25, 25, 40, 32, 25, 272, 11};
            pnlGlavniLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{51, 54, 173, 160, 128, 220, 20};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlGlavni.setPreferredSize(new Dimension(947, 630));
            this.lblKupac = new JLabel();
            this.pnlGlavni.add((Component)this.lblKupac, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
            this.pnlGlavni.add((Component)this.getJPanelDatumi(), (Object)new GridBagConstraints(0, 1, 7, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
            this.lblKupac.setText("Kupac");
            this.nfSifraKupca = new PzTextField();
            this.pnlGlavni.add((Component)this.nfSifraKupca, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 16, 1, new Insets(5, 0, 5, 0), 0, 0));
            this.pnlGlavni.add((Component)this.getJPanel2(), (Object)new GridBagConstraints(2, 3, 2, 2, 0.0, 0.0, 10, 1, new Insets(2, 0, 2, 5), 0, 0));
            this.pnlGlavni.add((Component)this.getJPanel3(), (Object)new GridBagConstraints(2, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(2, 0, 2, 5), 0, 0));
            this.nfSifraKupca.setEditable(false);
            this.nfSifraKupca.setFocusable(false);
            this.nfSifraKupca.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.nfSifraKupca.setCustomInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    if (ArhivaStampa.this.komitent == null) {
                        return false;
                    }
                    if (ArhivaStampa.this.komitent.getTip() == 2) {
                        JOptionPane.showMessageDialog(null, "Odabrani komitent je fizi\u010dko lice!", "Informacija", 1);
                    }
                    return PzProdajaUtil.grupeKomitenata(ArhivaStampa.this, PzApplication.getApplication().getSession().getLoggedUser(), ArhivaStampa.this.komitent);
                }
            });
            this.panelTipOtpremnice = new PzRadioGroup((Object[])new String[]{OTPREMNICA_SA_CENAMA, OTPREMNICA_BEZ_CENA});
            BoxLayout panelTipOtpremniceLayout = new BoxLayout((Container)this.panelTipOtpremnice, 1);
            this.panelTipOtpremnice.setLayout((LayoutManager)panelTipOtpremniceLayout);
            this.panelTipOtpremnice.setBorder((Border)BorderFactory.createTitledBorder("Tip otpremnice"));
            this.panelTipOtpremnice.setEnabled(false);
            this.panelTipOtpremnice.setSelectedValue((Object)OTPREMNICA_SA_CENAMA);
            this.panelTipOtpremnice.setOpaque(false);
            this.panelNaslov = new PzRadioGroup((Object[])new String[]{RACUN, OTPREMNICA_RACUN});
            BoxLayout panelNaslovLayout1 = new BoxLayout((Container)this.panelNaslov, 1);
            this.panelNaslov.setLayout((LayoutManager)panelNaslovLayout1);
            this.pnlGlavni.add((Component)this.getJTextArea1(), (Object)new GridBagConstraints(4, 6, 3, 1, 0.0, 0.0, 10, 1, new Insets(8, 0, 2, 5), 0, 0));
            this.panelNaslov.setBorder((Border)BorderFactory.createTitledBorder("Naslov dokumenta"));
            this.panelNaslov.setSelectedValue((Object)RACUN);
            this.panelNaslov.setEnabled(false);
            this.panelNaslov.setOpaque(false);
            this.panelNaslov.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getValue().equals(ArhivaStampa.RACUN)) {
                        ArhivaStampa.this.lblRobuIzdao.setEnabled(false);
                        ArhivaStampa.this.tfRobuIzdao.setEnabled(false);
                        ArhivaStampa.this.lblRobuPrimio.setEnabled(false);
                        ArhivaStampa.this.tfRobuPrimio.setEnabled(false);
                        ArhivaStampa.this.lblLicnaKarta.setEnabled(false);
                        ArhivaStampa.this.tfLicnaKarta.setEnabled(false);
                        ArhivaStampa.this.lblOtpremnica.setEnabled(true);
                        ArhivaStampa.this.tfOtpremnica.setEnabled(true);
                    } else {
                        ArhivaStampa.this.lblRobuIzdao.setEnabled(true);
                        ArhivaStampa.this.tfRobuIzdao.setEnabled(true);
                        ArhivaStampa.this.lblRobuPrimio.setEnabled(true);
                        ArhivaStampa.this.tfRobuPrimio.setEnabled(true);
                        ArhivaStampa.this.lblLicnaKarta.setEnabled(true);
                        ArhivaStampa.this.tfLicnaKarta.setEnabled(true);
                        ArhivaStampa.this.lblOtpremnica.setEnabled(false);
                        ArhivaStampa.this.tfOtpremnica.setEnabled(false);
                    }
                }
            });
            this.nazivKupca = new PzTextField();
            this.pnlGlavni.add((Component)this.nazivKupca, (Object)new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 16, 1, new Insets(5, 2, 5, 114), 0, 0));
            this.nazivKupca.setName("nazivKupca");
            this.nazivKupca.setEditable(false);
            this.nazivKupca.setFocusable(false);
            if (this.f.getTip().equals("OTPREMNICA")) {
                this.pnlGlavni.add(this.panelTipOtpremnice, (Object)new GridBagConstraints(0, 3, 2, 2, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
            } else {
                this.pnlGlavni.add(this.panelNaslov, (Object)new GridBagConstraints(0, 3, 2, 2, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
            }
            this.panelFaktura = new PzRadioGroup((Object[])new String[]{KLASICNA_FAKTURA, FAKTURA_ZA_IZVOZ});
            BoxLayout panelFakturaLayout = new BoxLayout((Container)this.panelFaktura, 1);
            this.panelFaktura.setLayout((LayoutManager)panelFakturaLayout);
            this.pnlGlavni.add(this.panelFaktura, (Object)new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            this.panelFaktura.setBorder((Border)BorderFactory.createTitledBorder("Tip fakture"));
            this.panelFaktura.setEnabled(false);
            this.panelFaktura.setSelectedValue((Object)KLASICNA_FAKTURA);
            this.panelFaktura.setOpaque(false);
            this.lblPoruka = new JLabel();
            this.panelFaktura.add((Component)this.lblPoruka);
            this.lblPoruka.setText("Poruka za izvoz");
            this.lblPoruka.setEnabled(false);
            this.panelFL = new PzPanel();
            this.panelFL.setOpaque(false);
            this.pnlGlavni.add((Component)this.panelFL, (Object)new GridBagConstraints(4, 3, 3, 2, 0.0, 0.0, 10, 1, new Insets(0, -2, -1, 5), 0, 0));
            GridBagLayout pzPanel2Layout = new GridBagLayout();
            pzPanel2Layout.columnWidths = new int[]{125, 135, 20};
            pzPanel2Layout.rowHeights = new int[]{25, 25, 25, 25};
            pzPanel2Layout.columnWeights = new double[]{0.0, 0.0, 0.1};
            pzPanel2Layout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            this.panelFL.setBorder((Border)BorderFactory.createTitledBorder("Podaci o fizi\u010dkom licu"));
            this.panelFL.setLayout((LayoutManager)pzPanel2Layout);
            this.panelFL.setName("panelFL");
            this.jlImePrezime = new JLabel();
            this.panelFL.add((Component)this.jlImePrezime, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 1, 5), 0, 0));
            this.jlImePrezime.setName("jlImePrezime");
            this.jlAdresa = new JLabel();
            this.panelFL.add((Component)this.jlAdresa, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 1, 5), 0, 0));
            this.jlAdresa.setName("jlAdresa");
            this.jlMesto = new JLabel();
            this.panelFL.add((Component)this.jlMesto, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 1, 5), 0, 0));
            this.jlMesto.setName("jlMesto");
            this.jlJMBG = new JLabel();
            this.panelFL.add((Component)this.jlJMBG, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 1, 5), 0, 0));
            this.jlJMBG.setName("jlJMBG");
            this.tfImePrezime = new PzTextField();
            this.tfImePrezime.setMaxLength(50);
            this.panelFL.add((Component)this.tfImePrezime, (Object)new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.tfImePrezime.setPreferredSize(new Dimension(128, 25));
            this.tfImePrezime.setName("tfImePrezime");
            this.tfAdresa = new PzTextField();
            this.tfAdresa.setMaxLength(50);
            this.panelFL.add((Component)this.tfAdresa, (Object)new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.tfAdresa.setPreferredSize(new Dimension(128, 25));
            this.tfAdresa.setName("tfAdresa");
            this.tfMesto = new PzTextField();
            this.tfMesto.setMaxLength(50);
            this.panelFL.add((Component)this.tfMesto, (Object)new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.tfMesto.setPreferredSize(new Dimension(128, 25));
            this.tfMesto.setName("tfMesto");
            this.tfJMBG = new PzTextField();
            this.panelFL.add((Component)this.tfJMBG, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.tfJMBG.setMaxLength(13);
            this.tfJMBG.setPreferredSize(new Dimension(100, 20));
            this.cbEfaktura = new JCheckBox();
            this.cbEfaktura.setOpaque(false);
            this.pnlGlavni.add((Component)this.cbEfaktura, (Object)new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.cbEfaktura.setName("cbEfaktura");
            this.cbPrilozi = new JCheckBox("E-Faktura sadrzi priloge");
            this.cbPrilozi.setOpaque(false);
            this.pnlGlavni.add((Component)this.cbPrilozi, (Object)new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.cbEfaktura.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ArhivaStampa.this.cbPrilozi.setEnabled(ArhivaStampa.this.cbEfaktura.isSelected());
                }
            });
            this.setPreferredSize(new Dimension(963, 730));
            this.setResizable(false);
            this.pack();
            this.paintPanel();
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private InputVerifier getInputVerifier() {
        return new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                java.sql.Date datValute;
                int razlika;
                java.sql.Date datPrometa = ArhivaStampa.this.dfDatumPrometa.getVal();
                if (input == ArhivaStampa.this.dfDatumValute && (razlika = PzDateUtility.subtract((java.sql.Date)(datValute = ArhivaStampa.this.dfDatumValute.getVal()), (java.sql.Date)datPrometa)) < 0) {
                    JOptionPane.showMessageDialog(ArhivaStampa.this.getParent(), "Datum valute ne mo\u017ee biti manji od datuma prometa!", "Informacija", 1);
                    return false;
                }
                return true;
            }
        };
    }

    private void loadProperties() {
        this.props = new PropertiesConfiguration();
        this.confFile = new File(String.valueOf(PzApplication.getApplication().getDataFolder().getAbsolutePath()) + File.separator + "ArhivaStampa.properties");
        try {
            if (!this.confFile.exists()) {
                this.props.load(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/gui/faktureZaProdajuRobe/resources/ArhivaStampa.properties"));
            } else {
                this.props.load(this.confFile);
            }
        }
        catch (ConfigurationException e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String ac = ((PzButton)e.getSource()).getActionCommand();
            if (ac.equals("potvrdi")) {
                int rez;
                if (this.f.getIdDok() != 0) {
                    this.f = (Faktura)PzEntityManager.find(Faktura.class, (Object)this.f.getIdDok());
                }
                this.saNivel = false;
                this.f.setDatum(this.dfDatumIzrade.getVal());
                if (this.f.getTip().equals("FAKTURA_IZ_SERVISA") || this.fakAutomobila) {
                    if (this.komitent == null) {
                        JOptionPane.showMessageDialog(null, "Nije unet komitent!", "Informacija", 1);
                        return;
                    }
                    this.f.setKomitent(this.komitent);
                }
                if (!this.f.getTip().equals("FAKTURA_INTERNI_RACUN")) {
                    this.f.setDatPrometa(this.dfDatumPrometa.getVal());
                    this.f.setDatValute(this.dfDatumValute.getVal());
                } else {
                    this.f.setDatPrometa(PzDateUtility.getCurrentDate());
                }
                if (!this.f.getTip().equals("FAKTURA_INTERNI_RACUN") && this.panelTipDok.isEnabled() && ((String)this.panelTipDok.getSelectedValue()).equals(SA_POREZOM) && this.f.getKomitent().getDomaciKomitent() == 0 && (rez = JOptionPane.showConfirmDialog(SwingUtilities.getRoot((Component)((Object)this)), "Inostrani komitent! Obra\u010dun PDV-a?", "", 0)) != 0) {
                    return;
                }
                if (this.f.izMaloprodaje()) {
                    this.f.setSaPorezom(1);
                } else if (this.panelTipDok.isEnabled() && ((String)this.panelTipDok.getSelectedValue()).equals(SA_POREZOM)) {
                    this.f.setSaPorezom(1);
                } else {
                    this.f.setSaPorezom(0);
                    if (((String)this.panelBezP.getSelectedValue()).equals(SA_PRAVOM)) {
                        this.f.setSaPravomNaOdbitak(1);
                    } else {
                        this.f.setSaPravomNaOdbitak(0);
                    }
                }
                if (this.f.getTip().equals("FAKTURA") || this.f.getTip().equals("OTPREMNICA") || this.f.getPodTip() != null && !this.f.getPodTip().equals(TipDokumentConfig.get().PODTIP_FAKTURA_AUTOMOBILA) || this.f.getTip().equals("PRENOSNICA_SA_KONSIGNACIJE") || this.f.getTip().equals("FAKTURA_IZ_SERVISA")) {
                    if (this.f.getTip().equals("FAKTURA") && !this.fakAutomobila || this.f.getTip().equals("FAKTURA_IZ_SERVISA")) {
                        if (((String)this.panelNaslov.getSelectedValue()).equals(RACUN)) {
                            this.f.setPodTip("RACUN");
                            this.f.setPotvrda(this.tfOtpremnica.getVal());
                        } else {
                            this.f.setPodTip("OTPREMNICA_RACUN");
                            if (this.f.getTip().equals("FAKTURA")) {
                                this.f.setNacinOtpreme(this.tfNacinOtpreme.getVal());
                            }
                        }
                    } else if (this.f.getTip().equals("OTPREMNICA")) {
                        this.f.setNacinOtpreme(this.tfNacinOtpreme.getVal());
                    }
                    this.f.setLicnaKarta(this.tfLicnaKarta.getVal().equals("") ? null : this.tfLicnaKarta.getVal());
                    this.f.setRobuIzdao(this.tfRobuIzdao.getVal().equals("") ? null : this.tfRobuIzdao.getVal());
                    this.f.setRobuPrimio(this.tfRobuPrimio.getVal().equals("") ? null : this.tfRobuPrimio.getVal());
                    this.f.setKomercijalista(this.tfSifraKomercijaliste.getVal());
                } else if (this.f.getTip().equals("FAKTURA_TRANZITA")) {
                    if (((String)this.panelFaktura.getSelectedValue()).equals(FAKTURA_ZA_IZVOZ)) {
                        this.f.setPodTip("IZVOZ");
                    } else {
                        this.f.setPodTip("KLASICNA");
                    }
                }
                if (this.f.getTip().equals("OTPREMNICA")) {
                    if (((String)this.panelTipOtpremnice.getSelectedValue()).equals(OTPREMNICA_SA_CENAMA)) {
                        this.f.setPodTip("SA");
                    } else {
                        this.f.setPodTip("BEZ");
                    }
                }
                this.saNivel = this.panelNivelacija.isEnabled() && ((String)this.panelNivelacija.getSelectedValue()).equals(SA_NIVELACIJOM);
                if (this.cbEfaktura.isSelected()) {
                    EDokumentValidator.create((PzDokument)this.f).validate();
                    if (!EDokumentTransport.createTransport().isCompanyRegistered(this.f.getKomitent())) {
                        PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Kupac nema registrovan nalog za primanje E-Faktura. Slanje fakture nije moguce!");
                        this.dispose();
                        return;
                    }
                }
                this.btnPotvrdi.setActionCommand("kraj");
                this.btnPotvrdi.setText("Kraj|(Ctrl+W)");
                this.setDisabledComponents(this.f);
                this.getJTextArea1().getArea().setText(PzPorukeManager.getStandardnaPoruka((PzDokument)this.f));
                this.getJTextArea1().getArea().setEditable(true);
                this.getJTextArea1().getArea().setFocusable(true);
                this.getJTextArea1().getArea().requestFocus();
                if (this.ostatakA.getVal() != 0.0) {
                    this.btnAvans.setEnabled(true);
                }
            } else if (ac.equals("avans")) {
                this.f.addTaksas();
                this.f.setUplata(new BigDecimal(0));
                this.getSession().putParameter("komitent", (Object)this.f.getKomitent());
                this.getSession().putParameter("datumDokumenta", (Object)this.f.getDatum());
                this.getSession().putParameter("dokument", (Object)this.f);
                this.showDialog(ZatvoriFakturuKupcaAvansom.class);
                this.f.setTaksafakturas(new ArrayList());
                this.uplataList = new Vector();
                this.uplataList = (Vector)this.getSession().getParameter(String.valueOf(this.f.getIdDok()) + "avansi");
            } else if (ac.equals("kraj")) {
                boolean rucniUnosOznake = false;
                if (this.f.getTip().equals("FAKTURA")) {
                    rucniUnosOznake = PzParameter.getParameterValue((String)"BRF_AUTOMATSKI", (String)"true").equals("false");
                } else if (this.f.getTip().equals("OTPREMNICA")) {
                    rucniUnosOznake = PzParameter.getParameterValue((String)"BRO_AUTOMATSKI", (String)"true").equals("false");
                }
                PzDefaultDokumentCustomizer fakturaCustomizer = null;
                if (rucniUnosOznake) {
                    this.getSession().putParameter("oznaka", null);
                    this.f.setOznDokumenta("");
                    this.showDialog(UnosOznake.class);
                    final Object ozn = this.getSession().getParameter("oznaka");
                    if (ozn != null) {
                        fakturaCustomizer = new PzDefaultDokumentCustomizer(){

                            public void finalize(PzDokument dokumentK, EntityManager em) throws Exception {
                                super.finalize(dokumentK, em);
                                dokumentK.setOznDokumenta(ozn.toString());
                                dokumentK.getDokument().setOznDokumenta(ozn.toString());
                            }
                        };
                    } else {
                        return;
                    }
                }
                this.taxExemption = null;
                if (PzParameter.getBoolean((String)"EFAKTURA", (boolean)false).booleanValue()) {
                    int rez;
                    if (this.f.getTip().equals("FAKTURA") && this.ostatakA.getBigDecimal().compareTo(BigDecimal.ZERO) != 0 && (this.uplataList == null || this.uplataList.size() == 0) && (rez = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Postoje dostupni avansi koje niste koristili. Naknadno zatvaranje avansom nije moguce.\r\n Zelite li da nastavite bez zatvaranja?", (String)"Zatvaranje avansom", null, (boolean)true)) != 0) {
                        return;
                    }
                    if (((String)this.panelTipDok.getSelectedValue()).equals(BEZ_POREZA)) {
                        this.taxExemption = PzDialogTaxExemption.getTaxExemptionCode((PzDialog)this);
                        if (this.taxExemption == null) {
                            return;
                        }
                    }
                    if (this.cbEfaktura.isSelected() && this.cbPrilozi.isSelected()) {
                        this.eAttachments = PzDialogAttachments.getDocumentReferences((PzDialog)this);
                        if (this.eAttachments.getReferences().size() == 0) {
                            this.eAttachments = null;
                            return;
                        }
                    }
                }
                if (this.arhiviraj(this.f, fakturaCustomizer)) {
                    if (this.getParent().getClass().equals(IzradaFaktureIzRJ.class) || this.getParent().getClass().equals(FakturisanjeOtpremnica.class) || this.getParent().getClass().equals(PzDialogInterniRacun.class) || this.getParent().getClass().equals(PzDialogFakturaAutomobila.class)) {
                        this.getSession().putParameter("arhiviran", (Object)true);
                        System.out.println("FAKTURA JE ARHIVIRANA: " + this.f.getArhiviran());
                    }
                } else {
                    PzSwingUtility.showErrorMessage((Component)this.mainPanel, (String)"Gre\u0161ka prilikom arhiviranja fakture. Poku\u0161ajte ponovo.");
                }
                this.dispose();
            } else if (ac.equals("sacuvaj")) {
                this.props.setProperty("NACIN_OTPREME", (Object)this.tfNacinOtpreme.getVal());
                this.props.setProperty(PROPERTIES_LICNA_KARTA, (Object)this.tfLicnaKarta.getVal());
                this.props.setProperty(PROPERTIES_ROBU_IZDAO, (Object)this.tfRobuIzdao.getVal());
                this.props.setProperty(PROPERTIES_ROBU_PRIMIO, (Object)this.tfRobuPrimio.getVal());
                if (this.panelTipDok.isEnabled()) {
                    if (((String)this.panelTipDok.getSelectedValue()).equals(BEZ_POREZA)) {
                        this.props.setProperty("SA_POREZOM", (Object)false);
                        this.props.setProperty("SA_PRAVOM", (Object)((String)this.panelBezP.getSelectedValue()).equals(SA_PRAVOM));
                    } else {
                        this.props.setProperty("SA_POREZOM", (Object)true);
                        this.props.setProperty("SA_PRAVOM", (Object)true);
                    }
                }
                if (this.panelNivelacija.isEnabled()) {
                    if (((String)this.panelNivelacija.getSelectedValue()).equals(SA_NIVELACIJOM)) {
                        this.props.setProperty("SA_NIVELACIJOM", (Object)true);
                        this.props.setProperty("UKUPNA_KOLICINA", (Object)((String)this.panelTipN.getSelectedValue()).equals(UKUPNA_KOLICINA));
                    } else {
                        this.props.setProperty("SA_NIVELACIJOM", (Object)false);
                        this.props.setProperty("UKUPNA_KOLICINA", (Object)false);
                    }
                }
                if (this.panelNaslov.isEnabled()) {
                    if (((String)this.panelNaslov.getSelectedValue()).equals(RACUN)) {
                        this.props.setProperty("RACUN", (Object)true);
                    } else {
                        this.props.setProperty("RACUN", (Object)false);
                    }
                }
                if (this.panelFaktura.isEnabled()) {
                    if (((String)this.panelFaktura.getSelectedValue()).equals(KLASICNA_FAKTURA)) {
                        this.props.setProperty("KLASICNA_FAKTURA", (Object)true);
                    } else {
                        this.props.setProperty("KLASICNA_FAKTURA", (Object)false);
                    }
                }
                if (this.panelTipOtpremnice.isEnabled()) {
                    if (((String)this.panelTipOtpremnice.getSelectedValue()).equals(OTPREMNICA_SA_CENAMA)) {
                        this.props.setProperty(PROPERTIES_OTPREMNICE, (Object)true);
                    } else {
                        this.props.setProperty(PROPERTIES_OTPREMNICE, (Object)false);
                    }
                }
                this.props.save(this.confFile);
            }
        }
        catch (Exception ex) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.komitent = (Komitent)entity;
            if (this.komitent.getTip() == 2 && !PzProdajaUtil.mozeFizickoLice(this.f.getRadnajedinica(), this.f.getTip())) {
                this.nfSifraKupca.setVal((Object)"");
                this.nazivKupca.setVal((Object)"");
                JOptionPane.showMessageDialog(this.getParent(), "Za odabrani tip dokumenta i radne jedinice nije mogu\u0107e izdati fakturu fizi\u010dkom licu!", "Informacija", 1);
                this.enablePodaciOFizickomLicu(false);
            } else {
                this.nfSifraKupca.setVal((Object)this.komitent.getSfrKomitent());
                this.nazivKupca.setVal((Object)this.komitent.getNaziv());
                if (this.komitent.getDomaciKomitent() == 0) {
                    this.panelTipDok.setSelectedValue((Object)BEZ_POREZA);
                    this.panelBezP.setEnabled(true);
                } else {
                    this.panelTipDok.setSelectedValue((Object)SA_POREZOM);
                    this.panelBezP.setEnabled(false);
                }
                if (this.komitent.getTip() == 2) {
                    this.enablePodaciOFizickomLicu(true);
                } else {
                    this.enablePodaciOFizickomLicu(false);
                }
                this.ostatakA.setEnabled(true);
                this.jlAvans.setEnabled(true);
                try {
                    this.ostatakA.setVal((Object)KomitentPrometUtility.getOstatakAvansaKupci((String)this.komitent.getSfrKomitent()));
                }
                catch (Exception e) {
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                }
            }
        } else {
            this.nfSifraKupca.setVal((Object)"");
            this.nazivKupca.setVal((Object)"");
        }
    }

    public static Object getGUIBuilderInstance() {
        return new ArhivaStampa(Boolean.FALSE);
    }

    public ArhivaStampa(Boolean initGUI) {
    }

    /*
     * Unable to fully structure code
     */
    private boolean arhiviraj(Faktura f, PzDefaultDokumentCustomizer fakturaCustomizer) {
        em = PzEntityManager.getEm();
        nivelacija = null;
        try {
            block47: {
                block48: {
                    block46: {
                        f.setArhiviran((short)1);
                        f.setPoruka(this.jTextArea1.getArea().getText());
                        f.setDatArh(new java.sql.Date(new Date().getTime()));
                        if (f.getTip().equals("FAKTURA_IZ_SERVISA") && !this.unoseSeSredstva) {
                            ((Fakturaservisa)f).setSredstvoNaziv("");
                            ((Fakturaservisa)f).setSredstvoKarakteristika("");
                            ((Fakturaservisa)f).setSredstvoFabrickiBroj("");
                        }
                        if (!f.izMaloprodaje() || f.getTip().equals("FAKTURA_INTERNI_RACUN")) break block46;
                        if (this.tblTabela.getRowCount() < 1) {
                            JOptionPane.showMessageDialog(null, "Nije definisan nijedan teku\u0107i ra\u010dun! Arhiviranje nije mogu\u0107e izvr\u0161iti!", "Informacija", 1);
lbl14:
                            // 5 sources

                            return false;
                        }
                        racun = (Tekuciracun)this.tblTabela.getSelectedEntity();
                        f.setTekuciRacun(String.valueOf(racun.getBrRacuna()) + ", " + racun.getBanka());
                        break block47;
                    }
                    if (f.getTip().equals("FAKTURA_INTERNI_RACUN")) break block47;
                    if (this.tblTabela.getRowCount() >= 1) break block48;
                    JOptionPane.showMessageDialog(null, "Nije definisan nijedan teku\u0107i ra\u010dun! Arhiviranje nije mogu\u0107e izvr\u0161iti!", "Informacija", 1);
                    ** GOTO lbl14
                }
                racun = (Tekuciracun)this.tblTabela.getSelectedEntity();
                f.setTekuciRacun(String.valueOf(racun.getBrRacuna()) + ", " + racun.getBanka());
            }
            if ((f.getTip().equals(TipDokumentConfig.get().FAKTURA) || f.getTip().equals(TipDokumentConfig.get().OTPREMNICA) || f.getTip().equals(TipDokumentConfig.get().FAKTURA_SERVISA)) && (kom = f.getKomitent()) != null) {
                limit = kom.getNovcaniLimit();
                if (limit != null && limit.doubleValue() > 0.0) {
                    iznos = f.getSaPorezom() == 1 ? (BigDecimal)this.getSession().getParameter("iznosSaPorezom") : (BigDecimal)this.getSession().getParameter("iznosBezPoreza");
                    ukupanDug = dosadasnjiDug = KomitentPrometUtility.getBigDecimalValue((String)KomitentPrometUtility.getUkupanDug((Komitent)kom, (Boolean)true));
                    ukupanDug = iznos.add(dosadasnjiDug);
                    if (ukupanDug.compareTo(limit) == 1) {
                        JOptionPane.showMessageDialog((Component)this.pnlGlavni, "Arhiviranjem ovog dokumenta bio bi prema\u0161en definisani limit za komitenta!\nArhiviranje nije mogu\u0107e!", "Informacija", 1);
                        return false;
                    }
                }
                if (PzProdajaUtil.komitentVanTolerancije(kom)) {
                    PzSwingUtility.showInformationMessage((Component)this.pnlGlavni, (String)("Za komitenta [ " + kom.getSfrKomitent() + " ] " + kom.getNaziv() + " postoji dug van tolerancije duga!\nArhiviranje nije mogu\u0107e!"));
                    return false;
                }
            }
            try {
                block51: {
                    block49: {
                        block50: {
                            em.getTransaction().begin();
                            if (this.getSession().getParameter("snimiDokument") != null) {
                                PzDokumentManager.getInstance().snimiDokument((PzDokument)f, true, null, em);
                            }
                            if (f.getKomitent() != null && f.getKomitent().getTip() == 2) {
                                lice = new Fizickolice();
                                lice.setIdDok(Integer.valueOf(f.getIdDok()));
                                lice.setImePrezime(this.tfImePrezime.getVal());
                                lice.setAdresa(this.tfAdresa.getVal());
                                lice.setMesto(this.tfMesto.getVal());
                                lice.setJmbg(this.tfJMBG.getVal());
                                em.persist((Object)lice);
                                f.setFizickolice(lice);
                            }
                            if (!f.getTip().equals("FAKTURA_TRANZITA")) break block49;
                            if (this.tfFaktura.getVal().trim().length() <= 0) break block50;
                            f.setOznDokumenta(this.tfFaktura.getVal());
                            if (!this.nadjiFakturu(this.tfFaktura.getVal())) break block51;
                            this.tfFaktura.setText("");
                            ** GOTO lbl14
                        }
                        JOptionPane.showMessageDialog(this.getParent(), "Nije unet broj fakture!", "Informacija ", 1);
                        this.tfFaktura.requestFocus();
                        ** GOTO lbl14
                    }
                    if (f.getTip().equals("FAKTURA") || f.getTip().equals("OTPREMNICA") || f.getTip().equals("PRENOSNICA_SA_KONSIGNACIJE") || f.getTip().equals("FAKTURA_IZ_SERVISA")) {
                        if (f.getZaOtpremnice() == 1) {
                            for (Faktura otpremnica : f.getFakturas()) {
                                otpremnica.setZauzeto(null);
                                em.merge((Object)otpremnica);
                            }
                        }
                    } else if (f.getTip().equals("AVANSNI_RACUN")) {
                        f.setPodTip("AVANSNI_RACUN_KOLICINA");
                    }
                }
                if (f.getTip().equals("PRENOSNICA_SA_KONSIGNACIJE") && f.getPodTip() != null && f.getPodTip().equals("AUTOMATSKA")) {
                    rbr = 0;
                    for (Artikalfaktura af : f.getArtikalfakturas()) {
                        original = (Artikalfaktura)em.find(Artikalfaktura.class, (Object)af.getId());
                        original.setIndp((short)1);
                        em.merge((Object)original);
                        af.getId().setrBroj(++rbr);
                    }
                }
                if (f.getTip().equals("AVANSNI_RACUN")) {
                    fakturaCustomizer = PzProdajaUtil.getAvansniRacunCustomizer();
                }
                if (f.getRadnajedinica().getgTip().equals("E")) {
                    for (Artikalfaktura af : f.getArtikalfakturas()) {
                        af.setCena(BDConverter.getProdCena((double)(af.getCena() * (1.0 - af.getProcRabata() / 100.0))).doubleValue());
                        af.setProcRabata(0.0);
                        em.merge((Object)af);
                    }
                }
                if (this.saNivel) {
                    nivelacija = ((String)this.panelTipN.getSelectedValue()).equals("Na ukupnu koli\u010dinu") != false ? PzEntityUtil.createNivelacija((PzDokument)f, (boolean)true, (boolean)true, (EntityManager)em) : PzEntityUtil.createNivelacija((PzDokument)f, (boolean)false, (boolean)true, (EntityManager)em);
                    this.arhiviraj(nivelacija, ((String)this.panelTipN.getSelectedValue()).equals("Na ukupnu koli\u010dinu"), em);
                }
                if (PzProdajaUtil.updateStanjeArhiviranje(f, em)) ** break;
                ** continue;
                if (f.getRadnajedinica().getTip().equals("G")) {
                    planskaVrednost = new BigDecimal("0.00");
                    for (Artikalfaktura af : f.getArtikalfakturas()) {
                        afp = af.getArtikalfakturaparameter("PLANSKA_CENA");
                        planskaVrednost = planskaVrednost.add(new BigDecimal(afp.getValue()).multiply(BDConverter.getKolicina((double)af.getKolicina())));
                    }
                    fp = new Fakturaparameter(f.getIdDok(), "PLANSKA_VREDNOST", planskaVrednost.toString(), "");
                    f.addFakturaparameter(fp);
                }
                if (f.getTip().equals("FAKTURA") && f.getPodTip().equals(TipDokumentConfig.get().PODTIP_FAKTURA_OTPREMNICA_RACUN) || f.getTip().equals(TipDokumentConfig.get().OTPREMNICA)) {
                    q = null;
                    upit = "SELECT p FROM Komitentparameter p where p.id.sfrKomitent='" + f.getKomitent().getSfrKomitent() + "' and p.id.idParameter LIKE '%LOKACIJA%' ";
                    q = em.createQuery(upit);
                    data = (Vector)q.getResultList();
                    if (data.size() > 0) {
                        lokacija = null;
                        this.getSession().putParameter("komitent", (Object)f.getKomitent());
                        this.getSession().putParameter("arhiva", (Object)true);
                        this.getSession().putParameter("parameter", (Object)"lokacija");
                        this.showDialog(PzDialogLokacije.class);
                        this.getSession().putParameter("arhiva", null);
                        lokacija = (String)this.getSession().getParameter("lokacija");
                        if (lokacija != null) {
                            p = new Fakturaparameter(f.getIdDok(), "LOKACIJA_KOMITENTA", lokacija, "Mesto isporuke robe");
                            em.persist((Object)p);
                            f.addFakturaparameter(p);
                        }
                    }
                }
                if (f.getTip().equals(TipDokumentConfig.get().PROFAKTURA) && f.getOriginal() != null) {
                    original = (Faktura)em.find(Faktura.class, (Object)f.getOriginal().getIdDok());
                    fTrosak = original.getFakturaparameter(original.getIdDok(), "DOD_TROS_NAZIV");
                    if (fTrosak != null) {
                        pTrosak = new Fakturaparameter(f.getIdDok(), "DOD_TROS_NAZIV", fTrosak.getValue(), "");
                        em.persist((Object)pTrosak);
                        f.getFakturaparameters().add(pTrosak);
                    }
                    if ((fTrosakIznos = original.getFakturaparameter(original.getIdDok(), "DOD_TROS_IZNOS")) != null) {
                        pTrosakIznos = new Fakturaparameter(f.getIdDok(), "DOD_TROS_IZNOS", fTrosakIznos.getValue(), "");
                        em.persist((Object)pTrosakIznos);
                        f.getFakturaparameters().add(pTrosakIznos);
                    }
                    if ((fTrosakTg = original.getFakturaparameter(original.getIdDok(), "DOD_TROS_TG")) != null) {
                        pTrosakTg = new Fakturaparameter(f.getIdDok(), "DOD_TROS_TG", fTrosakTg.getValue(), "");
                        em.persist((Object)pTrosakTg);
                        f.getFakturaparameters().add(pTrosakTg);
                    }
                    if ((fTrosakTgIznos = original.getFakturaparameter(original.getIdDok(), "DOD_TROS_TG_IZNOS")) != null) {
                        pTrosakTgIznos = new Fakturaparameter(f.getIdDok(), "DOD_TROS_TG_IZNOS", fTrosakTgIznos.getValue(), "");
                        em.persist((Object)pTrosakTgIznos);
                        f.getFakturaparameters().add(pTrosakTgIznos);
                    }
                }
                PzDokumentManager.getInstance().arhivirajDokument((PzDokument)f, true, (PzDokumentCustomizer)fakturaCustomizer, em);
                if (f.getIznos().doubleValue() < 0.0 && (rez = PzSwingUtility.daNeDijalog((Component)this, (Object)"Program je detektovao minusnu fakturu. Da li \u017eelite da \u0161tampate potvrdu?", (String)"Informacija", null, (boolean)false)) == 0) {
                    f.setStorno(1);
                    f.setMinusnaPotvrda(PzPorukeManager.getStandardnaPoruka((PzDokument)f));
                    f.setStorno(0);
                }
                if (this.uplataList != null && this.uplataList.size() != 0) {
                    i = 0;
                    while (i < this.uplataList.size()) {
                        this.uplataList.get(i).setOznDokumenta(f.getOznDokumenta());
                        PzDokumentManager.getInstance().arhivirajDokument((PzDokument)this.uplataList.get(i), true, null, em);
                        ++i;
                    }
                    fakP = new Fakturaparameter(f.getIdDok(), PzProdajaUtil.ZATVARANJE_FAKTURE_AVANSOM_DISCRIMINATOR, "true", "Zatvaranje fakture avansom");
                    em.persist((Object)fakP);
                }
                if (this.taxExemption != null) {
                    fakP = new Fakturaparameter(f.getIdDok(), "TAX_EXEMPTION", this.taxExemption, "Poresko oslobodjenje");
                    em.persist((Object)fakP);
                    f.addFakturaparameter(fakP);
                }
                this.stampajFiskalni(f, em);
                this.posaljiEFakturu(f, this.uplataList, em);
                em.getTransaction().commit();
                PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)f);
                if (nivelacija != null) {
                    PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)nivelacija);
                }
                if (this.getParent().getClass().equals(PodaciOServisiranomSredstvu.class)) {
                    ((PodaciOServisiranomSredstvu)this.getParent()).dispose();
                    this.getSession().putParameter("arhiviran", (Object)"1");
                }
            }
            catch (Exception e) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)this, (Throwable)e);
                return false;
            }
        }
        finally {
            em.close();
        }
        return true;
    }

    private void arhiviraj(Nivelacija nivel, boolean naUkupnuKolicinu, EntityManager em) throws Exception {
        if (nivel == null) {
            return;
        }
        if (nivel.getArtikalnivelacijas().size() == 0) {
            PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot((Component)((Object)this)), (String)"Nivelacija ne moze da se napravi jer cena nije promenjena");
            nivel = null;
        } else {
            if (naUkupnuKolicinu) {
                for (Artikalnivelacija arniv : nivel.getArtikalnivelacijas()) {
                    StanjePK stanjePk = new StanjePK(arniv.getId().getSfrProizvod(), nivel.getRadnajedinica());
                    Stanje s = (Stanje)em.find(Stanje.class, (Object)stanjePk);
                    s.setProdCena(arniv.getCenaNova());
                }
            }
            PzDokumentManager.getInstance().arhivirajDokument((PzDokument)nivel, true, null, em);
        }
    }

    public boolean nadjiFakturu(String id) {
        boolean nadjen = false;
        EntityManager em = PzEntityManager.getEm();
        Query q = em.createQuery("SELECT f from Faktura f WHERE f.oznDokumenta=:id and f.tip=:tip AND  f.radnajedinica=:rj");
        q.setParameter("id", (Object)this.tfFaktura.getVal());
        q.setParameter("tip", (Object)this.f.getTip());
        q.setParameter("rj", (Object)this.f.getRadnajedinica());
        Vector data = (Vector)q.getResultList();
        if (data.size() != 0) {
            nadjen = true;
            JOptionPane.showMessageDialog(this.getParent(), "Broj fakture " + id + " vec postoji", "Informacija ", 1);
        }
        return nadjen;
    }

    private void stampajFiskalni(Faktura f, EntityManager em) throws Exception {
        PzGenericService kasa;
        if ((f.getTip().equals(TipDokumentConfig.get().FAKTURA) || f.getTip().equals(TipDokumentConfig.get().FAKTURA_INTERNI_RACUN)) && f.getRadnajedinica() != null && f.izMaloprodaje() && (kasa = PzApplication.getApplication().getGenericServiceRegistry().getService("KASA_SERVICE")) != null && PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Da li \u017eelite da izdate fiskalni ra\u010dun uz fakturu?", (String)"Izdavanje fiskalnog ra\u010duna", null, (boolean)false) == 0) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("DOKUMENT", f);
            params.put("EntityManager", em);
            params.put("DIALOG_PARENT", (Object)this);
            kasa.run(params);
        }
    }

    private void posaljiEFakturu(Faktura f, List<Uplata> uplataList2, EntityManager em) throws Exception {
        if (PzParameter.getBoolean((String)"EFAKTURA", (boolean)false).booleanValue()) {
            PzWorkerDialog.showStatus((String)"Slanje E-Fakture u toku, molim\u043e sa\u010dekajte", (PzDialog)this);
            try {
                if (this.cbEfaktura.isSelected()) {
                    if (uplataList2 != null && uplataList2.size() > 0) {
                        FakturaRF.AVANS = uplataList2;
                    }
                    PzReportManager.GENERATE_ONLY = true;
                    PzReportManager.createAndShowReport((PzDialog)this, (PzDokument)f);
                    EDokument ef = null;
                    EDokumentTransport t = EDokumentTransport.createTransport();
                    ef = TipDokumentConfig.get().AVANSNI_RACUN.equals(f.getTip()) ? t.uploadAdvance(f) : t.uploadInvoice(f, uplataList2, this.eAttachments);
                    em.merge((Object)ef);
                }
            }
            finally {
                PzWorkerDialog.hideStatus();
            }
        }
    }

    private PzPanel getJPanel1() throws Exception {
        if (this.panelTabela == null) {
            this.panelTabela = new PzPanel();
            this.panelTabela.setOpaque(false);
            GridBagLayout jPanel1Layout2 = new GridBagLayout();
            jPanel1Layout2.rowWeights = new double[]{0.1};
            jPanel1Layout2.rowHeights = new int[]{7};
            jPanel1Layout2.columnWeights = new double[]{0.1};
            jPanel1Layout2.columnWidths = new int[]{7};
            this.panelTabela.setLayout((LayoutManager)jPanel1Layout2);
            this.panelTabela.setPreferredSize(new Dimension(10, 10));
            this.panelTabela.setBorder((Border)BorderFactory.createTitledBorder("Teku\u0107i ra\u010duni"));
            this.panelTabela.add((Component)this.getPlTabela(), (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.panelTabela;
    }

    private PzPanel getPlTabela() throws Exception {
        if (this.plTabela == null) {
            this.plTabela = new PzPanel();
            this.plTabela.setOpaque(false);
            BorderLayout jPanel1Layout = new BorderLayout();
            this.plTabela.setLayout((LayoutManager)jPanel1Layout);
            if (!this.f.getTip().equals("FAKTURA_INTERNI_RACUN")) {
                this.plTabela.add((Component)this.getScTabela(), (Object)"Center");
            }
        }
        return this.plTabela;
    }

    private JScrollPane getScTabela() throws Exception {
        if (this.scTabela == null) {
            this.scTabela = new JScrollPane();
            this.scTabela.setOpaque(false);
            this.scTabela.setBackground(new Color(211, 242, 210));
            List data = PzFirma.getFirma().getTekuciracuns();
            this.tblTabela = new PzTable(data, Tekuciracun.class);
            this.tblTabela.hideColumnByName("Podrazumevani");
            if (this.tblTabela.getDataSize() > 0) {
                int index = -1;
                int i = 0;
                while (i < this.tblTabela.getDataSize()) {
                    index = Integer.parseInt(this.tblTabela.getModel().getValueAt(this.tblTabela.convertRowIndexToModel(i), 0).toString());
                    if (index == 1) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                this.tblTabela.setRowSelectionInterval(index, index);
            }
            this.scTabela.setViewportView((Component)this.tblTabela);
        }
        return this.scTabela;
    }

    private PzPanel getJPanelRB() {
        if (this.panelRBs == null) {
            this.panelRBs = new PzPanel();
            this.panelRBs.setOpaque(false);
            GridBagLayout panelRBsLayout = new GridBagLayout();
            panelRBsLayout.rowWeights = new double[]{0.1};
            panelRBsLayout.rowHeights = new int[]{7};
            panelRBsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            panelRBsLayout.columnWidths = new int[]{240, 240, 240, 7};
            this.panelRBs.setLayout((LayoutManager)panelRBsLayout);
            GridBagLayout jPanel2Layout = new GridBagLayout();
            jPanel2Layout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            jPanel2Layout.rowHeights = new int[]{7, 7, 7, 7};
            jPanel2Layout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            jPanel2Layout.columnWidths = new int[]{230, 230, 230, 7};
            this.panelTipDok = new PzRadioGroup((Object[])new String[]{SA_POREZOM, BEZ_POREZA});
            this.panelTipDok.setOpaque(false);
            BoxLayout panelTipDokLayout1 = new BoxLayout((Container)this.panelTipDok, 1);
            this.panelTipDok.setLayout((LayoutManager)panelTipDokLayout1);
            this.panelRBs.add(this.panelTipDok, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelTipDok.setBorder((Border)BorderFactory.createTitledBorder("Tip dokumenta"));
            this.panelTipDok.setSelectedValue((Object)SA_POREZOM);
            this.panelTipDok.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getValue().equals(ArhivaStampa.SA_POREZOM)) {
                        ArhivaStampa.this.panelBezP.setEnabled(false);
                    } else {
                        ArhivaStampa.this.panelBezP.setEnabled(true);
                    }
                }
            });
            this.panelBezP = new PzRadioGroup((Object[])new String[]{SA_PRAVOM, BEZ_PRAVA});
            BoxLayout panelBezPLayout = new BoxLayout((Container)this.panelBezP, 1);
            this.panelBezP.setLayout((LayoutManager)panelBezPLayout);
            this.panelRBs.add(this.panelBezP, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelBezP.setBorder((Border)BorderFactory.createTitledBorder(BEZ_POREZA));
            this.panelBezP.setSelectedValue((Object)SA_PRAVOM);
            this.panelBezP.setEnabled(false);
            this.panelBezP.setOpaque(false);
            this.panelNivelacija = new PzRadioGroup((Object[])new String[]{SA_NIVELACIJOM, BEZ_NIVELACIJE});
            BoxLayout panelNivelacijaLayout1 = new BoxLayout((Container)this.panelNivelacija, 1);
            this.panelNivelacija.setLayout((LayoutManager)panelNivelacijaLayout1);
            this.panelRBs.add(this.panelNivelacija, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelNivelacija.setBorder((Border)BorderFactory.createTitledBorder("Nivelacija"));
            this.panelNivelacija.setSelectedValue((Object)SA_NIVELACIJOM);
            this.panelNivelacija.setOpaque(false);
            this.panelNivelacija.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    if (evt.getValue().equals(ArhivaStampa.BEZ_NIVELACIJE)) {
                        ArhivaStampa.this.panelTipN.setEnabled(false);
                    } else {
                        ArhivaStampa.this.panelTipN.setEnabled(true);
                    }
                }
            });
            this.panelTipN = new PzRadioGroup((Object[])new String[]{UKUPNA_KOLICINA, KOLICINA_ZA_PRODAJU});
            BoxLayout panelTipNLayout1 = new BoxLayout((Container)this.panelTipN, 1);
            this.panelTipN.setLayout((LayoutManager)panelTipNLayout1);
            this.panelRBs.add(this.panelTipN, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelTipN.setBorder((Border)BorderFactory.createTitledBorder("Tip nivelacije"));
            this.panelTipN.setSelectedValue((Object)KOLICINA_ZA_PRODAJU);
            this.panelTipN.setOpaque(false);
            if (this.f.getRadnajedinica().getTip().equals("G") && PzParameter.getParameterValue((String)"DVOJNO_KNJIGOVODSTVO", (String)"true").equals("true")) {
                this.panelNivelacija.setEnabled(false);
                this.panelTipN.setEnabled(false);
            }
        }
        return this.panelRBs;
    }

    private PzPanel getJPanelDatumi() {
        if (this.panelDatumi == null) {
            this.panelDatumi = new PzPanel();
            this.panelDatumi.setOpaque(false);
            GridBagLayout panelDatumiLayout = new GridBagLayout();
            panelDatumiLayout.rowWeights = new double[]{0.0};
            panelDatumiLayout.rowHeights = new int[]{25};
            panelDatumiLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            int[] nArray = new int[6];
            nArray[0] = 120;
            nArray[1] = 200;
            nArray[2] = 113;
            nArray[3] = 200;
            nArray[5] = 200;
            panelDatumiLayout.columnWidths = nArray;
            this.panelDatumi.setLayout((LayoutManager)panelDatumiLayout);
            GridBagLayout jPanel2Layout1 = new GridBagLayout();
            jPanel2Layout1.rowWeights = new double[]{0.1};
            jPanel2Layout1.rowHeights = new int[]{7};
            jPanel2Layout1.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            jPanel2Layout1.columnWidths = new int[]{120, 160, 171, 160, 160, 160};
            this.lblDatumIzrade = new JLabel();
            this.panelDatumi.add((Component)this.lblDatumIzrade, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblDatumIzrade.setText("Datum izrade");
            this.dfDatumIzrade = new PzDateField();
            this.panelDatumi.add((Component)this.dfDatumIzrade, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 50), 0, 0));
            this.dfDatumIzrade.setFont(new Font("Tahoma", 0, 14));
            this.dfDatumIzrade.setPreferredSize(new Dimension(80, 25));
            this.lblDatumPrometa = new JLabel();
            this.panelDatumi.add((Component)this.lblDatumPrometa, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblDatumPrometa.setText("Datum prometa");
            this.dfDatumPrometa = new PzDateField();
            this.panelDatumi.add((Component)this.dfDatumPrometa, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 50), 0, 0));
            this.dfDatumPrometa.setFont(new Font("Tahoma", 0, 14));
            this.dfDatumPrometa.setPreferredSize(new Dimension(80, 25));
            this.dfDatumPrometa.setInputVerifier(this.getInputVerifier());
            this.jLabel1 = new JLabel();
            this.panelDatumi.add((Component)this.jLabel1, (Object)new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel1.setText("Datum valute");
            this.dfDatumValute = new PzDateField();
            this.panelDatumi.add((Component)this.dfDatumValute, (Object)new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 50), 0, 0));
            this.dfDatumValute.setFont(new Font("Tahoma", 0, 14));
            this.dfDatumValute.setPreferredSize(new Dimension(80, 25));
            this.dfDatumValute.setInputVerifier(this.getInputVerifier());
        }
        return this.panelDatumi;
    }

    private PzButton getBtnAvans() {
        if (this.btnAvans == null) {
            this.btnAvans = new PzButton();
            this.btnAvans.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check.png")));
            this.btnAvans.setPreferredSize(new Dimension(115, 55));
            this.btnAvans.setEnabled(false);
            this.btnAvans.setName("btnAvans");
            this.btnAvans.setActionCommand("avans");
            this.btnAvans.addActionListener((ActionListener)((Object)this));
        }
        return this.btnAvans;
    }

    private PzPanel getJPanelAvans() throws Exception {
        if (this.panelAvans == null) {
            this.panelAvans = new PzPanel();
            this.panelAvans.setOpaque(false);
            GridBagLayout panelAvansLayout1 = new GridBagLayout();
            panelAvansLayout1.rowWeights = new double[]{0.0, 0.1};
            panelAvansLayout1.rowHeights = new int[]{25, 7};
            panelAvansLayout1.columnWeights = new double[]{0.0, 0.0, 0.1};
            panelAvansLayout1.columnWidths = new int[]{124, 168, 7};
            this.panelAvans.setLayout((LayoutManager)panelAvansLayout1);
            this.panelAvans.setBorder((Border)BorderFactory.createTitledBorder(""));
            GridBagLayout panelAvansLayout = new GridBagLayout();
            panelAvansLayout.rowWeights = new double[]{0.0, 0.1};
            panelAvansLayout.rowHeights = new int[]{25, 7};
            panelAvansLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            panelAvansLayout.columnWidths = new int[]{284, 188, 183, 20};
            this.jlAvans = new JLabel();
            this.panelAvans.add((Component)this.jlAvans, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jlAvans.setText("Ostatak avansa");
            this.jlAvans.setPreferredSize(new Dimension(90, 25));
            this.jlAvans.setHorizontalAlignment(4);
            this.jlAvans.setEnabled(false);
            this.ostatakA = new PzDoubleField();
            this.panelAvans.add((Component)this.ostatakA, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 1, 0), 0, 0));
            this.panelAvans.add((Component)this.getBtnAvans(), (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 3, new Insets(0, 0, 1, 0), 0, 0));
            this.pnlGlavni.add((Component)this.getJPanel1(), (Object)new GridBagConstraints(0, 6, 4, 1, 0.0, 0.0, 11, 1, new Insets(0, 5, 0, 5), 0, 0));
            this.ostatakA.setFont(new Font("Tahoma", 0, 14));
            this.ostatakA.setPreferredSize(new Dimension(115, 25));
            this.ostatakA.setEnabled(false);
        }
        return this.panelAvans;
    }

    private JPanel getJPanel2() throws Exception {
        if (this.panelOtpremnica == null) {
            this.panelOtpremnica = new PzPanel();
            this.panelOtpremnica.setOpaque(false);
            GridBagLayout jPanel2Layout2 = new GridBagLayout();
            jPanel2Layout2.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
            jPanel2Layout2.rowHeights = new int[]{25, 25, 25, 25};
            jPanel2Layout2.columnWeights = new double[]{0.0, 0.1};
            jPanel2Layout2.columnWidths = new int[]{120, 7};
            this.panelOtpremnica.setLayout((LayoutManager)jPanel2Layout2);
            this.panelOtpremnica.setBorder((Border)BorderFactory.createTitledBorder(""));
            this.lblNacinOtpreme = new JLabel();
            this.panelOtpremnica.add((Component)this.lblNacinOtpreme, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblNacinOtpreme.setText("Na\u010din otpreme");
            this.lblNacinOtpreme.setEnabled(false);
            this.lblSifraKomercijaliste = new JLabel();
            this.panelOtpremnica.add((Component)this.lblSifraKomercijaliste, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblSifraKomercijaliste.setText("\u0160ifra komercijaliste");
            this.lblSifraKomercijaliste.setEnabled(false);
            this.tfNacinOtpreme = new PzTextField();
            this.tfNacinOtpreme.setMaxLength(50);
            this.tfNacinOtpreme.setVal(this.props.getProperty("NACIN_OTPREME"));
            this.panelOtpremnica.add((Component)this.tfNacinOtpreme, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.tfNacinOtpreme.setFont(new Font("Tahoma", 0, 14));
            this.tfNacinOtpreme.setPreferredSize(new Dimension(6, 25));
            this.tfNacinOtpreme.setEnabled(false);
            this.tfSifraKomercijaliste = new PzTextField();
            this.tfSifraKomercijaliste.setMaxLength(20);
            this.panelOtpremnica.add((Component)this.tfSifraKomercijaliste, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.pnlGlavni.add((Component)this.getJPanelAvans(), (Object)new GridBagConstraints(4, 5, 3, 1, 0.0, 0.0, 10, 1, new Insets(2, 0, 2, 7), 0, 0));
            this.tfSifraKomercijaliste.setPreferredSize(new Dimension(128, 25));
            this.tfSifraKomercijaliste.setEnabled(false);
            this.lblFaktura = new JLabel();
            this.panelOtpremnica.add((Component)this.lblFaktura, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblFaktura.setText("Broj fakture");
            this.lblFaktura.setEnabled(false);
            this.lblOtpremnica = new JLabel();
            this.panelOtpremnica.add((Component)this.lblOtpremnica, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblOtpremnica.setText("Na bazi otpremnice");
            this.lblOtpremnica.setEnabled(false);
            this.tfFaktura = new PzTextField();
            this.panelOtpremnica.add((Component)this.tfFaktura, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.tfFaktura.setFont(new Font("Tahoma", 0, 14));
            this.tfFaktura.setPreferredSize(new Dimension(6, 25));
            this.tfFaktura.setEnabled(false);
            this.tfFaktura.setVerifyInput(true);
            this.tfFaktura.setMaxLength(15);
            this.tfOtpremnica = new PzTextField();
            this.panelOtpremnica.add((Component)this.tfOtpremnica, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.tfOtpremnica.setFont(new Font("Tahoma", 0, 14));
            this.tfOtpremnica.setPreferredSize(new Dimension(6, 25));
            this.tfOtpremnica.setEnabled(false);
        }
        return this.panelOtpremnica;
    }

    private JPanel getJPanel3() {
        if (this.panelRoba == null) {
            this.panelRoba = new PzPanel();
            this.panelRoba.setOpaque(false);
            GridBagLayout jPanel3Layout = new GridBagLayout();
            jPanel3Layout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            jPanel3Layout.rowHeights = new int[]{25, 25, 25, 7};
            jPanel3Layout.columnWeights = new double[]{0.0, 0.1};
            jPanel3Layout.columnWidths = new int[]{120, 7};
            this.panelRoba.setLayout((LayoutManager)jPanel3Layout);
            this.panelRoba.setBorder((Border)BorderFactory.createTitledBorder(""));
            this.lblRobuIzdao = new JLabel();
            this.panelRoba.add((Component)this.lblRobuIzdao, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblRobuIzdao.setText("Robu izdao");
            this.lblRobuIzdao.setEnabled(false);
            this.tfRobuIzdao = new PzTextField();
            this.tfRobuIzdao.setMaxLength(30);
            this.panelRoba.add((Component)this.tfRobuIzdao, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.tfRobuIzdao.setFont(new Font("Tahoma", 0, 14));
            this.tfRobuIzdao.setPreferredSize(new Dimension(6, 25));
            this.tfRobuIzdao.setEnabled(false);
            this.tfRobuIzdao.setVal(this.props.getProperty(PROPERTIES_ROBU_IZDAO));
            this.lblRobuPrimio = new JLabel();
            this.panelRoba.add((Component)this.lblRobuPrimio, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.pnlGlavni.add((Component)this.getJPanelRB(), (Object)new GridBagConstraints(0, 2, 7, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.lblRobuPrimio.setText("Robu primio");
            this.lblRobuPrimio.setEnabled(false);
            this.tfRobuPrimio = new PzTextField();
            this.tfRobuPrimio.setMaxLength(30);
            this.panelRoba.add((Component)this.tfRobuPrimio, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.tfRobuPrimio.setFont(new Font("Tahoma", 0, 14));
            this.tfRobuPrimio.setPreferredSize(new Dimension(6, 25));
            this.tfRobuPrimio.setEnabled(false);
            this.tfRobuPrimio.setVal(this.props.getProperty(PROPERTIES_ROBU_PRIMIO));
            this.lblLicnaKarta = new JLabel();
            this.panelRoba.add((Component)this.lblLicnaKarta, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblLicnaKarta.setText("Li\u010dna karta");
            this.lblLicnaKarta.setEnabled(false);
            this.tfLicnaKarta = new PzTextField();
            this.tfLicnaKarta.setMaxLength(30);
            this.panelRoba.add((Component)this.tfLicnaKarta, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.tfLicnaKarta.setPreferredSize(new Dimension(80, 25));
            this.tfLicnaKarta.setFont(new Font("Tahoma", 0, 14));
            this.tfLicnaKarta.setEnabled(false);
            this.tfLicnaKarta.setVal(this.props.getProperty(PROPERTIES_LICNA_KARTA));
        }
        return this.panelRoba;
    }

    private PzTextAreaPanel getJTextArea1() {
        if (this.jTextArea1 == null) {
            this.jTextArea1 = new PzTextAreaPanel();
            this.jTextArea1.setBorder((Border)BorderFactory.createTitledBorder("Uslovi prodaje"));
            this.jTextArea1.setEnabled(false);
            this.jTextArea1.setBorder((Border)BorderFactory.createTitledBorder(""));
            this.jTextArea1.setFocusable(false);
            this.getJTextArea1().getArea().setEditable(false);
            this.getJTextArea1().getArea().setFocusable(false);
        }
        return this.jTextArea1;
    }
}

