/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.jdesktop.application.Application;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Dtaksa;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Fakturaparameter;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Taksafaktura;
import rs.pezar.prodaja.PzExtensionLoader;
import rs.pezar.prodaja.gui.faktureZaProdajuRobe.UzmiDokument;
import rs.pezar.prodaja.gui.fakturisanjeOtpremnica.FakturisanjeOtpremnica;
import rs.pezar.prodaja.util.ProdajaGradientUtil;
import rs.pezar.prodaja.util.PzProdajaUtil;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogVracanjeFaktureUPripremu
extends PzDialog {
    private static final long serialVersionUID = -1487091348925367428L;
    private PzTextField nazKomitenta;
    private PzNumericOnlyTextField sfrKomitenta;
    private PzButton btnOk;
    private PzPanel panelButtons;
    private PzTextField oznDokument;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private Komitent k;
    private Faktura faktura;
    private boolean otpremnica = false;
    private PzPanel mainPanel;

    public PzDialogVracanjeFaktureUPripremu(JFrame frame, String parameter) {
        super(frame);
        if (parameter.equals("otpremnica")) {
            this.otpremnica = true;
        }
        this.initGUI();
    }

    private void initGUI() {
        GridBagLayout layout = new GridBagLayout();
        if (this.otpremnica) {
            this.setTitle("Vra\u0107anje otpremnice u pripremu");
        } else {
            this.setTitle("Vra\u0107anje fakture u pripremu");
        }
        layout.rowWeights = new double[]{0.1, 0.0, 0.0, 0.1};
        layout.rowHeights = new int[]{7, 25, 25, 20};
        layout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
        layout.columnWidths = new int[]{103, 90, 76, 20};
        this.mainPanel = new PzPanel();
        this.mainPanel.setLayout((LayoutManager)layout);
        this.getContentPane().add((Component)this.mainPanel);
        this.nazKomitenta = new PzTextField();
        this.mainPanel.add((Component)this.nazKomitenta, (Object)new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 2, 1, 50), 0, 0));
        this.nazKomitenta.setName("nazKomitenta");
        this.nazKomitenta.setEditable(false);
        this.nazKomitenta.setFocusable(false);
        this.sfrKomitenta = new PzNumericOnlyTextField();
        this.mainPanel.add((Component)this.sfrKomitenta, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
        this.sfrKomitenta.setName("sfrKomitenta");
        this.sfrKomitenta.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
        this.jLabel1 = new JLabel();
        this.mainPanel.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 3), 0, 0));
        this.jLabel1.setName("jLabel1");
        this.jLabel2 = new JLabel();
        this.mainPanel.add((Component)this.jLabel2, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 3), 0, 0));
        this.jLabel2.setText(this.otpremnica ? "Otpremnica" : "Faktura");
        this.oznDokument = new PzTextField();
        this.mainPanel.add((Component)this.oznDokument, (Object)new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.oznDokument.setName("oznDokument");
        this.oznDokument.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PzDialogVracanjeFaktureUPripremu.this.keyRel(evt);
            }
        });
        this.panelButtons = new PzPanel();
        this.mainPanel.add((Component)this.panelButtons, (Object)new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        FlowLayout panelButtonsLayout = new FlowLayout();
        panelButtonsLayout.setHgap(0);
        this.panelButtons.setLayout((LayoutManager)panelButtonsLayout);
        this.panelButtons.setOpaque(false);
        this.btnOk = new PzButton();
        this.panelButtons.add((Component)this.btnOk);
        this.btnOk.setPreferredSize(new Dimension(100, 30));
        this.btnOk.setName("btnOk");
        this.btnOk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check.png")));
        this.btnOk.addActionListener((ActionListener)((Object)this));
        Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        this.pack();
        this.setSize(580, 150);
        this.setResizable(false);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.faktura == null) {
            JOptionPane.showMessageDialog(this.getParent(), "Nije odabran nijedan dokument izabranog komitenta!", "Informacija ", 1);
            this.sfrKomitenta.requestFocusInWindow();
        } else {
            int rez;
            Query query;
            EntityManager em = PzEntityManager.getEm();
            this.faktura = (Faktura)em.find(Faktura.class, (Object)this.faktura.getIdDok());
            if (this.faktura.getZaOtpremnice() == 1 && (query = FakturisanjeOtpremnica.getFakturaZaOtpremniceQuery(em, PzExtensionLoader.getLoggedUser(), this.faktura.getRadnajedinica())).getResultList().size() > 0) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Postoji faktura za otpremnice u pripremi u radnoj jedinici: " + this.faktura.getRadnajedinica().getSkracenNaziv() + "!\nDa biste vratili ovu fakturu u pripremu morate arhivirati ili obrisati postoje\u0107u!", "Informacija ", 1);
                this.oznDokument.requestFocusInWindow();
                return;
            }
            if (this.faktura.getRadnajedinica().getNacinVodjenja().equals("PRNC")) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Nije mogu\u0107e vra\u0107anje dokumenta u pripremu u sistemu pra\u0107enja magacina po prose\u010dnoj nabavnoj ceni!", "Informacija ", 1);
                this.sfrKomitenta.requestFocusInWindow();
                return;
            }
            if (this.faktura.getDokument().getProknjizen() == 1) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Nije mogu\u0107e vra\u0107anje u pripremu dokumenta koji je proknji\u017een u finansijskom knjigovodstvu!", "Informacija ", 1);
                this.oznDokument.requestFocusInWindow();
                return;
            }
            if (this.otpremnica) {
                if (this.faktura.getZauzeto() != null && this.faktura.getZauzeto().length() > 0) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Nije mogu\u0107e vra\u0107anje u pripremu otpremnice koja je dodata na fakturu u pripremi!", "Informacija ", 1);
                    this.oznDokument.requestFocusInWindow();
                    return;
                }
                if (this.faktura.getFakturaBean() != null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Nije mogu\u0107e vra\u0107anje u pripremu otpremnice koja je fakturisana!", "Informacija ", 1);
                    this.oznDokument.requestFocusInWindow();
                    return;
                }
            }
            if ((rez = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Da li ste sigurni da \u017eelite da vratite dokument u pripremu?", (String)(this.otpremnica ? "Vra\u0107anje otpremnice u pripremu" : "Vra\u0107anje fakture u pripremu"), null, (boolean)false)) != 0) {
                this.sfrKomitenta.requestFocusInWindow();
                return;
            }
            try {
                try {
                    em.getTransaction().begin();
                    this.faktura.setArhiviran((short)0);
                    this.faktura.getDokument().setArhiviran((short)0);
                    if (this.faktura.getZaOtpremnice() == 1) {
                        for (Faktura otpremnica : this.faktura.getFakturas()) {
                            otpremnica.setZauzeto(this.faktura.getUserKraj().getPzusername());
                        }
                    }
                    for (Taksafaktura tf : this.faktura.getTaksafakturas()) {
                        em.remove(em.find(Taksafaktura.class, (Object)tf.getId()));
                    }
                    this.faktura.setTaksafakturas(new Vector());
                    for (Fakturaparameter fp : this.faktura.getFakturaparameters()) {
                        if (fp.getId().getName().startsWith("DOD_TROS")) continue;
                        em.remove(em.find(Fakturaparameter.class, (Object)fp.getId()));
                    }
                    this.faktura.setFakturaparameters(new Vector());
                    if (this.faktura.getFizickolice() != null) {
                        em.createNativeQuery("delete from fizickolice where iddok =?id").setParameter("id", (Object)this.faktura.getIdDok()).executeUpdate();
                    }
                    for (Dtaksa dt : this.faktura.getDokument().getDtaksas()) {
                        em.remove(em.find(Dtaksa.class, (Object)dt.getId()));
                    }
                    this.faktura.getDokument().setDtaksas(null);
                    Pzuser user = (Pzuser)em.find(Pzuser.class, (Object)PzApplication.getApplication().getSession().getLoggedUser().getPzusername());
                    this.faktura.setUserKraj(user);
                    this.faktura.createLog(5, null, user, em);
                    PzProdajaUtil.updateStanjeVracanjeUPripremu(this.faktura, em);
                    em.getTransaction().commit();
                    this.dispose();
                }
                catch (Exception ex) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
                    em.close();
                }
            }
            finally {
                em.close();
            }
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.k = (Komitent)entity;
            this.sfrKomitenta.setVal((Object)this.k.getSfrKomitent());
            this.nazKomitenta.setVal((Object)this.k.getNaziv());
        }
        if (entity == null) {
            this.nazKomitenta.setVal((Object)"");
        }
    }

    private void keyRel(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.faktura = null;
            if (this.oznDokument.getVal().equals("")) {
                if (this.otpremnica) {
                    this.getSession().putParameter("vracanjeOtpremniceUPripremu", (Object)true);
                } else {
                    this.getSession().putParameter("vracanjeFaktureUPripremu", (Object)true);
                }
                this.getSession().putParameter("komitent", (Object)this.k);
                this.showDialog(UzmiDokument.class);
                if (this.faktura == null) {
                    JOptionPane.showMessageDialog(this.getParent(), "Nije odabrana nijedna " + (this.otpremnica ? "otpremnica" : "faktura") + " izabranog komitenta!", "Informacija ", 1);
                    this.sfrKomitenta.requestFocusInWindow();
                    return;
                }
            } else {
                EntityManager em = PzEntityManager.getEm();
                Query q = null;
                q = this.otpremnica ? em.createQuery("SELECT f FROM Faktura f where f.dokument.proknjizen=0 and f.arhiviran = 1 and f.storno=0 and f.original is null and f.tip ='OTPREMNICA' and f.komitent=:komitent and f.oznDokumenta=:ozn") : em.createQuery("SELECT f FROM Faktura f where f.dokument.proknjizen=0 and f.arhiviran = 1 and f.storno=0 and f.original is null and ((f.tip ='FAKTURA' and f.podTip != 'POCETNO') or f.tip ='FAKTURA_USLUGA') and f.komitent=:komitent and f.oznDokumenta=:ozn");
                q.setParameter("komitent", (Object)this.k);
                q.setParameter("ozn", (Object)this.oznDokument.getVal());
                Vector data = (Vector)q.getResultList();
                if (data.size() == 1) {
                    this.faktura = (Faktura)q.getSingleResult();
                } else {
                    JOptionPane.showMessageDialog(this.getParent(), "Nijedna " + (this.otpremnica ? "otpremnica" : "faktura") + " izabranog komitenta sa unetom oznakom ne zadovaljava neophodne uslove pretrage!", "Informacija ", 1);
                    this.faktura = null;
                    return;
                }
            }
        }
    }

    public void refreshField(Faktura f) {
        this.faktura = f;
        if (f == null) {
            JOptionPane.showMessageDialog(this.getParent(), "Nije odabrana nijedna " + (this.otpremnica ? "otpremnica" : "faktura") + " izabranog komitenta!", "Informacija ", 1);
            this.sfrKomitenta.requestFocusInWindow();
            return;
        }
        this.oznDokument.setVal((Object)f.getOznDokumenta());
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogVracanjeFaktureUPripremu(Boolean.FALSE);
    }

    public PzDialogVracanjeFaktureUPripremu(Boolean initGUI) {
    }

    public boolean shouldBeShown() {
        this.mainPanel.setPaintGradient(true);
        this.mainPanel.setGradient(ProdajaGradientUtil.KOREKCIJE_GRADIENT);
        this.getSession().putParameter("gradient", (Object)ProdajaGradientUtil.KOREKCIJE_GRADIENT);
        return true;
    }
}

