/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.Date;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import rs.pezar.core.PzApplication;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Komitentparameter;
import rs.pezar.db.entity.Kurs;
import rs.pezar.db.entity.KursPK;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.prodaja.gui.PzDialogIzradaFaktureZaProdajuRobe;
import rs.pezar.prodaja.gui.fakturisanjeOtpremnica.FakturisanjeOtpremnica;
import rs.pezar.prodaja.util.PzProdajaUtil;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzDateUtility;

public class PzDialogUnosFakture
extends PzDialogInsert {
    private JLabel lblSifraKupca;
    private PzFieldIndikator indKursEvra;
    private PzPanel pnlGlavni;
    private PzFieldIndikator indKupac;
    private PzTextField tfNazivKupca;
    private PzDoubleField kursEvra;
    private JLabel jlKursEvra;
    private PzDateField dfDatumValute;
    private PzNumericOnlyTextField nfBrDanaValute;
    private PzDateField dfDatumPrometa;
    private PzDateField dfDatumIzrade;
    private PzTextField nfSifraKupca;
    private PzButton btnPotvrdi;
    private JLabel lblDatumValute;
    private JLabel lblBrojDanaValute;
    private JLabel lblDatumDPO;
    private JLabel lblDatumIzrade;
    private PzPanel pnlFields;
    private Radnajedinica rj;
    private PzPanelHeader header;
    private boolean izmena;
    private String tipF;
    private Faktura f;
    private PzTable table;
    private Komitent komitent;
    private String valuta;

    public PzDialogUnosFakture(PzDialog dialog) {
        super(dialog);
        this.izmena = Boolean.parseBoolean(this.getSession().getParameter("update").toString());
        this.paintPanel();
        this.postInit();
    }

    private void paintPanel() {
        this.pnlGlavni.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.pnlGlavni.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.pnlGlavni.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void postInit() {
        this.valuta = PzParameter.getParameterValue((String)"DEF_VALUTA", (String)"EUR");
        this.jlKursEvra.setText("Kurs valute-" + this.valuta);
    }

    protected void initGUI() {
        try {
            this.pnlGlavni = new PzPanel();
            BorderLayout pnlGlavniLayout = new BorderLayout();
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            this.pnlFields = new PzPanel();
            GridBagLayout plGlavniLayout = new GridBagLayout();
            this.pnlFields.setLayout((LayoutManager)plGlavniLayout);
            this.pnlGlavni.add((Component)this.pnlFields, (Object)"Center");
            plGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            plGlavniLayout.rowHeights = new int[]{25, 25, 25, 25, 25, 25, 7};
            plGlavniLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            plGlavniLayout.columnWidths = new int[]{146, 95, 100, 20};
            this.pnlFields.setPreferredSize(new Dimension(446, 219));
            this.pnlFields.setOpaque(false);
            this.lblSifraKupca = new JLabel();
            this.pnlFields.add((Component)this.lblSifraKupca, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.lblSifraKupca.setText("\u0160ifra kupca");
            this.lblDatumIzrade = new JLabel();
            this.pnlFields.add((Component)this.lblDatumIzrade, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblDatumIzrade.setText("Datum izrade");
            this.lblDatumDPO = new JLabel();
            this.pnlFields.add((Component)this.lblDatumDPO, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblDatumDPO.setText("Datum prometa");
            this.lblBrojDanaValute = new JLabel();
            this.pnlFields.add((Component)this.lblBrojDanaValute, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblBrojDanaValute.setText("Broj dana valute");
            this.lblDatumValute = new JLabel();
            this.pnlFields.add((Component)this.lblDatumValute, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblDatumValute.setText("Datum valute");
            this.btnPotvrdi = new PzButton();
            this.pnlFields.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check.png")));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.btnPotvrdi.setPreferredSize(new Dimension(115, 31));
            this.nfSifraKupca = new PzTextField();
            this.pnlFields.add((Component)this.nfSifraKupca, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.nfSifraKupca.setFont(new Font("Tahoma", 0, 14));
            this.nfSifraKupca.setPreferredSize(new Dimension(75, 24));
            this.nfSifraKupca.setEnabled(true);
            this.nfSifraKupca.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.nfSifraKupca.setCustomInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    if (PzDialogUnosFakture.this.komitent == null) {
                        return false;
                    }
                    if ((PzDialogUnosFakture.this.tipF.equals(TipDokumentConfig.get().FAKTURA) || PzDialogUnosFakture.this.tipF.equals(TipDokumentConfig.get().OTPREMNICA)) && !PzProdajaUtil.grupeKomitenata((PzDialog)PzDialogUnosFakture.this, PzApplication.getApplication().getSession().getLoggedUser(), PzDialogUnosFakture.this.komitent)) {
                        PzDialogUnosFakture.this.nfSifraKupca.setText("");
                        PzDialogUnosFakture.this.tfNazivKupca.setVal((Object)"");
                        return false;
                    }
                    if (PzDialogUnosFakture.this.komitent.getTip() == 2 && !PzProdajaUtil.mozeFizickoLice(PzDialogUnosFakture.this.rj, PzDialogUnosFakture.this.tipF)) {
                        PzDialogUnosFakture.this.nfSifraKupca.setVal((Object)"");
                        PzDialogUnosFakture.this.tfNazivKupca.setVal((Object)"");
                        JOptionPane.showMessageDialog((Component)PzDialogUnosFakture.this.indKupac, "Za odabrani tip dokumenta i radne jedinice nije mogu\u0107e izdati fakturu fizi\u010dkom licu!", "Informacija", 1);
                        PzDialogUnosFakture.this.nfSifraKupca.setState(PzFieldIndikator.STATE_INVALID);
                        return false;
                    }
                    if (PzDialogUnosFakture.this.komitent.getDomacaValuta() != 1) {
                        PzDialogUnosFakture.this.enableKurs(true);
                    } else {
                        PzDialogUnosFakture.this.enableKurs(false);
                    }
                    if (PzDialogUnosFakture.this.komitent.getTip() == 2) {
                        JOptionPane.showMessageDialog((Component)PzDialogUnosFakture.this.indKupac, "Odabrani komitent je fizi\u010dko lice!", "Informacija", 1);
                    }
                    return true;
                }
            });
            this.dfDatumIzrade = new PzDateField();
            this.pnlFields.add((Component)this.dfDatumIzrade, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.dfDatumIzrade.setFont(new Font("Tahoma", 0, 14));
            this.dfDatumIzrade.setPreferredSize(new Dimension(60, 24));
            this.dfDatumIzrade.setDefaultDate(PzDateUtility.getCurrentDate());
            this.dfDatumIzrade.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    PzDialogUnosFakture.this.dfDatumPrometa.setVal((Object)PzDialogUnosFakture.this.dfDatumIzrade.getVal());
                }
            });
            this.dfDatumPrometa = new PzDateField();
            this.pnlFields.add((Component)this.dfDatumPrometa, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.dfDatumPrometa.setFont(new Font("Tahoma", 0, 14));
            this.dfDatumPrometa.setPreferredSize(new Dimension(60, 24));
            this.dfDatumPrometa.setDefaultDate(PzDateUtility.getCurrentDate());
            this.dfDatumPrometa.setCustomInputVerifier(this.getInputVerifier());
            this.nfBrDanaValute = new PzNumericOnlyTextField();
            this.pnlFields.add((Component)this.nfBrDanaValute, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.nfBrDanaValute.setFont(new Font("Tahoma", 0, 14));
            this.nfBrDanaValute.setPreferredSize(new Dimension(75, 24));
            this.nfBrDanaValute.setMaxLength(3);
            this.nfBrDanaValute.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent evt) {
                    PzDialogUnosFakture.this.keyRel(evt);
                }
            });
            this.dfDatumValute = new PzDateField();
            this.pnlFields.add((Component)this.dfDatumValute, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.dfDatumValute.setFont(new Font("Tahoma", 0, 14));
            this.dfDatumValute.setPreferredSize(new Dimension(60, 24));
            this.dfDatumValute.setDefaultDate(PzDateUtility.getCurrentDate());
            this.dfDatumValute.setCustomInputVerifier(this.getInputVerifier());
            this.jlKursEvra = new JLabel();
            this.pnlFields.add((Component)this.jlKursEvra, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jlKursEvra.setText("Kurs evra");
            this.getTekstKupca();
            this.kursEvra = new PzDoubleField();
            this.pnlFields.add((Component)this.kursEvra, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 1, 0), 0, 0));
            this.pnlFields.add((Component)this.getTekstKupca(), (Object)new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 20, 0, 5), 0, 0));
            this.kursEvra.setFont(new Font("Tahoma", 0, 14));
            this.kursEvra.setPreferredSize(new Dimension(75, 24));
            this.kursEvra.setDecimalFormat(PzFormatFactory.getKursFormat());
            this.kursEvra.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    PzField field = (PzField)arg0;
                    if (PzDialogUnosFakture.this.kursEvra.getVal() <= 0.0) {
                        field.setState(PzFieldIndikator.STATE_INVALID);
                        return false;
                    }
                    if (PzDialogUnosFakture.this.izmena && PzDialogUnosFakture.this.f.getKurs() != PzDialogUnosFakture.this.kursEvra.getVal().doubleValue() && PzDialogUnosFakture.this.f.getArtikalfakturas().size() != 0) {
                        JOptionPane.showMessageDialog(PzDialogUnosFakture.this.getParent(), "Nije mogu\u0107e izmeniti kurs jer postoji promet artikala na fakturi vezan za postoje\u0107i kurs!", "Informacija", 1);
                        field.setState(PzFieldIndikator.STATE_INVALID);
                        field.setVal((Object)PzDialogUnosFakture.this.f.getKurs());
                        return false;
                    }
                    field.setState(PzFieldIndikator.STATE_VALID);
                    return true;
                }
            });
            this.kursEvra.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    String oznVal;
                    EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                    Komitentparameter val = PzDialogUnosFakture.this.komitent.getKomitentparameter("FAKVAL");
                    String string = oznVal = val != null && val.getValue() != null ? val.getValue() : null;
                    if (oznVal == null) {
                        oznVal = PzParameter.getParameterValue((String)"DEF_VALUTA", (String)"EUR", (EntityManager)em);
                    }
                    Kurs kurs = (Kurs)em.find(Kurs.class, (Object)new KursPK(oznVal, PzDialogUnosFakture.this.dfDatumPrometa.getVal()));
                    em.close();
                    if (kurs != null && PzDialogUnosFakture.this.kursEvra.getVal() == 0.0) {
                        PzDialogUnosFakture.this.kursEvra.setVal((Object)kurs.getSrednji());
                    }
                }
            });
            this.indKupac = new PzFieldIndikator();
            this.pnlFields.add((Component)this.indKupac, (Object)new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
            this.indKursEvra = new PzFieldIndikator();
            this.pnlFields.add((Component)this.indKursEvra, (Object)new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
            this.header = new PzPanelHeader();
            this.pnlGlavni.add((Component)this.header, (Object)"North");
            this.header.setIcon(this.getHeaderIcon());
            this.header.setTitle(this.getHeaderTitle());
            this.header.setOpaque(false);
            this.nfSifraKupca.setStateIndikator(this.indKupac);
            this.kursEvra.setStateIndikator(this.indKursEvra);
            this.pack();
            this.setSize(602, 330);
            this.setResizable(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.pnlFields.validateForm(true)) {
            return;
        }
        try {
            if (this.komitent == null) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Gre\u0161ka. Nisu uneti podaci o kupcu.");
                return;
            }
            String actionCommand = ((PzButton)e.getSource()).getActionCommand();
            if (actionCommand.equals("insert")) {
                Faktura propustenaProdaja;
                Komitent kom = (Komitent)PzEntityManager.find(Komitent.class, (Object)this.nfSifraKupca.getVal());
                if (this.tipF.equals("PROPUSTENA_PRODAJA") && (propustenaProdaja = PzProdajaUtil.postojiFaktura(this.tipF, this.rj, kom)) != null) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Za unetog kupca ve\u0107 postoji dokument sa propu\u0161tenom prodajom u odabranoj radnoj jedinici!", "Informacija", 1);
                    return;
                }
                Faktura f = new Faktura();
                f.setArhiviran((short)0);
                f.setStorno(0);
                f.setTip(this.tipF);
                if (this.tipF.equals("AVANSNI_RACUN")) {
                    f.setPodTip("AVANSNI_RACUN_KOLICINA");
                }
                f.setDatum(this.dfDatumIzrade.getVal());
                f.setDatPrometa(this.dfDatumPrometa.getVal());
                f.setDatValute(this.dfDatumValute.getVal());
                f.setKurs(this.kursEvra.getVal().doubleValue());
                f.setKomitent(kom);
                f.setRadnajedinica(this.rj);
                f.setProknjizen((short)0);
                if (this.tipF.equals("FAKTURA_ZA_OTPREMNICE")) {
                    f.setTip("FAKTURA");
                    f.setZaOtpremnice((short)1);
                    PzDokumentManager.getInstance().snimiDokument((PzDokument)f, true, null);
                    ((FakturisanjeOtpremnica)((Object)this.getParent())).setFaktura(f);
                } else {
                    this.table.insert((PzEntity)f, true);
                }
            } else if (actionCommand.equals("update")) {
                if (!this.tipF.equals("FAKTURA_ZA_OTPREMNICE")) {
                    this.f = (Faktura)PzEntityManager.find(Faktura.class, (Object)this.f.getIdDok());
                    this.f.setKomitent((Komitent)PzEntityManager.find(Komitent.class, (Object)this.nfSifraKupca.getVal()));
                }
                this.f.setDatum(this.dfDatumIzrade.getVal());
                this.f.setDatPrometa(this.dfDatumPrometa.getVal());
                this.f.setDatValute(this.dfDatumValute.getVal());
                this.f.setKurs(this.kursEvra.getVal().doubleValue());
                if (this.f.getZaOtpremnice() == 1) {
                    PzEntityManager.update((Object)this.f);
                    ((FakturisanjeOtpremnica)((Object)this.getParent())).setAkcija(true);
                } else {
                    this.table.updateSelectedEntity((PzEntity)this.f, true);
                    ((PzDialogIzradaFaktureZaProdajuRobe)((Object)this.getParent())).initializeTable(false);
                }
            }
            this.dispose();
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    private void keyRel(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            Date datPrometa = this.dfDatumPrometa.getVal();
            if (evt.getComponent() instanceof PzNumericOnlyTextField) {
                int val = this.nfBrDanaValute.getIntVal();
                this.dfDatumValute.setVal((Object)PzDateUtility.add((Date)datPrometa, (int)val));
            }
        }
    }

    protected void onInsert() {
        this.table = (PzTable)this.getSession().getParameter("tabela");
        this.tipF = this.getSession().getParameter("tipDokumenta").toString();
        this.btnPotvrdi.setActionCommand("insert");
    }

    protected void onUpdate() {
        this.table = (PzTable)this.getSession().getParameter("tabela");
        this.tipF = this.getSession().getParameter("tipDokumenta").toString();
        this.btnPotvrdi.setActionCommand("update");
        if (this.tipF.equals("FAKTURA_ZA_OTPREMNICE")) {
            this.f = (Faktura)this.getSession().getParameter("faktura");
            this.nfSifraKupca.setEditable(false);
            this.nfSifraKupca.setFocusable(false);
            this.komitent = this.f.getKomitent();
        } else {
            this.f = (Faktura)this.table.getSelectedEntity();
        }
        this.nfSifraKupca.setVal((Object)this.f.getKomitent().getSfrKomitent());
        this.tfNazivKupca.setVal((Object)this.f.getKomitent().getNaziv());
        this.dfDatumIzrade.setVal((Object)this.f.getDatum());
        this.dfDatumPrometa.setVal((Object)this.f.getDatPrometa());
        this.dfDatumValute.setVal((Object)this.f.getDatValute());
        this.kursEvra.setVal((Object)this.f.getKurs());
        if (this.f.getKomitent().getDomacaValuta() == 1) {
            this.enableKurs(false);
        } else {
            this.enableKurs(true);
        }
        this.nfBrDanaValute.setVal((Object)PzDateUtility.subtract((Date)this.f.getDatValute(), (Date)this.f.getDatPrometa()));
        this.pnlFields.updateAllFieldsState();
    }

    private void enableKurs(boolean enable) {
        this.jlKursEvra.setEnabled(enable);
        this.kursEvra.setEnabled(enable);
        this.indKursEvra.setEnabled(enable);
        if (!enable) {
            this.kursEvra.setVal((Object)0);
        } else {
            Komitentparameter val = this.komitent.getKomitentparameter("FAKVAL");
            String string = this.valuta = val != null && val.getValue() != null ? val.getValue() : null;
            if (this.valuta == null) {
                this.valuta = PzParameter.getParameterValue((String)"DEF_VALUTA", (String)"EUR");
            }
            this.jlKursEvra.setText("Kurs valute-" + this.valuta);
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.komitent = (Komitent)entity;
            this.nfSifraKupca.setVal((Object)this.komitent.getSfrKomitent());
            this.tfNazivKupca.setVal((Object)this.komitent.getNaziv());
        }
    }

    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Unos novog dokumenta");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/note_new.png")));
    }

    protected void setHeaderOnUpdate() {
        this.setHeaderTitle("Izmena dokumenta");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/note_new.png")));
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogUnosFakture(Boolean.FALSE);
    }

    public PzDialogUnosFakture(Boolean initGUI) {
    }

    public boolean shouldBeShown() {
        boolean result = true;
        this.tipF = this.getSession().getParameter("tipDokumenta").toString();
        if (this.izmena) {
            this.rj = this.f.getRadnajedinica();
            this.setTitle("Izmena dokumenta iz [ " + this.rj.getId().getOznRj() + " ] " + this.rj.getNaziv());
        } else {
            this.rj = this.tipF.equals("FAKTURA") ? PzDialogRJ.getRJ((PzDialog)this.getParentDialog(), (Character[])new Character[]{Character.valueOf("V".charAt(0)), Character.valueOf("E".charAt(0)), Character.valueOf("T".charAt(0)), Character.valueOf("K".charAt(0)), Character.valueOf("G".charAt(0))}) : (this.tipF.equals("FAKTURA_ZA_OTPREMNICE") ? (Radnajedinica)this.getSession().getParameter("radnaJedinica") : (this.tipF.equals("OTPREMNICA") ? PzDialogRJ.getRJ((PzDialog)this.getParentDialog(), (Character[])new Character[]{Character.valueOf("V".charAt(0)), Character.valueOf("K".charAt(0)), Character.valueOf("T".charAt(0)), Character.valueOf("E".charAt(0)), Character.valueOf("G".charAt(0))}) : (this.tipF.equals("PRENOSNICA_SA_KONSIGNACIJE") ? PzDialogRJ.getRJ((PzDialog)this.getParentDialog(), (String[])new String[]{"T", "ET"}) : (this.tipF.equals("PROFAKTURA") || this.tipF.equals("AVANSNI_RACUN") || this.tipF.equals("FAKTURA_TRANZITA") ? PzDialogRJ.getRJ((PzDialog)this.getParentDialog(), (Character[])new Character[]{Character.valueOf("V".charAt(0)), Character.valueOf("K".charAt(0)), Character.valueOf("E".charAt(0))}) : (this.tipF.equals("PROPUSTENA_PRODAJA") ? PzDialogRJ.getRJ((PzDialog)this.getParentDialog(), (String[])new String[]{"V", "EL", "T"}) : PzDialogRJ.getRJ((PzDialog)this.getParentDialog()))))));
            if (this.rj != null) {
                this.setTitle("Otvaranje novog dokumenta u " + this.rj.getOgranak().getNaziv() + "-" + this.rj.getNaziv());
            } else {
                result = false;
            }
        }
        return result;
    }

    private PzTextField getTekstKupca() {
        if (this.tfNazivKupca == null) {
            this.tfNazivKupca = new PzTextField();
            this.tfNazivKupca.setFocusable(false);
            this.tfNazivKupca.setSize(188, 24);
            this.tfNazivKupca.setPreferredSize(new Dimension(6, 24));
            this.tfNazivKupca.setCaretPosition(0);
        }
        return this.tfNazivKupca;
    }

    private InputVerifier getInputVerifier() {
        return new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                Date datPrometa = PzDialogUnosFakture.this.dfDatumPrometa.getVal();
                if (input == PzDialogUnosFakture.this.dfDatumPrometa) {
                    Date datIzrade = PzDialogUnosFakture.this.dfDatumIzrade.getVal();
                    int razlika = PzDateUtility.subtract((Date)datPrometa, (Date)datIzrade);
                    if (razlika > 0) {
                        JOptionPane.showMessageDialog(PzDialogUnosFakture.this.getParent(), "Datum prometa ne mo\u017ee biti posle datuma izrade!", "Informacija", 1);
                        return false;
                    }
                    if (PzDialogUnosFakture.this.komitent.getDomacaValuta() != 1) {
                        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                        Kurs kurs = (Kurs)em.find(Kurs.class, (Object)new KursPK(PzParameter.getParameterValue((String)"DEF_VALUTA", (String)"EUR", (EntityManager)em), PzDialogUnosFakture.this.dfDatumPrometa.getVal()));
                        em.close();
                        if (kurs == null) {
                            PzSwingUtility.showErrorMessage((Component)((Object)PzDialogUnosFakture.this), (String)("Na datum prometa ne postoji kurs valute! Preuzmite kurs za valutu - " + PzDialogUnosFakture.this.valuta + " na datum prometa kroz opciju: \u0160ifarnici->Kursna lista"));
                            return false;
                        }
                    }
                } else {
                    Date datValute = PzDialogUnosFakture.this.dfDatumValute.getVal();
                    int razlika = PzDateUtility.subtract((Date)datValute, (Date)datPrometa);
                    if (razlika < 0) {
                        JOptionPane.showMessageDialog(PzDialogUnosFakture.this.getParent(), "Datum valute ne mo\u017ee biti manji od datuma prometa!", "Informacija", 1);
                        return false;
                    }
                    PzDialogUnosFakture.this.nfBrDanaValute.setVal((Object)razlika);
                }
                return true;
            }
        };
    }
}

