/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.prodaja.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Dokument;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Komitent;
import rs.pezar.prodaja.gui.faktureZaProdajuRobe.UzmiDokument;
import rs.pezar.prodaja.util.ProdajaGradientUtil;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDateField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzCacheUtility;

public class PzDialogIzmenaDatumaValute
extends PzDialog {
    private static final long serialVersionUID = -1487091348925367428L;
    private PzTextField nazKomitenta;
    private PzNumericOnlyTextField sfrKomitenta;
    private PzDateField dfDatum;
    private JLabel lblDatum;
    private PzButton btnOk;
    private PzPanel panelButtons;
    private PzTextField oznDokument;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private Komitent k;
    private Faktura faktura;
    private PzPanel mainPanel;

    public PzDialogIzmenaDatumaValute(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        GridBagLayout layout = new GridBagLayout();
        this.setTitle("Vra\u0107anje fakture u pripremu");
        layout.rowWeights = new double[]{0.1, 0.0, 0.0, 0.0, 0.1};
        layout.rowHeights = new int[]{7, 25, 25, 20, 20};
        layout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
        layout.columnWidths = new int[]{103, 90, 76, 20};
        this.mainPanel = new PzPanel();
        this.mainPanel.setLayout((LayoutManager)layout);
        this.getContentPane().add((Component)this.mainPanel);
        this.nazKomitenta = new PzTextField();
        this.mainPanel.add((Component)this.nazKomitenta, (Object)new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 2, 1, 50), 0, 0));
        this.nazKomitenta.setName("nazKomitenta");
        this.nazKomitenta.setEditable(false);
        this.nazKomitenta.setFocusable(false);
        this.sfrKomitenta = new PzNumericOnlyTextField();
        this.mainPanel.add((Component)this.sfrKomitenta, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 1, 0), 0, 0));
        this.sfrKomitenta.setName("sfrKomitenta");
        this.sfrKomitenta.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
        this.jLabel1 = new JLabel();
        this.mainPanel.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 3), 0, 0));
        this.jLabel1.setText("\u0160ifra komitent");
        this.jLabel2 = new JLabel();
        this.mainPanel.add((Component)this.jLabel2, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 3), 0, 0));
        this.jLabel2.setText("Faktura");
        this.oznDokument = new PzTextField();
        this.mainPanel.add((Component)this.oznDokument, (Object)new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.oznDokument.setName("oznDokument");
        this.oznDokument.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PzDialogIzmenaDatumaValute.this.keyRel(evt);
            }
        });
        this.panelButtons = new PzPanel();
        this.mainPanel.add((Component)this.panelButtons, (Object)new GridBagConstraints(0, 4, 4, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        FlowLayout panelButtonsLayout = new FlowLayout();
        panelButtonsLayout.setHgap(0);
        this.panelButtons.setLayout((LayoutManager)panelButtonsLayout);
        this.panelButtons.setOpaque(false);
        this.btnOk = new PzButton();
        this.panelButtons.add((Component)this.btnOk);
        this.btnOk.setPreferredSize(new Dimension(100, 30));
        this.btnOk.setText("Potvrdi");
        this.btnOk.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/prodaja/resource/img/check.png")));
        this.btnOk.addActionListener((ActionListener)((Object)this));
        this.lblDatum = new JLabel();
        this.mainPanel.add((Component)this.lblDatum, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 3), 0, 0));
        this.lblDatum.setText("Datum valute");
        this.dfDatum = new PzDateField();
        this.mainPanel.add((Component)this.dfDatum, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pack();
        this.setSize(582, 161);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.faktura == null) {
            JOptionPane.showMessageDialog(this.getParent(), "Nije odabran nijedan dokument izabranog komitenta!", "Informacija ", 1);
            this.sfrKomitenta.requestFocusInWindow();
        } else {
            EntityManager em = PzEntityManager.getEm();
            this.faktura = (Faktura)em.find(Faktura.class, (Object)this.faktura.getIdDok());
            int rez = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Da li ste sigurni da \u017eelite da promenite datum valute?", (String)"Izmena datuma valute", null, (boolean)false);
            if (rez != 0) {
                this.sfrKomitenta.requestFocusInWindow();
                return;
            }
            try {
                try {
                    em.getTransaction().begin();
                    this.faktura.setDatValute(this.dfDatum.getVal());
                    Dokument dok = (Dokument)em.find(Dokument.class, (Object)this.faktura.getIdDok());
                    dok.setDatValute(this.dfDatum.getVal());
                    em.getTransaction().commit();
                    PzCacheUtility.removeReportFromCache((PzDokument)dok);
                    this.dispose();
                }
                catch (Exception ex) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
                    em.close();
                }
            }
            finally {
                em.close();
            }
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.k = (Komitent)entity;
            this.sfrKomitenta.setVal((Object)this.k.getSfrKomitent());
            this.nazKomitenta.setVal((Object)this.k.getNaziv());
        }
        if (entity == null) {
            this.nazKomitenta.setVal((Object)"");
        }
    }

    private void keyRel(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.faktura = null;
            if (this.oznDokument.getVal().equals("")) {
                this.getSession().putParameter("izmenaDatumaValute", (Object)true);
                this.getSession().putParameter("komitent", (Object)this.k);
                this.showDialog(UzmiDokument.class);
                if (this.faktura == null) {
                    JOptionPane.showMessageDialog(this.getParent(), "Nije odabrana nijedna faktura izabranog komitenta!", "Informacija ", 1);
                    this.sfrKomitenta.requestFocusInWindow();
                    return;
                }
            } else {
                EntityManager em = PzEntityManager.getEm();
                Query q = null;
                q = em.createQuery("SELECT f FROM Faktura f where f.dokument.proknjizen=1 and f.arhiviran = 1 and f.storno=0 and f.original is null and f.tip ='FAKTURA' and f.podTip != 'POCETNO' and f.komitent=:komitent and f.oznDokumenta=:ozn");
                q.setParameter("komitent", (Object)this.k);
                q.setParameter("ozn", (Object)this.oznDokument.getVal());
                Vector data = (Vector)q.getResultList();
                if (data.size() == 1) {
                    this.faktura = (Faktura)q.getSingleResult();
                } else {
                    JOptionPane.showMessageDialog(this.getParent(), "Nijedna faktura izabranog komitenta sa unetom oznakom ne zadovaljava neophodne uslove pretrage!", "Informacija ", 1);
                    this.faktura = null;
                    return;
                }
            }
            this.dfDatum.setVal((Object)this.faktura.getDatValute());
        }
    }

    public void refreshField(Faktura f) {
        this.faktura = f;
        if (f == null) {
            JOptionPane.showMessageDialog(this.getParent(), "Nije odabrana nijedna faktura izabranog komitenta!", "Informacija ", 1);
            this.sfrKomitenta.requestFocusInWindow();
            return;
        }
        this.oznDokument.setVal((Object)f.getOznDokumenta());
        this.dfDatum.setVal((Object)this.faktura.getDatValute());
    }

    public boolean shouldBeShown() {
        this.mainPanel.setPaintGradient(true);
        this.mainPanel.setGradient(ProdajaGradientUtil.KOREKCIJE_GRADIENT);
        this.getSession().putParameter("gradient", (Object)ProdajaGradientUtil.KOREKCIJE_GRADIENT);
        return true;
    }
}

