/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.dock.util.AbstractWindowProvider;
import bibliothek.gui.dock.util.WindowProviderListener;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.SwingUtilities;

public class ComponentWindowProvider
extends AbstractWindowProvider {
    private Component component;
    private Window window;
    private HierarchyListener listener = new HierarchyListener(){

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            Window oldWindow = ComponentWindowProvider.this.window;
            ComponentWindowProvider.this.window = ComponentWindowProvider.this.getWindowAncestor(ComponentWindowProvider.this.component);
            if (oldWindow != ComponentWindowProvider.this.window) {
                ComponentWindowProvider.this.fireWindowChanged(ComponentWindowProvider.this.window);
            }
        }
    };

    public ComponentWindowProvider(Component component) {
        this.component = component;
    }

    @Override
    public void addWindowProviderListener(WindowProviderListener listener) {
        int previous = this.listeners.size();
        super.addWindowProviderListener(listener);
        if (previous == 0 && this.listeners.size() > 0 && this.component != null) {
            this.component.addHierarchyListener(this.listener);
            this.window = this.getWindowAncestor(this.component);
        }
    }

    @Override
    public void removeWindowProviderListener(WindowProviderListener listener) {
        int previous = this.listeners.size();
        super.removeWindowProviderListener(listener);
        if (previous > 0 && this.listeners.size() == 0 && this.component != null) {
            this.component.removeHierarchyListener(this.listener);
        }
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        if (this.listeners.size() == 0) {
            this.component = component;
        } else {
            if (this.component != null) {
                this.component.removeHierarchyListener(this.listener);
            }
            this.component = component;
            if (this.component != null) {
                this.component.addHierarchyListener(this.listener);
            }
            Window oldWindow = this.window;
            Window window = this.window = component == null ? null : this.getWindowAncestor(component);
            if (oldWindow != this.window) {
                this.fireWindowChanged(this.window);
            }
        }
    }

    @Override
    public Window searchWindow() {
        if (this.component == null) {
            return null;
        }
        if (this.listeners.size() == 0) {
            return this.getWindowAncestor(this.component);
        }
        return this.window;
    }

    private Window getWindowAncestor(Component component) {
        if (component instanceof Window) {
            return (Window)component;
        }
        return SwingUtilities.getWindowAncestor(component);
    }
}

