/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;

public interface AWTComponentCaptureStrategy {
    public static final AWTComponentCaptureStrategy SCREEN_CAPTURE_STRATEGY = new AWTComponentCaptureStrategy(){

        @Override
        public BufferedImage createCapture(DockController controller, Component component) {
            GraphicsDevice device;
            block8: {
                GraphicsConfiguration configuration;
                block7: {
                    block6: {
                        if (component.isShowing()) break block6;
                        return null;
                    }
                    configuration = component.getGraphicsConfiguration();
                    if (configuration != null) break block7;
                    return null;
                }
                device = configuration.getDevice();
                if (device != null) break block8;
                return null;
            }
            try {
                Robot deviceRobot = new Robot(device);
                Point location = new Point(0, 0);
                SwingUtilities.convertPointToScreen(location, component);
                return deviceRobot.createScreenCapture(new Rectangle(location, component.getSize()));
            }
            catch (AWTException e) {
                e.printStackTrace();
                return null;
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
    };
    public static final AWTComponentCaptureStrategy RECURSIVE_PAINT_STRATEGY = new AWTComponentCaptureStrategy(){

        @Override
        public BufferedImage createCapture(DockController controller, Component component) {
            BufferedImage image = new BufferedImage(component.getWidth(), component.getHeight(), 2);
            Graphics2D g = image.createGraphics();
            this.forcePaint(component, g);
            g.dispose();
            return image;
        }

        private void forcePaint(Component component, Graphics g) {
            component.paintAll(g);
            if (component instanceof Container) {
                Container container = (Container)component;
                int i = 0;
                int n = container.getComponentCount();
                while (i < n) {
                    Component next = container.getComponent(i);
                    int width = next.getWidth();
                    int height = next.getHeight();
                    if (width > 0 && height > 0) {
                        Graphics sub = g.create(next.getX(), next.getY(), width, height);
                        this.forcePaint(next, sub);
                        sub.dispose();
                    }
                    ++i;
                }
            }
        }
    };
    public static final AWTComponentCaptureStrategy PAINT_ALL_STRATEGY = new AWTComponentCaptureStrategy(){

        @Override
        public BufferedImage createCapture(DockController controller, Component component) {
            BufferedImage image = new BufferedImage(component.getWidth(), component.getHeight(), 2);
            Graphics2D g = image.createGraphics();
            component.paintAll(g);
            g.dispose();
            return image;
        }
    };
    public static final PropertyKey<AWTComponentCaptureStrategy> STRATEGY = new PropertyKey<AWTComponentCaptureStrategy>("dock.AWTComponentCaptureStrategy", new ConstantPropertyFactory<AWTComponentCaptureStrategy>(PAINT_ALL_STRATEGY), true);

    public BufferedImage createCapture(DockController var1, Component var2);
}

