/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.title;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;

public abstract class DockTitleRequest {
    private Dockable target;
    private DockStation parent;
    private DockTitleVersion version;
    private DockTitle title;
    private boolean answered = false;
    private boolean installed = false;
    private boolean requesting = false;

    public DockTitleRequest(DockStation parent, Dockable target, DockTitleVersion version) {
        if (target == null) {
            throw new IllegalArgumentException("target must not be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("version must not be null");
        }
        this.target = target;
        this.parent = parent;
        this.version = version;
    }

    public void install() {
        if (!this.installed) {
            this.installed = true;
            this.version.install(this);
        }
    }

    public void uninstall() {
        if (this.installed) {
            this.installed = false;
            this.version.uninstall(this);
        }
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public Dockable getTarget() {
        return this.target;
    }

    public DockStation getParent() {
        return this.parent;
    }

    public DockTitleVersion getVersion() {
        return this.version;
    }

    protected abstract void answer(DockTitle var1, DockTitle var2);

    public void request() {
        this.answered = false;
        DockTitle old = this.title;
        try {
            this.requesting = true;
            this.executeRequestList();
        }
        finally {
            this.requesting = false;
        }
        if (old != this.title) {
            this.answer(old, this.title);
        }
    }

    protected boolean isAnswered() {
        return this.answered;
    }

    protected void executeRequestList() {
        this.requestDockTitle(this);
        if (this.answered) {
            return;
        }
        this.target.requestDockTitle(this);
        if (this.answered) {
            return;
        }
        if (this.parent != null) {
            this.parent.requestChildDockTitle(this);
            if (this.answered) {
                return;
            }
        }
        this.version.request(this);
    }

    public void requestDockTitle(DockTitleRequest request) {
    }

    public void requestNull() {
        if (this.title != null) {
            DockTitle old = this.title;
            this.title = null;
            this.answer(old, this.title);
        }
    }

    public void answer(DockTitle title) {
        if (!this.requesting) {
            throw new IllegalStateException("not requesting a title");
        }
        this.answered = true;
        this.title = title;
    }

    public DockTitle getAnswer() {
        return this.title;
    }
}

