/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.menu;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.CombinedHandler;
import bibliothek.gui.dock.station.stack.CombinedMenu;
import bibliothek.gui.dock.station.stack.menu.CombinedMenuContent;
import bibliothek.gui.dock.station.stack.menu.CombinedMenuContentListener;
import bibliothek.gui.dock.station.stack.tab.AbstractTabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.TabMenu;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.TabPaneMenuBackgroundComponent;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPaint;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public abstract class AbstractCombinedMenu
extends AbstractTabPaneComponent
implements CombinedMenu {
    private Component component;
    private Background background = new Background();
    private PropertyValue<CombinedMenuContent> content = new PropertyValue<CombinedMenuContent>(CombinedMenuContent.MENU_CONTENT){

        @Override
        protected void valueChanged(CombinedMenuContent oldValue, CombinedMenuContent newValue) {
        }
    };
    private List<Entry> entries = new ArrayList<Entry>();
    private DockController controller;
    private CombinedHandler<? super AbstractCombinedMenu> handler;

    public AbstractCombinedMenu(TabPane parent, CombinedHandler<? super AbstractCombinedMenu> handler) {
        super(parent);
        this.handler = handler;
    }

    protected void ensureComponent() {
        if (this.component == null) {
            this.component = this.createComponent();
        }
    }

    protected BackgroundAlgorithm getBackground() {
        return this.background;
    }

    protected void backgroundChanged(BackgroundPaint paint) {
    }

    protected abstract Component createComponent();

    public void open() {
        Handler handler = new Handler();
        handler.open();
    }

    protected void closed() {
    }

    @Override
    public void setController(DockController controller) {
        this.controller = controller;
        this.content.setProperties(controller);
        this.background.setController(controller);
    }

    public DockController getController() {
        return this.controller;
    }

    @Override
    public void setPaneVisible(boolean visible) {
        this.handler.setVisible(this, visible);
    }

    @Override
    public boolean isPaneVisible() {
        return this.handler.isVisible(this);
    }

    @Override
    public void setZOrder(int order) {
        this.handler.setZOrder(this, order);
    }

    @Override
    public int getZOrder() {
        return this.handler.getZOrder(this);
    }

    protected abstract void selected(Dockable var1);

    @Override
    public Component getComponent() {
        this.ensureComponent();
        return this.component;
    }

    @Override
    public void setIcon(int index, Icon icon) {
        this.entries.get((int)index).icon = icon;
    }

    @Override
    public void setText(int index, String text) {
        this.entries.get((int)index).text = text;
    }

    @Override
    public void setTooltip(int index, String tooltip) {
        this.entries.get((int)index).tooltip = tooltip;
    }

    @Override
    public void insert(int index, Dockable dockable) {
        Entry entry = new Entry();
        entry.dockable = dockable;
        entry.icon = dockable.getTitleIcon();
        entry.text = dockable.getTitleText();
        entry.tooltip = dockable.getTitleToolTip();
        this.entries.add(index, entry);
    }

    @Override
    public void remove(Dockable dockable) {
        int i = 0;
        int n = this.entries.size();
        while (i < n) {
            if (this.entries.get((int)i).dockable == dockable) {
                this.entries.remove(i);
                return;
            }
            ++i;
        }
    }

    @Override
    public Dockable[] getDockables() {
        Dockable[] result = new Dockable[this.entries.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.entries.get((int)i).dockable;
            ++i;
        }
        return result;
    }

    @Override
    public int getDockableCount() {
        return this.entries.size();
    }

    @Override
    public Dockable getDockable(int index) {
        return this.entries.get((int)index).dockable;
    }

    private class Background
    extends BackgroundAlgorithm
    implements TabPaneMenuBackgroundComponent {
        public Background() {
            super(TabPaneMenuBackgroundComponent.KIND, "dock.background.tabPane.child.menu");
        }

        @Override
        public void set(BackgroundPaint value) {
            super.set(value);
            AbstractCombinedMenu.this.backgroundChanged(this.getPaint());
        }

        @Override
        public TabMenu getMenu() {
            return AbstractCombinedMenu.this;
        }

        @Override
        public TabPaneComponent getChild() {
            return AbstractCombinedMenu.this;
        }

        @Override
        public TabPane getPane() {
            return this.getMenu().getTabParent();
        }

        @Override
        public Component getComponent() {
            return AbstractCombinedMenu.this.component;
        }
    }

    private static class Entry {
        public Dockable dockable;
        public String text;
        public String tooltip;
        public Icon icon;

        private Entry() {
        }

        public CombinedMenuContent.Item toItem() {
            return new CombinedMenuContent.Item(this.dockable, this.text, this.tooltip, this.icon);
        }
    }

    private class Handler
    implements CombinedMenuContentListener {
        private CombinedMenuContent menu;

        public Handler() {
            this.menu = (CombinedMenuContent)AbstractCombinedMenu.this.content.getValue();
        }

        public void open() {
            if (this.menu == null) {
                return;
            }
            Component component = AbstractCombinedMenu.this.getComponent();
            CombinedMenuContent.Item[] items = new CombinedMenuContent.Item[AbstractCombinedMenu.this.entries.size()];
            int i = 0;
            while (i < items.length) {
                items[i] = ((Entry)AbstractCombinedMenu.this.entries.get(i)).toItem();
                ++i;
            }
            this.menu.addCombinedMenuContentListener(this);
            this.menu.open(AbstractCombinedMenu.this.controller, component, 0, component.getHeight(), items);
        }

        @Override
        public void opened(CombinedMenuContent menu) {
        }

        @Override
        public void canceled(CombinedMenuContent menu) {
            menu.removeCombinedMenuContentListener(this);
        }

        @Override
        public void selected(CombinedMenuContent menu, Dockable selection) {
            menu.removeCombinedMenuContentListener(this);
            AbstractCombinedMenu.this.selected(selection);
        }
    }
}

