/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.dock.layout.AbstractDockableProperty;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.split.SplitDockProperty;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SplitDockPathProperty
extends AbstractDockableProperty
implements Iterable<Node> {
    private List<Node> nodes = new LinkedList<Node>();
    private long leafId = -1L;

    @Override
    public DockableProperty copy() {
        SplitDockPathProperty copy = new SplitDockPathProperty();
        for (Node node : this.nodes) {
            copy.add(node.getLocation(), node.getSize(), node.getId());
        }
        copy.setLeafId(this.getLeafId());
        this.copy(copy);
        return copy;
    }

    @Override
    public Iterator<Node> iterator() {
        return this.nodes.iterator();
    }

    public int size() {
        return this.nodes.size();
    }

    public Node getNode(int index) {
        return this.nodes.get(index);
    }

    public void setLeafId(long leafId) {
        this.leafId = leafId;
    }

    public long getLeafId() {
        return this.leafId;
    }

    public Node getLastNode() {
        if (this.nodes.isEmpty()) {
            return null;
        }
        return this.nodes.get(this.nodes.size() - 1);
    }

    public SplitDockProperty toLocation() {
        double x = 0.0;
        double y = 0.0;
        double w = 1.0;
        double h = 1.0;
        for (Node node : this.nodes) {
            switch (node.getLocation()) {
                case LEFT: {
                    w *= node.getSize();
                    break;
                }
                case RIGHT: {
                    x = x + w - w * node.getSize();
                    w *= node.getSize();
                    break;
                }
                case TOP: {
                    h *= node.getSize();
                    break;
                }
                case BOTTOM: {
                    y = y + h - h * node.getSize();
                    h *= node.getSize();
                }
            }
        }
        SplitDockProperty property = new SplitDockProperty(x, y, w, h);
        property.setSuccessor(this.getSuccessor());
        return property;
    }

    public SplitDockProperty toLocation(SplitNode onPath) {
        SplitDockProperty result;
        if (onPath == null || onPath.getId() == -1L) {
            return this.toLocation();
        }
        long id = onPath.getId();
        if (this.getLeafId() == id) {
            result = new SplitDockProperty(onPath.getX(), onPath.getY(), onPath.getWidth(), onPath.getHeight());
        } else {
            double x = 0.0;
            double y = 0.0;
            double w = 1.0;
            double h = 1.0;
            for (Node node : this.nodes) {
                if (node.getId() == id) {
                    x = onPath.getX();
                    y = onPath.getY();
                    w = onPath.getWidth();
                    h = onPath.getHeight();
                }
                switch (node.getLocation()) {
                    case LEFT: {
                        w *= node.getSize();
                        break;
                    }
                    case RIGHT: {
                        x = x + w - w * node.getSize();
                        w *= node.getSize();
                        break;
                    }
                    case TOP: {
                        h *= node.getSize();
                        break;
                    }
                    case BOTTOM: {
                        y = y + h - h * node.getSize();
                        h *= node.getSize();
                    }
                }
            }
            result = new SplitDockProperty(x, y, w, h);
        }
        result.setSuccessor(this.getSuccessor());
        return result;
    }

    public void add(Location location, double size, long id) {
        this.insert(location, size, this.nodes.size(), id);
    }

    public void insert(Location location, double size, int index, long id) {
        if (location == null) {
            throw new NullPointerException("location must not be null");
        }
        if (size < 0.0 || size > 1.0) {
            throw new IllegalArgumentException("size must be in the range 0.0 to 1.0");
        }
        this.nodes.add(index, new Node(location, size, id));
    }

    @Override
    public String getFactoryID() {
        return "SplitDockPathProperty";
    }

    @Override
    public void store(DataOutputStream out) throws IOException {
        Version.write(out, Version.VERSION_1_0_8);
        out.writeInt(this.nodes.size());
        for (Node node : this.nodes) {
            switch (node.getLocation()) {
                case LEFT: {
                    out.writeByte(0);
                    break;
                }
                case RIGHT: {
                    out.writeByte(1);
                    break;
                }
                case TOP: {
                    out.writeByte(2);
                    break;
                }
                case BOTTOM: {
                    out.writeByte(3);
                }
            }
            out.writeDouble(node.getSize());
            out.writeLong(node.getId());
        }
        out.writeLong(this.leafId);
    }

    @Override
    public void store(XElement element) {
        for (Node node : this.nodes) {
            XElement xnode = element.addElement("node");
            xnode.addString("location", node.getLocation().name());
            xnode.addDouble("size", node.getSize());
            if (node.getId() < 0L) continue;
            xnode.addLong("id", node.getId());
        }
        element.addElement("leaf").addLong("id", this.leafId);
    }

    @Override
    public void load(DataInputStream in) throws IOException {
        Version version = Version.read(in);
        version.checkCurrent();
        boolean version8 = Version.VERSION_1_0_8.compareTo(version) <= 0;
        this.nodes.clear();
        int count = in.readInt();
        while (count > 0) {
            --count;
            Location location = null;
            switch (in.readByte()) {
                case 0: {
                    location = Location.LEFT;
                    break;
                }
                case 1: {
                    location = Location.RIGHT;
                    break;
                }
                case 2: {
                    location = Location.TOP;
                    break;
                }
                case 3: {
                    location = Location.BOTTOM;
                }
            }
            double size = in.readDouble();
            long id = -1L;
            if (version8) {
                id = in.readLong();
            }
            this.nodes.add(new Node(location, size, id));
        }
        this.leafId = version8 ? in.readLong() : -1L;
    }

    @Override
    public void load(XElement element) {
        this.nodes.clear();
        XElement[] xElementArray = element.getElements("node");
        int n = xElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            XElement xnode = xElementArray[n2];
            Location location = Location.valueOf(xnode.getString("location"));
            double size = xnode.getDouble("size");
            long id = -1L;
            if (xnode.attributeExists("id")) {
                id = xnode.getLong("id");
            }
            this.nodes.add(new Node(location, size, id));
            ++n2;
        }
        XElement xleaf = element.getElement("leaf");
        this.leafId = xleaf != null ? xleaf.getLong("id") : -1L;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[nodes=" + this.nodes + ", leaf=" + this.leafId + "]";
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.nodes == null ? 0 : this.nodes.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SplitDockPathProperty)) {
            return false;
        }
        SplitDockPathProperty other = (SplitDockPathProperty)obj;
        return !(this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes));
    }

    public static enum Location {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }

    public static class Node {
        private double size;
        private Location location;
        private long id;

        public Node(Location location, double size, long id) {
            this.location = location;
            this.size = size;
            this.id = id;
        }

        public double getSize() {
            return this.size;
        }

        public Location getLocation() {
            return this.location;
        }

        public long getId() {
            return this.id;
        }

        public String toString() {
            return "[size=" + this.size + ", location=" + (Object)((Object)this.location) + ", id=" + this.id + "]";
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
            long temp = Double.doubleToLongBits(this.size);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Node)) {
                return false;
            }
            Node other = (Node)obj;
            if (this.location == null ? other.location != null : !this.location.equals((Object)other.location)) {
                return false;
            }
            return Double.doubleToLongBits(this.size) == Double.doubleToLongBits(other.size);
        }
    }
}

