/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.screen.ScreenDockFullscreenStrategy;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.station.screen.ScreenDockWindowBackgroundComponent;
import bibliothek.gui.dock.station.screen.ScreenDockWindowListener;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPaint;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class DisplayerScreenDockWindow
implements ScreenDockWindow {
    private ScreenDockStation station;
    private StationChildHandle handle;
    private List<ScreenDockWindowListener> listeners = new ArrayList<ScreenDockWindowListener>();
    private DockableDisplayerListener displayerListener = new DockableDisplayerListener(){

        @Override
        public void discard(DockableDisplayer displayer) {
            DisplayerScreenDockWindow.this.discardDisplayer();
        }
    };
    private DockController controller;
    private boolean showTitle = true;
    private ScreenDockFullscreenStrategy strategy;
    private Rectangle normalBounds;
    private Background background = new Background();

    public DisplayerScreenDockWindow(ScreenDockStation station) {
        if (station == null) {
            throw new IllegalArgumentException("station must not be null");
        }
        this.station = station;
    }

    @Override
    public void addScreenDockWindowListener(ScreenDockWindowListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeScreenDockWindowListener(ScreenDockWindowListener listener) {
        this.listeners.remove(listener);
    }

    protected ScreenDockWindowListener[] listeners() {
        return this.listeners.toArray(new ScreenDockWindowListener[this.listeners.size()]);
    }

    protected void fireFullscreenChanged() {
        ScreenDockWindowListener[] screenDockWindowListenerArray = this.listeners();
        int n = screenDockWindowListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScreenDockWindowListener listener = screenDockWindowListenerArray[n2];
            listener.fullscreenStateChanged(this);
            ++n2;
        }
    }

    protected void fireVisibilityChanged() {
        ScreenDockWindowListener[] screenDockWindowListenerArray = this.listeners();
        int n = screenDockWindowListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScreenDockWindowListener listener = screenDockWindowListenerArray[n2];
            listener.visibilityChanged(this);
            ++n2;
        }
    }

    protected void fireShapeChanged() {
        ScreenDockWindowListener[] screenDockWindowListenerArray = this.listeners();
        int n = screenDockWindowListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScreenDockWindowListener listener = screenDockWindowListenerArray[n2];
            listener.shapeChanged(this);
            ++n2;
        }
    }

    protected abstract void showDisplayer(DockableDisplayer var1);

    protected abstract Component getWindowComponent();

    protected abstract void setBackground(BackgroundAlgorithm var1);

    public void setShowTitle(boolean showTitle) {
        if (this.showTitle != showTitle) {
            this.showTitle = showTitle;
            if (this.handle != null) {
                if (showTitle) {
                    this.handle.setTitleRequest(this.station.getTitleVersion());
                } else {
                    this.handle.setTitleRequest(null);
                }
            }
        }
    }

    public boolean isShowTitle() {
        return this.showTitle;
    }

    @Override
    public Dockable getDockable() {
        if (this.handle == null) {
            return null;
        }
        return this.handle.getDockable();
    }

    @Override
    public void setDockable(Dockable dockable) {
        DockableDisplayer displayer;
        if (this.handle != null) {
            displayer = this.handle.getDisplayer();
            displayer.removeDockableDisplayerListener(this.displayerListener);
            this.handle.destroy();
            this.handle = null;
        }
        displayer = null;
        if (dockable != null) {
            this.handle = new StationChildHandle(this.station, this.station.getDisplayers(), dockable, this.showTitle ? this.station.getTitleVersion() : null);
            this.handle.updateDisplayer();
            displayer = this.handle.getDisplayer();
            displayer.addDockableDisplayerListener(this.displayerListener);
        }
        this.showDisplayer(displayer);
    }

    protected void discardDisplayer() {
        DockableDisplayer displayer = this.handle.getDisplayer();
        displayer.removeDockableDisplayerListener(this.displayerListener);
        this.handle.updateDisplayer();
        displayer = this.handle.getDisplayer();
        displayer.addDockableDisplayerListener(this.displayerListener);
        this.showDisplayer(displayer);
    }

    @Override
    public void setFullscreenStrategy(ScreenDockFullscreenStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public boolean isFullscreen() {
        if (this.strategy == null) {
            if (this.isVisible()) {
                throw new IllegalStateException("no strategy available");
            }
            return false;
        }
        return this.strategy.isFullscreen(this);
    }

    @Override
    public void setFullscreen(boolean fullscreen) {
        if (this.strategy == null) {
            throw new IllegalStateException("no strategy available");
        }
        boolean state = this.isFullscreen();
        if (state != fullscreen) {
            this.strategy.setFullscreen(this, fullscreen);
            this.fireFullscreenChanged();
        }
    }

    @Override
    public void setNormalBounds(Rectangle bounds) {
        this.normalBounds = bounds;
    }

    @Override
    public Rectangle getNormalBounds() {
        return this.normalBounds;
    }

    @Override
    public void setController(DockController controller) {
        if (this.handle != null && this.controller != null) {
            this.handle.setTitleRequest(null);
        }
        this.background.setController(controller);
        this.controller = controller;
        if (this.handle != null && this.controller != null && this.isShowTitle()) {
            this.handle.setTitleRequest(this.station.getTitleVersion());
        }
    }

    @Override
    public Point getTitleCenter() {
        if (this.handle == null) {
            return null;
        }
        DockableDisplayer displayer = this.handle.getDisplayer();
        if (displayer == null) {
            return null;
        }
        DockTitle title = displayer.getTitle();
        if (title == null) {
            return null;
        }
        Component base = this.getWindowComponent();
        if (base == null) {
            return null;
        }
        Component titleComponent = title.getComponent();
        Point result = new Point(0, 0);
        result = SwingUtilities.convertPoint(titleComponent, result, base);
        result.x += titleComponent.getWidth() / 2;
        result.y += titleComponent.getHeight() / 2;
        return result;
    }

    @Override
    public Point getOffsetDrop() {
        if (this.handle == null) {
            return null;
        }
        DockableDisplayer displayer = this.handle.getDisplayer();
        if (displayer == null) {
            return null;
        }
        Insets insets = this.getDockableInsets();
        return new Point(insets.left, insets.top);
    }

    @Override
    public Point getOffsetMove() {
        if (this.handle == null) {
            return null;
        }
        DockableDisplayer displayer = this.handle.getDisplayer();
        if (displayer == null) {
            return null;
        }
        DockTitle title = displayer.getTitle();
        if (title == null) {
            return null;
        }
        Component base = this.getWindowComponent();
        if (base == null) {
            return null;
        }
        Point zero = new Point(0, 0);
        zero = SwingUtilities.convertPoint(title.getComponent(), zero, base);
        return zero;
    }

    @Override
    public boolean inTitleArea(int x, int y) {
        if (this.handle == null) {
            return false;
        }
        DockableDisplayer displayer = this.handle.getDisplayer();
        if (displayer == null) {
            return false;
        }
        Point point = new Point(x, y);
        SwingUtilities.convertPointFromScreen(point, displayer.getComponent());
        return displayer.titleContains(point.x, point.y);
    }

    @Override
    public boolean inCombineArea(int x, int y) {
        return this.inTitleArea(x, y);
    }

    @Override
    public boolean contains(int x, int y) {
        Component component = this.getWindowComponent();
        Point point = new Point(x, y);
        SwingUtilities.convertPointFromScreen(point, component);
        return component.contains(point);
    }

    public DockController getController() {
        return this.controller;
    }

    @Override
    public ScreenDockStation getStation() {
        return this.station;
    }

    protected class Background
    extends BackgroundAlgorithm
    implements ScreenDockWindowBackgroundComponent {
        public Background() {
            super(ScreenDockWindowBackgroundComponent.KIND, "dock.background.station.screen");
        }

        @Override
        public void set(BackgroundPaint value) {
            super.set(value);
            if (this.getPaint() == null) {
                DisplayerScreenDockWindow.this.setBackground(null);
            } else {
                DisplayerScreenDockWindow.this.setBackground(this);
            }
        }

        @Override
        public ScreenDockWindow getWindow() {
            return DisplayerScreenDockWindow.this;
        }

        @Override
        public DockStation getStation() {
            return this.getWindow().getStation();
        }

        @Override
        public Component getComponent() {
            return DisplayerScreenDockWindow.this.getWindowComponent();
        }
    }
}

