/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.dock.layout.AbstractDockableProperty;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class FlapDockProperty
extends AbstractDockableProperty {
    public static final FlapDockProperty FIRST = new FlapDockProperty(0);
    public static final FlapDockProperty LAST = new FlapDockProperty(Integer.MAX_VALUE);
    private int index;
    private boolean holding = false;
    private int size = -1;
    private Path placeholder;

    public FlapDockProperty() {
    }

    public FlapDockProperty(int index) {
        this.setIndex(index);
    }

    public FlapDockProperty(int index, boolean holding, int size) {
        this(index, holding, size, null);
    }

    public FlapDockProperty(int index, boolean holding, int size, Path placeholder) {
        this.setIndex(index);
        this.setHolding(holding);
        this.setSize(size);
        this.setPlaceholder(placeholder);
    }

    @Override
    public DockableProperty copy() {
        FlapDockProperty copy = new FlapDockProperty(this.index, this.holding, this.size, this.placeholder);
        this.copy(copy);
        return copy;
    }

    public void setIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Index must be >= 0: " + index);
        }
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setHolding(boolean holding) {
        this.holding = holding;
    }

    public boolean isHolding() {
        return this.holding;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public void setPlaceholder(Path placeholder) {
        this.placeholder = placeholder;
    }

    public Path getPlaceholder() {
        return this.placeholder;
    }

    @Override
    public String getFactoryID() {
        return "flap dock";
    }

    @Override
    public void store(DataOutputStream out) throws IOException {
        Version.write(out, Version.VERSION_1_0_8);
        out.writeInt(this.index);
        out.writeBoolean(this.holding);
        out.writeInt(this.size);
        if (this.placeholder == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.placeholder.toString());
        }
    }

    @Override
    public void store(XElement element) {
        element.addElement("index").setInt(this.index);
        element.addElement("holding").setBoolean(this.holding);
        if (this.size >= 0) {
            element.addElement("size").setInt(this.size);
        }
        if (this.placeholder != null) {
            element.addElement("placeholder").setString(this.placeholder.toString());
        }
    }

    @Override
    public void load(DataInputStream in) throws IOException {
        Version version = Version.read(in);
        version.checkCurrent();
        this.setIndex(in.readInt());
        if (version.compareTo(Version.VERSION_1_0_8) >= 0) {
            this.holding = in.readBoolean();
            this.size = in.readInt();
            if (in.readBoolean()) {
                this.placeholder = new Path(in.readUTF());
            }
        } else if (version.compareTo(Version.VERSION_1_0_7) >= 0) {
            this.holding = in.readBoolean();
            this.size = in.readInt();
        } else {
            this.holding = false;
            this.size = -1;
        }
    }

    @Override
    public void load(XElement element) {
        XElement xindex = element.getElement("index");
        XElement xholding = element.getElement("holding");
        XElement xsize = element.getElement("size");
        XElement xplaceholder = element.getElement("placeholder");
        if (xindex == null && xholding == null) {
            this.index = element.getInt();
        } else {
            if (xindex != null) {
                this.index = xindex.getInt();
            }
            if (xholding != null) {
                this.holding = xholding.getBoolean();
            }
            this.size = xsize == null ? -1 : xsize.getInt();
        }
        if (xplaceholder != null) {
            this.placeholder = new Path(xplaceholder.getString());
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[index=" + this.index + ", holding=" + this.holding + ", size=" + this.size + ", placeholder=" + this.placeholder + "]";
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.holding ? 1231 : 1237);
        result = 31 * result + this.index;
        result = 31 * result + (this.placeholder == null ? 0 : this.placeholder.hashCode());
        result = 31 * result + this.size;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlapDockProperty other = (FlapDockProperty)obj;
        if (this.holding != other.holding) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        if (this.placeholder == null ? other.placeholder != null : !this.placeholder.equals(other.placeholder)) {
            return false;
        }
        return this.size == other.size;
    }
}

