/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionIcon;
import bibliothek.gui.dock.action.DockActionText;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.action.actions.SimpleMenuAction;
import bibliothek.gui.dock.action.actions.SimpleSelectableAction;
import bibliothek.gui.dock.util.AbstractUIValue;
import javax.swing.Icon;

public class FlapDockDirection
extends SimpleMenuAction
implements ListeningDockAction {
    private DirectedArrow north;
    private DirectedArrow south;
    private DirectedArrow east;
    private DirectedArrow west;
    private DirectedArrow center;
    private DockController controller;
    private FlapIcon[] icons;
    private DockActionText[] texts;

    public FlapDockDirection() {
        DockActionText flapDirection = new DockActionText("flap.direction", this){

            @Override
            protected void changed(String oldValue, String newValue) {
                FlapDockDirection.this.setText(newValue);
            }
        };
        DockActionText flapDirectionTooltip = new DockActionText("flap.direction.tooltip", this){

            @Override
            protected void changed(String oldValue, String newValue) {
                FlapDockDirection.this.setTooltip(newValue);
            }
        };
        this.center = new DirectedArrow(null);
        this.north = new DirectedArrow(FlapDockStation.Direction.NORTH);
        this.south = new DirectedArrow(FlapDockStation.Direction.SOUTH);
        this.east = new DirectedArrow(FlapDockStation.Direction.EAST);
        this.west = new DirectedArrow(FlapDockStation.Direction.WEST);
        DockActionText flapDirectionNorth = new DockActionText("flap.direction.north", this.north){

            @Override
            protected void changed(String oldValue, String newValue) {
                FlapDockDirection.this.north.setText(newValue);
            }
        };
        DockActionText flapDirectionNorthTooltip = new DockActionText("flap.direction.north.tooltip", this.north){

            @Override
            protected void changed(String oldValue, String newValue) {
                FlapDockDirection.this.north.setTooltip(newValue);
            }
        };
        DockActionText flapDirectionSouth = new DockActionText("flap.direction.south", this.south){

            @Override
            protected void changed(String oldValue, String newValue) {
                FlapDockDirection.this.south.setText(newValue);
            }
        };
        DockActionText flapDirectionSouthTooltip = new DockActionText("flap.direction.south.tooltip", this.south){

            @Override
            protected void changed(String oldValue, String newValue) {
                FlapDockDirection.this.south.setTooltip(newValue);
            }
        };
        DockActionText flapDirectionEast = new DockActionText("flap.direction.east", this.east){

            @Override
            protected void changed(String oldValue, String newValue) {
                FlapDockDirection.this.east.setText(newValue);
            }
        };
        DockActionText flapDirectionEastTooltip = new DockActionText("flap.direction.east.tooltip", this.east){

            @Override
            protected void changed(String oldValue, String newValue) {
                FlapDockDirection.this.east.setTooltip(newValue);
            }
        };
        DockActionText flapDirectionWest = new DockActionText("flap.direction.west", this.west){

            @Override
            protected void changed(String oldValue, String newValue) {
                FlapDockDirection.this.west.setText(newValue);
            }
        };
        DockActionText flapDirectionWestTooltip = new DockActionText("flap.direction.west.tooltip", this.west){

            @Override
            protected void changed(String oldValue, String newValue) {
                FlapDockDirection.this.west.setTooltip(newValue);
            }
        };
        DockActionText flapDirectionCenter = new DockActionText("flap.direction.center", this.center){

            @Override
            protected void changed(String oldValue, String newValue) {
                FlapDockDirection.this.center.setText(newValue);
            }
        };
        DockActionText flapDirectionCenterTooltip = new DockActionText("flap.direction.center.tooltip", this.center){

            @Override
            protected void changed(String oldValue, String newValue) {
                FlapDockDirection.this.center.setTooltip(newValue);
            }
        };
        this.icons = new FlapIcon[]{new FlapIcon("flap.direction"), new FlapIcon("flap.south"), new FlapIcon("flap.east"), new FlapIcon("flap.west"), new FlapIcon("flap.north"), new FlapIcon("flap.auto")};
        this.texts = new DockActionText[]{flapDirection, flapDirectionTooltip, flapDirectionNorth, flapDirectionNorthTooltip, flapDirectionSouth, flapDirectionSouthTooltip, flapDirectionEast, flapDirectionEastTooltip, flapDirectionWest, flapDirectionWestTooltip, flapDirectionCenter, flapDirectionCenterTooltip};
        DefaultDockActionSource source = new DefaultDockActionSource(new DockAction[0]);
        source.add(this.center);
        source.addSeparator();
        source.add(this.north, this.south, this.east, this.west);
        this.setMenu(source);
    }

    @Override
    public void setController(DockController controller) {
        if (this.controller != controller) {
            this.controller = controller;
            AbstractUIValue[] abstractUIValueArray = this.icons;
            int n = this.icons.length;
            int n2 = 0;
            while (n2 < n) {
                FlapIcon icon = abstractUIValueArray[n2];
                icon.setManager(controller.getIcons());
                ++n2;
            }
            abstractUIValueArray = this.texts;
            n = this.texts.length;
            n2 = 0;
            while (n2 < n) {
                AbstractUIValue text = abstractUIValueArray[n2];
                text.setManager(controller.getTexts());
                ++n2;
            }
        }
    }

    private void fire() {
        this.center.fireSelectedChanged();
        this.north.fireSelectedChanged();
        this.south.fireSelectedChanged();
        this.east.fireSelectedChanged();
        this.west.fireSelectedChanged();
    }

    private FlapDockStation getStation(Dockable dockable) {
        if (dockable instanceof FlapDockStation) {
            return (FlapDockStation)dockable;
        }
        if (dockable.getDockParent() != null) {
            return this.getStation(dockable.getDockParent().asDockable());
        }
        throw new IllegalArgumentException("Dockable or parent is not a FlapDockStation");
    }

    private class DirectedArrow
    extends SimpleSelectableAction.Radio {
        private FlapDockStation.Direction direction;

        public DirectedArrow(FlapDockStation.Direction direction) {
            this.direction = direction;
        }

        @Override
        public boolean isSelected(Dockable dockable) {
            FlapDockStation station = FlapDockDirection.this.getStation(dockable);
            if (this.direction == null) {
                return station.isAutoDirection();
            }
            return !station.isAutoDirection() && station.getDirection() == this.direction;
        }

        @Override
        public void setSelected(Dockable dockable, boolean selected) {
            if (selected) {
                FlapDockStation station = FlapDockDirection.this.getStation(dockable);
                if (this.direction == null) {
                    station.setAutoDirection(true);
                } else {
                    station.setAutoDirection(false);
                    station.setDirection(this.direction);
                }
                FlapDockDirection.this.fire();
            }
        }

        @Override
        public void fireSelectedChanged() {
            super.fireSelectedChanged();
        }
    }

    private class FlapIcon
    extends DockActionIcon {
        public FlapIcon(String id) {
            super(id, FlapDockDirection.this);
        }

        @Override
        protected void changed(Icon oldValue, Icon icon) {
            String key = this.getId();
            if (key.equals("flap.direction")) {
                FlapDockDirection.this.setIcon(icon);
            } else if (key.equals("flap.north")) {
                FlapDockDirection.this.north.setIcon(icon);
            } else if (key.equals("flap.south")) {
                FlapDockDirection.this.south.setIcon(icon);
            } else if (key.equals("flap.east")) {
                FlapDockDirection.this.east.setIcon(icon);
            } else if (key.equals("flap.west")) {
                FlapDockDirection.this.west.setIcon(icon);
            } else if (key.equals("flap.auto")) {
                FlapDockDirection.this.center.setIcon(icon);
            }
        }
    }
}

