/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.focus;

import bibliothek.gui.dock.focus.SimplifiedFocusTraversalPolicy;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;

public class DockFocusTraversalPolicy
extends FocusTraversalPolicy {
    private SimplifiedFocusTraversalPolicy policy;
    private boolean circle;
    private boolean recursionComponentBefore = false;
    private boolean recursionComponentAfter = false;
    private boolean recursionDefaultComponent = false;

    public DockFocusTraversalPolicy(SimplifiedFocusTraversalPolicy policy, boolean circle) {
        if (policy == null) {
            throw new IllegalArgumentException("policy must not be null");
        }
        this.policy = policy;
        this.circle = circle;
    }

    protected boolean accept(Component component) {
        return component.isFocusable() && component.isEnabled() && component.isDisplayable() && component.isShowing();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Component getComponentAfter(Container container, Component component) {
        if (this.recursionComponentAfter) {
            return this.policy.getAfter(container, component);
        }
        try {
            this.recursionComponentAfter = true;
            Component next = this.after(component);
            while (true) {
                Container nextContainer;
                if (next == component) {
                    return null;
                }
                if (next == null) {
                    return null;
                }
                if (next instanceof Container && !(nextContainer = (Container)next).isFocusCycleRoot() && nextContainer.isFocusTraversalPolicyProvider()) {
                    Component selected = this.circle ? nextContainer.getFocusTraversalPolicy().getFirstComponent(nextContainer) : nextContainer.getFocusTraversalPolicy().getDefaultComponent(nextContainer);
                    if (selected == next) {
                        Component component2 = next;
                        return component2;
                    }
                    next = selected;
                    continue;
                }
                if (this.accept(next)) {
                    Component component3 = next;
                    return component3;
                }
                next = this.after(next);
            }
        }
        finally {
            this.recursionComponentAfter = false;
        }
    }

    protected Component after(Component component) {
        Container provider = this.getRootOrProvider(component);
        if (provider == null) {
            return null;
        }
        FocusTraversalPolicy providerPolicy = this.getFocusTraversalPolicy(provider);
        if (providerPolicy == null) {
            return null;
        }
        Component result = providerPolicy.getComponentAfter(provider, component);
        if (provider.isFocusCycleRoot()) {
            return result;
        }
        if (providerPolicy == this) {
            if (result == null || this.policy.getFirst(provider) == result) {
                result = this.after(provider);
            }
        } else if (result == null || providerPolicy.getFirstComponent(provider) == result) {
            result = this.after(provider);
        }
        if (result == component) {
            return null;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Component getComponentBefore(Container container, Component component) {
        if (this.recursionComponentBefore) {
            return this.policy.getBefore(container, component);
        }
        try {
            this.recursionComponentBefore = true;
            Component previous = this.before(component);
            while (true) {
                Container previousContainer;
                if (previous == component) {
                    return null;
                }
                if (previous == null) {
                    return null;
                }
                if (previous instanceof Container && !(previousContainer = (Container)previous).isFocusCycleRoot() && previousContainer.isFocusTraversalPolicyProvider()) {
                    Component selected = this.circle ? previousContainer.getFocusTraversalPolicy().getLastComponent(previousContainer) : previousContainer.getFocusTraversalPolicy().getDefaultComponent(previousContainer);
                    if (selected == previous) {
                        Component component2 = previous;
                        return component2;
                    }
                    previous = selected;
                    continue;
                }
                if (this.accept(previous)) {
                    Component component3 = previous;
                    return component3;
                }
                previous = this.after(previous);
            }
        }
        finally {
            this.recursionComponentBefore = false;
        }
    }

    protected Component before(Component component) {
        Container provider = this.getRootOrProvider(component);
        FocusTraversalPolicy providerPolicy = this.getFocusTraversalPolicy(provider);
        Component result = providerPolicy.getComponentBefore(provider, component);
        if (provider.isFocusCycleRoot()) {
            return result;
        }
        if (providerPolicy == this) {
            if (result == null || this.policy.getLast(provider) == result) {
                result = this.before(provider);
            }
        } else if (result == null || providerPolicy.getLastComponent(provider) == result) {
            result = this.before(provider);
        }
        if (result == component) {
            return null;
        }
        return result;
    }

    @Override
    public Component getDefaultComponent(Container container) {
        if (this.recursionDefaultComponent) {
            return this.policy.getDefault(container);
        }
        try {
            Component result;
            Container ccontainer;
            this.recursionDefaultComponent = true;
            FocusTraversalPolicy providerPolicy = this.getFocusTraversalPolicy(container);
            Component component = providerPolicy.getDefaultComponent(container);
            if (component == container) {
                Component component2 = component;
                return component2;
            }
            if (component instanceof Container && ((ccontainer = (Container)component).isFocusCycleRoot() || ccontainer.isFocusTraversalPolicyProvider()) && (result = this.getDefaultComponent(ccontainer)) != null) {
                Component component3 = result;
                return component3;
            }
            Component component4 = component;
            return component4;
        }
        finally {
            this.recursionDefaultComponent = false;
        }
    }

    @Override
    public Component getFirstComponent(Container container) {
        Component result;
        Container ccontainer;
        FocusTraversalPolicy providerPolicy = this.getFocusTraversalPolicy(container);
        Component component = providerPolicy.getDefaultComponent(container);
        if (component == container) {
            return component;
        }
        if (component instanceof Container && ((ccontainer = (Container)component).isFocusCycleRoot() || ccontainer.isFocusTraversalPolicyProvider()) && (result = this.getFirstComponent(ccontainer)) != null) {
            return result;
        }
        return component;
    }

    @Override
    public Component getLastComponent(Container container) {
        Component result;
        Container ccontainer;
        FocusTraversalPolicy providerPolicy = this.getFocusTraversalPolicy(container);
        Component component = providerPolicy.getDefaultComponent(container);
        if (component == container) {
            return component;
        }
        if (component instanceof Container && ((ccontainer = (Container)component).isFocusCycleRoot() || ccontainer.isFocusTraversalPolicyProvider()) && (result = this.getLastComponent(ccontainer)) != null) {
            return result;
        }
        return component;
    }

    protected Container getRootOrProvider(Component component) {
        Container container = component.getParent();
        while (container != null) {
            if (container.isFocusCycleRoot() || container.isFocusTraversalPolicyProvider()) {
                return container;
            }
            container = container.getParent();
        }
        return null;
    }

    protected FocusTraversalPolicy getFocusTraversalPolicy(Container provider) {
        while (provider != null) {
            if ((provider.isFocusCycleRoot() || provider.isFocusTraversalPolicyProvider()) && provider.isFocusTraversalPolicySet()) {
                return provider.getFocusTraversalPolicy();
            }
            provider = provider.getParent();
        }
        return null;
    }
}

