/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.menu;

import bibliothek.gui.dock.facile.menu.NodeMenuPiece;
import bibliothek.gui.dock.support.menu.MenuPiece;
import bibliothek.gui.dock.support.menu.MenuPieceListener;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JMenu;

public class RootMenuPiece
extends NodeMenuPiece {
    private JMenu menu;
    private boolean disableWhenEmpty;

    public RootMenuPiece() {
        this(new JMenu());
    }

    public RootMenuPiece(String text, boolean disableWhenEmpty, MenuPiece ... pieces) {
        this(new JMenu(text));
        this.setDisableWhenEmpty(disableWhenEmpty);
        MenuPiece[] menuPieceArray = pieces;
        int n = pieces.length;
        int n2 = 0;
        while (n2 < n) {
            MenuPiece piece = menuPieceArray[n2];
            this.add(piece);
            ++n2;
        }
    }

    public RootMenuPiece(JMenu menu) {
        if (menu == null) {
            throw new NullPointerException("menu must not be null");
        }
        this.menu = menu;
        menu.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    RootMenuPiece.this.checkVisibility();
                }
            }
        });
        this.checkVisibility();
        this.addListener(new MenuPieceListener(){

            @Override
            public void insert(MenuPiece child, int index, Component ... items) {
                JMenu menu = RootMenuPiece.this.getMenu();
                int i = 0;
                while (i < items.length) {
                    menu.add(items[i], i + index);
                    ++i;
                }
                menu.setEnabled(!RootMenuPiece.this.disableWhenEmpty || RootMenuPiece.this.getItemCount() > 0);
            }

            @Override
            public void remove(MenuPiece child, int index, int length) {
                JMenu menu = RootMenuPiece.this.getMenu();
                int i = index + length - 1;
                while (i >= index) {
                    menu.remove(i);
                    --i;
                }
                menu.setEnabled(!RootMenuPiece.this.disableWhenEmpty || RootMenuPiece.this.getItemCount() > 0);
            }
        });
    }

    private void checkVisibility() {
        boolean showing = this.getParent() == null ? this.menu.isShowing() : this.getParent().isBound();
        if (showing && !this.isBound()) {
            this.bind();
        } else if (!showing && this.isBound()) {
            this.unbind();
        }
    }

    public void setDisableWhenEmpty(boolean disableWhenEmpty) {
        this.disableWhenEmpty = disableWhenEmpty;
        this.menu.setEnabled(!disableWhenEmpty || this.getItemCount() > 0);
    }

    public boolean isDisableWhenEmpty() {
        return this.disableWhenEmpty;
    }

    @Override
    public JMenu getMenu() {
        return this.menu;
    }

    @Override
    public void setParent(MenuPiece parent) {
        super.setParent(parent);
        this.checkVisibility();
    }
}

