/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.relocator;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.control.DockRelocator;
import bibliothek.gui.dock.control.DockRelocatorMode;
import bibliothek.gui.dock.control.relocator.DockRelocatorEvent;
import bibliothek.gui.dock.control.relocator.Merger;
import bibliothek.gui.dock.control.relocator.VetoableDockRelocatorListener;
import bibliothek.gui.dock.event.DockRelocatorListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractDockRelocator
implements DockRelocator {
    @Deprecated
    private List<DockRelocatorListener> listeners = new ArrayList<DockRelocatorListener>();
    private List<VetoableDockRelocatorListener> vetoableListeners = new ArrayList<VetoableDockRelocatorListener>();
    private DockController controller;
    private int dragDistance = 10;
    private boolean dragOnlyTitel = false;
    private List<DockRelocatorMode> modes = new ArrayList<DockRelocatorMode>();
    private Set<DockRelocatorMode> activeModes = new HashSet<DockRelocatorMode>();
    private Merger merger = null;

    public AbstractDockRelocator(DockController controller) {
        if (controller == null) {
            throw new IllegalArgumentException("controller must not be null");
        }
        this.controller = controller;
    }

    public DockController getController() {
        return this.controller;
    }

    @Override
    @Deprecated
    public void addDockRelocatorListener(DockRelocatorListener listener) {
        this.listeners.add(listener);
    }

    @Override
    @Deprecated
    public void removeDockRelocatorListener(DockRelocatorListener listener) {
        this.listeners.remove(listener);
    }

    protected DockRelocatorListener[] listListeners() {
        return this.listeners.toArray(new DockRelocatorListener[this.listeners.size()]);
    }

    protected void fireInit(Dockable dockable) {
        DockRelocatorListener[] dockRelocatorListenerArray = this.listListeners();
        int n = dockRelocatorListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockRelocatorListener listener = dockRelocatorListenerArray[n2];
            listener.init(this.controller, dockable);
            ++n2;
        }
    }

    protected void fireCancel(Dockable dockable) {
        DockRelocatorListener[] dockRelocatorListenerArray = this.listListeners();
        int n = dockRelocatorListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockRelocatorListener listener = dockRelocatorListenerArray[n2];
            listener.cancel(this.controller, dockable);
            ++n2;
        }
    }

    protected void fireDrag(Dockable dockable, DockStation station) {
        DockRelocatorListener[] dockRelocatorListenerArray = this.listListeners();
        int n = dockRelocatorListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockRelocatorListener listener = dockRelocatorListenerArray[n2];
            listener.drag(this.controller, dockable, station);
            ++n2;
        }
    }

    protected void fireDrop(Dockable dockable, DockStation station) {
        DockRelocatorListener[] dockRelocatorListenerArray = this.listListeners();
        int n = dockRelocatorListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockRelocatorListener listener = dockRelocatorListenerArray[n2];
            listener.drop(this.controller, dockable, station);
            ++n2;
        }
    }

    @Override
    public void addVetoableDockRelocatorListener(VetoableDockRelocatorListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.vetoableListeners.add(listener);
    }

    @Override
    public void removeVetoableDockRelocatorListener(VetoableDockRelocatorListener listener) {
        this.vetoableListeners.remove(listener);
    }

    protected VetoableDockRelocatorListener[] vetoableListeners() {
        return this.vetoableListeners.toArray(new VetoableDockRelocatorListener[this.vetoableListeners.size()]);
    }

    protected void fireGrabbing(DockRelocatorEvent event) {
        VetoableDockRelocatorListener[] vetoableDockRelocatorListenerArray = this.vetoableListeners();
        int n = vetoableDockRelocatorListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            VetoableDockRelocatorListener listener = vetoableDockRelocatorListenerArray[n2];
            listener.grabbing(event);
            ++n2;
        }
    }

    protected void fireGrabbed(DockRelocatorEvent event) {
        VetoableDockRelocatorListener[] vetoableDockRelocatorListenerArray = this.vetoableListeners();
        int n = vetoableDockRelocatorListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            VetoableDockRelocatorListener listener = vetoableDockRelocatorListenerArray[n2];
            listener.grabbed(event);
            ++n2;
        }
    }

    protected void fireDragged(DockRelocatorEvent event) {
        VetoableDockRelocatorListener[] vetoableDockRelocatorListenerArray = this.vetoableListeners();
        int n = vetoableDockRelocatorListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            VetoableDockRelocatorListener listener = vetoableDockRelocatorListenerArray[n2];
            listener.dragged(event);
            ++n2;
        }
    }

    protected void fireDropping(DockRelocatorEvent event) {
        VetoableDockRelocatorListener[] vetoableDockRelocatorListenerArray = this.vetoableListeners();
        int n = vetoableDockRelocatorListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            VetoableDockRelocatorListener listener = vetoableDockRelocatorListenerArray[n2];
            listener.dropping(event);
            ++n2;
        }
    }

    protected void fireDropped(DockRelocatorEvent event) {
        VetoableDockRelocatorListener[] vetoableDockRelocatorListenerArray = this.vetoableListeners();
        int n = vetoableDockRelocatorListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            VetoableDockRelocatorListener listener = vetoableDockRelocatorListenerArray[n2];
            listener.dropped(event);
            ++n2;
        }
    }

    protected void fireCanceled(DockRelocatorEvent event) {
        VetoableDockRelocatorListener[] vetoableDockRelocatorListenerArray = this.vetoableListeners();
        int n = vetoableDockRelocatorListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            VetoableDockRelocatorListener listener = vetoableDockRelocatorListenerArray[n2];
            listener.canceled(event);
            ++n2;
        }
    }

    @Override
    public boolean isDragOnlyTitel() {
        return this.dragOnlyTitel;
    }

    @Override
    public void setDragOnlyTitel(boolean dragOnlyTitel) {
        this.dragOnlyTitel = dragOnlyTitel;
    }

    @Override
    public int getDragDistance() {
        return this.dragDistance;
    }

    @Override
    public void setDragDistance(int dragDistance) {
        this.dragDistance = dragDistance;
    }

    @Override
    public Merger getMerger() {
        return this.merger;
    }

    @Override
    public void setMerger(Merger merger) {
        this.merger = merger;
    }

    @Override
    public void addMode(DockRelocatorMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Mode must not be null");
        }
        this.modes.add(mode);
    }

    @Override
    public void removeMode(DockRelocatorMode mode) {
        if (this.activeModes.remove(mode)) {
            mode.setActive(this.controller, false);
        }
        this.modes.remove(mode);
    }

    protected void disableAllModes() {
        for (DockRelocatorMode mode : this.activeModes) {
            mode.setActive(this.controller, false);
        }
        this.activeModes.clear();
    }

    protected void checkModes(int modifiers) {
        for (DockRelocatorMode mode : this.modes) {
            boolean active = mode.shouldBeActive(this.controller, modifiers);
            if (active) {
                if (!this.activeModes.add(mode)) continue;
                mode.setActive(this.controller, true);
                continue;
            }
            if (!this.activeModes.remove(mode)) continue;
            mode.setActive(this.controller, false);
        }
    }
}

