/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.focus;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

public class FocusTracker {
    private Component lastFocused;
    private Component root;
    private FocusListener focusListener = new FocusListener(){

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void focusGained(FocusEvent e) {
            FocusTracker.this.lastFocused = e.getComponent();
        }
    };
    private ContainerListener containerListener = new ContainerListener(){

        @Override
        public void componentRemoved(ContainerEvent e) {
            FocusTracker.this.remove(e.getChild());
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            FocusTracker.this.add(e.getChild());
        }
    };

    public FocusTracker(Component root) {
        this.root = root;
        this.add(root);
    }

    public void destroy() {
        this.remove(this.root);
    }

    public Component getLastFocused() {
        return this.lastFocused;
    }

    protected void add(Component component) {
        component.addFocusListener(this.focusListener);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.addContainerListener(this.containerListener);
            int i = 0;
            int n = container.getComponentCount();
            while (i < n) {
                this.add(container.getComponent(i));
                ++i;
            }
        }
    }

    protected void remove(Component component) {
        if (this.lastFocused == component) {
            this.lastFocused = null;
        }
        component.removeFocusListener(this.focusListener);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.removeContainerListener(this.containerListener);
            int i = 0;
            int n = container.getComponentCount();
            while (i < n) {
                this.remove(container.getComponent(i));
                ++i;
            }
        }
    }
}

