/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.color;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.ColorMap;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.color.ColorTransmitter;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.gui.dock.util.color.DockColor;
import java.awt.Color;

public abstract class MinimizedButtonColorTransmitter
extends ColorTransmitter {
    private ColorManager manager;
    private String[] keys;

    public MinimizedButtonColorTransmitter(ColorManager manager, String ... keys) {
        super(keys);
        this.keys = keys;
        this.manager = manager;
    }

    protected abstract Color convert(Color var1, String var2);

    protected abstract Color convertFocused(Color var1, String var2);

    protected abstract Color convertSelected(Color var1, String var2);

    protected abstract boolean isForeground(String var1);

    protected abstract boolean isFocused(String var1);

    protected abstract boolean isSelected(String var1);

    public String[] getKeys() {
        return this.keys;
    }

    @Override
    protected Color get(Color color, String id, DockColor observer) {
        CDockable dockable = this.getDockable(observer);
        if (dockable != null) {
            return this.get(color, id, dockable);
        }
        return color;
    }

    @Override
    protected CDockable getDockable(DockColor observer) {
        Dockable dockable = ((TitleColor)observer).getTitle().getDockable();
        if (dockable instanceof CommonDockable) {
            return ((CommonDockable)dockable).getDockable();
        }
        return null;
    }

    @Override
    protected Color get(Color color, String id, CDockable dockable) {
        boolean selected;
        Color check = null;
        ColorMap colors = dockable.getColors();
        boolean foreground = this.isForeground(id);
        boolean focused = this.isFocused(id);
        boolean bl = selected = focused || this.isSelected(id);
        if (foreground) {
            if (focused) {
                check = colors.getColor("minimized.foreground.focused");
            }
            if (check == null && selected) {
                check = colors.getColor("minimized.foreground.selected");
            }
            if (check == null) {
                check = colors.getColor("minimized.foreground");
            }
        }
        if (check == null) {
            if (focused && (check = colors.getColor("minimized.background.focused")) != null) {
                check = this.convertFocused(check, id);
            }
            if (check == null && selected && (check = colors.getColor("minimized.background.selected")) != null) {
                check = this.convertSelected(check, id);
            }
            if (check == null && (check = colors.getColor("minimized.background")) != null) {
                check = this.convert(check, id);
            }
        }
        if (check != null) {
            return check;
        }
        return color;
    }

    @Override
    protected void update(CDockable dockable, String key, Color color) {
        boolean change;
        boolean bl = change = "minimized.background".equals(key) || "minimized.background.focused".equals(key) || "minimized.background.selected".equals(key) || "minimized.foreground".equals(key) || "minimized.foreground.focused".equals(key) || "minimized.foreground.selected".equals(key);
        if (change) {
            String[] stringArray = this.keys;
            int n = this.keys.length;
            int n2 = 0;
            while (n2 < n) {
                String check = stringArray[n2];
                this.set(check, this.get((Color)this.manager.get(check), check, dockable), dockable);
                ++n2;
            }
        }
    }
}

