/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action;

import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.event.DockActionSourceListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class FilteredDockActionSource
extends AbstractDockActionSource {
    private DockActionSource source;
    private List<Boolean> actions = null;
    private Listener listener = new Listener();

    public FilteredDockActionSource(DockActionSource source) {
        if (source == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        this.source = source;
    }

    @Override
    public Iterator<DockAction> iterator() {
        return new Iterator<DockAction>(){
            private Iterator<DockAction> iterator;
            private DockAction next;
            {
                this.iterator = FilteredDockActionSource.this.source.iterator();
                this.advance();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public DockAction next() {
                DockAction result = this.next;
                this.advance();
                return result;
            }

            private void advance() {
                while (this.iterator.hasNext()) {
                    DockAction check = this.iterator.next();
                    if (!FilteredDockActionSource.this.include(check)) continue;
                    this.next = check;
                    return;
                }
                this.next = null;
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    @Override
    public void addDockActionSourceListener(DockActionSourceListener listener) {
        if (this.listeners.isEmpty()) {
            this.source.addDockActionSourceListener(this.listener);
            this.actions = new ArrayList<Boolean>();
            for (DockAction action : this.source) {
                this.actions.add(this.include(action));
            }
        }
        super.addDockActionSourceListener(listener);
    }

    @Override
    public void removeDockActionSourceListener(DockActionSourceListener listener) {
        super.removeDockActionSourceListener(listener);
        if (this.listeners.isEmpty()) {
            this.source.removeDockActionSourceListener(this.listener);
            this.actions = null;
        }
    }

    @Override
    public DockAction getDockAction(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Index out of bounds: " + index);
        }
        int count = -1;
        if (this.actions == null) {
            for (DockAction action : this.source) {
                if (!this.include(action) || index != ++count) continue;
                return action;
            }
        } else {
            int i = 0;
            int n = this.source.getDockActionCount();
            while (i < n) {
                if (this.actions.get(i).booleanValue() && index == ++count) {
                    return this.source.getDockAction(i);
                }
                ++i;
            }
        }
        throw new IllegalArgumentException("Index out of bounds: " + index);
    }

    @Override
    public int getDockActionCount() {
        int count = 0;
        if (this.actions == null) {
            for (DockAction action : this.source) {
                if (!this.include(action)) continue;
                ++count;
            }
        } else {
            int i = 0;
            int n = this.source.getDockActionCount();
            while (i < n) {
                if (this.actions.get(i).booleanValue()) {
                    ++count;
                }
                ++i;
            }
        }
        return count;
    }

    @Override
    public LocationHint getLocationHint() {
        return this.source.getLocationHint();
    }

    protected abstract boolean include(DockAction var1);

    private class Listener
    implements DockActionSourceListener {
        private Listener() {
        }

        @Override
        public void actionsAdded(DockActionSource source, int firstIndex, int lastIndex) {
            int insert = 0;
            int i = 0;
            while (i < firstIndex) {
                if (((Boolean)FilteredDockActionSource.this.actions.get(i)).booleanValue()) {
                    ++insert;
                }
                ++i;
            }
            int count = 0;
            int i2 = firstIndex;
            while (i2 <= lastIndex) {
                DockAction action = source.getDockAction(i2);
                boolean include = FilteredDockActionSource.this.include(action);
                FilteredDockActionSource.this.actions.add(i2, include);
                if (include) {
                    ++count;
                }
                ++i2;
            }
            if (count > 0) {
                FilteredDockActionSource.this.fireAdded(insert, insert + count - 1);
            }
        }

        @Override
        public void actionsRemoved(DockActionSource source, int firstIndex, int lastIndex) {
            int remove = 0;
            int i = 0;
            while (i < firstIndex) {
                if (((Boolean)FilteredDockActionSource.this.actions.get(i)).booleanValue()) {
                    ++remove;
                }
                ++i;
            }
            int count = 0;
            int i2 = lastIndex;
            while (i2 >= firstIndex) {
                if (((Boolean)FilteredDockActionSource.this.actions.remove(i2)).booleanValue()) {
                    ++count;
                }
                --i2;
            }
            if (count > 0) {
                FilteredDockActionSource.this.fireRemoved(remove, remove + count - 1);
            }
        }
    }
}

