/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockHierarchyLock;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.HierarchyDockActionSource;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.displayer.DockableDisplayerHints;
import bibliothek.gui.dock.dockable.DockHierarchyObserver;
import bibliothek.gui.dock.dockable.DockableStateListener;
import bibliothek.gui.dock.dockable.DockableStateListenerManager;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.event.DockTitleEvent;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.event.DoubleClickListener;
import bibliothek.gui.dock.event.SplitDockListener;
import bibliothek.gui.dock.layout.AbstractDockableProperty;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.security.SecureContainer;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.DockStationIcon;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.StationBackgroundComponent;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.station.split.DefaultSplitLayoutManager;
import bibliothek.gui.dock.station.split.DockableSplitDockTree;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.Placeholder;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.Root;
import bibliothek.gui.dock.station.split.SplitDockAccess;
import bibliothek.gui.dock.station.split.SplitDockCombinerSource;
import bibliothek.gui.dock.station.split.SplitDockFullScreenProperty;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockProperty;
import bibliothek.gui.dock.station.split.SplitDockStationFactory;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.split.SplitDockTreeFactory;
import bibliothek.gui.dock.station.split.SplitFullScreenAction;
import bibliothek.gui.dock.station.split.SplitLayoutManager;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.station.split.SplitPlaceholderSet;
import bibliothek.gui.dock.station.split.SplitTreeFactory;
import bibliothek.gui.dock.station.support.CombinerSource;
import bibliothek.gui.dock.station.support.CombinerTarget;
import bibliothek.gui.dock.station.support.DockStationListenerManager;
import bibliothek.gui.dock.station.support.DockableVisibilityManager;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.support.PlaceholderStrategyListener;
import bibliothek.gui.dock.station.support.RootPlaceholderStrategy;
import bibliothek.gui.dock.themes.DefaultDisplayerFactoryValue;
import bibliothek.gui.dock.themes.DefaultStationPaintValue;
import bibliothek.gui.dock.themes.StationCombinerValue;
import bibliothek.gui.dock.title.ControllerTitleFactory;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPanel;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.icon.DockIcon;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

public class SplitDockStation
extends SecureContainer
implements Dockable,
DockStation {
    public static final String TITLE_ID = "split";
    public static final PropertyKey<KeyStroke> MAXIMIZE_ACCELERATOR = new PropertyKey("SplitDockStation maximize accelerator");
    public static final PropertyKey<SplitLayoutManager> LAYOUT_MANAGER = new PropertyKey<DefaultSplitLayoutManager>("SplitDockStation layout manager", new ConstantPropertyFactory<DefaultSplitLayoutManager>(new DefaultSplitLayoutManager()), true);
    private DockStation parent;
    private VisibleListener visibleListener = new VisibleListener();
    private DockController controller;
    private DockTheme theme;
    private StationCombinerValue combiner;
    private DockTitleVersion title;
    private List<DockableListener> dockableListeners = new ArrayList<DockableListener>();
    private DockableStateListenerManager dockableStateListeners;
    private DockHierarchyObserver hierarchyObserver;
    private List<SplitDockListener> splitListeners = new ArrayList<SplitDockListener>();
    private DockableVisibilityManager visibility;
    private List<DockTitle> titles = new LinkedList<DockTitle>();
    private HierarchyDockActionSource globalSource;
    protected DockStationListenerManager dockStationListeners = new DockStationListenerManager(this);
    private PropertyValue<String> titleText = new PropertyValue<String>(PropertyKey.DOCK_STATION_TITLE){

        @Override
        protected void valueChanged(String oldValue, String newValue) {
            if (oldValue == null) {
                oldValue = "";
            }
            if (newValue == null) {
                newValue = "";
            }
            DockableListener[] dockableListenerArray = SplitDockStation.this.dockableListeners.toArray(new DockableListener[SplitDockStation.this.dockableListeners.size()]);
            int n = dockableListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                DockableListener listener = dockableListenerArray[n2];
                listener.titleTextChanged(SplitDockStation.this, oldValue, newValue);
                ++n2;
            }
        }
    };
    private DockIcon titleIcon;
    private PropertyValue<String> titleToolTip = new PropertyValue<String>(PropertyKey.DOCK_STATION_TOOLTIP){

        @Override
        protected void valueChanged(String oldValue, String newValue) {
            DockableListener[] dockableListenerArray = SplitDockStation.this.dockableListeners.toArray(new DockableListener[SplitDockStation.this.dockableListeners.size()]);
            int n = dockableListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                DockableListener listener = dockableListenerArray[n2];
                listener.titleToolTipChanged(SplitDockStation.this, oldValue, newValue);
                ++n2;
            }
        }
    };
    private PropertyValue<SplitLayoutManager> layoutManager = new PropertyValue<SplitLayoutManager>(LAYOUT_MANAGER){

        @Override
        protected void valueChanged(SplitLayoutManager oldValue, SplitLayoutManager newValue) {
            if (oldValue != null) {
                oldValue.uninstall(SplitDockStation.this);
            }
            if (newValue != null) {
                newValue.install(SplitDockStation.this);
            }
        }
    };
    private PropertyValue<PlaceholderStrategy> placeholderStrategyProperty = new PropertyValue<PlaceholderStrategy>(PlaceholderStrategy.PLACEHOLDER_STRATEGY){

        @Override
        protected void valueChanged(PlaceholderStrategy oldValue, PlaceholderStrategy newValue) {
            SplitDockStation.this.placeholderStrategy.setStrategy(newValue);
        }
    };
    private RootPlaceholderStrategy placeholderStrategy = new RootPlaceholderStrategy(this);
    private boolean expandOnDoubleclick = true;
    private FullScreenListener fullScreenListener = new FullScreenListener();
    private List<StationChildHandle> dockables = new ArrayList<StationChildHandle>();
    private Dockable frontDockable;
    private StationChildHandle fullScreenDockable;
    private ListeningDockAction fullScreenAction;
    private int dividerSize = 4;
    private float sideSnapSize = 0.25f;
    private int borderSideSnapSize = 25;
    private boolean allowSideSnap = true;
    private Access access = new Access();
    private Root root;
    private SplitPlaceholderSet placeholderSet;
    private int treeLock = 0;
    private PutInfo putInfo;
    private DefaultStationPaintValue paint;
    private DefaultDisplayerFactoryValue displayerFactory;
    private DisplayerCollection displayers;
    private DividerListener dividerListener;
    private boolean resizingEnabled = true;
    private boolean continousDisplay = false;
    private DockableDisplayerHints hints;
    private Content content;
    private Background background = new Background();

    public SplitDockStation() {
        this(true);
    }

    public SplitDockStation(boolean createFullScreenAction) {
        this.content = new Content();
        this.content.setBackground(this.background);
        this.setBasePane(this.content);
        this.placeholderSet = new SplitPlaceholderSet(this.access);
        this.dockableStateListeners = new DockableStateListenerManager(this);
        this.paint = new DefaultStationPaintValue("dock.paint.split", this);
        this.combiner = new StationCombinerValue("dock.combiner.split", this);
        this.displayerFactory = new DefaultDisplayerFactoryValue("dock.displayer.split", this);
        this.displayers = new DisplayerCollection((DockStation)this, this.displayerFactory);
        this.displayers.addDockableDisplayerListener(new DockableDisplayerListener(){

            @Override
            public void discard(DockableDisplayer displayer) {
                SplitDockStation.this.discard(displayer);
            }
        });
        this.dividerListener = new DividerListener();
        if (createFullScreenAction) {
            this.fullScreenAction = this.createFullScreenAction();
        }
        this.visibility = new DockableVisibilityManager(this.dockStationListeners);
        this.getContentPane().addMouseListener(this.dividerListener);
        this.getContentPane().addMouseMotionListener(this.dividerListener);
        this.hierarchyObserver = new DockHierarchyObserver(this);
        this.globalSource = new HierarchyDockActionSource(this);
        this.globalSource.bind();
        this.titleIcon = new DockStationIcon("dockStation.default", this){

            @Override
            protected void changed(Icon oldValue, Icon newValue) {
                DockableListener[] dockableListenerArray = SplitDockStation.this.dockableListeners.toArray(new DockableListener[SplitDockStation.this.dockableListeners.size()]);
                int n = dockableListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DockableListener listener = dockableListenerArray[n2];
                    listener.titleIconChanged(SplitDockStation.this, oldValue, newValue);
                    ++n2;
                }
            }
        };
        this.addDockStationListener(new DockStationAdapter(){

            @Override
            public void dockableAdded(DockStation station, Dockable dockable) {
                SplitDockStation.this.updateConfigurableDisplayerHints();
            }

            @Override
            public void dockableRemoved(DockStation station, Dockable dockable) {
                SplitDockStation.this.updateConfigurableDisplayerHints();
            }
        });
        this.placeholderStrategy.addListener(new PlaceholderStrategyListener(){

            @Override
            public void placeholderInvalidated(Set<Path> placeholders) {
                SplitDockStation.this.removePlaceholders(placeholders);
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    if (SplitDockStation.this.getDockParent() == null) {
                        SplitDockStation.this.dockableStateListeners.checkVisibility();
                    }
                    SplitDockStation.this.visibility.fire();
                }
            }
        });
    }

    protected Root createRoot(SplitDockAccess access) {
        return new Root(access);
    }

    protected final Root root() {
        if (this.root == null) {
            this.root = this.createRoot(this.access);
        }
        return this.root;
    }

    @Override
    public String toString() {
        if (this.root == null) {
            return super.toString();
        }
        return this.root.toString();
    }

    @Override
    public Dimension getMinimumSize() {
        Insets insets = this.getInsets();
        Dimension base = this.getRoot().getMinimumSize();
        if (insets != null) {
            base = new Dimension(base.width + insets.left + insets.right, base.height + insets.top + insets.bottom);
        }
        return base;
    }

    @Override
    public DockTheme getTheme() {
        return this.theme;
    }

    @Override
    public void updateTheme() {
        DockTheme newTheme;
        DockController controller = this.getController();
        if (controller != null && (newTheme = controller.getTheme()) != this.theme) {
            this.theme = newTheme;
            try {
                this.callDockUiUpdateTheme();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected void callDockUiUpdateTheme() throws IOException {
        DockUI.updateTheme(this, new SplitDockStationFactory());
    }

    protected ListeningDockAction createFullScreenAction() {
        return new SplitFullScreenAction(this);
    }

    public void setFullScreenAction(ListeningDockAction fullScreenAction) {
        if (this.fullScreenAction != null) {
            throw new IllegalStateException("The fullScreenAction can only be set once");
        }
        this.fullScreenAction = fullScreenAction;
    }

    public void setExpandOnDoubleclick(boolean expandOnDoubleclick) {
        this.expandOnDoubleclick = expandOnDoubleclick;
    }

    public boolean isExpandOnDoubleclick() {
        return this.expandOnDoubleclick;
    }

    public void setResizingEnabled(boolean resizingEnabled) {
        this.resizingEnabled = resizingEnabled;
    }

    public boolean isResizingEnabled() {
        return this.resizingEnabled;
    }

    @Override
    public void setDockParent(DockStation station) {
        if (this.parent != null) {
            this.parent.removeDockStationListener(this.visibleListener);
        }
        this.parent = station;
        if (station != null) {
            station.addDockStationListener(this.visibleListener);
        }
        this.hierarchyObserver.update();
    }

    @Override
    public DockStation getDockParent() {
        return this.parent;
    }

    @Override
    public void setController(DockController controller) {
        super.setController(controller);
        if (this.controller != controller) {
            if (this.controller != null) {
                this.controller.getDoubleClickController().removeListener(this.fullScreenListener);
            }
            for (StationChildHandle handle : this.dockables) {
                handle.setTitleRequest(null);
            }
            this.controller = controller;
            this.getDisplayers().setController(controller);
            if (this.fullScreenAction != null) {
                this.fullScreenAction.setController(controller);
            }
            this.titleIcon.setController(controller);
            this.titleText.setProperties(controller);
            this.layoutManager.setProperties(controller);
            this.placeholderStrategyProperty.setProperties(controller);
            this.paint.setController(controller);
            this.displayerFactory.setController(controller);
            this.combiner.setController(controller);
            this.background.setController(controller);
            if (controller != null) {
                this.title = controller.getDockTitleManager().getVersion(TITLE_ID, ControllerTitleFactory.INSTANCE);
                controller.getDoubleClickController().addListener(this.fullScreenListener);
            } else {
                this.title = null;
            }
            for (StationChildHandle handle : this.dockables) {
                handle.setTitleRequest(this.title);
            }
            this.hierarchyObserver.controllerChanged(controller);
            this.visibility.fire();
        }
    }

    @Override
    public DockController getController() {
        return this.controller;
    }

    @Override
    public void addDockableListener(DockableListener listener) {
        this.dockableListeners.add(listener);
    }

    @Override
    public void removeDockableListener(DockableListener listener) {
        this.dockableListeners.remove(listener);
    }

    @Override
    public void addDockHierarchyListener(DockHierarchyListener listener) {
        this.hierarchyObserver.addDockHierarchyListener(listener);
    }

    @Override
    public void removeDockHierarchyListener(DockHierarchyListener listener) {
        this.hierarchyObserver.removeDockHierarchyListener(listener);
    }

    @Override
    public void addMouseInputListener(MouseInputListener listener) {
    }

    @Override
    public void removeMouseInputListener(MouseInputListener listener) {
    }

    @Override
    public boolean accept(DockStation station) {
        return true;
    }

    @Override
    public boolean accept(DockStation base, Dockable neighbour) {
        return true;
    }

    protected boolean acceptable(Dockable old, Dockable next) {
        if (!old.accept(this, next)) {
            return false;
        }
        if (!next.accept(this)) {
            return false;
        }
        DockController controller = this.getController();
        if (controller != null) {
            return controller.getAcceptance().accept(this, old, next);
        }
        return true;
    }

    protected boolean acceptable(Dockable next) {
        if (!this.accept(next)) {
            return false;
        }
        if (!next.accept(this)) {
            return false;
        }
        DockController controller = this.getController();
        if (controller != null) {
            return controller.getAcceptance().accept(this, next);
        }
        return true;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public DockElement getElement() {
        return this;
    }

    @Override
    public boolean isUsedAsTitle() {
        return false;
    }

    @Override
    public boolean shouldFocus() {
        return true;
    }

    @Override
    public boolean shouldTransfersFocus() {
        return false;
    }

    @Override
    public Point getPopupLocation(Point click, boolean popupTrigger) {
        if (popupTrigger) {
            return click;
        }
        return null;
    }

    @Override
    public String getTitleText() {
        String text = this.titleText.getValue();
        if (text == null) {
            return "";
        }
        return text;
    }

    public void setTitleText(String titleText) {
        this.titleText.setValue(titleText);
    }

    @Override
    public String getTitleToolTip() {
        return this.titleToolTip.getValue();
    }

    public void setTitleToolTip(String text) {
        this.titleToolTip.setValue(text);
    }

    @Override
    public Icon getTitleIcon() {
        return (Icon)this.titleIcon.value();
    }

    public void setTitleIcon(Icon titleIcon) {
        this.titleIcon.setValue(titleIcon, true);
    }

    public void resetTitleIcon() {
        this.titleIcon.setValue(null);
    }

    public void setSplitLayoutManager(SplitLayoutManager manager) {
        this.layoutManager.setValue(manager);
    }

    public SplitLayoutManager getSplitLayoutManager() {
        return this.layoutManager.getOwnValue();
    }

    public RootPlaceholderStrategy getPlaceholderStrategy() {
        return this.placeholderStrategy;
    }

    public void setPlaceholderStrategy(PlaceholderStrategy strategy) {
        this.placeholderStrategyProperty.setValue(strategy);
    }

    public void setSideSnapSize(float sideSnapSize) {
        if (sideSnapSize < 0.0f) {
            throw new IllegalArgumentException("sideSnapSize must not be less than 0");
        }
        this.sideSnapSize = sideSnapSize;
    }

    public float getSideSnapSize() {
        return this.sideSnapSize;
    }

    public void setBorderSideSnapSize(int borderSideSnapSize) {
        if (borderSideSnapSize < 0) {
            throw new IllegalArgumentException("borderSideSnapeSize must not be less than 0");
        }
        this.borderSideSnapSize = borderSideSnapSize;
    }

    public int getBorderSideSnapSize() {
        return this.borderSideSnapSize;
    }

    public void setDividerSize(int dividerSize) {
        if (dividerSize < 0) {
            throw new IllegalArgumentException("dividerSize must not be less than 0");
        }
        this.dividerSize = dividerSize;
        this.doLayout();
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setContinousDisplay(boolean continousDisplay) {
        this.continousDisplay = continousDisplay;
    }

    public boolean isContinousDisplay() {
        return this.continousDisplay;
    }

    public void setAllowSideSnap(boolean allowSideSnap) {
        this.allowSideSnap = allowSideSnap;
    }

    public boolean isAllowSideSnap() {
        return this.allowSideSnap;
    }

    @Override
    public void requestDockTitle(DockTitleRequest request) {
    }

    @Override
    public void changed(Dockable dockable, DockTitle title, boolean active) {
        title.changed(new DockTitleEvent(this, dockable, active));
    }

    @Override
    public void requestChildDockTitle(DockTitleRequest request) {
    }

    @Override
    public void bind(DockTitle title) {
        if (this.titles.contains(title)) {
            throw new IllegalArgumentException("Title is already bound");
        }
        this.titles.add(title);
        DockableListener[] dockableListenerArray = this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()]);
        int n = dockableListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockableListener listener = dockableListenerArray[n2];
            listener.titleBound(this, title);
            ++n2;
        }
    }

    @Override
    public void unbind(DockTitle title) {
        if (!this.titles.contains(title)) {
            throw new IllegalArgumentException("Title is unknown");
        }
        this.titles.remove(title);
        DockableListener[] dockableListenerArray = this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()]);
        int n = dockableListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockableListener listener = dockableListenerArray[n2];
            listener.titleUnbound(this, title);
            ++n2;
        }
    }

    @Override
    public DockTitle[] listBoundTitles() {
        return this.titles.toArray(new DockTitle[this.titles.size()]);
    }

    @Override
    public DockActionSource getLocalActionOffers() {
        return null;
    }

    @Override
    public DockActionSource getGlobalActionOffers() {
        return this.globalSource;
    }

    @Override
    public void configureDisplayerHints(DockableDisplayerHints hints) {
        this.hints = hints;
        this.updateConfigurableDisplayerHints();
    }

    protected DockableDisplayerHints getConfigurableDisplayerHints() {
        return this.hints;
    }

    protected void updateConfigurableDisplayerHints() {
        if (this.hints != null) {
            if (this.getDockableCount() == 0) {
                this.hints.setShowBorderHint(Boolean.TRUE);
            } else {
                this.hints.setShowBorderHint(Boolean.FALSE);
            }
        }
    }

    @Override
    public DockStation asDockStation() {
        return this;
    }

    @Override
    public DefaultDockActionSource getDirectActionOffers(Dockable dockable) {
        if (this.fullScreenAction == null) {
            return null;
        }
        DefaultDockActionSource source = new DefaultDockActionSource(new LocationHint(LocationHint.DIRECT_ACTION, LocationHint.VERY_RIGHT), new DockAction[0]);
        source.add(this.fullScreenAction);
        return source;
    }

    @Override
    public DockActionSource getIndirectActionOffers(Dockable dockable) {
        if (this.fullScreenAction == null) {
            return null;
        }
        DockStation parent = dockable.getDockParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof SplitDockStation) {
            return null;
        }
        dockable = parent.asDockable();
        if (dockable == null) {
            return null;
        }
        parent = dockable.getDockParent();
        if (parent != this) {
            return null;
        }
        DefaultDockActionSource source = new DefaultDockActionSource(this.fullScreenAction);
        source.setHint(new LocationHint(LocationHint.INDIRECT_ACTION, LocationHint.VERY_RIGHT));
        return source;
    }

    @Override
    public void addDockStationListener(DockStationListener listener) {
        this.dockStationListeners.addListener(listener);
    }

    @Override
    public void removeDockStationListener(DockStationListener listener) {
        this.dockStationListeners.removeListener(listener);
    }

    @Override
    public void addDockableStateListener(DockableStateListener listener) {
        this.dockableStateListeners.addListener(listener);
    }

    @Override
    public void removeDockableStateListener(DockableStateListener listener) {
        this.dockableStateListeners.removeListener(listener);
    }

    public void addSplitDockStationListener(SplitDockListener listener) {
        this.splitListeners.add(listener);
    }

    public void removeSplitDockStationListener(SplitDockListener listener) {
        this.splitListeners.remove(listener);
    }

    @Override
    public boolean isVisible(Dockable dockable) {
        return this.isStationVisible() && (!this.isFullScreen() || dockable == this.getFullScreen());
    }

    @Override
    public boolean isStationVisible() {
        return this.isDockableVisible();
    }

    @Override
    public boolean isDockableVisible() {
        DockController controller = this.getController();
        if (controller == null) {
            return false;
        }
        DockStation parent = this.getDockParent();
        if (parent != null) {
            return parent.isVisible(this);
        }
        return this.isShowing();
    }

    @Override
    public int getDockableCount() {
        return this.dockables.size();
    }

    @Override
    public Dockable getDockable(int index) {
        return this.dockables.get(index).getDockable();
    }

    @Override
    public DockableProperty getDockableProperty(Dockable child, Dockable target) {
        AbstractDockableProperty result = this.getDockablePlaceholderProperty(child, target);
        if (result == null) {
            result = this.getDockablePathProperty(child);
        }
        return result;
    }

    public SplitDockPathProperty getDockablePathProperty(final Dockable dockable) {
        final SplitDockPathProperty path = new SplitDockPathProperty();
        this.root().submit(new SplitTreeFactory<Object>(){

            @Override
            public Object leaf(Dockable check, long id, Path[] placeholders, PlaceholderMap placeholderMap) {
                if (dockable == check) {
                    path.setLeafId(id);
                    return this;
                }
                return null;
            }

            @Override
            public Object placeholder(long id, Path[] placeholders, PlaceholderMap placeholderMap) {
                return null;
            }

            @Override
            public Object root(Object root, long id) {
                return root;
            }

            @Override
            public Object horizontal(Object left, Object right, double divider, long id, Path[] placeholders, PlaceholderMap placeholderMap, boolean visible) {
                if (left != null) {
                    if (visible) {
                        path.insert(SplitDockPathProperty.Location.LEFT, divider, 0, id);
                    }
                    return left;
                }
                if (right != null) {
                    if (visible) {
                        path.insert(SplitDockPathProperty.Location.RIGHT, 1.0 - divider, 0, id);
                    }
                    return right;
                }
                return null;
            }

            @Override
            public Object vertical(Object top, Object bottom, double divider, long id, Path[] placeholders, PlaceholderMap placeholderMap, boolean visible) {
                if (top != null) {
                    if (visible) {
                        path.insert(SplitDockPathProperty.Location.TOP, divider, 0, id);
                    }
                    return top;
                }
                if (bottom != null) {
                    if (visible) {
                        path.insert(SplitDockPathProperty.Location.BOTTOM, 1.0 - divider, 0, id);
                    }
                    return bottom;
                }
                return null;
            }
        });
        return path;
    }

    public SplitDockProperty getDockableLocationProperty(Dockable dockable) {
        Leaf leaf = this.getRoot().getLeaf(dockable);
        return new SplitDockProperty(leaf.getX(), leaf.getY(), leaf.getWidth(), leaf.getHeight());
    }

    public SplitDockPlaceholderProperty getDockablePlaceholderProperty(Dockable dockable, Dockable target) {
        Leaf leaf = this.getRoot().getLeaf(dockable);
        if (leaf == null) {
            throw new IllegalArgumentException("dockable not known to this station");
        }
        Path placeholder = this.getPlaceholderStrategy().getPlaceholderFor(target == null ? dockable : target);
        if (placeholder == null) {
            return null;
        }
        this.placeholderSet.set((SplitNode)leaf, placeholder, new SplitNode[0]);
        return new SplitDockPlaceholderProperty(placeholder, this.getDockablePathProperty(dockable));
    }

    @Override
    public Dockable getFrontDockable() {
        if (this.isFullScreen()) {
            return this.getFullScreen();
        }
        if (this.frontDockable == null && this.dockables.size() > 0) {
            this.frontDockable = this.dockables.get(0).getDockable();
        }
        return this.frontDockable;
    }

    @Override
    public void setFrontDockable(Dockable dockable) {
        Dockable old = this.getFrontDockable();
        this.frontDockable = dockable;
        if (this.isFullScreen() && dockable != null) {
            this.setFullScreen(dockable);
        }
        if (old != dockable) {
            this.access.dockableSelected(old);
        }
    }

    public boolean isFullScreen() {
        return this.fullScreenDockable != null;
    }

    public Dockable getFullScreen() {
        return this.fullScreenDockable == null ? null : this.fullScreenDockable.getDockable();
    }

    public boolean hasFullScreenAction() {
        return this.fullScreenAction != null;
    }

    public void setFullScreen(Dockable dockable) {
        block9: {
            try {
                this.access.arm();
                dockable = this.layoutManager.getValue().willMakeFullscreen(this, dockable);
                Dockable oldFullScreen = this.getFullScreen();
                if (oldFullScreen == dockable) break block9;
                if (dockable != null) {
                    this.access.repositioned.add(dockable);
                    Leaf leaf = this.getRoot().getLeaf(dockable);
                    if (leaf == null) {
                        throw new IllegalArgumentException("Dockable not child of this station");
                    }
                    this.fullScreenDockable = leaf.getDockableHandle();
                    for (StationChildHandle handle : this.dockables) {
                        handle.getDisplayer().getComponent().setVisible(handle == this.fullScreenDockable);
                    }
                } else {
                    this.fullScreenDockable = null;
                    for (StationChildHandle handle : this.dockables) {
                        handle.getDisplayer().getComponent().setVisible(true);
                    }
                }
                if (oldFullScreen != null) {
                    this.access.repositioned.add(oldFullScreen);
                }
                this.doLayout();
                this.fireFullScreenChanged(oldFullScreen, this.getFullScreen());
                this.visibility.fire();
            }
            finally {
                this.access.fire();
            }
        }
    }

    public void setNextFullScreen() {
        if (this.dockables.size() > 0) {
            if (this.fullScreenDockable == null) {
                this.setFullScreen(this.getDockable(0));
            } else {
                int index = this.indexOfDockable(this.fullScreenDockable.getDockable());
                ++index;
                this.setFullScreen(this.getDockable(index %= this.getDockableCount()));
            }
        }
    }

    @Override
    public boolean accept(Dockable child) {
        return true;
    }

    @Override
    public PlaceholderMap getPlaceholders() {
        return null;
    }

    @Override
    public void setPlaceholders(PlaceholderMap placeholders) {
    }

    @Override
    public boolean prepareDrop(int x, int y, int titleX, int titleY, boolean checkOverrideZone, Dockable dockable) {
        this.putInfo = SwingUtilities.isDescendingFrom(this.getComponent(), dockable.getComponent()) ? null : this.layoutManager.getValue().prepareDrop(this, x, y, titleX, titleY, checkOverrideZone, dockable);
        if (this.putInfo != null) {
            this.prepareCombine(this.putInfo, x, y);
        }
        return this.putInfo != null;
    }

    private void prepareCombine(PutInfo putInfo, int x, int y) {
        if ((putInfo.getPut() == PutInfo.Put.CENTER || putInfo.getPut() == PutInfo.Put.TITLE) && putInfo.getCombinerSource() == null && putInfo.getCombinerTarget() == null && putInfo.getNode() instanceof Leaf) {
            Point mouseOnStation = new Point(x, y);
            SwingUtilities.convertPointFromScreen(mouseOnStation, this.getComponent());
            SplitDockCombinerSource source = new SplitDockCombinerSource(putInfo, this, mouseOnStation);
            CombinerTarget target = this.getCombiner().prepare(source, true);
            putInfo.setCombination(source, target);
        }
    }

    @Override
    public void drop(Dockable dockable) {
        this.addDockable(dockable, null);
    }

    @Override
    public boolean drop(Dockable dockable, DockableProperty property) {
        if (property instanceof SplitDockProperty) {
            return this.drop(dockable, (SplitDockProperty)property);
        }
        if (property instanceof SplitDockPathProperty) {
            return this.drop(dockable, (SplitDockPathProperty)property);
        }
        if (property instanceof SplitDockPlaceholderProperty) {
            return this.drop(dockable, (SplitDockPlaceholderProperty)property);
        }
        if (property instanceof SplitDockFullScreenProperty) {
            return this.drop(dockable, (SplitDockFullScreenProperty)property);
        }
        return false;
    }

    public boolean drop(Dockable dockable, SplitDockProperty property) {
        return this.drop(dockable, property, this.root());
    }

    private boolean drop(final Dockable dockable, final SplitDockProperty property, SplitNode root) {
        try {
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            if (this.getDockableCount() == 0) {
                if (!this.acceptable(dockable)) {
                    return false;
                }
                this.drop(dockable);
                return true;
            }
            this.updateBounds();
            class DropInfo {
                public Leaf bestLeaf;
                public double bestLeafIntersection;
                public SplitNode bestNode;
                public double bestNodeIntersection = Double.POSITIVE_INFINITY;
                public PutInfo.Put bestNodePut;

                DropInfo() {
                }
            }
            final DropInfo info = new DropInfo();
            root.visit(new SplitNodeVisitor(){
                {
                }

                @Override
                public void handleLeaf(Leaf leaf) {
                    double intersection = leaf.intersection(property);
                    if (intersection > info.bestLeafIntersection) {
                        info.bestLeafIntersection = intersection;
                        info.bestLeaf = leaf;
                    }
                    this.handleNeighbour(leaf);
                }

                @Override
                public void handleNode(Node node) {
                    if (node.isVisible()) {
                        this.handleNeighbour(node);
                    }
                }

                @Override
                public void handleRoot(Root root) {
                }

                @Override
                public void handlePlaceholder(Placeholder placeholder) {
                }

                private void handleNeighbour(SplitNode node) {
                    if (SplitDockStation.this.acceptable(dockable)) {
                        double py;
                        double px;
                        double ky;
                        double x = node.getX();
                        double y = node.getY();
                        double width = node.getWidth();
                        double height = node.getHeight();
                        double left = Math.abs(x - property.getX());
                        double right = Math.abs(x + width - property.getX() - property.getWidth());
                        double top = Math.abs(y - property.getY());
                        double bottom = Math.abs(y + height - property.getY() - property.getHeight());
                        double value = left + right + top + bottom;
                        value -= Math.max(Math.max(left, right), Math.max(top, bottom));
                        double kx = property.getX() + property.getWidth() / 2.0;
                        PutInfo.Put put = node.relativeSidePut(kx, ky = property.getY() + property.getHeight() / 2.0);
                        if (put == PutInfo.Put.TOP) {
                            px = x + 0.5 * width;
                            py = y + 0.25 * height;
                        } else if (put == PutInfo.Put.BOTTOM) {
                            px = x + 0.5 * width;
                            py = y + 0.75 * height;
                        } else if (put == PutInfo.Put.LEFT) {
                            px = x + 0.25 * width;
                            py = y + 0.5 * height;
                        } else {
                            px = x + 0.5 * width;
                            py = y + 0.75 * height;
                        }
                        double distance = Math.pow((kx - px) * (kx - px) + (ky - py) * (ky - py), 0.25);
                        value *= distance;
                        if (value < info.bestNodeIntersection) {
                            info.bestNodeIntersection = value;
                            info.bestNode = node;
                            info.bestNodePut = put;
                        }
                    }
                }
            });
            if (info.bestLeaf != null) {
                DockStation station = info.bestLeaf.getDockable().asDockStation();
                DockableProperty successor = property.getSuccessor();
                if (station != null && successor != null && station.drop(dockable, successor)) {
                    this.validate();
                    return true;
                }
                if (info.bestLeafIntersection > 0.75) {
                    if (station != null && station.accept(dockable) && dockable.accept(station)) {
                        station.drop(dockable);
                        this.validate();
                        return true;
                    }
                    boolean result = this.dropOver(info.bestLeaf, dockable, property.getSuccessor(), null, null);
                    this.validate();
                    boolean bl = result;
                    return bl;
                }
            }
            if (info.bestNode != null) {
                if (!this.acceptable(dockable)) {
                    return false;
                }
                double divider = 0.5;
                if (info.bestNodePut == PutInfo.Put.LEFT) {
                    divider = property.getWidth() / info.bestNode.getWidth();
                } else if (info.bestNodePut == PutInfo.Put.RIGHT) {
                    divider = 1.0 - property.getWidth() / info.bestNode.getWidth();
                } else if (info.bestNodePut == PutInfo.Put.TOP) {
                    divider = property.getHeight() / info.bestNode.getHeight();
                } else if (info.bestNodePut == PutInfo.Put.BOTTOM) {
                    divider = 1.0 - property.getHeight() / info.bestNode.getHeight();
                }
                divider = Math.max(0.0, Math.min(1.0, divider));
                boolean bl = this.dropAside(info.bestNode, info.bestNodePut, dockable, null, divider, null);
                return bl;
            }
            this.repaint();
            return false;
        }
        finally {
            this.access.fire();
        }
    }

    public boolean drop(Dockable dockable, SplitDockPathProperty property) {
        try {
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            int index = 0;
            SplitNode start = null;
            long leafId = property.getLeafId();
            if (leafId != -1L && (start = this.getNode(leafId)) != null) {
                index = property.size();
            }
            if (start == null) {
                index = property.size() - 1;
                while (index >= 0) {
                    SplitDockPathProperty.Node node = property.getNode(index);
                    long id = node.getId();
                    if (id != -1L && (start = this.getNode(id)) != null) break;
                    --index;
                }
            }
            if (start == null || index < 0) {
                start = this.root();
                index = 0;
            }
            this.updateBounds();
            boolean done = start.insert(property, index, dockable);
            if (done) {
                this.revalidate();
            }
            boolean bl = done;
            return bl;
        }
        finally {
            this.access.fire();
        }
    }

    public boolean drop(Dockable dockable, SplitDockPlaceholderProperty property) {
        try {
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            this.validate();
            boolean bl = this.root().insert(property, dockable);
            return bl;
        }
        finally {
            this.access.fire();
        }
    }

    public boolean drop(Dockable dockable, SplitDockFullScreenProperty property) {
        try {
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            DockableProperty successor = property.getSuccessor();
            if (dockable.getDockParent() == this) {
                this.setFullScreen(dockable);
                return true;
            }
            Dockable currentFullScreen = this.getFullScreen();
            if (currentFullScreen == null) {
                return false;
            }
            DockStation currentFullScreenStation = currentFullScreen.asDockStation();
            if (currentFullScreenStation != null) {
                return successor != null && currentFullScreenStation.drop(dockable, successor);
                {
                }
            }
            Leaf leaf = this.getRoot().getLeaf(currentFullScreen);
            this.setFullScreen(null);
            if (!this.dropOver(leaf, dockable, successor, null, null)) {
                return false;
            }
            Dockable last = dockable;
            while (dockable != null && dockable != this) {
                last = dockable;
                DockStation station = dockable.getDockParent();
                Dockable dockable2 = dockable = station == null ? null : station.asDockable();
            }
            if (last != null) {
                this.setFullScreen(last);
            }
            return true;
        }
        finally {
            this.access.fire();
        }
    }

    public PutInfo getDropInfo() {
        return this.putInfo;
    }

    @Override
    public void drop() {
        this.drop(this.putInfo);
    }

    public void drop(PutInfo put) {
        this.drop(put, null);
    }

    private void drop(DockHierarchyLock.Token token) {
        this.drop(this.putInfo, token);
    }

    /*
     * Unable to fully structure code
     */
    private void drop(PutInfo putInfo, DockHierarchyLock.Token token) {
        try {
            fire = token == null;
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            if (putInfo.getNode() == null) {
                if (fire) {
                    DockUtilities.ensureTreeValidity(this, putInfo.getDockable());
                    token = DockHierarchyLock.acquireLinking(this, putInfo.getDockable());
                }
                try {
                    if (fire) {
                        this.dockStationListeners.fireDockableAdding(putInfo.getDockable());
                    }
                    this.addDockable(putInfo.getDockable(), token);
                    if (!fire) ** GOTO lbl44
                    this.dockStationListeners.fireDockableAdded(putInfo.getDockable());
                }
                finally {
                    if (fire) {
                        token.release();
                    }
                }
            } else {
                finish = false;
                if (putInfo.getPut() == PutInfo.Put.CENTER || putInfo.getPut() == PutInfo.Put.TITLE) {
                    if (putInfo.getNode() instanceof Leaf) {
                        if (putInfo.getLeaf() != null) {
                            if (fire) {
                                token = DockHierarchyLock.acquireUnlinking(this, putInfo.getLeaf().getDockable());
                            }
                            try {
                                putInfo.getLeaf().setDockable(null, token);
                                putInfo.setLeaf(null);
                            }
                            finally {
                                if (fire) {
                                    token.release();
                                }
                            }
                        }
                        if (this.dropOver((Leaf)putInfo.getNode(), putInfo.getDockable(), putInfo.getCombinerSource(), putInfo.getCombinerTarget())) {
                            finish = true;
                        }
                    } else {
                        putInfo.setPut(PutInfo.Put.TOP);
                    }
                }
                if (!finish) {
                    this.updateBounds();
                    this.layoutManager.getValue().calculateDivider(this, putInfo, this.root().getLeaf(putInfo.getDockable()));
                    this.dropAside(putInfo.getNode(), putInfo.getPut(), putInfo.getDockable(), putInfo.getLeaf(), putInfo.getDivider(), token);
                }
            }
lbl44:
            // 5 sources

            this.revalidate();
        }
        finally {
            this.access.fire();
        }
    }

    protected boolean dropOver(Leaf leaf, Dockable dockable, CombinerSource source, CombinerTarget target) {
        return this.dropOver(leaf, dockable, null, source, target);
    }

    protected boolean dropOver(Leaf leaf, Dockable dockable, DockableProperty property, CombinerSource source, CombinerTarget target) {
        if (!this.acceptable(leaf.getDockable(), dockable)) {
            return false;
        }
        try {
            DockStation combinedStation;
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            DockUtilities.ensureTreeValidity(this, dockable);
            if (source == null || target == null) {
                PutInfo info = new PutInfo(leaf, PutInfo.Put.TITLE, dockable);
                source = new SplitDockCombinerSource(info, this, null);
                target = this.combiner.prepare(source, true);
            }
            if (leaf.getDockable() != null) {
                DockHierarchyLock.Token token = DockHierarchyLock.acquireUnlinking(this, leaf.getDockable());
                try {
                    leaf.setDockable(null, token);
                }
                finally {
                    token.release();
                }
            }
            Dockable combination = this.combiner.combine(source, target);
            leaf.setPlaceholderMap(null);
            if (property != null && (combinedStation = combination.asDockStation()) != null && dockable.getDockParent() == combinedStation) {
                combinedStation.move(dockable, property);
            }
            DockHierarchyLock.Token token = DockHierarchyLock.acquireLinking(this, combination);
            try {
                this.dockStationListeners.fireDockableAdding(combination);
                leaf.setDockable(combination, token);
                this.dockStationListeners.fireDockableAdded(combination);
            }
            finally {
                token.release();
            }
            this.revalidate();
            this.repaint();
            return true;
        }
        finally {
            this.access.fire();
        }
    }

    protected boolean dropAside(SplitNode neighbor, PutInfo.Put put, Dockable dockable, Leaf leaf, double divider, DockHierarchyLock.Token token) {
        if (!this.acceptable(dockable)) {
            return false;
        }
        try {
            boolean fire = token == null;
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            if (fire) {
                DockUtilities.ensureTreeValidity(this, dockable);
                token = DockHierarchyLock.acquireLinking(this, dockable);
            }
            try {
                if (fire) {
                    this.dockStationListeners.fireDockableAdding(dockable);
                }
                boolean leafSet = false;
                if (leaf == null) {
                    leaf = new Leaf(this.access);
                    leafSet = true;
                }
                SplitNode parent = neighbor.getParent();
                Node node = null;
                this.updateBounds();
                int location = parent.getChildLocation(neighbor);
                node = put == PutInfo.Put.TOP ? new Node((SplitDockAccess)this.access, (SplitNode)leaf, neighbor, Orientation.VERTICAL) : (put == PutInfo.Put.BOTTOM ? new Node((SplitDockAccess)this.access, neighbor, (SplitNode)leaf, Orientation.VERTICAL) : (put == PutInfo.Put.LEFT ? new Node((SplitDockAccess)this.access, (SplitNode)leaf, neighbor, Orientation.HORIZONTAL) : new Node((SplitDockAccess)this.access, neighbor, (SplitNode)leaf, Orientation.HORIZONTAL)));
                node.setDivider(divider);
                parent.setChild(node, location);
                if (leafSet) {
                    leaf.setDockable(dockable, token);
                }
                if (fire) {
                    this.dockStationListeners.fireDockableAdded(dockable);
                }
                this.revalidate();
                this.repaint();
            }
            finally {
                if (fire) {
                    token.release();
                }
            }
        }
        finally {
            this.access.fire();
        }
        return true;
    }

    @Override
    public boolean prepareMove(int x, int y, int titleX, int titleY, boolean checkOverrideZone, Dockable dockable) {
        this.putInfo = this.layoutManager.getValue().prepareMove(this, x, y, titleX, titleY, checkOverrideZone, dockable);
        if (this.putInfo != null) {
            this.prepareCombine(this.putInfo, x, y);
        }
        return this.putInfo != null;
    }

    @Override
    public void move() {
        try {
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            Root root = this.root();
            Leaf leaf = root.getLeaf(this.putInfo.getDockable());
            SplitNode parent = this.putInfo.getNode();
            if (leaf.getParent() == parent) {
                while (parent != null) {
                    if (parent == root) {
                        return;
                    }
                    Node node = (Node)parent;
                    SplitNode next = node.getLeft() == leaf ? node.getRight() : node.getLeft();
                    if (next.isVisible()) {
                        this.putInfo.setNode(next);
                        break;
                    }
                    parent = parent.getParent();
                }
            }
            this.putInfo.setLeaf(leaf);
            if (this.putInfo.getPut() == PutInfo.Put.CENTER) {
                leaf.placehold(false);
            } else {
                leaf.delete(true);
            }
            this.drop(DockHierarchyLock.acquireFake());
        }
        finally {
            this.access.fire();
        }
    }

    @Override
    public void move(Dockable dockable, DockableProperty property) {
    }

    public void dropTree(SplitDockTree<Dockable> tree) {
        this.dropTree(tree, true);
    }

    public void dropTree(SplitDockTree<Dockable> tree, boolean checkValidity) {
        if (tree == null) {
            throw new IllegalArgumentException("Tree must not be null");
        }
        DockUtilities.checkLayoutLocked();
        DockController controller = this.getController();
        try {
            this.access.arm();
            ++this.treeLock;
            if (controller != null) {
                controller.freezeLayout();
            }
            this.setFullScreen(null);
            this.removeAllDockables();
            Dockable[] dockableArray = tree.getDockables();
            int n = dockableArray.length;
            int n2 = 0;
            while (n2 < n) {
                Dockable dockable = dockableArray[n2];
                DockUtilities.ensureTreeValidity(this, dockable);
                ++n2;
            }
            SplitDockTree.Key rootKey = tree.getRoot();
            if (rootKey != null) {
                HashMap<Leaf, Dockable> linksToSet = new HashMap<Leaf, Dockable>();
                this.root().evolve(rootKey, checkValidity, linksToSet);
                for (Map.Entry entry : linksToSet.entrySet()) {
                    ((Leaf)entry.getKey()).setDockable((Dockable)entry.getValue(), null);
                }
                this.updateBounds();
            }
        }
        finally {
            --this.treeLock;
            if (controller != null) {
                controller.meltLayout();
            }
            this.access.fire();
        }
    }

    public DockableSplitDockTree createTree() {
        DockableSplitDockTree tree = new DockableSplitDockTree();
        this.createTree(new SplitDockTreeFactory(tree));
        return tree;
    }

    public void createTree(SplitDockTreeFactory factory) {
        this.root().submit(factory);
    }

    public <N> N visit(SplitTreeFactory<N> factory) {
        return this.root().submit(factory);
    }

    @Override
    public void draw() {
        this.putInfo.setDraw(true);
        this.repaint();
    }

    @Override
    public void forget() {
        this.putInfo = null;
        this.repaint();
    }

    @Override
    public <D extends Dockable & DockStation> boolean isInOverrideZone(int x, int y, D invoker, Dockable drop) {
        if (this.isFullScreen()) {
            return false;
        }
        if (this.getDockParent() != null && this.getDockParent().isInOverrideZone(x, y, invoker, drop)) {
            return true;
        }
        Point point = new Point(x, y);
        SwingUtilities.convertPointFromScreen(point, this);
        return this.root().isInOverrideZone(point.x, point.y);
    }

    @Override
    public boolean canDrag(Dockable dockable) {
        return true;
    }

    @Override
    public void drag(Dockable dockable) {
        if (dockable.getDockParent() != this) {
            throw new IllegalArgumentException("The dockable cannot be dragged, it is not child of this station.");
        }
        this.removeDockable(dockable);
    }

    protected void fireFullScreenChanged(Dockable oldDockable, Dockable newDockable) {
        SplitDockListener[] splitDockListenerArray = this.splitListeners.toArray(new SplitDockListener[this.splitListeners.size()]);
        int n = splitDockListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SplitDockListener listener = splitDockListenerArray[n2];
            listener.fullScreenDockableChanged(this, oldDockable, newDockable);
            ++n2;
        }
    }

    protected void fireTitleExchanged(DockTitle title) {
        DockableListener[] dockableListenerArray = this.dockableListeners.toArray(new DockableListener[this.dockableListeners.size()]);
        int n = dockableListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockableListener listener = dockableListenerArray[n2];
            listener.titleExchanged(this, title);
            ++n2;
        }
    }

    protected void fireTitleExchanged() {
        DockTitle[] bound;
        DockTitle[] dockTitleArray = bound = this.listBoundTitles();
        int n = bound.length;
        int n2 = 0;
        while (n2 < n) {
            DockTitle title = dockTitleArray[n2];
            this.fireTitleExchanged(title);
            ++n2;
        }
        this.fireTitleExchanged(null);
    }

    @Override
    public Rectangle getStationBounds() {
        Point location = new Point(0, 0);
        SwingUtilities.convertPointToScreen(location, this);
        if (this.isAllowSideSnap()) {
            return new Rectangle(location.x - this.borderSideSnapSize, location.y - this.borderSideSnapSize, this.getWidth() + 2 * this.borderSideSnapSize, this.getHeight() + 2 * this.borderSideSnapSize);
        }
        return new Rectangle(location.x, location.y, this.getWidth(), this.getHeight());
    }

    @Override
    public boolean canCompare(DockStation station) {
        if (!this.isAllowSideSnap()) {
            return false;
        }
        if (station.asDockable() != null) {
            Component component = station.asDockable().getComponent();
            Component root = SwingUtilities.getRoot(this.getComponent());
            if (root != null && root == SwingUtilities.getRoot(component)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int compare(DockStation station) {
        if (!this.isAllowSideSnap()) {
            return 0;
        }
        if (station.asDockable() != null) {
            Component component = station.asDockable().getComponent();
            Component root = SwingUtilities.getRoot(this.getComponent());
            if (root != null && root == SwingUtilities.getRoot(component)) {
                Rectangle sizeThis = this.getStationBounds();
                Rectangle sizeOther = station.getStationBounds();
                if (sizeThis == null && sizeOther == null) {
                    return 0;
                }
                if (sizeThis == null) {
                    return -1;
                }
                if (sizeOther == null) {
                    return 1;
                }
                if (sizeThis.width * sizeThis.height > sizeOther.width * sizeOther.height) {
                    return -1;
                }
                if (sizeThis.width * sizeThis.height < sizeOther.width * sizeOther.height) {
                    return 1;
                }
            }
        }
        return 0;
    }

    @Override
    public Dockable asDockable() {
        return this;
    }

    public DefaultStationPaintValue getPaint() {
        return this.paint;
    }

    public DefaultDisplayerFactoryValue getDisplayerFactory() {
        return this.displayerFactory;
    }

    public DisplayerCollection getDisplayers() {
        return this.displayers;
    }

    public StationCombinerValue getCombiner() {
        return this.combiner;
    }

    @Override
    protected void paintOverlay(Graphics g) {
        if (this.putInfo != null && this.putInfo.isDraw()) {
            DefaultStationPaintValue paint = this.getPaint();
            if (this.putInfo.getNode() == null) {
                Rectangle bounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                paint.drawInsertion(g, bounds, bounds);
            } else {
                CombinerTarget target = this.putInfo.getCombinerTarget();
                if (target == null) {
                    Rectangle bounds = this.putInfo.getNode().getBounds();
                    if (this.putInfo.getPut() == PutInfo.Put.LEFT) {
                        bounds.width = (int)((double)bounds.width * this.putInfo.getDivider() + 0.5);
                    } else if (this.putInfo.getPut() == PutInfo.Put.RIGHT) {
                        int width = bounds.width;
                        bounds.width = (int)((double)bounds.width * (1.0 - this.putInfo.getDivider()) + 0.5);
                        bounds.x += width - bounds.width;
                    } else if (this.putInfo.getPut() == PutInfo.Put.TOP) {
                        bounds.height = (int)((double)bounds.height * this.putInfo.getDivider() + 0.5);
                    } else if (this.putInfo.getPut() == PutInfo.Put.BOTTOM) {
                        int height = bounds.height;
                        bounds.height = (int)((double)bounds.height * (1.0 - this.putInfo.getDivider()) + 0.5);
                        bounds.y += height - bounds.height;
                    }
                    paint.drawInsertion(g, this.putInfo.getNode().getBounds(), bounds);
                } else {
                    Rectangle bounds = this.putInfo.getNode().getBounds();
                    StationPaint stationPaint = (StationPaint)paint.get();
                    if (stationPaint != null) {
                        target.paint(g, this.getComponent(), stationPaint, bounds, bounds);
                    }
                }
            }
        }
        this.dividerListener.paint(g);
    }

    public void addDockable(Dockable dockable) {
        this.addDockable(dockable, null);
    }

    private void addDockable(Dockable dockable, DockHierarchyLock.Token token) {
        try {
            boolean fire = token == null;
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            if (fire) {
                DockUtilities.ensureTreeValidity(this, dockable);
                token = DockHierarchyLock.acquireLinking(this, dockable);
            }
            try {
                if (fire) {
                    this.dockStationListeners.fireDockableAdding(dockable);
                }
                Leaf leaf = new Leaf(this.access);
                Root root = this.root();
                if (root.getChild() == null) {
                    root.setChild(leaf);
                } else {
                    SplitNode child = root.getChild();
                    root.setChild(null);
                    Node node = new Node(this.access, leaf, child);
                    root.setChild(node);
                }
                leaf.setDockable(dockable, token);
                if (fire) {
                    this.dockStationListeners.fireDockableAdded(dockable);
                }
                this.revalidate();
            }
            finally {
                if (fire) {
                    token.release();
                }
            }
        }
        finally {
            this.access.fire();
        }
    }

    @Override
    public boolean canReplace(Dockable old, Dockable next) {
        return true;
    }

    @Override
    public void replace(DockStation old, Dockable next) {
        this.replace(old.asDockable(), next, true);
    }

    @Override
    public void replace(Dockable previous, Dockable next) {
        this.replace(previous, next, false);
    }

    private void replace(Dockable previous, Dockable next, boolean station) {
        try {
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            if (previous == null) {
                throw new NullPointerException("previous must not be null");
            }
            if (next == null) {
                throw new NullPointerException("next must not be null");
            }
            if (previous != next) {
                Leaf leaf = this.root().getLeaf(previous);
                if (leaf == null) {
                    throw new IllegalArgumentException("Previous is not child of this station");
                }
                DockUtilities.ensureTreeValidity(this, next);
                boolean wasFullScreen = this.isFullScreen() && this.getFullScreen() == previous;
                leaf.setDockable(next, null, true, station);
                if (wasFullScreen) {
                    this.setFullScreen(next);
                }
                this.revalidate();
                this.repaint();
            }
        }
        finally {
            this.access.fire();
        }
    }

    private void addHandle(StationChildHandle handle, DockHierarchyLock.Token token) {
        boolean fire;
        Dockable dockable = handle.getDockable();
        DockUtilities.ensureTreeValidity(this, dockable);
        boolean bl = fire = token == null;
        if (fire) {
            token = DockHierarchyLock.acquireLinking(this, dockable);
        }
        try {
            if (fire) {
                this.dockStationListeners.fireDockableAdding(dockable);
            }
            this.dockables.add(handle);
            dockable.setDockParent(this);
            handle.updateDisplayer();
            DockableDisplayer displayer = handle.getDisplayer();
            this.getContentPane().add(displayer.getComponent());
            displayer.getComponent().setVisible(!this.isFullScreen());
            if (fire) {
                this.dockStationListeners.fireDockableAdded(dockable);
            }
        }
        finally {
            if (fire) {
                token.release();
            }
        }
    }

    protected void discard(DockableDisplayer displayer) {
        int index = this.indexOfDockable(displayer.getDockable());
        if (index < 0) {
            throw new IllegalArgumentException("displayer unknown to this station: " + displayer);
        }
        Dockable dockable = displayer.getDockable();
        boolean visible = displayer.getComponent().isVisible();
        Leaf leaf = this.root().getLeaf(dockable);
        this.getContentPane().remove(displayer.getComponent());
        StationChildHandle handle = leaf.getDockableHandle();
        handle.updateDisplayer();
        displayer = handle.getDisplayer();
        this.getContentPane().add(displayer.getComponent());
        displayer.getComponent().setVisible(visible);
        this.revalidate();
    }

    public int indexOfDockable(Dockable dockable) {
        int i = 0;
        int n = this.dockables.size();
        while (i < n) {
            if (this.dockables.get(i).getDockable() == dockable) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void removeAllDockables() {
        DockController controller = this.getController();
        try {
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            if (controller != null) {
                controller.freezeLayout();
            }
            int i = this.getDockableCount() - 1;
            while (i >= 0) {
                this.removeDisplayer(i, null);
                --i;
            }
            this.root().setChild(null);
        }
        finally {
            if (controller != null) {
                controller.meltLayout();
            }
            this.access.fire();
        }
    }

    public void removeDockable(Dockable dockable) {
        try {
            this.access.arm();
            DockUtilities.checkLayoutLocked();
            Leaf leaf = this.root().getLeaf(dockable);
            if (leaf != null) {
                leaf.setDockable(null, null, true, dockable.asDockStation() != null);
                leaf.placehold(true);
            }
        }
        finally {
            this.access.fire();
        }
    }

    public void removePlaceholder(Path placeholder) {
        HashSet<Path> placeholders = new HashSet<Path>();
        placeholders.add(placeholder);
        this.removePlaceholders(placeholders);
    }

    public void removePlaceholders(final Set<Path> placeholders) {
        if (placeholders.isEmpty()) {
            return;
        }
        final ArrayList nodesToDelete = new ArrayList();
        this.root().visit(new SplitNodeVisitor(){

            @Override
            public void handleRoot(Root root) {
                this.handle(root);
            }

            @Override
            public void handlePlaceholder(Placeholder placeholder) {
                this.handle(SplitDockStation.this.root);
            }

            @Override
            public void handleNode(Node node) {
                this.handle(SplitDockStation.this.root);
            }

            @Override
            public void handleLeaf(Leaf leaf) {
                this.handle(SplitDockStation.this.root);
            }

            private void handle(SplitNode node) {
                node.removePlaceholders(placeholders);
                if (!node.isOfUse()) {
                    nodesToDelete.add(node);
                }
            }
        });
        for (SplitNode node : nodesToDelete) {
            node.delete(true);
        }
    }

    private void removeHandle(StationChildHandle handle, DockHierarchyLock.Token token) {
        int index = this.dockables.indexOf(handle);
        if (index >= 0) {
            this.removeDisplayer(index, token);
        }
    }

    private void removeDisplayer(int index, DockHierarchyLock.Token token) {
        boolean fire;
        StationChildHandle handle = this.dockables.get(index);
        if (handle == this.fullScreenDockable) {
            this.setNextFullScreen();
            if (handle == this.fullScreenDockable) {
                this.setFullScreen(null);
            }
        }
        Dockable dockable = handle.getDockable();
        boolean bl = fire = token == null;
        if (fire) {
            token = DockHierarchyLock.acquireUnlinking(this, dockable);
        }
        try {
            if (fire) {
                this.dockStationListeners.fireDockableRemoving(dockable);
            }
            this.dockables.remove(index);
            DockableDisplayer displayer = handle.getDisplayer();
            displayer.getComponent().setVisible(true);
            this.getContentPane().remove(displayer.getComponent());
            handle.destroy();
            if (dockable == this.frontDockable) {
                this.setFrontDockable(null);
            }
            dockable.setDockParent(null);
            if (fire) {
                this.dockStationListeners.fireDockableRemoved(dockable);
            }
        }
        finally {
            if (fire) {
                token.release();
            }
        }
    }

    public Root getRoot() {
        return this.root();
    }

    public SplitNode getNode(long id) {
        if (this.root == null) {
            return null;
        }
        class Visitor
        implements SplitNodeVisitor {
            private SplitNode result;
            private final /* synthetic */ long val$id;

            Visitor(long l) {
                this.val$id = l;
            }

            @Override
            public void handleRoot(Root root) {
                if (root.getId() == this.val$id) {
                    this.result = root;
                }
            }

            @Override
            public void handleLeaf(Leaf leaf) {
                if (leaf.getId() == this.val$id) {
                    this.result = leaf;
                }
            }

            @Override
            public void handlePlaceholder(Placeholder placeholder) {
                if (placeholder.getId() == this.val$id) {
                    this.result = placeholder;
                }
            }

            @Override
            public void handleNode(Node node) {
                if (node.getId() == this.val$id) {
                    this.result = node;
                }
            }
        }
        Visitor visitor = new Visitor(id);
        this.getRoot().visit(visitor);
        return visitor.result;
    }

    @Override
    public String getFactoryID() {
        return "SplitDockStationFactory";
    }

    public void updateBounds() {
        Insets insets = this.getBasePane().getInsets();
        double factorW = this.getWidth() - insets.left - insets.right;
        double factorH = this.getHeight() - insets.top - insets.bottom;
        SplitLayoutManager manager = this.layoutManager.getValue();
        if (factorW <= 0.0 || factorH <= 0.0) {
            manager.updateBounds(this.root(), 0.0, 0.0, 0.0, 0.0);
        } else {
            manager.updateBounds(this.root(), (double)insets.left / factorW, (double)insets.top / factorH, factorW, factorH);
        }
    }

    protected void checkMousePositionAsync() {
        DockController controller = this.getController();
        if (controller != null && !controller.isRestrictedEnvironment()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PointerInfo p = MouseInfo.getPointerInfo();
                    Point e = p.getLocation();
                    SwingUtilities.convertPointFromScreen(e, SplitDockStation.this.getContentPane());
                    SplitDockStation.this.dividerListener.current = SplitDockStation.this.root().getDividerNode(e.x, e.y);
                    if (SplitDockStation.this.dividerListener.current == null) {
                        SplitDockStation.this.setCursor(null);
                    }
                }
            });
        }
    }

    private class Access
    implements SplitDockAccess {
        private long lastUniqueId = -1L;
        private int repositionedArm = 0;
        private Set<Dockable> repositioned = new HashSet<Dockable>();
        private Dockable dockableSelected = null;

        private Access() {
        }

        @Override
        public StationChildHandle getFullScreenDockable() {
            return SplitDockStation.this.fullScreenDockable;
        }

        @Override
        public DockTitleVersion getTitleVersion() {
            return SplitDockStation.this.title;
        }

        @Override
        public SplitDockStation getOwner() {
            return SplitDockStation.this;
        }

        @Override
        public double validateDivider(double divider, Node node) {
            return ((SplitLayoutManager)SplitDockStation.this.layoutManager.getValue()).validateDivider(SplitDockStation.this, divider, node);
        }

        @Override
        public StationChildHandle newHandle(Dockable dockable) {
            return new StationChildHandle(SplitDockStation.this, SplitDockStation.this.getDisplayers(), dockable, SplitDockStation.this.title);
        }

        @Override
        public void addHandle(StationChildHandle dockable, DockHierarchyLock.Token token) {
            SplitDockStation.this.addHandle(dockable, token);
        }

        @Override
        public void removeHandle(StationChildHandle handle, DockHierarchyLock.Token token) {
            SplitDockStation.this.removeHandle(handle, token);
        }

        @Override
        public boolean drop(Dockable dockable, SplitDockProperty property, SplitNode root) {
            return SplitDockStation.this.drop(dockable, property, root);
        }

        @Override
        public PutInfo validatePutInfo(PutInfo putInfo) {
            return ((SplitLayoutManager)SplitDockStation.this.layoutManager.getValue()).validatePutInfo(SplitDockStation.this, putInfo);
        }

        @Override
        public void repositioned(SplitNode node) {
            this.arm();
            try {
                node.visit(new SplitNodeVisitor(){

                    @Override
                    public void handleRoot(Root root) {
                    }

                    @Override
                    public void handlePlaceholder(Placeholder placeholder) {
                    }

                    @Override
                    public void handleNode(Node node) {
                    }

                    @Override
                    public void handleLeaf(Leaf leaf) {
                        Dockable dockable = leaf.getDockable();
                        if (dockable != null) {
                            Access.this.repositioned.add(dockable);
                        }
                    }
                });
            }
            finally {
                this.fire();
            }
        }

        public void dockableSelected(Dockable dockable) {
            this.arm();
            if (this.dockableSelected == null) {
                this.dockableSelected = dockable;
            }
            this.fire();
        }

        public void arm() {
            ++this.repositionedArm;
        }

        public void fire() {
            --this.repositionedArm;
            if (this.repositionedArm == 0) {
                ArrayList<Dockable> dockables = new ArrayList<Dockable>();
                for (Dockable dockable : this.repositioned) {
                    if (dockable.getDockParent() != SplitDockStation.this) continue;
                    dockables.add(dockable);
                }
                this.repositioned.clear();
                if (dockables.size() > 0) {
                    SplitDockStation.this.dockStationListeners.fireDockablesRepositioned(dockables.toArray(new Dockable[dockables.size()]));
                }
                if (this.dockableSelected != null) {
                    Dockable newDockable = SplitDockStation.this.getFrontDockable();
                    if (this.dockableSelected != newDockable) {
                        SplitDockStation.this.dockStationListeners.fireDockableSelected(this.dockableSelected, newDockable);
                    }
                    this.dockableSelected = null;
                }
            }
        }

        @Override
        public long uniqueID() {
            long id = System.currentTimeMillis();
            if (id <= this.lastUniqueId) {
                ++this.lastUniqueId;
                id = this.lastUniqueId + 1L;
            }
            while (SplitDockStation.this.getNode(id) != null) {
                ++id;
            }
            this.lastUniqueId = id;
            return id;
        }

        @Override
        public boolean isTreeAutoCleanupEnabled() {
            return SplitDockStation.this.treeLock == 0;
        }

        @Override
        public SplitPlaceholderSet getPlaceholderSet() {
            return SplitDockStation.this.placeholderSet;
        }
    }

    private class Background
    extends BackgroundAlgorithm
    implements StationBackgroundComponent {
        public Background() {
            super(StationBackgroundComponent.KIND, "dock.background.station.split");
        }

        @Override
        public Component getComponent() {
            return SplitDockStation.this.getComponent();
        }

        @Override
        public DockStation getStation() {
            return SplitDockStation.this;
        }
    }

    private class Content
    extends BackgroundPanel {
        public Content() {
            super(true, false);
        }

        @Override
        public void doLayout() {
            SplitDockStation.this.updateBounds();
            Insets insets = this.getInsets();
            if (SplitDockStation.this.fullScreenDockable != null) {
                SplitDockStation.this.fullScreenDockable.getDisplayer().getComponent().setBounds(insets.left, insets.top, this.getWidth() - insets.left - insets.right, this.getHeight() - insets.bottom - insets.top);
            }
        }
    }

    private class DividerListener
    extends MouseInputAdapter {
        private Node current;
        private double divider;
        private boolean pressed = false;
        private Rectangle bounds = new Rectangle();
        private int deltaX;
        private int deltaY;

        private DividerListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SplitDockStation.this.isResizingEnabled() && !this.pressed) {
                this.pressed = true;
                this.mouseMoved(e);
                if (this.current != null) {
                    this.divider = this.current.getDividerAt(e.getX() + this.deltaX, e.getY() + this.deltaY);
                    SplitDockStation.this.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                    this.bounds = this.current.getDividerBounds(this.divider, this.bounds);
                    SplitDockStation.this.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SplitDockStation.this.isResizingEnabled() && this.pressed && this.current != null) {
                this.divider = this.current.getDividerAt(e.getX() + this.deltaX, e.getY() + this.deltaY);
                this.divider = ((SplitLayoutManager)SplitDockStation.this.layoutManager.getValue()).validateDivider(SplitDockStation.this, this.divider, this.current);
                SplitDockStation.this.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                this.bounds = this.current.getDividerBounds(this.divider, this.bounds);
                SplitDockStation.this.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                if (SplitDockStation.this.continousDisplay && this.current != null) {
                    this.current.setDivider(this.divider);
                    SplitDockStation.this.updateBounds();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.pressed) {
                this.pressed = false;
                if (this.current != null) {
                    this.current.setDivider(this.divider);
                    SplitDockStation.this.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                    SplitDockStation.this.updateBounds();
                }
                SplitDockStation.this.setCursor(null);
                this.mouseMoved(e);
                SplitDockStation.this.checkMousePositionAsync();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (SplitDockStation.this.isResizingEnabled()) {
                this.current = SplitDockStation.this.root().getDividerNode(e.getX(), e.getY());
                if (this.current == null) {
                    SplitDockStation.this.setCursor(null);
                } else if (this.current.getOrientation() == Orientation.HORIZONTAL) {
                    SplitDockStation.this.setCursor(Cursor.getPredefinedCursor(10));
                } else {
                    SplitDockStation.this.setCursor(Cursor.getPredefinedCursor(8));
                }
                if (this.current != null) {
                    this.bounds = this.current.getDividerBounds(this.current.getDivider(), this.bounds);
                    this.deltaX = this.bounds.width / 2 + this.bounds.x - e.getX();
                    this.deltaY = this.bounds.height / 2 + this.bounds.y - e.getY();
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (SplitDockStation.this.isResizingEnabled() && !this.pressed) {
                this.current = null;
                SplitDockStation.this.setCursor(null);
            }
        }

        public void paint(Graphics g) {
            if (SplitDockStation.this.isResizingEnabled() && this.current != null && this.pressed) {
                SplitDockStation.this.getPaint().drawDivider(g, this.bounds);
            }
        }
    }

    private class FullScreenListener
    implements DoubleClickListener {
        private FullScreenListener() {
        }

        @Override
        public DockElement getTreeLocation() {
            return SplitDockStation.this;
        }

        @Override
        public boolean process(Dockable dockable, MouseEvent event) {
            if (event.isConsumed() || !SplitDockStation.this.isExpandOnDoubleclick()) {
                return false;
            }
            if (dockable == SplitDockStation.this) {
                return false;
            }
            if ((dockable = this.unwrap(dockable)) != null) {
                if (SplitDockStation.this.isFullScreen()) {
                    if (SplitDockStation.this.getFullScreen() == dockable) {
                        SplitDockStation.this.setFullScreen(null);
                        event.consume();
                    }
                } else {
                    SplitDockStation.this.setFullScreen(dockable);
                    event.consume();
                }
                return true;
            }
            return false;
        }

        private Dockable unwrap(Dockable dockable) {
            while (dockable.getDockParent() != SplitDockStation.this) {
                DockStation parent = dockable.getDockParent();
                if (parent == null) {
                    return null;
                }
                dockable = parent.asDockable();
                if (dockable != null) continue;
                return null;
            }
            return dockable;
        }
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }

    private class VisibleListener
    extends DockStationAdapter {
        private VisibleListener() {
        }

        @Override
        public void dockableVisibiltySet(DockStation station, Dockable dockable, boolean visible) {
            SplitDockStation.this.visibility.fire();
        }
    }
}

