/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack.tab;

import java.util.Arrays;

public class Arch {
    private int width;
    private int height;
    private int[] values;

    public Arch(int width, int height) {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("width or height smaller than 1: " + width + ", " + height);
        }
        this.width = width;
        this.height = height;
        this.values = new int[width];
        this.calculate();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getValue(int x) {
        return this.values[x];
    }

    private void calculate() {
        int y;
        int lineWidth = this.lineH(this.width);
        int lineHeight = this.lineV(this.height);
        int archWidth = (this.width - lineWidth) / 2;
        int archHeight = (this.height - lineHeight) / 2;
        Arrays.fill(this.values, -1);
        double[] sample = this.arch(0, 0, archWidth, archHeight, (double)lineHeight / (double)lineWidth);
        int x = 0;
        while (x < archWidth) {
            this.values[x] = y = (int)(sample[x] + 0.5);
            this.values[this.width - 1 - x] = this.height - 1 - y;
            ++x;
        }
        sample = this.line(archWidth, archHeight, archWidth + lineWidth / 2 - 1, archHeight + lineHeight / 2 - 1);
        x = 0;
        while (x < sample.length) {
            this.values[x + archWidth] = y = (int)(sample[x] + 0.5);
            this.values[this.width - 1 - x - archWidth] = this.height - 1 - y;
            ++x;
        }
        if (this.values[0] == -1) {
            this.values[0] = 0;
            this.values[this.values.length - 1] = this.height - 1;
        }
        x = 1;
        int n = this.width / 2;
        while (x <= n) {
            if (this.values[x] == -1) {
                this.values[x] = this.values[x - 1];
                this.values[this.width - x - 1] = this.values[this.width - x];
            }
            ++x;
        }
    }

    private double[] line(int x1, int y1, int x2, int y2) {
        double[] sample = new double[x2 - x1 + 1];
        int t = 0;
        while (t < sample.length) {
            int t2 = 0;
            while (t2 < 10) {
                double value = (double)(10 * t + t2) / 10.0 / (double)sample.length;
                double bx = (double)x1 + value * (double)(x2 - x1 + 1);
                double by = (double)y1 + value * (double)(y2 - y1 + 1);
                int n = (int)bx - x1;
                sample[n] = sample[n] + 0.1 * by;
                ++t2;
            }
            ++t;
        }
        return sample;
    }

    private double[] arch(int x, int y, int width, int height, double slope) {
        double cutLine = y;
        double cutX = this.cutWithZero(x + width, y + height, slope, cutLine);
        double cutY = cutLine;
        double cutM = Math.tan(Math.PI - Math.atan(slope) / 2.0);
        double cutC = cutY - cutM * cutX;
        double cutDelta = -0.6;
        cutY = cutM * (cutX += cutDelta) + cutC;
        double[] sample = new double[width];
        int t = 0;
        while (t < width) {
            int t2 = 0;
            while (t2 < 10) {
                double value = (double)(10 * t + t2) / 10.0 / (double)width;
                double bx = this.bezier(value, x, cutX, x + width);
                double by = this.bezier(value, y, cutY, y + height);
                int n = (int)bx - x;
                sample[n] = sample[n] + 0.1 * by;
                ++t2;
            }
            ++t;
        }
        return sample;
    }

    private double bezier(double t, double p0, double p1, double p2) {
        return (1.0 - t) * (1.0 - t) * p0 + 2.0 * t * (1.0 - t) * p1 + t * t * p2;
    }

    private double cutWithZero(double x, double y, double m, double line) {
        double c = y - m * x;
        return (line - c) / m;
    }

    private int lineH(int width) {
        int line = width / 3;
        int mod = width % 3;
        if (mod == 1) {
            return line + 1;
        }
        return line;
    }

    private int lineV(int height) {
        int line = height / 2;
        if ((height - line) % 2 == 1) {
            ++line;
        }
        return line;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int y = 0;
        while (y < this.height) {
            if (y > 0) {
                builder.append("\n");
            }
            if (y < 10) {
                builder.append(" ");
            }
            builder.append(y);
            builder.append(": ");
            int x = 0;
            while (x < this.width) {
                if (this.values[x] == y) {
                    builder.append("*");
                } else {
                    builder.append(" ");
                }
                ++x;
            }
            ++y;
        }
        return builder.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.height;
        result = 31 * result + this.width;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Arch other = (Arch)obj;
        if (this.height != other.height) {
            return false;
        }
        return this.width == other.width;
    }
}

