/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.bubble;

import bibliothek.gui.DockUI;
import bibliothek.gui.dock.themes.ColorScheme;
import bibliothek.gui.dock.themes.color.AbstractColorScheme;
import bibliothek.gui.dock.themes.color.DefaultColorScheme;
import bibliothek.gui.dock.util.UIProperties;
import bibliothek.gui.dock.util.UIScheme;
import bibliothek.gui.dock.util.UISchemeEvent;
import bibliothek.gui.dock.util.UISchemeListener;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.gui.dock.util.color.DockColor;
import bibliothek.util.Colors;
import bibliothek.util.Path;
import java.awt.Color;
import java.util.Collection;
import java.util.Set;

public class SimpleBubbleColorScheme
extends DefaultColorScheme {
    public static final SimpleBubbleColorScheme BLOPS = new SimpleBubbleColorScheme(Color.BLACK, Color.WHITE, new Color(100, 255, 100), new Color(255, 100, 100), Color.DARK_GRAY, 0.3, 0.6, 0.9);
    public static final SimpleBubbleColorScheme BRIGHT = new SimpleBubbleColorScheme(Color.LIGHT_GRAY, Color.WHITE, new Color(200, 200, 200), new Color(200, 200, 255), new Color(100, 100, 100), 0.3, 0.6, 0.9);
    public static final ColorScheme LOOK_AND_FEEL = new AbstractColorScheme(){
        private ColorScheme delegate;
        private UISchemeListener<Color, DockColor, ColorBridge> delegateListener = new UISchemeListener<Color, DockColor, ColorBridge>(){

            @Override
            public void changed(final UISchemeEvent<Color, DockColor, ColorBridge> event) {
                this.fire(new UISchemeEvent<Color, DockColor, ColorBridge>(){

                    @Override
                    public UIScheme<Color, DockColor, ColorBridge> getScheme() {
                        return this.self();
                    }

                    @Override
                    public Collection<Path> changedBridges(Set<Path> names) {
                        return event.changedBridges(names);
                    }

                    @Override
                    public Collection<String> changedResources(Set<String> names) {
                        return event.changedResources(names);
                    }
                });
            }
        };
        {
            this.updateUI();
        }

        private ColorScheme self() {
            return this;
        }

        @Override
        public void addListener(UISchemeListener<Color, DockColor, ColorBridge> listener) {
            boolean has = this.hasListeners();
            super.addListener(listener);
            if (!has) {
                this.delegate.addListener(this.delegateListener);
            }
        }

        @Override
        public void removeListener(UISchemeListener<Color, DockColor, ColorBridge> listener) {
            super.removeListener(listener);
            if (!this.hasListeners()) {
                this.delegate.removeListener(this.delegateListener);
            }
        }

        @Override
        public void install(UIProperties<Color, DockColor, ColorBridge> properties) {
            this.delegate.install(properties);
        }

        @Override
        public void uninstall(UIProperties<Color, DockColor, ColorBridge> properties) {
            this.delegate.uninstall(properties);
        }

        @Override
        public ColorBridge getBridge(Path name, UIProperties<Color, DockColor, ColorBridge> properties) {
            return this.delegate.getBridge(name, properties);
        }

        @Override
        public Color getResource(String name, UIProperties<Color, DockColor, ColorBridge> properties) {
            return this.delegate.getResource(name, properties);
        }

        @Override
        protected void updateUI() {
            ColorManager manager;
            int n;
            int n2;
            ColorManager[] colorManagerArray;
            if (this.delegate != null) {
                colorManagerArray = this.managers();
                n2 = colorManagerArray.length;
                n = 0;
                while (n < n2) {
                    manager = colorManagerArray[n];
                    this.delegate.uninstall(manager);
                    ++n;
                }
                if (this.hasListeners()) {
                    this.delegate.removeListener(this.delegateListener);
                }
            }
            this.delegate = new SimpleBubbleColorScheme(DockUI.getColor("dock.title.selection.background"), DockUI.getColor("dock.title.background"), Colors.diffMirror(DockUI.getColor("dock.title.background"), 0.25), Colors.diffMirror(DockUI.getColor("dock.title.selection.background"), 0.4), Colors.undiffMirror(DockUI.getColor("dock.title.background"), 0.75), DockUI.getColor("dock.title.selection.foreground"), DockUI.getColor("dock.title.foreground"), 0.3, 0.6, 0.9);
            colorManagerArray = this.managers();
            n2 = colorManagerArray.length;
            n = 0;
            while (n < n2) {
                manager = colorManagerArray[n];
                this.delegate.install(manager);
                ++n;
            }
            if (this.hasListeners()) {
                this.delegate.addListener(this.delegateListener);
            }
            this.fire(new UISchemeEvent<Color, DockColor, ColorBridge>(){

                @Override
                public UIScheme<Color, DockColor, ColorBridge> getScheme() {
                    return this.self();
                }

                @Override
                public Collection<Path> changedBridges(Set<Path> names) {
                    return null;
                }

                @Override
                public Collection<String> changedResources(Set<String> names) {
                    return null;
                }
            });
        }
    };

    public SimpleBubbleColorScheme(Color color) {
        this(Colors.fuller(color, 0.5), Colors.brighter(color, 0.9), color, Colors.brighter(color, 0.9), Colors.darker(color, 0.9), 0.3, 0.6, 0.9);
    }

    public SimpleBubbleColorScheme(Color active, Color inactive, Color enabled, Color selected, Color disabled, double factorWeak, double factor, double factorStrong) {
        this(active, inactive, enabled, selected, disabled, Colors.diffMirror(active, 1.0), Colors.diffMirror(inactive, 1.0), factorWeak, factor, factorStrong);
    }

    public SimpleBubbleColorScheme(Color active, Color inactive, Color enabled, Color selected, Color disabled, Color activeText, Color inactiveText, double factorWeak, double factor, double factorStrong) {
        this.setColor("stack.tab.background.top.mouse", Colors.brighter(inactive, factor));
        this.setColor("stack.tab.background.bottom.mouse", Colors.darker(inactive, factor));
        this.setColor("stack.tab.border.mouse", Colors.middle(Colors.diffMirror(inactive, factorWeak), Colors.diffMirror(active, factorWeak)));
        this.setColor("stack.tab.foreground.mouse", Colors.diffMirror(inactive, 1.0));
        this.setColor("stack.tab.background.top", Colors.brighter(inactive, factorWeak));
        this.setColor("stack.tab.background.bottom", Colors.darker(inactive, factorWeak));
        this.setColor("stack.tab.border", Colors.diffMirror(inactive, factorWeak));
        this.setColor("stack.tab.foreground", Colors.diffMirror(inactive, 1.0));
        this.setColor("stack.tab.background.top.selected.mouse", Colors.brighter(inactive, factor));
        this.setColor("stack.tab.background.bottom.selected.mouse", Colors.darker(inactive, factor));
        this.setColor("stack.tab.border.selected.mouse", Colors.diffMirror(inactive, factor));
        this.setColor("stack.tab.foreground.selected.mouse", Colors.diffMirror(inactive, 1.0));
        this.setColor("stack.tab.background.top.selected", Colors.brighter(inactive, factor));
        this.setColor("stack.tab.background.bottom.selected", Colors.darker(inactive, factor));
        this.setColor("stack.tab.border.selected", Colors.diffMirror(inactive, factorWeak));
        this.setColor("stack.tab.foreground.selected", Colors.diffMirror(inactive, 1.0));
        this.setColor("stack.tab.background.top.focused.mouse", Colors.brighter(active, factor));
        this.setColor("stack.tab.background.bottom.focused.mouse", Colors.darker(active, factor));
        this.setColor("stack.tab.border.focused.mouse", Colors.diffMirror(active, factor));
        this.setColor("stack.tab.foreground.focused.mouse", Colors.diffMirror(active, 1.0));
        this.setColor("stack.tab.background.top.focused", Colors.brighter(active, factorWeak));
        this.setColor("stack.tab.background.bottom.focused", Colors.darker(active, factorWeak));
        this.setColor("stack.tab.border.focused", Colors.diffMirror(active, factorWeak));
        this.setColor("stack.tab.foreground.focused", Colors.diffMirror(active, 1.0));
        this.setColor("title.background.top.active", Colors.brighter(active, factorWeak));
        this.setColor("title.background.top.active.mouse", Colors.brighter(active, factor));
        this.setColor("title.background.top.inactive", Colors.brighter(inactive, factorWeak));
        this.setColor("title.background.top.inactive.mouse", Colors.brighter(inactive, factor));
        this.setColor("title.background.bottom.active", Colors.darker(active, factorWeak));
        this.setColor("title.background.bottom.active.mouse", Colors.darker(active, factor));
        this.setColor("title.background.bottom.inactive", Colors.darker(inactive, factorWeak));
        this.setColor("title.background.bottom.inactive.mouse", Colors.darker(inactive, factor));
        this.setColor("title.foreground.active", activeText);
        this.setColor("title.foreground.active.mouse", activeText);
        this.setColor("title.foreground.inactive", inactiveText);
        this.setColor("title.foreground.inactive.mouse", inactiveText);
        this.setColor("title.background.top.active.flap", Colors.brighter(active, factorWeak));
        this.setColor("title.background.top.active.mouse.flap", Colors.brighter(active, factor));
        this.setColor("title.background.top.inactive.flap", Colors.brighter(inactive, factorWeak));
        this.setColor("title.background.top.inactive.mouse.flap", Colors.brighter(inactive, factor));
        this.setColor("title.background.top.selected.flap", Colors.brighter(inactive, factorWeak));
        this.setColor("title.background.top.selected.mouse.flap", Colors.brighter(inactive, factor));
        this.setColor("title.background.bottom.active.flap", Colors.darker(active, factorWeak));
        this.setColor("title.background.bottom.active.mouse.flap", Colors.darker(active, factor));
        this.setColor("title.background.bottom.inactive.flap", Colors.darker(inactive, factorWeak));
        this.setColor("title.background.bottom.inactive.mouse.flap", Colors.darker(inactive, factor));
        this.setColor("title.background.bottom.selected.flap", Colors.darker(inactive, factorWeak));
        this.setColor("title.background.bottom.selected.mouse.flap", Colors.darker(inactive, factor));
        this.setColor("title.foreground.active.flap", activeText);
        this.setColor("title.foreground.active.mouse.flap", activeText);
        this.setColor("title.foreground.inactive.flap", inactiveText);
        this.setColor("title.foreground.inactive.mouse.flap", inactiveText);
        this.setColor("title.foreground.selected.flap", inactiveText);
        this.setColor("title.foreground.selected.mouse.flap", inactiveText);
        this.setColor("displayer.border.high.active", Colors.brighter(active, factorWeak));
        this.setColor("displayer.border.high.active.mouse", Colors.brighter(active, factor));
        this.setColor("displayer.border.high.inactive", Colors.brighter(inactive, factorWeak));
        this.setColor("displayer.border.high.inactive.mouse", Colors.brighter(inactive, factor));
        this.setColor("displayer.border.low.active", Colors.darker(active, factorWeak));
        this.setColor("displayer.border.low.active.mouse", Colors.darker(active, factor));
        this.setColor("displayer.border.low.inactive", Colors.darker(inactive, factorWeak));
        this.setColor("displayer.border.low.inactive.mouse", Colors.darker(inactive, factor));
        this.setColor("action.button", disabled);
        this.setColor("action.button.focus", Colors.diffMirror(disabled, factorWeak));
        this.setColor("action.button.enabled", enabled);
        this.setColor("action.button.enabled.focus", Colors.diffMirror(enabled, factorWeak));
        this.setColor("action.button.selected", Colors.middle(disabled, Colors.middle(selected, disabled)));
        this.setColor("action.button.selected.focus", Colors.diffMirror(Colors.middle(disabled, Colors.middle(selected, disabled)), factorWeak));
        this.setColor("action.button.selected.enabled", selected);
        this.setColor("action.button.selected.enabled.focus", Colors.diffMirror(selected, factorWeak));
        this.setColor("action.button.mouse.enabled", Colors.undiffMirror(enabled, factor));
        this.setColor("action.button.mouse.enabled.focus", Colors.undiffMirror(Colors.diffMirror(enabled, factor), factorWeak));
        this.setColor("action.button.mouse.selected.enabled", Colors.undiffMirror(selected, factor));
        this.setColor("action.button.mouse.selected.enabled.focus", Colors.undiffMirror(Colors.diffMirror(selected, factor), factorWeak));
        this.setColor("action.button.pressed.enabled", Colors.undiffMirror(enabled, factorStrong));
        this.setColor("action.button.pressed.enabled.focus", Colors.undiffMirror(Colors.diffMirror(enabled, factorStrong), factorWeak));
        this.setColor("action.button.pressed.selected.enabled", Colors.undiffMirror(selected, factorStrong));
        this.setColor("action.button.pressed.selected.enabled.focus", Colors.undiffMirror(Colors.diffMirror(selected, factorStrong), factorWeak));
        this.setColor("action.dropdown", disabled);
        this.setColor("action.dropdown.enabled", enabled);
        this.setColor("action.dropdown.selected", Colors.middle(disabled, Colors.middle(selected, disabled)));
        this.setColor("action.dropdown.selected.enabled", selected);
        this.setColor("action.dropdown.mouse.enabled", Colors.undiffMirror(enabled, factor));
        this.setColor("action.dropdown.mouse.selected.enabled", Colors.undiffMirror(selected, factor));
        this.setColor("action.dropdown.pressed.enabled", Colors.undiffMirror(enabled, factorStrong));
        this.setColor("action.dropdown.pressed.selected.enabled", Colors.undiffMirror(selected, factorStrong));
        this.setColor("action.dropdown.focus", Colors.diffMirror(disabled, factorWeak));
        this.setColor("action.dropdown.enabled.focus", Colors.diffMirror(enabled, factorWeak));
        this.setColor("action.dropdown.selected.focus", Colors.diffMirror(Colors.middle(disabled, Colors.middle(selected, disabled)), factorWeak));
        this.setColor("action.dropdown.selected.enabled.focus", Colors.diffMirror(selected, factorWeak));
        this.setColor("action.dropdown.mouse.enabled.focus", Colors.undiffMirror(Colors.diffMirror(enabled, factor), factorWeak));
        this.setColor("action.dropdown.mouse.selected.enabled.focus", Colors.undiffMirror(Colors.diffMirror(selected, factor), factorWeak));
        this.setColor("action.dropdown.pressed.enabled.focus", Colors.undiffMirror(Colors.diffMirror(enabled, factorStrong), factorWeak));
        this.setColor("action.dropdown.pressed.selected.enabled.focus", Colors.undiffMirror(Colors.diffMirror(selected, factorStrong), factorWeak));
        this.setColor("action.dropdown.line", Colors.diffMirror(disabled, factorWeak));
        this.setColor("action.dropdown.line.enabled", Colors.diffMirror(enabled, factorWeak));
        this.setColor("action.dropdown.line.selected", Colors.diffMirror(Colors.middle(disabled, Colors.middle(selected, disabled)), factorWeak));
        this.setColor("action.dropdown.line.selected.enabled", Colors.diffMirror(selected, factorWeak));
        this.setColor("action.dropdown.line.mouse.enabled", Colors.undiffMirror(Colors.diffMirror(enabled, factor), factorWeak));
        this.setColor("action.dropdown.line.mouse.selected.enabled", Colors.undiffMirror(Colors.diffMirror(selected, factor), factorWeak));
        this.setColor("action.dropdown.line.pressed.enabled", Colors.undiffMirror(Colors.diffMirror(enabled, factorStrong), factorWeak));
        this.setColor("action.dropdown.line.pressed.selected.enabled", Colors.undiffMirror(Colors.diffMirror(selected, factorStrong), factorWeak));
        this.setColor("paint.divider", disabled);
        this.setColor("paint.insertion", selected);
        this.setColor("paint.line", selected);
    }
}

