/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference.preferences;

import bibliothek.extension.gui.dock.preference.DefaultPreference;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.util.Path;

public class DockPropertyPreference<V>
extends DefaultPreference<V> {
    private PropertyKey<V> key;
    private DockProperties properties;

    public DockPropertyPreference(DockProperties properties, PropertyKey<V> key, Path type, Path path) {
        super(type, path);
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties must not be null");
        }
        this.key = key;
        this.properties = properties;
    }

    public DockPropertyPreference(DockProperties properties, PropertyKey<V> key, String label, Path type, Path path) {
        super(label, type, path);
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties must not be null");
        }
        this.key = key;
        this.properties = properties;
    }

    public DockPropertyPreference(String prefix, DockProperties properties, PropertyKey<V> key, V defaultValue, Path type, Path path) {
        this(properties, key, type, path);
        this.setDefaultValue(defaultValue);
        this.setLabelId(String.valueOf(prefix) + ".label");
        this.setDescriptionId(String.valueOf(prefix) + ".description");
    }

    @Override
    public void read() {
        V value = this.properties.get(this.key, Priority.CLIENT);
        if (value == null) {
            this.setValue(this.getDefaultValue());
        } else {
            this.setValue(value);
        }
    }

    @Override
    public void write() {
        this.properties.setOrRemove(this.key, this.getValue(), Priority.CLIENT);
    }
}

