/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import jxl.CellView;
import jxl.Image;
import jxl.Sheet;
import jxl.biff.drawing.ClientAnchor;
import jxl.biff.drawing.ClientData;
import jxl.biff.drawing.DrawingData;
import jxl.biff.drawing.DrawingGroup;
import jxl.biff.drawing.DrawingGroupObject;
import jxl.biff.drawing.EscherContainer;
import jxl.biff.drawing.EscherRecord;
import jxl.biff.drawing.EscherRecordType;
import jxl.biff.drawing.MsoDrawingRecord;
import jxl.biff.drawing.ObjRecord;
import jxl.biff.drawing.Opt;
import jxl.biff.drawing.Origin;
import jxl.biff.drawing.PNGReader;
import jxl.biff.drawing.ShapeType;
import jxl.biff.drawing.Sp;
import jxl.biff.drawing.SpContainer;
import jxl.common.Assert;
import jxl.common.LengthConverter;
import jxl.common.LengthUnit;
import jxl.common.Logger;

public class Drawing
implements DrawingGroupObject,
Image {
    private static Logger logger = Logger.getLogger(Drawing.class);
    private EscherContainer readSpContainer;
    private MsoDrawingRecord msoDrawingRecord;
    private ObjRecord objRecord;
    private boolean initialized = false;
    private File imageFile;
    private byte[] imageData;
    private int objectId;
    private int blipId;
    private double x;
    private double y;
    private double width;
    private double height;
    private int referenceCount;
    private EscherContainer escherData;
    private Origin origin;
    private DrawingGroup drawingGroup;
    private DrawingData drawingData;
    private ShapeType type;
    private int shapeId;
    private int drawingNumber;
    private Sheet sheet;
    private PNGReader pngReader;
    private ImageAnchorProperties imageAnchorProperties;
    public static ImageAnchorProperties MOVE_AND_SIZE_WITH_CELLS = new ImageAnchorProperties(1);
    public static ImageAnchorProperties MOVE_WITH_CELLS = new ImageAnchorProperties(2);
    public static ImageAnchorProperties NO_MOVE_OR_SIZE_WITH_CELLS = new ImageAnchorProperties(3);
    private static final double DEFAULT_FONT_SIZE = 10.0;

    public Drawing(MsoDrawingRecord mso, ObjRecord obj, DrawingData dd, DrawingGroup dg, Sheet s) {
        this.drawingGroup = dg;
        this.msoDrawingRecord = mso;
        this.drawingData = dd;
        this.objRecord = obj;
        this.sheet = s;
        this.initialized = false;
        this.origin = Origin.READ;
        this.drawingData.addData(this.msoDrawingRecord.getData());
        this.drawingNumber = this.drawingData.getNumDrawings() - 1;
        this.drawingGroup.addDrawing(this);
        Assert.verify(mso != null && obj != null);
        this.initialize();
    }

    protected Drawing(DrawingGroupObject dgo, DrawingGroup dg) {
        Drawing d = (Drawing)dgo;
        Assert.verify(d.origin == Origin.READ);
        this.msoDrawingRecord = d.msoDrawingRecord;
        this.objRecord = d.objRecord;
        this.initialized = false;
        this.origin = Origin.READ;
        this.drawingData = d.drawingData;
        this.drawingGroup = dg;
        this.drawingNumber = d.drawingNumber;
        this.drawingGroup.addDrawing(this);
    }

    public Drawing(double x, double y, double w, double h, File image) {
        this.imageFile = image;
        this.initialized = true;
        this.origin = Origin.WRITE;
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        this.referenceCount = 1;
        this.imageAnchorProperties = MOVE_WITH_CELLS;
        this.type = ShapeType.PICTURE_FRAME;
    }

    public Drawing(double x, double y, double w, double h, byte[] image) {
        this.imageData = image;
        this.initialized = true;
        this.origin = Origin.WRITE;
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        this.referenceCount = 1;
        this.imageAnchorProperties = MOVE_WITH_CELLS;
        this.type = ShapeType.PICTURE_FRAME;
    }

    private void initialize() {
        Opt opt;
        this.readSpContainer = this.drawingData.getSpContainer(this.drawingNumber);
        Assert.verify(this.readSpContainer != null);
        EscherRecord[] children = this.readSpContainer.getChildren();
        Sp sp = (Sp)this.readSpContainer.getChildren()[0];
        this.shapeId = sp.getShapeId();
        this.objectId = this.objRecord.getObjectId();
        this.type = ShapeType.getType(sp.getShapeType());
        if (this.type == ShapeType.UNKNOWN) {
            logger.warn("Unknown shape type");
        }
        if ((opt = (Opt)this.readSpContainer.getChildren()[1]).getProperty(260) != null) {
            this.blipId = opt.getProperty((int)260).value;
        }
        if (opt.getProperty(261) != null) {
            this.imageFile = new File(opt.getProperty((int)261).stringValue);
        } else if (this.type == ShapeType.PICTURE_FRAME) {
            logger.warn("no filename property for drawing");
            this.imageFile = new File(Integer.toString(this.blipId));
        }
        ClientAnchor clientAnchor = null;
        int i = 0;
        while (i < children.length && clientAnchor == null) {
            if (children[i].getType() == EscherRecordType.CLIENT_ANCHOR) {
                clientAnchor = (ClientAnchor)children[i];
            }
            ++i;
        }
        if (clientAnchor == null) {
            logger.warn("client anchor not found");
        } else {
            this.x = clientAnchor.getX1();
            this.y = clientAnchor.getY1();
            this.width = clientAnchor.getX2() - this.x;
            this.height = clientAnchor.getY2() - this.y;
            this.imageAnchorProperties = ImageAnchorProperties.getImageAnchorProperties(clientAnchor.getProperties());
        }
        if (this.blipId == 0) {
            logger.warn("linked drawings are not supported");
        }
        this.initialized = true;
    }

    @Override
    public File getImageFile() {
        return this.imageFile;
    }

    @Override
    public String getImageFilePath() {
        if (this.imageFile == null) {
            return this.blipId != 0 ? Integer.toString(this.blipId) : "__new__image__";
        }
        return this.imageFile.getPath();
    }

    @Override
    public final void setObjectId(int objid, int bip, int sid) {
        this.objectId = objid;
        this.blipId = bip;
        this.shapeId = sid;
        if (this.origin == Origin.READ) {
            this.origin = Origin.READ_WRITE;
        }
    }

    @Override
    public final int getObjectId() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.objectId;
    }

    @Override
    public int getShapeId() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.shapeId;
    }

    @Override
    public final int getBlipId() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.blipId;
    }

    @Override
    public MsoDrawingRecord getMsoDrawingRecord() {
        return this.msoDrawingRecord;
    }

    @Override
    public EscherContainer getSpContainer() {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.origin == Origin.READ) {
            return this.getReadSpContainer();
        }
        SpContainer spContainer = new SpContainer();
        Sp sp = new Sp(this.type, this.shapeId, 2560);
        spContainer.add(sp);
        Opt opt = new Opt();
        opt.addProperty(260, true, false, this.blipId);
        if (this.type == ShapeType.PICTURE_FRAME) {
            String filePath = this.imageFile != null ? this.imageFile.getPath() : "";
            opt.addProperty(261, true, true, filePath.length() * 2, filePath);
            opt.addProperty(447, false, false, 65536);
            opt.addProperty(959, false, false, 524288);
            spContainer.add(opt);
        }
        ClientAnchor clientAnchor = new ClientAnchor(this.x, this.y, this.x + this.width, this.y + this.height, this.imageAnchorProperties.getValue());
        spContainer.add(clientAnchor);
        ClientData clientData = new ClientData();
        spContainer.add(clientData);
        return spContainer;
    }

    @Override
    public void setDrawingGroup(DrawingGroup dg) {
        this.drawingGroup = dg;
    }

    @Override
    public DrawingGroup getDrawingGroup() {
        return this.drawingGroup;
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    @Override
    public int getReferenceCount() {
        return this.referenceCount;
    }

    @Override
    public void setReferenceCount(int r) {
        this.referenceCount = r;
    }

    @Override
    public double getX() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.x;
    }

    @Override
    public void setX(double x) {
        if (this.origin == Origin.READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = Origin.READ_WRITE;
        }
        this.x = x;
    }

    @Override
    public double getY() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.y;
    }

    @Override
    public void setY(double y) {
        if (this.origin == Origin.READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = Origin.READ_WRITE;
        }
        this.y = y;
    }

    @Override
    public double getWidth() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.width;
    }

    @Override
    public void setWidth(double w) {
        if (this.origin == Origin.READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = Origin.READ_WRITE;
        }
        this.width = w;
    }

    @Override
    public double getHeight() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.height;
    }

    @Override
    public void setHeight(double h) {
        if (this.origin == Origin.READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = Origin.READ_WRITE;
        }
        this.height = h;
    }

    private EscherContainer getReadSpContainer() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.readSpContainer;
    }

    @Override
    public byte[] getImageData() {
        Assert.verify(this.origin == Origin.READ || this.origin == Origin.READ_WRITE);
        if (!this.initialized) {
            this.initialize();
        }
        return this.drawingGroup.getImageData(this.blipId);
    }

    @Override
    public byte[] getImageBytes() throws IOException {
        if (this.origin == Origin.READ || this.origin == Origin.READ_WRITE) {
            return this.getImageData();
        }
        Assert.verify(this.origin == Origin.WRITE);
        if (this.imageFile == null) {
            Assert.verify(this.imageData != null);
            return this.imageData;
        }
        byte[] data = new byte[(int)this.imageFile.length()];
        FileInputStream fis = new FileInputStream(this.imageFile);
        fis.read(data, 0, data.length);
        fis.close();
        return data;
    }

    @Override
    public ShapeType getType() {
        return this.type;
    }

    @Override
    public void writeAdditionalRecords(jxl.write.biff.File outputFile) throws IOException {
        if (this.origin == Origin.READ) {
            outputFile.write(this.objRecord);
            return;
        }
        ObjRecord objrec = new ObjRecord(this.objectId, ObjRecord.PICTURE);
        outputFile.write(objrec);
    }

    @Override
    public void writeTailRecords(jxl.write.biff.File outputFile) throws IOException {
    }

    @Override
    public double getColumn() {
        return this.getX();
    }

    @Override
    public double getRow() {
        return this.getY();
    }

    @Override
    public boolean isFirst() {
        return this.msoDrawingRecord.isFirst();
    }

    @Override
    public boolean isFormObject() {
        return false;
    }

    public void removeRow(int r) {
        if (this.y > (double)r) {
            this.setY(r);
        }
    }

    private double getWidthInPoints() {
        if (this.sheet == null) {
            logger.warn("calculating image width:  sheet is null");
            return 0.0;
        }
        int firstCol = (int)this.x;
        int lastCol = (int)Math.ceil(this.x + this.width) - 1;
        CellView cellView = this.sheet.getColumnView(firstCol);
        int firstColWidth = cellView.getSize();
        double firstColImageWidth = (1.0 - (this.x - (double)firstCol)) * (double)firstColWidth;
        double pointSize = cellView.getFormat() != null ? (double)cellView.getFormat().getFont().getPointSize() : 10.0;
        double firstColWidthInPoints = firstColImageWidth * 0.59 * pointSize / 256.0;
        int lastColWidth = 0;
        double lastColImageWidth = 0.0;
        double lastColWidthInPoints = 0.0;
        if (lastCol != firstCol) {
            cellView = this.sheet.getColumnView(lastCol);
            lastColWidth = cellView.getSize();
            lastColImageWidth = (this.x + this.width - (double)lastCol) * (double)lastColWidth;
            pointSize = cellView.getFormat() != null ? (double)cellView.getFormat().getFont().getPointSize() : 10.0;
            lastColWidthInPoints = lastColImageWidth * 0.59 * pointSize / 256.0;
        }
        double width = 0.0;
        int i = 0;
        while (i < lastCol - firstCol - 1) {
            cellView = this.sheet.getColumnView(firstCol + 1 + i);
            pointSize = cellView.getFormat() != null ? (double)cellView.getFormat().getFont().getPointSize() : 10.0;
            width += (double)cellView.getSize() * 0.59 * pointSize / 256.0;
            ++i;
        }
        double widthInPoints = width + firstColWidthInPoints + lastColWidthInPoints;
        return widthInPoints;
    }

    private double getHeightInPoints() {
        if (this.sheet == null) {
            logger.warn("calculating image height:  sheet is null");
            return 0.0;
        }
        int firstRow = (int)this.y;
        int lastRow = (int)Math.ceil(this.y + this.height) - 1;
        int firstRowHeight = this.sheet.getRowView(firstRow).getSize();
        int lastRowHeight = 0;
        if (lastRow != firstRow) {
            lastRowHeight = this.sheet.getRowView(lastRow).getSize();
            double cfr_ignored_0 = (this.y + this.height - (double)lastRow) * (double)lastRowHeight;
        }
        double height = 0.0;
        int i = 0;
        while (i < lastRow - firstRow - 1) {
            height += (double)this.sheet.getRowView(firstRow + 1 + i).getSize();
            ++i;
        }
        double heightInTwips = height + (double)firstRowHeight + (double)lastRowHeight;
        double heightInPoints = heightInTwips / 20.0;
        return heightInPoints;
    }

    @Override
    public double getWidth(LengthUnit unit) {
        double widthInPoints = this.getWidthInPoints();
        return widthInPoints * LengthConverter.getConversionFactor(LengthUnit.POINTS, unit);
    }

    @Override
    public double getHeight(LengthUnit unit) {
        double heightInPoints = this.getHeightInPoints();
        return heightInPoints * LengthConverter.getConversionFactor(LengthUnit.POINTS, unit);
    }

    @Override
    public int getImageWidth() {
        return this.getPngReader().getWidth();
    }

    @Override
    public int getImageHeight() {
        return this.getPngReader().getHeight();
    }

    @Override
    public double getHorizontalResolution(LengthUnit unit) {
        int res = this.getPngReader().getHorizontalResolution();
        return (double)res / LengthConverter.getConversionFactor(LengthUnit.METRES, unit);
    }

    @Override
    public double getVerticalResolution(LengthUnit unit) {
        int res = this.getPngReader().getVerticalResolution();
        return (double)res / LengthConverter.getConversionFactor(LengthUnit.METRES, unit);
    }

    private PNGReader getPngReader() {
        if (this.pngReader != null) {
            return this.pngReader;
        }
        byte[] imdata = null;
        if (this.origin == Origin.READ || this.origin == Origin.READ_WRITE) {
            imdata = this.getImageData();
        } else {
            try {
                imdata = this.getImageBytes();
            }
            catch (IOException iOException) {
                logger.warn("Could not read image file");
                imdata = new byte[]{};
            }
        }
        this.pngReader = new PNGReader(imdata);
        this.pngReader.read();
        return this.pngReader;
    }

    protected void setImageAnchor(ImageAnchorProperties iap) {
        this.imageAnchorProperties = iap;
        if (this.origin == Origin.READ) {
            this.origin = Origin.READ_WRITE;
        }
    }

    protected ImageAnchorProperties getImageAnchor() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.imageAnchorProperties;
    }

    protected static class ImageAnchorProperties {
        private int value;
        private static ImageAnchorProperties[] o = new ImageAnchorProperties[0];

        ImageAnchorProperties(int v) {
            this.value = v;
            ImageAnchorProperties[] oldArray = o;
            o = new ImageAnchorProperties[oldArray.length + 1];
            System.arraycopy(oldArray, 0, o, 0, oldArray.length);
            ImageAnchorProperties.o[oldArray.length] = this;
        }

        int getValue() {
            return this.value;
        }

        static ImageAnchorProperties getImageAnchorProperties(int val) {
            ImageAnchorProperties iap = MOVE_AND_SIZE_WITH_CELLS;
            int pos = 0;
            while (pos < o.length) {
                if (o[pos].getValue() == val) {
                    iap = o[pos];
                    break;
                }
                ++pos;
            }
            return iap;
        }
    }
}

