/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.msg.widget.panel.pnlKorisnik;

import com.jgoodies.forms.factories.DefaultComponentFactory;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import rs.pezar.msg.action.ActionSetup;
import rs.pezar.msg.device.DeviceConfiguratorWindow;
import rs.pezar.msg.widget.panel.PnlKorisnik;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;

public class PnlIcons
extends PzPanel {
    private JLabel icnVnc;
    private JLabel icnActions;
    private JLabel icnDevices;
    private Vector<String> devices;
    private Vector<String> actions;
    private PnlKorisnik pnlKorisnik;
    private String remoteId = "";

    public PnlIcons(PnlKorisnik pnlKorisnik) {
        this.pnlKorisnik = pnlKorisnik;
        this.setBorder(new EmptyBorder(0, 0, 0, 8));
        this.setFocusable(false);
        this.setRequestFocusEnabled(false);
        this.setOpaque(false);
        this.setLayout(new FlowLayout(2, 5, 5));
        this.icnActions = new JLabel("");
        this.icnActions.addMouseListener(this.getActionMouseAdapter());
        this.icnVnc = DefaultComponentFactory.getInstance().createLabel("");
        this.icnVnc.setIcon(new ImageIcon(PnlIcons.class.getResource("/rs/pezar/msg/widget/resource/Vnc_logo_16.png")));
        this.add(this.icnVnc);
        this.icnActions.setIcon(new ImageIcon(PnlIcons.class.getResource("/rs/pezar/msg/widget/resource/console_network.png")));
        this.add(this.icnActions);
        this.icnDevices = new JLabel("");
        this.icnDevices.addMouseListener(this.getDeviceMouseAdapter());
        this.icnDevices.setIcon(new ImageIcon(PnlIcons.class.getResource("/rs/pezar/msg/widget/resource/PCI-card_network.png")));
        this.add(this.icnDevices);
    }

    public void updateDevices(Vector<String> devices) {
        if (devices == null || devices.size() == 0) {
            this.devices = null;
            SwingUtilities.invokeLater(this.getDeviceRunnable());
        } else {
            this.devices = devices;
            SwingUtilities.invokeLater(this.getDeviceRunnable());
            this.refreshDeviceTooltip();
        }
    }

    public void updateActions(Vector<String> actions) {
        if (actions == null || actions.size() == 0) {
            this.actions = null;
            SwingUtilities.invokeLater(this.getActionRunnable());
            return;
        }
        this.actions = actions;
        SwingUtilities.invokeLater(this.getActionRunnable());
        this.refreshDeviceTooltip();
        this.refreshActionTooltip();
    }

    public void updateRemoteId(String id) {
        this.remoteId = id;
        SwingUtilities.invokeLater(this.getRemoteIdRunnable());
        this.refreshRemoteIdTooltip();
    }

    private void refreshRemoteIdTooltip() {
        this.icnVnc.setToolTipText(this.remoteId);
    }

    private Runnable getActionRunnable() {
        Runnable updateActions = new Runnable(){

            @Override
            public void run() {
                if (PnlIcons.this.actions == null) {
                    PnlIcons.this.icnActions.setVisible(false);
                } else {
                    if (!PnlIcons.this.icnActions.isVisible()) {
                        PnlIcons.this.icnActions.setVisible(true);
                    }
                    PnlIcons.this.validate();
                }
            }
        };
        return updateActions;
    }

    private Runnable getRemoteIdRunnable() {
        Runnable updateActions = new Runnable(){

            @Override
            public void run() {
                if (PnlIcons.this.remoteId != null && PnlIcons.this.remoteId.equals("")) {
                    PnlIcons.this.icnVnc.setVisible(false);
                } else if (!PnlIcons.this.icnVnc.isVisible()) {
                    PnlIcons.this.icnVnc.setVisible(true);
                }
            }
        };
        return updateActions;
    }

    private Runnable getDeviceRunnable() {
        Runnable updateDevices = new Runnable(){

            @Override
            public void run() {
                if (PnlIcons.this.devices == null) {
                    PnlIcons.this.icnDevices.setVisible(false);
                } else {
                    PnlIcons.this.icnDevices.setVisible(true);
                }
            }
        };
        return updateDevices;
    }

    private MouseAdapter getActionMouseAdapter() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (arg0.getButton() == 1) {
                    PzDialog setup = ActionSetup.getActionDialog();
                    setup.setVisible(true);
                    setup.setAlwaysOnTop(true);
                    ActionSetup.getActionPanel().addUserRecipient(PnlIcons.this.pnlKorisnik.getUserQueue().replace("queue.", ""));
                } else if (arg0.getButton() == 3) {
                    ActionSetup.getActionPanel().addUserRecipient(PnlIcons.this.pnlKorisnik.getUserQueue().replace("queue.", ""));
                }
            }
        };
        return mouseAdapter;
    }

    private MouseAdapter getDeviceMouseAdapter() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (arg0.getButton() == 1) {
                    PzDialog setup = DeviceConfiguratorWindow.getDeviceConfiguratorDialog();
                    setup.setVisible(true);
                }
            }
        };
        return mouseAdapter;
    }

    public void refreshActionTooltip() {
        String temp = "";
        if (this.actions != null) {
            int i = 0;
            while (i < this.actions.size()) {
                temp = String.valueOf(temp) + this.actions.get(i) + " , ";
                ++i;
            }
        }
        if (temp.length() >= 3) {
            temp = temp.substring(0, temp.length() - 3);
        }
        temp = "DOSTUPNE AKCIJE: (" + temp + ")";
        this.icnActions.setToolTipText(temp);
    }

    public void setEnabled(boolean enabled) {
        this.icnActions.setEnabled(enabled);
        this.icnDevices.setEnabled(enabled);
        this.icnVnc.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void refreshDeviceTooltip() {
        String temp = "";
        if (this.devices != null) {
            int i = 0;
            while (i < this.devices.size()) {
                String[] temp1 = this.devices.get(i).split(":");
                temp = String.valueOf(temp) + temp1[3] + "(" + "ID: " + temp1[1] + ")" + " , ";
                ++i;
            }
        }
        if (temp.length() >= 3) {
            temp = temp.substring(0, temp.length() - 3);
        }
        temp = "DOSTUPNI UREDJAJI: (" + temp + ")";
        this.icnDevices.setToolTipText(temp);
    }
}

