/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.msg.tools.system;

import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.win32.StdCallLibrary;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Win32IdleTime {
    public static int getIdleTimeMillisWin32() {
        User32.LASTINPUTINFO lastInputInfo = new User32.LASTINPUTINFO();
        User32.INSTANCE.GetLastInputInfo(lastInputInfo);
        return Kernel32.INSTANCE.GetTickCount() - lastInputInfo.dwTime;
    }

    public static void main(String[] args) {
        if (!System.getProperty("os.name").contains("Windows")) {
            System.err.println("ERROR: Only implemented on Windows");
            System.exit(1);
        }
        State state = State.UNKNOWN;
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
        while (true) {
            State newState;
            int idleSec;
            State state2 = (idleSec = Win32IdleTime.getIdleTimeMillisWin32() / 1000) < 30 ? State.ONLINE : (newState = idleSec > 300 ? State.AWAY : State.IDLE);
            if (newState != state) {
                state = newState;
                System.out.println(String.valueOf(dateFormat.format(new Date())) + " # " + (Object)((Object)state));
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    public static interface Kernel32
    extends StdCallLibrary {
        public static final Kernel32 INSTANCE = (Kernel32)Native.loadLibrary((String)"kernel32", Kernel32.class);

        public int GetTickCount();
    }

    static enum State {
        UNKNOWN,
        ONLINE,
        IDLE,
        AWAY;

    }

    public static interface User32
    extends StdCallLibrary {
        public static final User32 INSTANCE = (User32)Native.loadLibrary((String)"user32", User32.class);

        public boolean GetLastInputInfo(LASTINPUTINFO var1);

        public static class LASTINPUTINFO
        extends Structure {
            public int cbSize = 8;
            public int dwTime;
        }
    }
}

