/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.msg.msg.control;

import java.awt.event.ActionEvent;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import rs.pezar.msg.msg.control.ControlMessageDecoder;
import rs.pezar.msg.msg.control.OnlineUserData;
import rs.pezar.msg.msg.interfaces.RefreshListenerInterface;

public class MsgControl {
    public static final Integer REFRESH_SECONDS = 15000;
    Vector<OnlineUserData> users;
    Timer timer;
    TimerTask t;
    Object mutex;
    public Vector<RefreshListenerInterface> listener = new Vector();

    public MsgControl() {
        this.users = new Vector();
        this.timer = new Timer();
        this.mutex = new Object();
        this.t = new TimerTask(){

            @Override
            public void run() {
                MsgControl.this.refreshUsers();
            }
        };
        this.timer.schedule(this.t, 0L, (long)REFRESH_SECONDS.intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void put(String topicName, String user, String queue) {
        Object object = this.mutex;
        synchronized (object) {
            OnlineUserData userData = ControlMessageDecoder.decodeData(queue);
            userData.setTopic(topicName);
            userData.setName(user);
            int i = 0;
            while (i < this.users.size()) {
                if (this.users.get(i).getName().equals(userData.getName())) {
                    this.users.remove(i);
                }
                ++i;
            }
            this.users.add(userData);
            if (this.listener != null || this.listener.size() != 0) {
                i = 0;
                while (i < this.listener.size()) {
                    if (this.listener.get(i).getTopicName() != null && this.listener.get(i).getTopicName().equals(topicName)) {
                        this.listener.get(i).actionPerformed(new ActionEvent(this, 1, "refresh"));
                    }
                    ++i;
                }
            }
        }
    }

    public void resetControl() {
        this.users.clear();
    }

    public Vector<String> getUsersByDestination(String topicName) throws InterruptedException {
        Vector<String> temp = new Vector<String>();
        int i = 0;
        while (i < this.users.size()) {
            if (this.users.get(i).getTopic().equals(topicName)) {
                temp.add(this.users.get(i).getName());
            }
            ++i;
        }
        return temp;
    }

    public String getUserQueue(String user) throws InterruptedException {
        int i = 0;
        while (i < this.users.size()) {
            OnlineUserData tempUser = this.users.get(i);
            if (tempUser.getName().equals(user)) {
                return tempUser.getQueue();
            }
            ++i;
        }
        return null;
    }

    public String getDeviceQueue(String type, String id) {
        int j = 0;
        while (j < this.users.size()) {
            Vector<String> devices = this.users.get(j).getDevices();
            int i = 0;
            while (i < devices.size()) {
                String[] infoOnDevice = devices.get(i).split(":");
                if (infoOnDevice[1].equals(id) && infoOnDevice[2].equals(type)) {
                    return infoOnDevice[0];
                }
                ++i;
            }
            ++j;
        }
        return null;
    }

    public Vector<String> getAllDevices() {
        Vector<String> tempDevices = new Vector<String>();
        if (this.users != null) {
            int i = 0;
            while (i < this.users.size()) {
                if (this.users.get(i).getDevices() != null) {
                    tempDevices.addAll(this.users.get(i).getDevices());
                }
                ++i;
            }
        }
        return tempDevices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void refreshUsers() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.users == null || this.users.size() == 0) {
                return;
            }
            int i = 0;
            while (i < this.users.size()) {
                Long timeStamp = System.currentTimeMillis();
                Long userTimeStamp = this.users.get(i).getTimeStamp();
                if (timeStamp - (long)(REFRESH_SECONDS * 2) > userTimeStamp) {
                    this.users.get(i).setState("O");
                }
                ++i;
            }
        }
    }

    public void printInfoAll() {
    }

    public void addRefreshUsersListener(RefreshListenerInterface refreshListener) {
        this.listener.add(refreshListener);
    }

    public Vector<String> getOnlineUserNames() {
        Vector<String> onlineUserNsmes = new Vector<String>();
        int i = 0;
        while (i < this.users.size()) {
            onlineUserNsmes.add(this.users.get(i).getName());
            ++i;
        }
        return onlineUserNsmes;
    }

    public Vector<OnlineUserData> getOnlineUsers() {
        return this.users;
    }

    public static void main(String[] args) {
        System.out.println(System.currentTimeMillis());
    }
}

