/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.msg.device;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Semaphore;
import javax.jms.JMSException;
import rs.pezar.msg.PzExtensionLoader;
import rs.pezar.msg.device.NetDataWrapper;
import rs.pezar.msg.device.interfaces.DeviceDataInterface;
import rs.pezar.msg.device.interfaces.DeviceDriverInterface;
import rs.pezar.msg.msg.MsgProtocol;

public class LockWrapper
extends Thread {
    private DeviceDriverInterface drvr;
    private Queue queue;
    private HashMap<String, String> returnData = null;
    private Semaphore localTransactionOver;
    private Semaphore canStartWorking;
    private Semaphore canAddJob;

    public LockWrapper(DeviceDriverInterface driver, MsgProtocol msgProtocol) {
        this.drvr = driver;
        this.queue = new LinkedList();
        this.localTransactionOver = new Semaphore(0);
        this.canStartWorking = new Semaphore(0);
        this.canAddJob = new Semaphore(1);
    }

    public void addJob(NetDataWrapper d) {
        try {
            this.canAddJob.acquire();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.queue.add(d);
        this.canStartWorking.release();
    }

    public synchronized DeviceDriverInterface getDrvr() {
        return this.drvr;
    }

    public synchronized NetDataWrapper getNextJob() {
        NetDataWrapper d = (NetDataWrapper)this.queue.poll();
        return d;
    }

    @Override
    public void run() {
        int provera = 0;
        super.run();
        while (true) {
            try {
                this.canStartWorking.acquire();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            System.out.println(++provera);
            NetDataWrapper n = this.getNextJob();
            this.returnData = null;
            this.returnData = this.drvr.runDeviceWithData((DeviceDataInterface)n.getData());
            if (!n.isLocalDevice()) {
                try {
                    PzExtensionLoader.getInstance().getMsgProtocol().sendReply(n.getReplyTo(), this.returnData);
                }
                catch (JMSException e) {
                    System.out.println("Ne moze se poslati povratna poruka");
                    e.printStackTrace();
                }
            } else {
                this.localTransactionOver.release();
            }
            --provera;
            this.canAddJob.release();
        }
    }

    public HashMap<String, String> getReturnData() {
        return this.returnData;
    }

    public Semaphore getLocalTransactionOver() {
        return this.localTransactionOver;
    }
}

