/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.msg.device;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import javax.jms.JMSException;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.configuration.ConfigurationException;
import rs.pezar.core.PzApplication;
import rs.pezar.msg.PzExtensionLoader;
import rs.pezar.msg.device.DeviceDriverCollector;
import rs.pezar.msg.device.DeviceManager;
import rs.pezar.msg.device.cashregister.CashRegisterHandler;
import rs.pezar.msg.device.cashregister.data.CashRegisterControl;
import rs.pezar.msg.device.interfaces.DeviceDriverInterface;
import rs.pezar.msg.msg.MsgProtocol;
import rs.pezar.msg.msg.interfaces.RefreshListenerInterface;
import rs.pezar.msg.tools.xml.NetDeviceSettings;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogChoice;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzToolBarIcon;

public class DeviceConfiguratorWindow
extends PzPanel
implements RefreshListenerInterface,
ActionListener {
    private static final String ICON_SUCCESS = "rs/pezar/msg/menu/resource/img/check_small.png";
    private static final String ICON_FAIL = "rs/pezar/msg/menu/resource/img/warning_small.png";
    private JLabel lblConnected;
    private PzPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private PzButton btnSkloni;
    private PzButton bthUpotreba;
    private JTable tableUUpotrebi;
    private PzPanel jPanel3;
    private PzPanel jPanel2;
    private PzButton btnOsvezi;
    private JTable table;
    private Vector<NetDeviceSettings> netDevices;
    private Vector<NetDeviceSettings> localDevices;
    private static final Object mutex = new Object();
    private static final int COL_QUEUE = 0;
    private static final int COL_ID = 1;
    private static final int COL_TYPE = 2;
    private PzButton btnDodajLokalni;
    private static final int COL_NAME = 3;
    private boolean changeMade = false;
    private DeviceManager deviceManager;
    Vector<NetDeviceSettings> changedRowNumbersInSavedData;
    Vector<NetDeviceSettings> changedDevices;
    private JToolBar toolBar;
    private PzToolBarIcon pztlbrcnDodajlokUredjaj;
    private PzToolBarIcon pztlbrcnOsveiListuUredjaja;
    private PzToolBarIcon pztlbrcnStaviUupotrebu;
    private PzToolBarIcon pztlbrcnSkloniIzupotrebe;
    private PzToolBarIcon pztlbrcnSauvajpodeavanja;
    private PzToolBarIcon pztlbrcnTestirajKaseuUpotrebi;
    private JCheckBox chckbxDozvoliUpotrebuUredjaja;
    private boolean dozvoljenaUpotreba = false;
    private static DeviceConfiguratorWindow deviceConf;

    public DeviceConfiguratorWindow() {
        MsgProtocol msgProtocol = PzExtensionLoader.getInstance().getMsgProtocol();
        if (msgProtocol != null) {
            PzExtensionLoader.getInstance().getMsgProtocol().getControl().addRefreshUsersListener(this);
        }
        this.changedRowNumbersInSavedData = new Vector();
        this.changedDevices = new Vector();
        this.deviceManager = new DeviceManager(msgProtocol);
        if (msgProtocol != null) {
            msgProtocol.getControl().addRefreshUsersListener(this);
        }
        this.localDevices = new Vector();
        this.initGUI();
        this.loadSavedSettings();
    }

    private void initGUI() {
        try {
            this.setPreferredSize(new Dimension(691, 630));
            DefaultTableModel tableModel = new DefaultTableModel(null, new String[]{"Lokacija", "ID", "Tip", "Opis uredjaja"});
            DefaultTableModel tableUUpotrebiModel = new DefaultTableModel(null, new String[]{"Tip", "ID", "Lokacija", "Opis uredjaja"});
            this.setLayout(null);
            this.jPanel1 = new PzPanel();
            this.jPanel1.setBounds(10, 0, 681, 507);
            this.add((Component)this.jPanel1);
            this.jPanel1.setPreferredSize(new Dimension(684, 402));
            GridBagLayout gbl_jPanel1 = new GridBagLayout();
            int[] nArray = new int[3];
            nArray[0] = 552;
            nArray[1] = 118;
            gbl_jPanel1.columnWidths = nArray;
            int[] nArray2 = new int[3];
            nArray2[0] = 262;
            nArray2[1] = 242;
            gbl_jPanel1.rowHeights = nArray2;
            gbl_jPanel1.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            gbl_jPanel1.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            this.jPanel1.setLayout((LayoutManager)gbl_jPanel1);
            this.jPanel2 = new PzPanel();
            BorderLayout jPanel2Layout = new BorderLayout();
            GridBagConstraints gbc_jPanel2 = new GridBagConstraints();
            gbc_jPanel2.fill = 1;
            gbc_jPanel2.insets = new Insets(0, 0, 5, 5);
            gbc_jPanel2.gridx = 0;
            gbc_jPanel2.gridy = 0;
            this.jPanel1.add((Component)this.jPanel2, (Object)gbc_jPanel2);
            this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
            this.jPanel2.setBorder((Border)BorderFactory.createTitledBorder("Svi uredjaji"));
            this.jScrollPane1 = new JScrollPane();
            this.jPanel2.add((Component)this.jScrollPane1, (Object)"Center");
            this.jScrollPane1.setBounds(22, 17, 451, 163);
            this.jScrollPane1.setPreferredSize(new Dimension(451, 157));
            this.jScrollPane1.setToolTipText("U ovoj tabeli se nalaze svi prepoznati uredjaji sa mre\u017ee kao i lokalni uredjaji koji su dodati");
            this.jScrollPane1.setEnabled(false);
            this.table = new JTable(tableModel);
            this.jScrollPane1.setViewportView(this.table);
            this.table.setBounds(22, 159, 609, 216);
            this.toolBar = new JToolBar();
            this.toolBar.setOrientation(1);
            GridBagConstraints gbc_toolBar = new GridBagConstraints();
            gbc_toolBar.fill = 1;
            gbc_toolBar.gridheight = 2;
            gbc_toolBar.insets = new Insets(0, 0, 5, 0);
            gbc_toolBar.gridx = 1;
            gbc_toolBar.gridy = 0;
            this.jPanel1.add((Component)this.toolBar, (Object)gbc_toolBar);
            this.pztlbrcnDodajlokUredjaj = new PzToolBarIcon();
            this.pztlbrcnDodajlokUredjaj.setIcon((Icon)new ImageIcon(DeviceConfiguratorWindow.class.getResource("/rs/pezar/msg/menu/resource/img/cubes_add.png")));
            this.pztlbrcnDodajlokUredjaj.addActionListener((ActionListener)this);
            this.pztlbrcnDodajlokUredjaj.setText("Dodaj|lok. uredjaj");
            this.toolBar.add((Component)this.pztlbrcnDodajlokUredjaj);
            this.pztlbrcnOsveiListuUredjaja = new PzToolBarIcon();
            this.pztlbrcnOsveiListuUredjaja.setIcon((Icon)new ImageIcon(DeviceConfiguratorWindow.class.getResource("/rs/pezar/msg/menu/resource/img/table_refresh.png")));
            this.pztlbrcnOsveiListuUredjaja.addActionListener((ActionListener)this);
            this.pztlbrcnOsveiListuUredjaja.setText("Osve\u017ei|listu uredjaja");
            this.toolBar.add((Component)this.pztlbrcnOsveiListuUredjaja);
            this.pztlbrcnStaviUupotrebu = new PzToolBarIcon();
            this.pztlbrcnStaviUupotrebu.setIcon((Icon)new ImageIcon(DeviceConfiguratorWindow.class.getResource("/rs/pezar/msg/menu/resource/img/down_plus.png")));
            this.pztlbrcnStaviUupotrebu.addActionListener((ActionListener)this);
            this.pztlbrcnStaviUupotrebu.setText("Stavi u|upotrebu");
            this.toolBar.add((Component)this.pztlbrcnStaviUupotrebu);
            this.pztlbrcnSkloniIzupotrebe = new PzToolBarIcon();
            this.pztlbrcnSkloniIzupotrebe.setIcon((Icon)new ImageIcon(DeviceConfiguratorWindow.class.getResource("/rs/pezar/msg/menu/resource/img/up_minus.png")));
            this.pztlbrcnSkloniIzupotrebe.addActionListener((ActionListener)this);
            this.pztlbrcnSkloniIzupotrebe.setText("Skloni iz|upotrebe");
            this.toolBar.add((Component)this.pztlbrcnSkloniIzupotrebe);
            this.pztlbrcnSauvajpodeavanja = new PzToolBarIcon();
            this.pztlbrcnSauvajpodeavanja.setIcon((Icon)new ImageIcon(DeviceConfiguratorWindow.class.getResource("/rs/pezar/msg/menu/resource/img/disks.png")));
            this.pztlbrcnSauvajpodeavanja.addActionListener((ActionListener)this);
            this.pztlbrcnSauvajpodeavanja.setText("Sa\u010duvaj |pode\u0161avanja");
            this.toolBar.add((Component)this.pztlbrcnSauvajpodeavanja);
            this.pztlbrcnTestirajKaseuUpotrebi = new PzToolBarIcon();
            this.pztlbrcnTestirajKaseuUpotrebi.setIcon((Icon)new ImageIcon(DeviceConfiguratorWindow.class.getResource("/rs/pezar/msg/menu/resource/img/text.png")));
            this.pztlbrcnTestirajKaseuUpotrebi.addActionListener((ActionListener)this);
            this.pztlbrcnTestirajKaseuUpotrebi.setText("Testiraj uredjaje|u upotrebi");
            this.toolBar.add((Component)this.pztlbrcnTestirajKaseuUpotrebi);
            this.jPanel3 = new PzPanel();
            BorderLayout jPanel3Layout = new BorderLayout();
            this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
            GridBagConstraints gbc_jPanel3 = new GridBagConstraints();
            gbc_jPanel3.fill = 1;
            gbc_jPanel3.insets = new Insets(0, 0, 0, 5);
            gbc_jPanel3.gridx = 0;
            gbc_jPanel3.gridy = 1;
            this.jPanel1.add((Component)this.jPanel3, (Object)gbc_jPanel3);
            this.jPanel3.setBorder((Border)BorderFactory.createTitledBorder("Uredjaji u upotrebi"));
            this.jPanel3.setToolTipText("U ovoj tabeli se nalaze uredjaji koje ovaj ra\u010dunar koristi");
            this.jScrollPane2 = new JScrollPane();
            this.jPanel3.add((Component)this.jScrollPane2, (Object)"Center");
            this.jScrollPane2.setPreferredSize(new Dimension(460, 157));
            this.tableUUpotrebi = new JTable();
            this.jScrollPane2.setViewportView(this.tableUUpotrebi);
            this.tableUUpotrebi.setModel(tableUUpotrebiModel);
            this.lblConnected = new JLabel();
            this.lblConnected.setBounds(10, 597, 546, 22);
            this.lblConnected.setHorizontalAlignment(2);
            this.add(this.lblConnected);
            PzPanel pzButtonPanel = new PzPanel();
            pzButtonPanel.setBorder((Border)new TitledBorder(null, "Radni mod uredjaja", 4, 2, null, null));
            pzButtonPanel.setBounds(10, 518, 546, 76);
            this.add((Component)pzButtonPanel);
            pzButtonPanel.setLayout(null);
            this.chckbxDozvoliUpotrebuUredjaja = new JCheckBox("Dozvoli upotrebu lokalnih uredjaja sa drugih radnih stanica");
            this.chckbxDozvoliUpotrebuUredjaja.setBounds(18, 30, 501, 23);
            pzButtonPanel.add((Component)this.chckbxDozvoliUpotrebuUredjaja);
            this.chckbxDozvoliUpotrebuUredjaja.addActionListener(this);
            this.chckbxDozvoliUpotrebuUredjaja.setSelected(DeviceManager.getShared());
            if (MsgProtocol.getInstance() == null) {
                this.lblConnected.setText("Konekcija sa serverom za razmenu podataka nije uspostavljena.");
                this.lblConnected.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(ICON_FAIL)));
            } else {
                this.lblConnected.setText("Konektovano na server za razmenu podataka.");
                this.lblConnected.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(ICON_SUCCESS)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void lastChangeNotSaved() throws ConfigurationException {
        int i = JOptionPane.showConfirmDialog((Component)((Object)this), "Zadnja izmena nije snimljena. Snimiti?", "Izmena nije snimljena", 0);
        if (i == 0) {
            DeviceManager.putSettingsToFile();
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource().equals(this.pztlbrcnOsveiListuUredjaja)) {
            this.onOsveziPressed();
        } else if (arg0.getActionCommand().equals("refresh")) {
            this.onMessage();
        } else if (arg0.getSource().equals(this.pztlbrcnStaviUupotrebu)) {
            this.onUpotrebaPressed();
        } else if (arg0.getSource().equals(this.pztlbrcnSkloniIzupotrebe)) {
            this.onSkloniPressed();
        } else if (arg0.getSource().equals(this.pztlbrcnSauvajpodeavanja)) {
            this.onSnimiPressed();
        } else if (arg0.getSource().equals(this.pztlbrcnDodajlokUredjaj)) {
            this.onDodajLokalniPressed();
        } else if (arg0.getSource().equals(this.pztlbrcnTestirajKaseuUpotrebi)) {
            this.onTest();
        } else if (arg0.getSource().equals(this.chckbxDozvoliUpotrebuUredjaja)) {
            this.onUpotrebaUredjajaDozvoljena();
        }
    }

    private void onUpotrebaUredjajaDozvoljena() {
        this.dozvoljenaUpotreba = this.chckbxDozvoliUpotrebuUredjaja.isSelected();
        PzExtensionLoader.getInstance().getDeviceManager().setSharedDevices(this.dozvoljenaUpotreba);
    }

    private void onTest() {
        boolean success = true;
        CashRegisterControl cntrl = new CashRegisterControl();
        cntrl.setControlCode("CODE_TEST");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("USER", PzApplication.getApplication().getSession().getLoggedUser().getPzusername());
        cntrl.setParameters(parameters);
        try {
            CashRegisterHandler.sendToDefaultCashRegister(cntrl);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog((Component)((Object)this), e.getMessage());
            success = false;
        }
        if (success) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Ok, uredjaj u upotrebi radi.");
        }
    }

    private void onDodajLokalniPressed() {
        if (DeviceDriverCollector.getDeviceDrivers() == null || DeviceDriverCollector.getDeviceDrivers().size() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Ne postoji ni jedan plugin rukovaoc uredjajima instaliran.", "Gre\u0161ka", 0);
            return;
        }
        new Vector();
        PzChoice[] nizChoiceova = new PzChoice[DeviceDriverCollector.getDeviceDrivers().size()];
        int i = 0;
        while (i < DeviceDriverCollector.getDeviceDrivers().size()) {
            PzChoice pzChoice;
            nizChoiceova[i] = pzChoice = new PzChoice(DeviceDriverCollector.getDeviceDrivers().get(i).getDeviceName(), (Object)DeviceDriverCollector.getDeviceDrivers().get(i).getDeviceName(), (ImageIcon)DeviceDriverCollector.getDeviceDrivers().get(i).getResource((byte)4), (ImageIcon)DeviceDriverCollector.getDeviceDrivers().get(i).getResource((byte)14));
            ++i;
        }
        PzDialog temp = new PzDialog(){

            public void actionPerformed(ActionEvent e) {
            }
        };
        String chosenDevice = (String)PzDialogChoice.showPzDialogChoice((PzDialog)temp, (PzChoice[])nizChoiceova, (String)"Izbor uredjaja", (Byte)PzDialogChoice.TYPE_RADIOBUTTON);
        int chosenIndex = -1;
        int i2 = 0;
        while (i2 < DeviceDriverCollector.getDeviceDrivers().size()) {
            if (DeviceDriverCollector.getDeviceDrivers().get(i2).getDeviceName().equals(chosenDevice)) {
                chosenIndex = i2;
                break;
            }
            ++i2;
        }
        if (chosenIndex == -1) {
            return;
        }
        boolean initialized = DeviceDriverCollector.getDeviceDrivers().get(chosenIndex).initDriver(null);
        if (!initialized) {
            return;
        }
        try {
            DeviceDriverCollector.getDeviceDrivers().get(chosenIndex).setWorkingDirectoryPath(PzApplication.getApplication().getDataFolder().getPath());
            DeviceDriverCollector.getDeviceDrivers().get(chosenIndex).runDriver();
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog((Component)((Object)this), e2.getMessage(), "Greska", 0);
        }
        PzExtensionLoader.getInstance().getDeviceManager().addDevice(DeviceDriverCollector.getDeviceDrivers().get(chosenIndex));
        NetDeviceSettings newDevice = new NetDeviceSettings();
        if (DeviceDriverCollector.getDeviceDrivers().get(chosenIndex).getParams() != null) {
            newDevice.setBaud(DeviceDriverCollector.getDeviceDrivers().get(chosenIndex).getParams().get("BAUD"));
            newDevice.setPort(DeviceDriverCollector.getDeviceDrivers().get(chosenIndex).getParams().get("PORT"));
            newDevice.setParam1(DeviceDriverCollector.getDeviceDrivers().get(chosenIndex).getParams().get("PARAM1"));
            newDevice.setParam2(DeviceDriverCollector.getDeviceDrivers().get(chosenIndex).getParams().get("PARAM2"));
            newDevice.setParam3(DeviceDriverCollector.getDeviceDrivers().get(chosenIndex).getParams().get("PARAM3"));
            newDevice.setParam4(DeviceDriverCollector.getDeviceDrivers().get(chosenIndex).getParams().get("PARAM4"));
            newDevice.setParam5(DeviceDriverCollector.getDeviceDrivers().get(chosenIndex).getParams().get("PARAM5"));
        }
        newDevice.setId(DeviceDriverCollector.getDeviceDrivers().get(chosenIndex).getDeviceId());
        newDevice.setLocal("yes");
        newDevice.setName(DeviceDriverCollector.getDeviceDrivers().get(chosenIndex).getDeviceName());
        String userQueueName = MsgProtocol.getInstance() == null ? String.valueOf(PzApplication.getApplication().getSession().getLoggedUser().getIme()) + "(SAMO LOKAL)" : PzExtensionLoader.getInstance().getMsgProtocol().getQueueReceptorName();
        newDevice.setQueue(userQueueName);
        newDevice.setType(DeviceDriverCollector.getDeviceDrivers().get(chosenIndex).getDeviceType());
        this.localDevices.add(newDevice);
        if (PzExtensionLoader.getInstance().getMsgProtocol() == null) {
            this.netDevices.add(newDevice);
            this.refreshTableUUpotrebi();
        } else {
            this.onOsveziPressed();
        }
    }

    private void onSnimiPressed() {
        DeviceManager.setSettings(this.netDevices, this.chckbxDozvoliUpotrebuUredjaja.isSelected());
        try {
            DeviceManager.putSettingsToFile();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        JOptionPane.showMessageDialog((Component)((Object)this), "Pode\u0161avanja uspe\u0161no snimljena.", "Uspe\u0161no", 1);
        this.changeMade = false;
    }

    private void onSkloniPressed() {
        if (this.tableUUpotrebi.getSelectedRow() == -1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Morate prvo selektovati uredjaj iz tabele 'Uredjaji u upotrebi'", "Gre\u0161ka", 0);
            return;
        }
        int i = 0;
        while (i < this.netDevices.size()) {
            if (this.netDevices.get(i).getName().equals((String)this.tableUUpotrebi.getModel().getValueAt(this.tableUUpotrebi.getSelectedRow(), 3)) && this.netDevices.get(i).getName().equals((String)this.tableUUpotrebi.getModel().getValueAt(this.tableUUpotrebi.getSelectedRow(), 3)) && this.netDevices.get(i).getName().equals((String)this.tableUUpotrebi.getModel().getValueAt(this.tableUUpotrebi.getSelectedRow(), 3)) && this.netDevices.get(i).getName().equals((String)this.tableUUpotrebi.getModel().getValueAt(this.tableUUpotrebi.getSelectedRow(), 3))) {
                this.netDevices.remove(i);
            }
            ++i;
        }
        this.refreshTableUUpotrebi();
        this.changeMade = true;
    }

    private void onUpotrebaPressed() {
        if (this.table.getSelectedRow() == -1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Morate prvo selektovati uredjaj iz tabele 'Svi uredjaji'", "Gre\u0161ka", 0);
            return;
        }
        String[] temp = new String[]{"", "", "", ""};
        temp[0] = (String)this.table.getModel().getValueAt(this.table.getSelectedRow(), 0);
        temp[1] = (String)this.table.getModel().getValueAt(this.table.getSelectedRow(), 1);
        temp[2] = (String)this.table.getModel().getValueAt(this.table.getSelectedRow(), 2);
        temp[3] = (String)this.table.getModel().getValueAt(this.table.getSelectedRow(), 3);
        int i = 0;
        while (i < this.netDevices.size()) {
            if (this.netDevices.get(i).getType().equals(temp[2]) && this.netDevices.get(i).getId().equals(temp[1])) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Ovaj uredjaj je ve\u0107 stavljen u upotrebu.", "Gre\u0161ka", 0);
                return;
            }
            ++i;
        }
        i = 0;
        while (i < this.netDevices.size()) {
            if (this.netDevices.get(i).getType().equals(temp[2])) {
                int p = JOptionPane.showConfirmDialog((Component)((Object)this), "Uredjaj tipa " + temp[2] + " ve\u0107 postoji u upotrebi. Da li ste sigurni?", "Da li ste sigurni?", 0);
                if (p == 0) {
                    NetDeviceSettings n = new NetDeviceSettings(temp[3], temp[2], temp[0], temp[1]);
                    int j = 0;
                    while (j < this.localDevices.size()) {
                        if (this.localDevices.get(j).getId().equals(temp[1]) && this.localDevices.get(j).getType().equals(temp[2])) {
                            n.setBaud(this.localDevices.get(j).getBaud());
                            n.setLocal("yes");
                            n.setPort(this.localDevices.get(j).getPort());
                            n.setParam1(this.localDevices.get(j).getParam1());
                            n.setParam2(this.localDevices.get(j).getParam2());
                            n.setParam3(this.localDevices.get(j).getParam3());
                            n.setParam4(this.localDevices.get(j).getParam4());
                            n.setParam5(this.localDevices.get(j).getParam5());
                            break;
                        }
                        ++j;
                    }
                    this.netDevices.add(n);
                    this.changeMade = true;
                    this.refreshTableUUpotrebi();
                    return;
                }
                return;
            }
            ++i;
        }
        NetDeviceSettings n = new NetDeviceSettings(temp[3], temp[2], temp[0], temp[1]);
        i = 0;
        while (i < this.localDevices.size()) {
            if (this.localDevices.get(i).getId().equals(temp[1]) && this.localDevices.get(i).getType().equals(temp[2])) {
                n.setBaud(this.localDevices.get(i).getBaud());
                n.setLocal("yes");
                n.setPort(this.localDevices.get(i).getPort());
                n.setParam1(this.localDevices.get(i).getParam1());
                n.setParam2(this.localDevices.get(i).getParam2());
                n.setParam3(this.localDevices.get(i).getParam3());
                n.setParam4(this.localDevices.get(i).getParam4());
                n.setParam5(this.localDevices.get(i).getParam5());
                break;
            }
            ++i;
        }
        this.netDevices.add(n);
        this.changeMade = true;
        this.refreshTableUUpotrebi();
        this.changeMade = true;
    }

    private void onKonfigurisiPressed() {
        if (this.table.getSelectedRow() == -1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Morate prvo selektovati uredjaj iz tabele 'Svi uredjaji'", "Gre\u0161ka", 0);
            return;
        }
        String id = (String)this.table.getModel().getValueAt(this.table.getSelectedRow(), 1);
        String type = (String)this.table.getModel().getValueAt(this.table.getSelectedRow(), 2);
        DeviceDriverInterface device = null;
        try {
            device = PzExtensionLoader.getInstance().getMsgProtocol().getDeviceManager().getDevice(type, id).getDrvr();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Uredjaj nije povezan", "Gre\u0161ka", 0);
        }
        if (device == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Ne mo\u017eete konfigurisati uredjaje koji se ne\nalaze fizi\u010dki na ovoj ma\u0161ini", "Gre\u0161ka", 0);
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "Ok, ovde treba da se podigne konfiguracioni dijalog, ali... on jos nije gotov :) \n Bitno je da radi logika :)", "Gre\u00c3\u2026\u00c2\u00a1ka", 0);
        }
    }

    private void onOsveziPressed() {
        if (MsgProtocol.getInstance() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Morate biti konektovani na server za razmenu poruka.", "Gre\u0161ka", 0);
            return;
        }
        try {
            MsgProtocol.getInstance().sendDiscoverMessage("topic.users");
        }
        catch (JMSException jMSException) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Osve\u017eavanje ne mo\u017ee biti izvedeno\nProverite da li ste povezani na server za razmenu poruka.", "Gre\u0161ka", 0);
        }
    }

    @Override
    public String getTopicName() {
        PzExtensionLoader.getInstance().getMsgProtocol();
        return "topic.users";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshTableUUpotrebi() {
        Object object = mutex;
        synchronized (object) {
            DefaultTableModel tableModel = new DefaultTableModel(null, new String[]{"Kod korisnika", "ID", "Tip", "Opis uredjaja"});
            int i = 0;
            while (i < this.netDevices.size()) {
                Object[] all = new String[]{this.netDevices.get(i).getQueue(), this.netDevices.get(i).getId(), this.netDevices.get(i).getType(), this.netDevices.get(i).getName()};
                tableModel.insertRow(i, all);
                ++i;
            }
            this.tableUUpotrebi.setModel(tableModel);
            this.tableUUpotrebi.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage() {
        boolean changed = false;
        Object object = mutex;
        synchronized (object) {
            Vector<String> devices = PzExtensionLoader.getInstance().getMsgProtocol().getControl().getAllDevices();
            ((DefaultTableModel)this.table.getModel()).getDataVector().removeAllElements();
            int i = 0;
            while (i < devices.size()) {
                Object[] all = devices.get(i).split(":");
                if (this.checkForChanges(new NetDeviceSettings(all[3], all[2], all[0], all[1]))) {
                    changed = true;
                }
                ((DefaultTableModel)this.table.getModel()).insertRow(i, all);
                ++i;
            }
        }
        if (changed) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Detektovana je promena uredjaja na mre\u017ei.\nAutomatska rekonfiguracija izvr\u0161ena.", "Detektovane promene", 1);
            this.reconfigure();
            changed = false;
        }
    }

    private void reconfigure() {
        int i = 0;
        while (i < this.netDevices.size()) {
            int j = 0;
            while (j < this.changedDevices.size()) {
                if (this.netDevices.get(i).getId().equals(this.changedDevices.get(j).getId()) && this.netDevices.get(i).getType().equals(this.changedDevices.get(j).getType()) && !this.netDevices.get(i).getQueue().equals(this.changedDevices.get(j).getQueue())) {
                    this.netDevices.get(i).setQueue(this.changedDevices.get(j).getQueue());
                }
                ++j;
            }
            ++i;
        }
        this.changedRowNumbersInSavedData.clear();
        this.changedDevices.clear();
        this.refreshTableUUpotrebi();
        this.onSnimiPressed();
    }

    private boolean checkForChanges(NetDeviceSettings newDevice) {
        boolean changed = false;
        if (this.netDevices != null) {
            int i = 0;
            while (i < this.netDevices.size()) {
                if (this.netDevices.get(i).getId().equals(newDevice.getId()) && this.netDevices.get(i).getType().equals(newDevice.getType()) && !this.netDevices.get(i).getQueue().equals(newDevice.getQueue())) {
                    this.changedRowNumbersInSavedData.add(this.netDevices.get(i));
                    this.changedDevices.add(newDevice);
                    changed = true;
                }
                ++i;
            }
        }
        return changed;
    }

    public void loadSavedSettings() {
        this.netDevices = DeviceManager.getnetDevices();
        boolean shared = DeviceManager.getShared();
        this.deviceManager.setSharedDevices(shared);
        this.refreshTableUUpotrebi();
    }

    public Vector<NetDeviceSettings> getNetDevices() {
        return this.netDevices;
    }

    public void setLblConnected() {
        this.lblConnected.setText("Konektovano na server za razmenu podataka.");
        this.lblConnected.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(ICON_SUCCESS)));
    }

    public void setLblDisconnected() {
        this.lblConnected.setText("Konekcija sa serverom za razmenu podataka nije uspostavljena.");
        this.lblConnected.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource(ICON_FAIL)));
    }

    public static DeviceConfiguratorWindow getDeviceConfiguratorPanel() {
        if (deviceConf == null) {
            deviceConf = new DeviceConfiguratorWindow();
        }
        return deviceConf;
    }

    public static PzDialog getDeviceConfiguratorDialog() {
        PzDialog dialog = new PzDialog(){

            public void actionPerformed(ActionEvent e) {
            }
        };
        if (deviceConf == null) {
            deviceConf = new DeviceConfiguratorWindow();
        }
        dialog.setLayout((LayoutManager)new BorderLayout(0, 0));
        dialog.setTitle("Pode\u0161avanje uredjaja");
        dialog.setSize(deviceConf.getWidth(), deviceConf.getHeight() + 50);
        dialog.add((Component)((Object)deviceConf), (Object)"Center");
        return dialog;
    }
}

