/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.indexes;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import org.xBaseJ.DBF;
import org.xBaseJ.Util;

public class MDXAnchor {
    static final short BLOCKLENGTH = 512;
    byte filetype;
    byte[] lastreIndex = new byte[3];
    byte[] DBFname = new byte[16];
    short blocksize;
    short blockbytes;
    byte production;
    byte[] resrvd1 = new byte[3];
    short indexes;
    byte[] resrvd2 = new byte[2];
    int nextAvailable;
    int nextfreepage;
    int freepages;
    byte[] created = new byte[3];
    byte resrvd3;
    int[] something = new int[4];
    RandomAccessFile nfile;
    String knownName;

    public MDXAnchor(RandomAccessFile ifile) {
        this.nfile = ifile;
    }

    public void set(String Name) {
        byte[] dname;
        this.filetype = (byte)2;
        this.lastreIndex[0] = 0;
        this.lastreIndex[1] = 0;
        this.lastreIndex[2] = 0;
        try {
            dname = Name.substring(0, Math.min(16, Name.length())).getBytes(DBF.encodedType);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            dname = Name.substring(0, Math.min(16, Name.length())).getBytes();
        }
        int x = 0;
        while (x < dname.length) {
            this.DBFname[x] = dname[x];
            ++x;
        }
        this.production = 1;
        this.nextAvailable = 4;
        this.blocksize = (short)2;
        this.blockbytes = (short)(this.blocksize * 512);
        this.indexes = 0;
        this.resrvd1[0] = 48;
        this.resrvd1[1] = 32;
        this.resrvd2[1] = 27;
        this.created[0] = 0;
        this.created[1] = 0;
        this.created[2] = 0;
        this.something[0] = 25;
        this.something[1] = 1;
        this.knownName = new String(Name);
    }

    public void reset(RandomAccessFile ifile) {
        this.nfile = ifile;
        this.filetype = (byte)2;
        this.lastreIndex[0] = 0;
        this.lastreIndex[1] = 0;
        this.lastreIndex[2] = 0;
        this.nextAvailable = 4;
        this.created[0] = 0;
        this.created[1] = 0;
        this.created[2] = 0;
    }

    public void read() throws IOException {
        this.nfile.seek(0L);
        this.filetype = this.nfile.readByte();
        this.nfile.read(this.lastreIndex);
        this.nfile.read(this.DBFname);
        this.blocksize = this.nfile.readShort();
        this.blockbytes = this.nfile.readShort();
        this.production = this.nfile.readByte();
        this.nfile.read(this.resrvd1);
        this.indexes = this.nfile.readShort();
        this.nfile.read(this.resrvd2);
        this.nextAvailable = this.nfile.readInt();
        this.nextfreepage = this.nfile.readInt();
        this.freepages = this.nfile.readInt();
        this.nfile.read(this.created);
        this.resrvd3 = this.nfile.readByte();
        this.something[0] = this.nfile.readInt();
        this.something[1] = this.nfile.readInt();
        this.something[2] = this.nfile.readInt();
        this.something[3] = this.nfile.readInt();
        this.redo_numbers();
    }

    public void write() throws IOException {
        this.redo_numbers();
        this.nfile.seek(0L);
        this.nfile.writeByte(this.filetype);
        Calendar d = Calendar.getInstance();
        this.lastreIndex[0] = (byte)(d.get(1) - 1900);
        this.lastreIndex[1] = (byte)(d.get(2) + 1);
        this.lastreIndex[2] = (byte)d.get(5);
        this.nfile.write(this.lastreIndex);
        this.nfile.write(this.DBFname);
        this.nfile.writeShort(this.blocksize);
        this.nfile.writeShort(this.blockbytes);
        this.nfile.writeByte(this.production);
        this.nfile.write(this.resrvd1);
        this.nfile.writeShort(this.indexes);
        this.nfile.write(this.resrvd2);
        this.nfile.writeInt(this.nextAvailable);
        this.nfile.writeInt(this.nextfreepage);
        this.nfile.writeInt(this.freepages);
        this.nfile.write(this.created);
        this.nfile.writeByte(this.resrvd3);
        this.nfile.writeInt(this.something[0]);
        this.nfile.writeInt(this.something[1]);
        this.nfile.writeInt(this.something[2]);
        this.nfile.writeInt(this.something[3]);
        this.redo_numbers();
    }

    public void redo_numbers() {
        this.blocksize = Util.x86(this.blocksize);
        this.blockbytes = Util.x86(this.blockbytes);
        this.indexes = Util.x86(this.indexes);
        this.nextAvailable = Util.x86(this.nextAvailable);
        this.nextfreepage = Util.x86(this.nextfreepage);
        this.freepages = Util.x86(this.freepages);
    }

    public int get_nextavailable() {
        return this.nextAvailable;
    }

    public void update_nextavailable() throws IOException {
        this.nextAvailable += this.blocksize;
        this.write();
    }

    public void reset_nextavailable() throws IOException {
        this.nextAvailable -= this.blocksize;
        this.write();
    }

    public int get_blocksize() {
        return this.blocksize;
    }

    public int get_blockbytes() {
        return this.blockbytes;
    }

    public static short getBLOCKLENGTH() {
        return 512;
    }

    public short getBlockbytes() {
        return this.blockbytes;
    }

    public short getBlocksize() {
        return this.blocksize;
    }

    public byte[] getCreated() {
        return this.created;
    }

    public byte[] getDBFname() {
        return this.DBFname;
    }

    public byte getFiletype() {
        return this.filetype;
    }

    public int getFreepages() {
        return this.freepages;
    }

    public void setIndexes(short ind) {
        this.indexes = ind;
    }

    public void addOneToIndexes() {
        this.indexes = (short)(this.indexes + 1);
    }

    public short getIndexes() {
        return this.indexes;
    }

    public String getKnownName() {
        return this.knownName;
    }

    public byte[] getLastreIndex() {
        return this.lastreIndex;
    }

    public int getnextAvailable() {
        return this.nextAvailable;
    }

    public int getNextfreepage() {
        return this.nextfreepage;
    }

    public RandomAccessFile getNfile() {
        return this.nfile;
    }

    public byte getProduction() {
        return this.production;
    }
}

