/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.testing.parser;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import rs.pezar.msg.device.cashregister.data.Article;
import rs.pezar.msg.device.cashregister.data.CashRegisterBill;
import rs.pezar.msg.device.cashregister.data.CashRegisterControl;

public class TestParser {
    private XMLConfiguration config;
    private String opis = "";
    private String ime = "";

    public CashRegisterBill loadBill(String resource) throws ConfigurationException {
        String ime;
        int size = 0;
        this.config = new XMLConfiguration(resource);
        CashRegisterBill cashregisterBill = new CashRegisterBill();
        Object prop = this.config.getProperty("racun.artikal[@ime]");
        String opis = this.config.getString("racun.opis[@opis]");
        if (opis != null) {
            this.opis = opis;
        }
        if ((ime = this.config.getString("racun.opis[@ime]")) != null) {
            this.ime = ime;
        }
        size = prop instanceof Collection ? ((Collection)prop).size() : 1;
        int i = 0;
        while (i < size) {
            Article article = new Article();
            article.setName(this.config.getString("racun.artikal(" + String.valueOf(i) + ")[@ime]"));
            try {
                article.setPLU(Integer.valueOf(Integer.parseInt(this.config.getString("racun.artikal(" + String.valueOf(i) + ")[@plu]"))));
            }
            catch (Exception exception) {}
            article.setPrice(new BigDecimal(this.config.getString("racun.artikal(" + String.valueOf(i) + ")[@cena]")));
            article.setQuantity(new BigDecimal(this.config.getString("racun.artikal(" + String.valueOf(i) + ")[@kolicina]")));
            article.setSifra(this.config.getString("racun.artikal(" + String.valueOf(i) + ")[@sifra]"));
            article.setTaxRate((char)this.config.getString("racun.artikal(" + String.valueOf(i) + ")[@taksa]").getBytes()[0]);
            article.setUnit(this.config.getString("racun.artikal(" + String.valueOf(i) + ")[@jm]"));
            cashregisterBill.addArticle(article);
            ++i;
        }
        try {
            cashregisterBill.setPaidAmountCash(new BigDecimal(Double.parseDouble(this.config.getString("racun.kesh"))));
        }
        catch (Exception exception) {}
        try {
            cashregisterBill.setPaidAmountCard(new BigDecimal(this.config.getString("racun.kartica")));
        }
        catch (Exception exception) {}
        try {
            cashregisterBill.setPaidAmountCheck(new BigDecimal(this.config.getString("racun.cek")));
        }
        catch (Exception exception) {}
        cashregisterBill.setPreBill(false);
        cashregisterBill.setOperaterPassword("0000");
        cashregisterBill.setOperaterCode("1");
        cashregisterBill.setCashRegisterCode("1");
        if (cashregisterBill.getPaidAmountCard() == null && cashregisterBill.getPaidAmountCash() == null && cashregisterBill.getPaidAmountCheck() == null) {
            this.opis = "Iznos kartice, ceka i gotovine ne mogu biti null zajedno.";
        }
        return cashregisterBill;
    }

    public CashRegisterControl loadControl(String resource) throws ConfigurationException {
        String ime;
        int size = 0;
        this.config = new XMLConfiguration(resource);
        CashRegisterControl cashRegisterControl = new CashRegisterControl();
        Object prop = this.config.getProperty("kontrola[@kod]");
        String opis = this.config.getString("opis[@opis]");
        if (opis != null) {
            this.opis = opis;
        }
        if ((ime = this.config.getString("opis[@ime]")) != null) {
            this.ime = ime;
        }
        size = prop instanceof Collection ? ((Collection)prop).size() : 1;
        int i = 0;
        while (i < size) {
            HashMap<String, String> map = new HashMap<String, String>();
            cashRegisterControl.setControlCode(this.config.getString("kontrola[@kod]"));
            map.put(this.config.getString("kontrola[@paramId1]"), this.config.getString("kontrola[@paramVrednost1]"));
            map.put(this.config.getString("kontrola[@paramId2]"), this.config.getString("kontrola[@paramVrednost2]"));
            map.put(this.config.getString("kontrola[@paramId3]"), this.config.getString("kontrola[@paramVrednost3]"));
            cashRegisterControl.setParameters(map);
            ++i;
        }
        return cashRegisterControl;
    }

    public static void main(String[] args) {
        TestParser tp = new TestParser();
        try {
            tp.loadBill("testovi\\test1.xml");
            return;
        }
        catch (ConfigurationException configurationException) {
            return;
        }
    }

    public String getOpis() {
        return this.opis;
    }

    public void setOpis(String opis) {
        this.opis = opis;
    }

    public String getIme() {
        return this.ime;
    }

    public void setIme(String ime) {
        this.ime = ime;
    }
}

