/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.testing;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ResourceList {
    public static Collection<String> getResources(Pattern pattern) {
        String[] classPathElements;
        ArrayList<String> retval = new ArrayList<String>();
        String classPath = System.getProperty("java.class.path", ".");
        String[] stringArray = classPathElements = classPath.split(":");
        int n = classPathElements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            retval.addAll(ResourceList.getResources(element, pattern));
            ++n2;
        }
        return retval;
    }

    private static Collection<String> getResources(String element, Pattern pattern) {
        ArrayList<String> retval = new ArrayList<String>();
        File file = new File(element);
        if (file.isDirectory()) {
            retval.addAll(ResourceList.getResourcesFromDirectory(file, pattern));
        } else {
            retval.addAll(ResourceList.getResourcesFromJarFile(file, pattern));
        }
        return retval;
    }

    private static Collection<String> getResourcesFromJarFile(File file, Pattern pattern) {
        ZipFile zf;
        ArrayList<String> retval = new ArrayList<String>();
        try {
            zf = new ZipFile(file);
        }
        catch (ZipException e) {
            throw new Error(e);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        Enumeration<? extends ZipEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            String fileName = ze.getName();
            boolean accept = pattern.matcher(fileName).matches();
            if (!accept) continue;
            retval.add(fileName);
        }
        try {
            zf.close();
        }
        catch (IOException e1) {
            throw new Error(e1);
        }
        return retval;
    }

    private static Collection<String> getResourcesFromDirectory(File directory, Pattern pattern) {
        File[] fileList;
        ArrayList<String> retval = new ArrayList<String>();
        File[] fileArray = fileList = directory.listFiles();
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                retval.addAll(ResourceList.getResourcesFromDirectory(file, pattern));
            } else {
                try {
                    String fileName = file.getCanonicalPath();
                    boolean accept = pattern.matcher(fileName).matches();
                    if (accept) {
                        retval.add(fileName);
                    }
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }
            ++n2;
        }
        return retval;
    }

    public static void main(String[] args) {
        Pattern pattern = Pattern.compile("/rs/pezar/kasa/testing/resources");
        Collection<String> list = ResourceList.getResources(pattern);
        for (String name : list) {
            System.out.println(name);
        }
    }
}

