/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.fsm;

import java.io.IOException;
import java.util.HashMap;
import rs.pezar.kasa.commporthandler.DevicePort;
import rs.pezar.kasa.fsm.State;
import rs.pezar.kasa.fsm.StateLogger;
import rs.pezar.kasa.messages.Messages;

public class RetransmitState
extends State {
    public static final String STATE_NAME = "RETRANSMIT_STATE";
    private Messages returnedData;
    private DevicePort crport;
    private String lastMessage;
    private int retransmissionCount;
    private StateLogger loggedPort;
    private HashMap<String, Object> params;

    public RetransmitState(HashMap<String, Object> params) {
        this.params = params;
        this.stateName = STATE_NAME;
        this.returnedData = (Messages)params.get("DATA");
        this.lastMessage = (String)params.get("LAST_MESSAGE");
        this.loggedPort = (StateLogger)params.get("LOGGEDPORT");
        this.crport = this.loggedPort.getDevicePort();
        this.retransmissionCount = 0;
    }

    @Override
    public void run() {
        try {
            Thread.currentThread();
            Thread.sleep(700L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ++this.retransmissionCount;
        this.lastMessage = (String)this.params.get("LAST_MESSAGE");
        try {
            this.loggedPort.loggedWrite(this.lastMessage, this.lastMessage.lastIndexOf(3) + 1, this.stateName, null);
        }
        catch (IOException e) {
            this.nextState = 5;
            this.returnedData.addError("ERROR|FSM: Greska prilikom upisa na COM port");
            e.printStackTrace();
            return;
        }
        if (this.retransmissionCount <= 15) {
            this.nextState = 4;
        } else {
            this.nextState = 5;
            this.returnedData.addError("INFO|FSM: Greska prilikom retransmisije." + String.valueOf(15) + " neuspelih pokusaja. Proverite stabilnost veze printera i racunara.");
        }
    }

    public void resetCounter() {
        this.retransmissionCount = 0;
    }
}

