/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.fsm;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import rs.pezar.kasa.cashregister.CashRegisterControl;
import rs.pezar.kasa.commporthandler.DevicePort;
import rs.pezar.kasa.exceptions.BadChecksumException;
import rs.pezar.kasa.exceptions.ErrorPrinterFailed;
import rs.pezar.kasa.exceptions.InfoPrinterMalfunctions;
import rs.pezar.kasa.fsm.State;
import rs.pezar.kasa.fsm.StateLogger;
import rs.pezar.kasa.messages.Messages;

public class ReceiveState
extends State {
    public static final String STATE_NAME = "RECEIVE_STATE";
    CashRegisterControl fp550Control;
    DevicePort crport;
    private Messages returnedData;
    private byte[] returnMessage;
    private StateLogger loggedPort;
    private Integer receiveDelay;
    private Integer read_wait = 3;

    public ReceiveState(HashMap<String, Object> params) {
        this.stateName = STATE_NAME;
        this.returnedData = (Messages)params.get("DATA");
        this.fp550Control = (CashRegisterControl)params.get("CONTROL");
        if (params.get("DELAY") != null && StringUtils.isNumeric((String)((String)params.get("DELAY")))) {
            this.receiveDelay = Integer.parseInt((String)params.get("DELAY"));
        }
        this.loggedPort = (StateLogger)params.get("LOGGEDPORT");
        this.crport = this.loggedPort.getDevicePort();
    }

    @Override
    public synchronized void run() {
        boolean result = true;
        if (this.receiveDelay != null && this.receiveDelay > 0) {
            try {
                Thread.sleep(this.receiveDelay.intValue());
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
        try {
            this.returnMessage = this.loggedPort.loggedRead(3, this.stateName, "Poruka Primljena");
        }
        catch (Exception exception) {
            this.returnedData.addError("ERROR|FSM: STATE_RECEIVE (Printer ne vraca odgovor)");
            this.nextState = 5;
            return;
        }
        if (this.returnMessage[0] == 114) {
            this.nextState = 6;
            return;
        }
        if (this.returnMessage[0] == 119) {
            this.nextState = 7;
            return;
        }
        this.fp550Control.GetProtocol().CheckReturnedData(this.returnMessage, this.returnedData);
        try {
            this.fp550Control.GetProtocol().CheckMessageIntegrity(this.returnMessage);
            this.fp550Control.GetProtocol().CheckReturnedErrors(this.returnMessage);
            this.fp550Control.GetProtocol().CheckReturnedInfos(this.returnMessage);
        }
        catch (BadChecksumException e) {
            this.returnedData.addError(e.getMessage());
            e.printStackTrace();
        }
        catch (ErrorPrinterFailed e) {
            this.returnedData.addErrors(e.getMessages());
            result = false;
            e.printStackTrace();
        }
        catch (InfoPrinterMalfunctions e) {
            this.returnedData.ReturnInfos().clear();
            this.returnedData.addInfos(e.getMessages());
        }
        this.nextState = result ? Integer.valueOf(2) : Integer.valueOf(5);
    }
}

