/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.fsm;

import java.util.HashMap;
import java.util.LinkedList;
import rs.pezar.kasa.fsm.State;
import rs.pezar.kasa.fsm.StateLogger;
import rs.pezar.kasa.messages.Messages;

public class IdleState
extends State {
    public static final String STATE_NAME = "IDLE_STATE";
    private Messages returnedData;
    private LinkedList<String> outMessage;
    private int currentState;
    private StateLogger loggedPort;

    public IdleState(HashMap<String, Object> params) {
        this.stateName = STATE_NAME;
        this.returnedData = (Messages)params.get("DATA");
        this.outMessage = (LinkedList)params.get("OUT_MESSAGE");
        this.currentState = (Integer)params.get("CURRENT_STATE");
        this.loggedPort = (StateLogger)params.get("LOGGEDPORT");
    }

    @Override
    public void run() {
        this.loggedPort.getDeviceLogger().putTransaction();
        this.loggedPort.getDeviceLogger().newTransaction();
        this.loggedPort.getDeviceLogger().logData(this.stateName, null, null, null);
        try {
            this.hold();
        }
        catch (InterruptedException e1) {
            this.nextState = 5;
            this.returnedData.addError("ERROR|FSM:Idle stanje prekinuto, moguce nepravilno izvrsavanje.");
            e1.printStackTrace();
        }
        if (this.currentState == 0) {
            this.nextState = 0;
            return;
        }
        if (!this.outMessage.isEmpty()) {
            this.nextState = 3;
            return;
        }
        this.nextState = 2;
    }
}

