/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.fsm;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Vector;
import rs.pezar.kasa.cashregister.CashRegisterControl;
import rs.pezar.kasa.cashregister.DatecsCommandHelper;
import rs.pezar.kasa.commporthandler.DevicePort;
import rs.pezar.kasa.fsm.ErrorState;
import rs.pezar.kasa.fsm.IdleState;
import rs.pezar.kasa.fsm.InitState;
import rs.pezar.kasa.fsm.ReceiveState;
import rs.pezar.kasa.fsm.RetransmitState;
import rs.pezar.kasa.fsm.SendState;
import rs.pezar.kasa.fsm.StateLogger;
import rs.pezar.kasa.fsm.WaitState;
import rs.pezar.kasa.messages.Messages;
import rs.pezar.kasa.roundlogger.DeviceLogger;

public class CashRegisterFSM {
    public static final int STATE_END = 0;
    public static final int STATE_INIT = 1;
    public static final int STATE_IDLE = 2;
    public static final int STATE_SEND = 3;
    public static final int STATE_RECEIVE = 4;
    public static final int STATE_ERROR = 5;
    public static final int STATE_RETRANSMIT = 6;
    public static final int STATE_WAIT = 7;
    public static final boolean TRANSACT_lOG = true;
    public byte logResource;
    private DeviceLogger deviceLogger;
    private StateLogger portLogger;
    public static final int READ_DELAY = 3;
    public static final int RETRANSMISSION_COUNT_ERROR = 15;
    public static boolean INITIAL_BEEP = true;
    public Integer currentState = 1;
    public LinkedList<String> outMessage;
    public static CashRegisterControl cashRegister;
    public static FSM automate;
    public static boolean initialized;
    Messages returnedData;
    private String lastMessage = null;
    private DevicePort crport;
    private InitState initState;
    private ReceiveState receiveState;
    private SendState sendState;
    private IdleState idleState;
    private ErrorState errorState;
    private RetransmitState retransmitState;
    private WaitState waitState;

    static {
        initialized = false;
    }

    public CashRegisterFSM(CashRegisterControl crControl, DevicePort port, HashMap<String, String> params) {
        Vector<String> statesToLog;
        cashRegister = crControl;
        this.returnedData = new Messages();
        automate = new FSM();
        this.outMessage = new LinkedList();
        String log = params.get("LOG");
        if (log != null && log.equals("ERRORS")) {
            statesToLog = new Vector<String>();
            statesToLog.add("ERROR_STATE");
        } else {
            statesToLog = null;
        }
        this.crport = port;
        this.deviceLogger = new DeviceLogger(statesToLog);
        this.deviceLogger.setLogHelper(new DatecsCommandHelper());
        this.portLogger = new StateLogger(this.deviceLogger, this.crport);
        HashMap<String, Object> stateParams = new HashMap<String, Object>();
        stateParams.put("CONTROL", cashRegister);
        stateParams.put("PORT", this.crport);
        stateParams.put("DATA", this.returnedData);
        stateParams.put("OUT_MESSAGE", this.outMessage);
        stateParams.put("LAST_MESSAGE", this.lastMessage);
        stateParams.put("CURRENT_STATE", this.currentState);
        stateParams.put("LOGGEDPORT", this.portLogger);
        stateParams.put("DELAY", params.get("DELAY"));
        this.initState = new InitState(stateParams);
        this.receiveState = new ReceiveState(stateParams);
        this.sendState = new SendState(stateParams);
        this.idleState = new IdleState(stateParams);
        this.errorState = new ErrorState(stateParams);
        this.retransmitState = new RetransmitState(stateParams);
        this.waitState = new WaitState(stateParams);
    }

    public void setLogResource(String resourcePath, Byte resourceType) {
        this.deviceLogger.setResource(resourcePath, resourceType);
        this.logResource = resourceType;
    }

    public void start() {
        automate.start();
    }

    public void stop() {
        this.crport.closePort();
        this.currentState = 0;
        this.idleState.release(1);
    }

    public synchronized void WaitOnInitialize() {
        if (!initialized) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void ReleaseOnInitialized() {
        if (!initialized) {
            this.notifyAll();
            initialized = true;
        }
    }

    public synchronized void AddToCommandList(String command) {
        this.WaitOnInitialize();
        this.outMessage.add(command);
    }

    public synchronized Messages ExecuteCommand() {
        this.WaitOnInitialize();
        this.returnedData.ClearData();
        this.idleState.release(1);
        return this.returnedData;
    }

    public class FSM
    extends Thread {
        @Override
        public void run() {
            block11: while (CashRegisterFSM.this.currentState != 0) {
                switch (CashRegisterFSM.this.currentState) {
                    case 1: {
                        CashRegisterFSM.this.initState.runState();
                        CashRegisterFSM.this.currentState = CashRegisterFSM.this.initState.getNextState();
                        if (CashRegisterFSM.this.currentState != 2) break;
                        CashRegisterFSM.this.ReleaseOnInitialized();
                        break;
                    }
                    case 2: {
                        CashRegisterFSM.this.WaitOnInitialize();
                        CashRegisterFSM.this.retransmitState.resetCounter();
                        CashRegisterFSM.this.idleState.runState();
                        CashRegisterFSM.this.currentState = CashRegisterFSM.this.idleState.getNextState();
                        try {
                            Thread.sleep(30L);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                        continue block11;
                    }
                    case 3: {
                        CashRegisterFSM.this.WaitOnInitialize();
                        CashRegisterFSM.this.sendState.runState();
                        CashRegisterFSM.this.currentState = CashRegisterFSM.this.sendState.getNextState();
                        break;
                    }
                    case 6: {
                        CashRegisterFSM.this.retransmitState.runState();
                        CashRegisterFSM.this.currentState = CashRegisterFSM.this.retransmitState.getNextState();
                        break;
                    }
                    case 4: {
                        CashRegisterFSM.this.receiveState.runState();
                        CashRegisterFSM.this.currentState = CashRegisterFSM.this.receiveState.getNextState();
                        if (CashRegisterFSM.this.currentState == 7) continue block11;
                        if (CashRegisterFSM.this.currentState == 2 && !CashRegisterFSM.this.outMessage.isEmpty()) {
                            CashRegisterFSM.this.currentState = 3;
                            break;
                        }
                        if (CashRegisterFSM.this.currentState != 2 || !CashRegisterFSM.this.outMessage.isEmpty()) continue block11;
                        CashRegisterFSM.this.currentState = 2;
                        CashRegisterFSM.this.returnedData.DataReady();
                        break;
                    }
                    case 7: {
                        CashRegisterFSM.this.waitState.runState();
                        CashRegisterFSM.this.currentState = CashRegisterFSM.this.waitState.getNextState();
                        break;
                    }
                    case 5: {
                        CashRegisterFSM.this.errorState.runState();
                        CashRegisterFSM.this.currentState = CashRegisterFSM.this.errorState.getNextState();
                        break;
                    }
                }
            }
        }
    }
}

