/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.cashregister;

import java.util.Arrays;
import java.util.Stack;
import rs.pezar.kasa.cashregister.CashRegisterProtocol;
import rs.pezar.kasa.exceptions.BadCharacterException;
import rs.pezar.kasa.exceptions.BadChecksumException;
import rs.pezar.kasa.exceptions.ErrorPrinterFailed;
import rs.pezar.kasa.exceptions.InfoPrinterMalfunctions;
import rs.pezar.kasa.exceptions.MaxLengthException;
import rs.pezar.kasa.messages.Messages;
import rs.pezar.kasa.util.HexDump;

public class DatecsProtocol
implements CashRegisterProtocol {
    public static final int MAX_UP_MESSAGE_LENGTH = 215;
    public static final int MAX_DOWN_MESSAGE_LENGTH = 220;
    public static final int MSG_DOWN_LENGTH = 203;
    public static final int MSG_UP_LENGTH = 198;
    public byte[] messageUp;
    public byte[] messageDown;
    public static final byte ERROR_CHECK = 32;
    public static final byte ERROR_PRINTER_MECHANICS_FAIL = 16;
    public static final byte ERROR_DISPLAY_NOT_CONNECTED = 8;
    public static final byte ERROR_TIME_DATE_NOT_SET = 4;
    public static final byte ERROR_COMMAND_FORMAT_WRONG = 2;
    public static final byte ERROR_RECEIVED_DATA_SYNTAX = 1;
    public static final byte ERROR_CHASIS_INTRUSION = 32;
    public static final byte ERROR_RAM_CHANGED = 16;
    public static final byte ERROR_UNKNOWN = 8;
    public static final byte ERROR_OPERATING_MEMORY_CLEAR = 4;
    public static final byte ERROR_COMMAND_NOT_ALLOWED = 2;
    public static final byte ERROR_AMOUNT_EXCEED = 1;
    public static final byte ERROR_INFO_BILL_OPEN = 32;
    public static final byte ERROR_SECONDARY_PAPER_ALMOST = 16;
    public static final byte ERROR_FISCAL_BILL_OPEN = 8;
    public static final byte ERROR_SECONDARY_PAPER_OUT = 4;
    public static final byte ERROR_BOTH_CLIPS_ALMOST = 2;
    public static final byte ERROR_BOTH_CLIPS_OUT = 1;
    public static final byte ERROR_BAUD_RATE_SET = 8;
    public static final byte ERROR_TRANSPARENT_DISPLAY = 4;
    public static final byte ERROR_AUTOMATIC_CUT_ALLOWED = 1;
    public static final byte ERROR_MEMORY_CHECK = 32;
    public static final byte ERROR_FISCAL_MEMORY_FULL = 16;
    public static final byte ERROR_FISCAL_MEMORY_LESS_50 = 8;
    public static final byte ERROR_NO_FISCAL_MODULE = 4;
    public static final byte ERROR_FISCAL_MEMORY_WRITE = 1;
    public static final byte ERROR_SERIAL_NR_FISCAL_NR = 32;
    public static final byte ERROR_TAX_RATE_ALREADY_SET = 16;
    public static final byte ERROR_FISCAL_ON = 8;
    public static final byte ERROR_LAST_DAILY_REPORT_FAIL = 4;
    public static final byte ERROR_FISCAL_MEM_CLEARED = 2;
    public static final byte ERROR_FISCAL_MEM_READ_ONLY = 1;
    public static final byte SYN_SYNC = 22;
    public static final byte SYN_NAK = 21;
    public static final byte MSG_ERROR = -1;
    public static final byte MSG_PREAMBLE = 1;
    public static final byte MSG_DELIMITER = 4;
    public static final byte MSG_POSTAMBLE = 5;
    public static final byte MSG_TERMINATOR = 3;
    public boolean messageReady = false;
    public byte messageSequence = (byte)32;
    public int position = 4;
    public byte[] checksum;
    public int dataLength = 0;
    private boolean messagePre = false;
    private boolean messageLen = false;
    private boolean messageSeq = false;
    private boolean messageCmd = false;
    private boolean messageData = false;
    private boolean messagePost = false;
    private boolean messageBcc = false;
    private boolean messageTer = false;
    public static String INFO_TEXT_BILL_OPEN = "[code=0x0005]";
    public static String INFO_FISCAL_BILL_OPEN = "[code=0x000A]";
    private Stack<Byte> sequence = new Stack();

    public DatecsProtocol() {
        this.messageUp = new byte[215];
        this.messageDown = new byte[220];
        this.checksum = new byte[4];
    }

    @Override
    public byte[] GetMessageDown() {
        return this.messageDown;
    }

    @Override
    public byte GetMessageERROR() {
        return -1;
    }

    @Override
    public byte GetMessageNAK() {
        return 21;
    }

    @Override
    public byte GetMessageSYNC() {
        return 22;
    }

    @Override
    public byte GetMessageTERMINATOR() {
        return 3;
    }

    @Override
    public void FormMessage(byte command, String data) throws Exception {
        this.ResetSteps();
        this.InitMessage();
        this.InsertSequenceNumber();
        this.InsertCommand(command);
        if (data != null) {
            this.InsertData(data.getBytes(), data.length());
        }
        this.AppendPostamble();
        this.InsertLength();
        this.AppendChecksum();
        this.AppendTerminator();
    }

    @Override
    public void FormMessage(byte command, byte[] data, int dataLength) throws Exception {
        this.ResetSteps();
        this.InitMessage();
        this.InsertSequenceNumber();
        this.InsertCommand(command);
        if (data != null) {
            this.InsertData(data, dataLength);
        }
        this.AppendPostamble();
        this.InsertLength();
        this.AppendChecksum();
        this.AppendTerminator();
    }

    private void InitMessage() {
        this.messagePre = true;
        this.messageDown[0] = 1;
    }

    public void PrintMessage() {
        int i = 0;
        while (i < 220) {
            System.out.println(this.messageDown[i]);
            ++i;
        }
    }

    private void InsertSequenceNumber() {
        this.messageSeq = true;
        this.messageDown[2] = this.messageSequence;
        this.messageSequence = (byte)(this.messageSequence + 1);
        if (this.messageSequence > 126) {
            this.messageSequence = (byte)32;
        }
        this.sequence.push(this.messageSequence);
    }

    private byte Sequence() {
        return this.sequence.pop();
    }

    private void ResetSteps() {
        this.messagePre = false;
        this.messageLen = false;
        this.messageSeq = false;
        this.messageCmd = false;
        this.messageData = false;
        this.messagePost = false;
        this.messageBcc = false;
        this.messageTer = false;
        this.position = 4;
        this.dataLength = 0;
        int i = 0;
        while (i < 220) {
            this.messageDown[i] = 0;
            ++i;
        }
    }

    private void CalculateChecksum() throws Exception {
        int check = 0;
        int check1 = 0;
        char checkTemp = '\u0000';
        if (!(this.messageLen | this.messageSeq | this.messageCmd | this.messageData | this.messagePost)) {
            throw new Exception();
        }
        int i = 1;
        while (i < this.dataLength + 5) {
            check1 = 0xFF & this.messageDown[i];
            check = (char)(check + check1);
            ++i;
        }
        checkTemp = (char)(check & 0xF000);
        checkTemp = (char)(checkTemp >> 12);
        checkTemp = (char)(checkTemp + 48);
        this.checksum[0] = (byte)checkTemp;
        checkTemp = (char)(check & 0xF00);
        checkTemp = (char)(checkTemp >> 8);
        checkTemp = (char)(checkTemp + 48);
        this.checksum[1] = (byte)checkTemp;
        checkTemp = (char)(check & 0xF0);
        checkTemp = (char)(checkTemp >> 4);
        checkTemp = (char)(checkTemp + 48);
        this.checksum[2] = (byte)checkTemp;
        checkTemp = (char)(check & 0xF);
        checkTemp = (char)(checkTemp + 48);
        this.checksum[3] = (byte)checkTemp;
    }

    private void InsertData(byte[] data, int length) throws MaxLengthException, BadCharacterException {
        if (length > 203) {
            throw new MaxLengthException();
        }
        this.dataLength = length;
        int check = 0;
        check = data[0];
        check = check << 24 >>> 24;
        int i = 0;
        while (i < length) {
            check = data[i];
            if ((check = check << 24 >>> 24) < 32) {
                throw new BadCharacterException();
            }
            ++i;
        }
        System.arraycopy(data, 0, this.messageDown, 4, length);
        this.position += length;
        this.messageData = true;
    }

    private void AppendPostamble() {
        this.messageDown[this.position++] = 5;
        this.messagePost = true;
    }

    private void AppendChecksum() throws Exception {
        this.CalculateChecksum();
        System.arraycopy(this.checksum, 0, this.messageDown, this.position, 4);
        this.messageBcc = true;
        this.position += 4;
    }

    private void AppendTerminator() {
        this.messageDown[this.position] = 3;
        this.messageTer = true;
        ++this.position;
    }

    private void InsertLength() {
        this.messageDown[1] = (byte)(this.dataLength + 4 + 32);
        this.messageBcc = true;
    }

    private void InsertCommand(byte command) {
        this.messageCmd = true;
        this.messageDown[3] = command;
    }

    @Override
    public int CheckMessageIntegrity(byte[] message) throws BadChecksumException {
        int check = 0;
        int check1 = 0;
        char checkTemp = '\u0000';
        int i = 0;
        int dataLeng = message[1] - 32 + 6;
        dataLeng = dataLeng << 24 >>> 24;
        int checksumPos = message[1] - 32 + 1;
        checksumPos = checksumPos << 24 >>> 24;
        byte[] checksumUp = new byte[4];
        Arrays.fill(this.checksum, (byte)0);
        if (message[0] != 1) {
            throw new BadChecksumException(new String("Communication error, message begins with unaccepted character, possibly synchronisation error"));
        }
        this.messageUp = Arrays.copyOf(message, dataLeng);
        checksumUp = Arrays.copyOfRange(this.messageUp, checksumPos, dataLeng - 1);
        i = 1;
        while (i < checksumPos) {
            check1 = 0xFF & this.messageUp[i];
            check = (char)(check + check1);
            ++i;
        }
        checkTemp = (char)(check & 0xF000);
        checkTemp = (char)(checkTemp >> 12);
        checkTemp = (char)(checkTemp + 48);
        this.checksum[0] = (byte)checkTemp;
        checkTemp = (char)(check & 0xF00);
        checkTemp = (char)(checkTemp >> 8);
        checkTemp = (char)(checkTemp + 48);
        this.checksum[1] = (byte)checkTemp;
        checkTemp = (char)(check & 0xF0);
        checkTemp = (char)(checkTemp >> 4);
        checkTemp = (char)(checkTemp + 48);
        this.checksum[2] = (byte)checkTemp;
        checkTemp = (char)(check & 0xF);
        checkTemp = (char)(checkTemp + 48);
        this.checksum[3] = (byte)checkTemp;
        if (Arrays.equals(this.checksum, checksumUp)) {
            return 0;
        }
        throw new BadChecksumException(new String("Bad checksum, message: " + HexDump.toString((byte[])message) + " calculated: " + HexDump.toString((byte[])this.checksum) + " expected: " + HexDump.toString((byte[])checksumUp)));
    }

    @Override
    public void CheckReturnedErrors(byte[] message) throws ErrorPrinterFailed {
        int length = message[1];
        length = length << 24 >>> 24;
        int statusPos = length - 32 - 6;
        statusPos = statusPos << 24 >>> 24;
        byte[] statusBytes = new byte[6];
        ErrorPrinterFailed errorException = new ErrorPrinterFailed();
        statusBytes = Arrays.copyOfRange(message, statusPos, length);
        if ((statusBytes[0] & 0x20) == 32) {
            if ((statusBytes[0] & 8) == 8) {
                errorException.AddError((byte)8, "H|Displej nije povezan! [code=0x0001]", true);
            }
            if ((statusBytes[0] & 0x10) == 16) {
                errorException.AddError((byte)16, "H|Doslo je do mehanickog kvara na printeru(0.4) [code=0x0015]", false);
            }
            if ((statusBytes[0] & 2) == 2) {
                errorException.AddError((byte)2, "H|Printer je primio komandu koju ne raspoznaje(0.1) [code=0x0016]", false);
            }
            if ((statusBytes[0] & 1) == 1) {
                errorException.AddError((byte)1, "H|Printer je primio poruku sa greskom u sintaksi(0.0) [code=0x0017]", false);
            }
            if ((statusBytes[1] & 0x10) == 16) {
                errorException.AddError((byte)16, "H|Detektovane su promene u operativnoj memoriji, obratite se serviseru(1.4) [code=0x0018]", false);
            }
            if ((statusBytes[1] & 4) == 4) {
                errorException.AddError((byte)4, "L|Operativna memorija printera je obrisana(1.2) [code=0x0019]", false);
            }
            if ((statusBytes[1] & 2) == 2) {
                errorException.AddError((byte)2, "H|Komanda nije dozvoljena u ovom printer modu(1.1) [code=0x001A]", false);
            }
            if ((statusBytes[2] & 1) == 1) {
                errorException.AddError((byte)1, "H|Jedna ili obe rolne su bez papira, zamenite rolne! (2.0) [code=0x001B]", false);
            }
            throw errorException;
        }
        if ((statusBytes[0] & 0x20) == 32) {
            if ((statusBytes[4] & 0x10) == 16) {
                errorException.AddError((byte)16, "H|Fiskalna memorija je puna! [code=0x001C]", false);
            }
            if ((statusBytes[4] & 1) == 1) {
                errorException.AddError((byte)1, "H|Upis u fiskalnu memoriju nije moguc! [code=0x001D]", false);
            }
            if ((statusBytes[5] & 4) == 4) {
                errorException.AddError((byte)4, "H|Zadnji dnevni izvestaj nije dobar [code=0x001E]", false);
            }
            if ((statusBytes[5] & 1) == 1) {
                errorException.AddError((byte)1, "H|Fiskalna memorija je podesena na 'READONLY' mod [code=0x001F]", false);
            }
            throw errorException;
        }
    }

    @Override
    public void CheckReturnedInfos(byte[] message) throws InfoPrinterMalfunctions {
        int length = message[1];
        length = length << 24 >>> 24;
        int statusPos = length - 32 - 6;
        statusPos = statusPos << 24 >>> 24;
        byte[] statusBytes = new byte[6];
        InfoPrinterMalfunctions infoException = new InfoPrinterMalfunctions();
        statusBytes = Arrays.copyOfRange(message, statusPos, length);
        if ((statusBytes[0] & 8) == 8) {
            infoException.AddInfo((byte)8, "H|Displej nije povezan! [code=0x0001]", true);
        }
        if ((statusBytes[0] & 4) == 4) {
            infoException.AddInfo((byte)4, "H|Vreme i datum nisu podeseni [code=0x0002]!", true);
        }
        if ((statusBytes[1] & 0x20) == 32) {
            infoException.AddInfo((byte)32, "H|Vrata printera su otvorena(1.5) [code=0x0003]", true);
        }
        if ((statusBytes[1] & 1) == 1) {
            infoException.AddInfo((byte)1, "H|Iznos premasuje dozvoljeni iznos(1.0) [code=0x0004]", true);
        }
        if ((statusBytes[2] & 0x20) == 32) {
            infoException.AddInfo((byte)32, "H|Tekstualni racun otvoren(2.5) [code=0x0005]", true);
        }
        if ((statusBytes[2] & 0x10) == 16) {
            infoException.AddInfo((byte)16, "H|Kontrolna rolna je jos malo pri kraju, zamenite je!(2.4) [code=0x0007]", true);
        }
        if ((statusBytes[2] & 4) == 4) {
            infoException.AddInfo((byte)4, "H|Nema vise papira na kontrolnoj rolni! (2.2) [code=0x0008]", true);
        }
        if ((statusBytes[2] & 2) == 2) {
            infoException.AddInfo((byte)2, "H|Jedna ili obe rolne su skoro prazne, zamenite rolne! [code=0x0009]", true);
        }
        if ((statusBytes[2] & 8) == 8) {
            infoException.AddInfo((byte)8, "H|Racun otvoren [code=0x000A]", true);
        }
        if ((statusBytes[3] & 8) == 8) {
            infoException.AddInfo((byte)8, "L|Baud rate podesen [code=0x000B]", true);
        }
        if ((statusBytes[3] & 4) == 4) {
            infoException.AddInfo((byte)4, "L|Dsplej - transparentni mod podesen [code=0x000C]", true);
        }
        if ((statusBytes[3] & 1) == 1) {
            infoException.AddInfo((byte)1, "L|Dozvoljeno automatsko secenje papira [code=0x000D]", true);
        }
        if ((statusBytes[4] & 8) == 8) {
            infoException.AddInfo((byte)8, "M|Fiskalna memorija ima manje od 50 slobodnih mesta! [code=0x000E]", true);
        }
        if ((statusBytes[4] & 4) == 4) {
            infoException.AddInfo((byte)4, "H|Ne postoji fiskalni modul u printeru [code=0x000F]", true);
        }
        if ((statusBytes[5] & 0x20) == 32) {
            infoException.AddInfo((byte)32, "L|Serijski broj i fiskalni broj podeseni [code=0x0010]", false);
        }
        if ((statusBytes[5] & 0x10) == 16) {
            infoException.AddInfo((byte)16, "L|Poreske stope su podesene barem jednom [code=0x0011]", false);
        }
        if ((statusBytes[5] & 8) == 8) {
            infoException.AddInfo((byte)8, "L|Fiskalni mod ukljucen [code=0x0012]", false);
        } else {
            infoException.AddInfo((byte)8, "L|Fiskalni mod iskljucen [code=0x0013]", false);
        }
        if ((statusBytes[5] & 2) == 2) {
            infoException.AddInfo((byte)2, "L|Fiskalna memorija obrisana [code=0x0014]", true);
        }
        throw infoException;
    }

    @Override
    public void CheckReturnedData(byte[] message, Messages data) {
        byte length = message[1];
        int dataEnd = length - 32 - 6 - 1;
        dataEnd = dataEnd << 24 >>> 24;
        int dataBegin = 4;
        byte[] dataBytes = new byte[215];
        dataBytes = Arrays.copyOfRange(message, dataBegin, dataEnd);
        data.SetMessage(message[3], (byte)0, new String(dataBytes));
    }

    @Override
    public void ClearData(Messages data) {
        data.ClearData();
    }
}

