/*
 * Decompiled with CFR 0.152.
 */
package G;

import BI.AD;
import BI.UC;
import G.F;
import G.N;
import G.O;
import G.S;
import N.Z;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class J
extends AD
implements F,
O {
    public ByteBuffer m_data;
    public int m_nWidth = 0;
    public int m_nHeight = 0;
    public int m_nHorizRes = 9525;
    public int m_nVertRes = 9525;
    public int m_nPixelDepth = 24;
    public int m_nPlanes = 1;
    public int m_compression = 0;
    public int m_nImageSize = 0;
    public int m_nColorsUsed = 0;
    public int m_nColorsImportant = 0;
    public int[] m_palette;

    public static boolean isCompatibleImage(ByteBuffer byteBuffer) {
        ByteOrder byteOrder = byteBuffer.order();
        try {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            int n = byteBuffer.position();
            int n2 = byteBuffer.getInt(n);
            if (byteBuffer.get(n) == 66 && byteBuffer.get(n + 1) == 77) {
                n2 = byteBuffer.getInt(n + 14);
            }
            boolean bl = n2 == 12 || n2 == 40;
            byteBuffer.order(byteOrder);
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            byteBuffer.order(byteOrder);
            return bl;
        }
    }

    public J(ByteBuffer byteBuffer) throws UC {
        int n;
        this.m_data = byteBuffer.duplicate();
        this.m_data.order(ByteOrder.LITTLE_ENDIAN);
        this.m_data.mark();
        if (this.m_data.get() == 66 && this.m_data.get() == 77) {
            Z.skip(this.m_data, 12);
        } else {
            this.m_data.reset();
        }
        int n2 = this.m_data.getInt();
        if (n2 != 40 && n2 != 12) {
            throw new IllegalArgumentException();
        }
        if (n2 == 40) {
            this.m_nWidth = this.m_data.getInt();
            this.m_nHeight = this.m_data.getInt();
            this.m_nPlanes = this.m_data.getShort();
            this.m_nPixelDepth = this.m_data.getShort();
            this.m_compression = this.m_data.getInt();
            this.m_nImageSize = this.m_data.getInt();
            n = this.m_data.getInt();
            this.m_nHorizRes = n != 0 ? 36000000 / n : 9525;
            int n3 = this.m_data.getInt();
            this.m_nVertRes = n3 != 0 ? 36000000 / n3 : 9525;
            this.m_nColorsUsed = this.m_data.getInt();
            this.m_nColorsImportant = this.m_data.getInt();
        } else {
            this.m_nWidth = this.m_data.getShort();
            this.m_nHeight = this.m_data.getShort();
            this.m_nPlanes = this.m_data.getShort();
            this.m_nPixelDepth = this.m_data.getShort();
        }
        if (this.m_nWidth <= 0 || this.m_nHeight <= 0 || this.m_nPlanes != 1 || this.m_nPixelDepth != 0 && this.m_nPixelDepth != 1 && this.m_nPixelDepth != 4 && this.m_nPixelDepth != 8 && this.m_nPixelDepth != 16 && this.m_nPixelDepth != 24 && this.m_nPixelDepth != 32 || this.m_compression < 0 || this.m_compression > 3 || this.m_nImageSize < 0 || this.m_nHorizRes < 0 || this.m_nVertRes < 0 || this.m_nColorsUsed < 0 || this.m_nColorsImportant < 0) {
            throw new IllegalArgumentException();
        }
        if (this.m_compression < 0 || this.m_compression > 2) {
            throw new IllegalArgumentException();
        }
        if (this.m_nPixelDepth <= 8) {
            if (this.m_nColorsUsed == 0) {
                this.m_nColorsUsed = 1 << this.m_nPixelDepth;
            }
            if (this.m_nColorsUsed > 0) {
                this.m_palette = new int[this.m_nColorsUsed];
                for (n = 0; n < this.m_nColorsUsed; ++n) {
                    this.m_palette[n] = n2 == 12 ? this.m_data.get() & 0xFF | (this.m_data.get() & 0xFF) << 8 | (this.m_data.get() & 0xFF) << 16 | 0xFF000000 : this.m_data.getInt() | 0xFF000000;
                }
            }
        }
    }

    public S getFormat() {
        return eFormatDIB;
    }

    public int getHeight() {
        return this.m_nHeight;
    }

    public int getWidth() {
        return this.m_nWidth;
    }

    public int getHorizRes() {
        return this.m_nHorizRes;
    }

    public int getVertRes() {
        return this.m_nVertRes;
    }

    public int getEmuHeight() {
        return this.m_nHeight * this.m_nVertRes;
    }

    public int getEmuWidth() {
        return this.m_nWidth * this.m_nHorizRes;
    }

    public int[] getPalette() {
        return this.m_palette;
    }

    public boolean isGrayscale() {
        return false;
    }

    public void getImageData(N n, boolean bl) {
    }
}

