/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import rs.pezar.db.commons.PzParameter;

public class PzFileUtility {
    public static InputStream getReportFileAsInputStream(String path, ClassLoader loader) throws IOException {
        File reportFileLocal = null;
        String reportsDir = PzParameter.getParameterValue("REPORTS_DIR");
        if (reportsDir != null && !reportsDir.equals("")) {
            String reportName = path.substring(path.lastIndexOf(47) + 1);
            String localPath = String.valueOf(reportsDir) + File.separator + reportName;
            if (new File(localPath).exists()) {
                reportFileLocal = new File(localPath);
            }
        }
        if (reportFileLocal == null) {
            return loader.getResource(path).openStream();
        }
        FileInputStream is = new FileInputStream(reportFileLocal);
        return is;
    }

    public static InputStream getReportFileAsInputStreamURL(URL path, ClassLoader loader) throws IOException {
        File reportFileLocal = null;
        String reportFileName = path.getFile();
        String reportsDir = PzParameter.getParameterValue("REPORTS_DIR");
        if (reportsDir != null && !reportsDir.equals("")) {
            String reportName = reportFileName.substring(reportFileName.lastIndexOf(47) + 1);
            String localPath = String.valueOf(reportsDir) + File.separator + reportName;
            if (new File(localPath).exists()) {
                reportFileLocal = new File(localPath);
            }
        }
        if (reportFileLocal == null) {
            return path.openStream();
        }
        FileInputStream is = new FileInputStream(reportFileLocal);
        return is;
    }

    public static InputStream getFileAsInputStream(String path, ClassLoader loader) throws IOException {
        return loader.getResource(path).openStream();
    }

    public static Document loadXML(String path) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputStreamReader reader = new InputStreamReader(ClassLoader.getSystemClassLoader().getResource(path).openStream(), "UTF8");
        BufferedReader input = new BufferedReader(reader);
        String xml = "";
        while (input.ready()) {
            xml = String.valueOf(xml) + input.readLine();
        }
        input.close();
        xml = xml.replaceAll(">.*?<", "><").replaceAll("\\s+", " ");
        return builder.parse(new ByteArrayInputStream(xml.getBytes("UTF-8")));
    }

    public static Document loadXML(String path, ClassLoader loader) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputStreamReader reader = new InputStreamReader(loader.getResourceAsStream(path), "UTF8");
        BufferedReader input = new BufferedReader(reader);
        String xml = "";
        while (input.ready()) {
            xml = String.valueOf(xml) + input.readLine();
        }
        input.close();
        xml = xml.replaceAll("<!\\-\\-.*?\\-\\->", "").replaceAll(">.*?<", "><").replaceAll("\\s+", " ");
        return builder.parse(new ByteArrayInputStream(xml.getBytes("UTF-8")));
    }

    public static void copyFile(InputStream is, OutputStream os) throws IOException {
        int i = 0;
        while ((i = is.read()) != -1) {
            os.write(i);
        }
        os.close();
    }

    public static void copyFile(String sourcePath, String destPath) throws IOException {
        FileInputStream is = new FileInputStream(new File(sourcePath));
        new File(destPath);
        FileOutputStream os = new FileOutputStream(new File(destPath));
        PzFileUtility.copyFile(is, os);
        ((InputStream)is).close();
        ((OutputStream)os).close();
    }

    public static boolean removeDirectory(File directory) {
        if (directory == null) {
            return false;
        }
        if (!directory.exists()) {
            return true;
        }
        if (!directory.isDirectory()) {
            return false;
        }
        String[] list = directory.list();
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                File entry = new File(directory, list[i]);
                if (entry.isDirectory() ? !PzFileUtility.removeDirectory(entry) : !entry.delete()) {
                    return false;
                }
                ++i;
            }
        }
        return directory.delete();
    }
}

