/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.custom;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Email;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Tipemaila;
import rs.pezar.swing.PzBusyPainterUI;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.custom.PzDialogEmailPretraga;
import rs.pezar.swing.custom.PzDialogPretragaKomitenta;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzTextAreaPanel;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzMail;

public class PzDialogEmail
extends PzDialog {
    private static final long serialVersionUID = -2543375843088240489L;
    private PzPanel mainPanel;
    private PzTextField to;
    private PzButton btnPronadji;
    private PzButton btnSend;
    private JPanel pnlButton;
    private JLabel fileName;
    private JLabel jLabel4;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzTextAreaPanel body;
    private PzTextField subject;
    private PzPanelHeader header;
    private MimeMessage message;
    private MimeBodyPart attachment;
    private PzBusyPainterUI layerUI;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PzDialogEmail inst = new PzDialogEmail(frame);
                inst.setVisible(true);
            }
        });
    }

    public PzDialogEmail(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    public PzDialogEmail(PzDialog parent) {
        super(parent);
        this.initGUI();
        this.loadAddresses();
    }

    public PzDialogEmail(PzDialog parent, ByteArrayOutputStream fs, String fileName) {
        this(parent, fs, fileName, "");
    }

    public PzDialogEmail(PzDialog parent, ByteArrayOutputStream fs, String fileName, String subject) {
        super(parent);
        this.initGUI();
        try {
            String f = fileName != null ? PzDialogEmail.normalizeAttachmentName(fileName) : "pezar.report.pdf";
            this.attachment = new MimeBodyPart();
            ByteArrayDataSource fileDataSource = new ByteArrayDataSource(fs.toByteArray(), "application/pdf");
            this.attachment.setDataHandler(new DataHandler((DataSource)fileDataSource));
            this.attachment.setFileName(f);
            this.fileName.setText(f);
            this.subject.setText(subject);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        this.loadAddresses();
    }

    public static String normalizeAttachmentName(String input) {
        String pattern = PzParameter.getParameterValue("EMAIL_ATTACHMENT_PATTERN");
        String attachment = String.valueOf(input.replaceAll("\u0161", "s").replaceAll("\u0160", "S").replaceAll("\u010d|\u0107", "c").replaceAll("\u010c|\u0106", "C").replaceAll("\u0111", "dj").replaceAll("\u0110", "Dj").replaceAll("\u017e", "z").replaceAll("\u017d", "Z").replaceAll("\\.", " ").replaceAll("\\s+", ".").replaceAll("\\\\|/|\\-|\\:", "-")) + ".pdf";
        if (pattern == null) {
            return attachment;
        }
        return pattern.replace("$attachment", attachment);
    }

    private void loadAddresses() {
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        List addresses = em.createQuery("SELECT e.adresa FROM Email e").getResultList();
        em.close();
        this.to.setAutocompletionActivated(true);
        this.to.setAutoCompletionList(addresses);
    }

    private void initGUI() {
        try {
            this.setTitle("Slanje email-om");
            this.header = new PzPanelHeader();
            this.header.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("rs/pezar/swing/resources/img/mail_earth.png")));
            this.header.setTitle("Slanje dokumenta email-om");
            this.header.setText("Unesite email adresu i poruku");
            this.getContentPane().add((Component)this.header, "North");
            this.header.setPreferredSize(new Dimension(530, 65));
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.layerUI = new PzBusyPainterUI();
            JXLayer layer = new JXLayer((Component)this.mainPanel, (LayerUI)this.layerUI);
            this.getContentPane().add((Component)layer, "Center");
            this.mainPanel.setLayout(mainPanelLayout);
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
            mainPanelLayout.columnWeights = new double[]{0.0, 0.1, 0.0};
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            mainPanelLayout.rowHeights = new int[]{7, 7, 7, 7, 7, 7};
            mainPanelLayout.columnWidths = new int[]{7, 339, 7};
            this.to = new PzTextField();
            this.mainPanel.add((Component)this.to, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 5), 0, 0));
            this.to.setFont(new Font("Tahoma", 0, 14));
            this.subject = new PzTextField();
            this.mainPanel.add((Component)this.subject, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.subject.setFont(new Font("Tahoma", 0, 14));
            this.body = new PzTextAreaPanel();
            this.body.setAreaFont(new Font("Tahoma", 0, 14));
            this.mainPanel.add((Component)this.body, new GridBagConstraints(0, 4, 3, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel1 = new JLabel();
            this.mainPanel.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel1.setText("Adresa primaoca:");
            this.jLabel2 = new JLabel();
            this.mainPanel.add((Component)this.jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel2.setText("Naslov poruke:");
            this.jLabel3 = new JLabel();
            this.mainPanel.add((Component)this.jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
            this.jLabel3.setText("Dokument koji se \u0161alje:");
            this.jLabel4 = new JLabel();
            this.mainPanel.add((Component)this.jLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 0), 0, 0));
            this.jLabel4.setText("Tekst poruke:");
            this.fileName = new JLabel();
            this.mainPanel.add((Component)this.fileName, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 2, new Insets(2, 0, 2, 0), 0, 0));
            this.fileName.setText("file");
            this.fileName.setForeground(new Color(0, 0, 160));
            this.fileName.setFont(new Font("Tahoma", 1, 12));
            this.btnPronadji = new PzButton("Prona\u0111i");
            this.btnPronadji.setActionCommand("pronadji");
            this.btnPronadji.addActionListener(this);
            this.mainPanel.add((Component)this.btnPronadji, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 2, 0), 0, 0));
            this.pnlButton = new JPanel();
            this.getContentPane().add((Component)this.pnlButton, "South");
            this.pnlButton.setPreferredSize(new Dimension(530, 49));
            this.btnSend = new PzButton();
            this.pnlButton.add(this.btnSend);
            this.btnSend.setText("\u0160alji");
            this.btnSend.setPreferredSize(new Dimension(125, 32));
            this.btnSend.addActionListener(this);
            this.btnSend.setActionCommand("send");
            this.setSize(800, 600);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("send")) {
            Pzuser user = PzApplication.getApplication().getSession().getLoggedUser();
            this.btnSend.setEnabled(false);
            try {
                if (this.to.getVal().equals("")) {
                    PzSwingUtility.showErrorMessage(this, "Niste uneli adresu primaoca.");
                    this.btnSend.setEnabled(true);
                    return;
                }
                this.message = PzMail.getMimeMessage();
                String addr = null;
                if (user.getEmail(1) == null) {
                    Firma f = (Firma)PzEntityManager.find(Firma.class, 1);
                    if (f.getEmail() == null) {
                        throw new AddressException("Nemate pode\u0161en poslovni email korisnika, niti email firme u sistemu. Slanje poruke Vam je zbog toga onemogu\u0107eno.");
                    }
                    addr = f.getEmail();
                } else {
                    addr = user.getEmail(1).getAdresa();
                }
                this.message.setFrom((Address)new InternetAddress(addr, String.valueOf(user.getPzuserInfo().getIme()) + " " + user.getPzuserInfo().getPrezime() + " [ " + PzFirma.getFirma().getNaziv() + " ]"));
                this.message.setReplyTo((Address[])new InternetAddress[]{new InternetAddress(addr, String.valueOf(user.getPzuserInfo().getIme()) + " " + user.getPzuserInfo().getPrezime() + " [ " + PzFirma.getFirma().getNaziv() + " ]")});
                Address[] to = this.getRecipients();
                this.message.setRecipients(Message.RecipientType.TO, to);
                this.message.setSubject(this.subject.getVal());
                MimeBodyPart msgBody = new MimeBodyPart();
                msgBody.setText(new String(this.body.getVal().getBytes("UTF-8")));
                MimeMultipart mp = new MimeMultipart();
                mp.addBodyPart((BodyPart)msgBody);
                mp.addBodyPart((BodyPart)this.attachment);
                this.message.setContent((Multipart)mp);
                this.layerUI.setLocked(true);
                this.sendMessage();
            }
            catch (Exception e1) {
                PzMysqlExceptionHandler.handle(this, e1);
                this.btnSend.setEnabled(true);
            }
        } else if (e.getActionCommand().equals("pronadji")) {
            PzDialogEmailPretraga dlg = new PzDialogEmailPretraga(this);
            dlg.setCloseOnEnter(true);
            this.showDialog(dlg);
            Email email = (Email)PzTable.selectedEntity;
            PzTable.selectedEntity = null;
            if (email != null) {
                this.to.setVal(email.getAdresa());
            }
        }
    }

    private Address[] getRecipients() throws AddressException {
        String[] rcpStr = this.to.getText().split(",");
        Address[] recipients = new Address[rcpStr.length];
        int i = 0;
        while (i < rcpStr.length) {
            recipients[i] = new InternetAddress(rcpStr[i].trim());
            ++i;
        }
        return recipients;
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogEmail(Boolean.FALSE);
    }

    public PzDialogEmail(Boolean initGUI) {
    }

    public void run() {
        try {
            this.layerUI.setLocked(true);
            Transport.send((Message)this.message);
            this.layerUI.setLocked(false);
            JOptionPane.showMessageDialog(this, "Poruka je uspe\u0161no poslata", "Slanje poruke", 1);
            this.btnSend.setEnabled(true);
        }
        catch (MessagingException e) {
            this.layerUI.setLocked(false);
            JOptionPane.showMessageDialog(this, "Do\u0161lo je do gre\u0161ke pri slanju poruke. Poruka nije poslata.", "Slanje poruke", 0);
            PzMysqlExceptionHandler.handle(e);
            this.btnSend.setEnabled(true);
        }
    }

    private void sendMessage() {
        SwingWorker<Object, Object> sender = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                Transport.send((Message)PzDialogEmail.this.message);
                return null;
            }

            @Override
            protected void done() {
                try {
                    try {
                        this.get();
                        JOptionPane.showMessageDialog(PzDialogEmail.this, "Poruka je uspe\u0161no poslata", "Slanje poruke", 1);
                        PzDialogEmail.this.saveAddress();
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(PzDialogEmail.this, "Do\u0161lo je do gre\u0161ke pri slanju poruke. Poruka nije poslata.", "Slanje poruke", 0);
                        PzMysqlExceptionHandler.handle(e);
                        PzDialogEmail.this.layerUI.setLocked(false);
                        PzDialogEmail.this.btnSend.setEnabled(true);
                    }
                }
                finally {
                    PzDialogEmail.this.layerUI.setLocked(false);
                    PzDialogEmail.this.btnSend.setEnabled(true);
                }
            }
        };
        sender.execute();
    }

    protected void saveAddress() throws AddressException {
        Address[] adr = this.getRecipients();
        int i = 0;
        while (i < adr.length) {
            block15: {
                InternetAddress address = (InternetAddress)adr[i];
                EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                Email email = (Email)em.find(Email.class, (Object)address.getAddress());
                if (email == null) {
                    int ch = PzSwingUtility.daNeDijalog(this, "Email " + address.getAddress() + " ne postoji u sistemu. Da li \u017eelite da je sa\u010duvate?", "Nepostoje\u0107a adresa", null, false);
                    if (ch == 0) {
                        this.showDialog(PzDialogPretragaKomitenta.class);
                        Komitent k = null;
                        try {
                            k = (Komitent)this.getSession().getParameter("email_komitent");
                        }
                        catch (Exception exception) {}
                        if (k == null) {
                            em.close();
                        } else {
                            this.getSession().putParameter("email_komitent", null);
                            try {
                                try {
                                    em.getTransaction().begin();
                                    Tipemaila tipEmaila = (Tipemaila)em.find(Tipemaila.class, (Object)1);
                                    if (tipEmaila == null) {
                                        tipEmaila = new Tipemaila();
                                        tipEmaila.setIdTipEmaila(1);
                                        tipEmaila.setNaziv("POSLOVNI EMAIL");
                                        tipEmaila.setPredefinisan(0);
                                        em.persist((Object)tipEmaila);
                                    }
                                    email = new Email();
                                    email.setAdresa(address.getAddress());
                                    email.setKomitent(k);
                                    email.setTipEmaila(tipEmaila);
                                    em.persist((Object)email);
                                    em.getTransaction().commit();
                                    JOptionPane.showMessageDialog(this, "Email adresa uspe\u0161no sa\u010duvana za komitenta " + k.getNaziv(), "Snimanje email adrese u bazu", 1);
                                }
                                catch (Exception e) {
                                    if (em.getTransaction().isActive()) {
                                        em.getTransaction().rollback();
                                    }
                                    PzMysqlExceptionHandler.handle(this, e);
                                    em.close();
                                    break block15;
                                }
                            }
                            catch (Throwable throwable) {
                                em.close();
                                throw throwable;
                            }
                            em.close();
                        }
                    } else {
                        em.close();
                    }
                }
            }
            ++i;
        }
        this.dispose();
    }
}

