/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing.custom;

import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.swing.SwingWorker;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.swing.custom.PzLoginDialog;
import rs.pezar.swing.custom.PzLoginException;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.UserLockUtility;

class Logger
extends SwingWorker<Object, Object> {
    private final PzLoginDialog caller;
    private final String username;
    private final String password;
    EntityManager em;

    public Logger(PzLoginDialog caller, String username, String password) {
        this.caller = caller;
        this.username = username;
        this.password = password;
    }

    @Override
    protected Object doInBackground() throws Exception {
        this.em = PzEntityManager.getEm();
        Object rez = this.em.createQuery("SELECT user FROM Pzuser user WHERE user.pzusername =:username AND user.password =:pass").setParameter("username", (Object)this.username).setParameter("pass", (Object)this.password).getSingleResult();
        return rez;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void done() {
        try {
            try {
                Pzuser u = (Pzuser)this.get();
                if (!u.isAdministrator() && !PzParameter.getBoolean("LOGOVANJE_DOZVOLJENO", true, this.em).booleanValue()) {
                    throw new PzInfoException("Pristup sistemu je iz tehni\u010dkih razloga zabranjen. Poku\u0161ajte kasnije.");
                }
                if (u.getStatus() == 0) {
                    throw new PzInfoException("Ne mo\u017eete pristupiti sistemu jer vam je nalog deaktiviran. Obratite se moderatoru sistema.");
                }
                PzApplication.getApplication().getSession().setLoggedUser(u);
                PzApplication.getApplication().getLocalMachineUserSettings().setProperty("KOR.IME", u.getPzusername());
                UserLockUtility.lockCurrentUser();
                this.caller.loginSucceed();
                return;
            }
            catch (UserLockUtility.UserLockException e) {
                PzSwingUtility.showErrorMessage(this.caller, e.getMessage());
                this.caller.unlockPanel();
                if (this.em == null) return;
                this.em.close();
                return;
            }
            catch (Exception e) {
                if (e.getCause() instanceof NoResultException) {
                    this.caller.loginFailed();
                } else if (e.getCause() instanceof PersistenceException) {
                    this.caller.wrongDatabase();
                } else if (e.getCause() instanceof PzLoginException) {
                    this.caller.loginForbidden();
                } else {
                    PzMysqlExceptionHandler.handle(this.caller, e);
                }
                this.caller.unlockPanel();
                if (this.em == null) return;
                this.em.close();
                return;
            }
        }
        finally {
            if (this.em != null) {
                this.em.close();
            }
        }
    }
}

