/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityUtil;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.data.models.PzManageableTableModel;
import rs.pezar.swing.event.PzTableCheckboxListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;

public abstract class PzManageableTable
extends PzAbstractTable {
    private static final long serialVersionUID = -5326310691941847270L;
    private Vector<PzEntity> entitiesAdded;
    private Vector<Integer> entitiesAddedIndexes;
    private PzEntityFilter filter;
    private PzManageableTableModel model;
    private int columnIndex = -1;

    public PzManageableTable() {
    }

    public PzManageableTable(TableModel model) {
        super(model);
    }

    public void insertGUI(PzEntity entity) {
        this.insertGUI(entity, true);
    }

    public void insertGUI(PzEntity entity, boolean calculate) {
        ((PzManageableTableModel)this.getModel()).insert(entity);
        int index = ((PzManageableTableModel)this.getModel()).getRowCount() - 1;
        ((PzManageableTableModel)this.getModel()).fireTableRowsInserted(index, index);
        if (this.getRowCount() == 1) {
            this.restoreState();
        }
        if (calculate) {
            this.calculateFields();
            this.restoreState();
        }
        this.setRowSelectionInterval(index, index);
        this.scrollCellToVisible(index, 0);
    }

    public void updateGUI(int index, PzEntity entity) {
        int i = this.convertRowIndexToModel(index);
        ((PzManageableTableModel)this.getModel()).update(this.convertRowIndexToModel(index), entity);
        ((PzManageableTableModel)this.getModel()).fireTableRowsUpdated(i, i);
        this.autoRecalculateFields();
        if (this.getSelectedRow() != index) {
            this.setRowSelectionInterval(index, index);
        }
    }

    public void removeGUI(int index) {
        int i = this.convertRowIndexToModel(index);
        ((PzManageableTableModel)this.getModel()).remove(this.convertRowIndexToModel(index));
        ((PzManageableTableModel)this.getModel()).fireTableRowsDeleted(i, i);
        this.calculateFields();
        if (index > 0) {
            this.setRowSelectionInterval(index - 1, index - 1);
        } else if (this.getRowCount() > 0) {
            this.setRowSelectionInterval(this.convertRowIndexToView(index), this.convertRowIndexToView(index));
        }
    }

    public PzEntity getSelectedEntity() {
        if (this.getSelectedRow() == -1) {
            return null;
        }
        return ((PzManageableTableModel)this.getModel()).getEntity(this.convertRowIndexToModel(this.getSelectedRow()));
    }

    public void updateSelectedEntityGUI(PzEntity entity) {
        this.updateGUI(this.convertRowIndexToModel(this.getSelectedRow()), entity);
    }

    public void removeSelectedEntityGUI() {
        this.removeGUI(this.getSelectedRow());
    }

    public boolean insert(PzEntity entity, boolean toDatabase) {
        try {
            if (toDatabase) {
                if (entity instanceof PzDokument) {
                    PzDokumentManager.getInstance().snimiDokument((PzDokument)entity, true, null);
                } else {
                    PzEntityManager.insert(entity);
                }
            }
            this.insertGUI(entity);
            this.setRowSelectionInterval(this.getRowCount() - 1, this.getRowCount() - 1);
            return true;
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(SwingUtilities.getRoot((Component)((Object)this)), e);
            return false;
        }
    }

    public boolean insert(PzEntity entity, EntityManager em) {
        try {
            if (this.entitiesAdded == null) {
                this.entitiesAdded = new Vector();
            }
            this.entitiesAdded.addElement(entity);
            if (entity instanceof PzDokument) {
                PzDokumentManager.getInstance().snimiDokument((PzDokument)entity, true, null, em);
            } else {
                PzEntityManager.insert(entity, em);
            }
            return true;
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(SwingUtilities.getRoot((Component)((Object)this)), e);
            return false;
        }
    }

    public void commitInsert() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PzManageableTable.this.entitiesAdded != null) {
                    for (PzEntity entity : PzManageableTable.this.entitiesAdded) {
                        PzManageableTable.this.insertGUI(entity, false);
                    }
                    PzManageableTable.this.entitiesAdded.clear();
                    PzManageableTable.this.entitiesAdded = null;
                }
                PzManageableTable.this.calculateFields();
                PzManageableTable.this.restoreState();
                if (PzManageableTable.this.getRowCount() > 0) {
                    PzManageableTable.this.setRowSelectionInterval(PzManageableTable.this.getRowCount() - 1, PzManageableTable.this.getRowCount() - 1);
                }
            }
        });
    }

    public boolean remove(int index, Class<?> c, Object key, boolean fromDatabase) {
        try {
            if (index != -1) {
                if (fromDatabase) {
                    PzEntityManager.delete(c, key);
                }
                this.removeGUI(index);
                this.selectRow(index);
            }
            return true;
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(SwingUtilities.getRoot((Component)((Object)this)), e);
            return false;
        }
    }

    public boolean remove(int index, boolean ask, EntityManager em) {
        try {
            boolean removed = false;
            if (ask) {
                int rez = JOptionPane.showConfirmDialog(SwingUtilities.getRoot((Component)((Object)this)), "Da li ste sigurni?!", "Brisanje", 0);
                if (rez == 0) {
                    removed = this.getEntity(index) instanceof PzDokument ? this.remove(index, this.getEntity(index).getClass(), (Object)((PzDokument)this.getEntity(index)).getIdDok(), em) : this.remove(index, this.getEntity(index).getClass(), (Object)((PzDokument)this.getEntity(index)).getIdDok(), em);
                }
            } else {
                removed = this.remove(index, this.getEntity(index).getClass(), PzEntityUtil.getID(this.getEntity(index)), em);
            }
            return removed;
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(SwingUtilities.getRoot((Component)((Object)this)), e);
            return false;
        }
    }

    public boolean remove(int index, Class<?> c, Object key, EntityManager em) {
        try {
            if (index != -1) {
                PzEntityManager.delete(c, key, em);
            }
            if (this.entitiesAddedIndexes == null) {
                this.entitiesAddedIndexes = new Vector();
            }
            this.entitiesAddedIndexes.addElement(index);
            return true;
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(SwingUtilities.getRoot((Component)((Object)this)), e);
            return false;
        }
    }

    public void commitRemove() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PzManageableTable.this.entitiesAddedIndexes != null && PzManageableTable.this.entitiesAddedIndexes.size() > 0) {
                    Collections.sort(PzManageableTable.this.entitiesAddedIndexes);
                    int i = PzManageableTable.this.entitiesAddedIndexes.size() - 1;
                    while (i > -1) {
                        PzManageableTable.this.removeGUI((Integer)PzManageableTable.this.entitiesAddedIndexes.elementAt(i));
                        --i;
                    }
                    PzManageableTable.this.entitiesAddedIndexes.clear();
                    PzManageableTable.this.entitiesAddedIndexes = null;
                }
            }
        });
    }

    public boolean removeSelectedEntity(boolean ask, boolean fromDatabase) {
        if (this.getSelectedEntity() == null) {
            return false;
        }
        boolean removed = false;
        if (ask) {
            int rez = PzSwingUtility.daNeDijalog(SwingUtilities.getRoot((Component)((Object)this)), "Da li ste sigurni?!", "Brisanje", null, false);
            if (rez == 0) {
                removed = this.getSelectedEntity() instanceof PzDokument ? this.remove(this.getSelectedRow(), this.getSelectedEntity().getClass(), (Object)((PzDokument)this.getSelectedEntity()).getIdDok(), fromDatabase) : this.remove(this.getSelectedRow(), this.getSelectedEntity().getClass(), PzEntityUtil.getID(this.getSelectedEntity()), fromDatabase);
            }
        } else {
            removed = this.getSelectedEntity() instanceof PzDokument ? this.remove(this.getSelectedRow(), this.getSelectedEntity().getClass(), (Object)((PzDokument)this.getSelectedEntity()).getIdDok(), fromDatabase) : this.remove(this.getSelectedRow(), this.getSelectedEntity().getClass(), PzEntityUtil.getID(this.getSelectedEntity()), fromDatabase);
        }
        return removed;
    }

    public boolean removeSelectedEntity(boolean ask, EntityManager em) {
        if (this.getSelectedEntity() == null) {
            return false;
        }
        boolean removed = false;
        if (ask) {
            Object[] options = new Object[]{"Da", "Ne"};
            int rez = JOptionPane.showOptionDialog(SwingUtilities.getRoot((Component)((Object)this)), "Da li ste sigurni?!", "Brisanje", 0, 3, null, options, options[0]);
            if (rez == 0) {
                removed = this.remove(this.getSelectedRow(), this.getSelectedEntity().getClass(), PzEntityUtil.getID(this.getSelectedEntity()), em);
            }
        } else {
            removed = this.remove(this.getSelectedRow(), this.getSelectedEntity().getClass(), PzEntityUtil.getID(this.getSelectedEntity()), em);
        }
        return removed;
    }

    public boolean removeSelectedEntity(Object key, boolean ask, boolean fromDatabase) {
        if (this.getSelectedEntity() == null) {
            return false;
        }
        boolean removed = false;
        if (ask) {
            int rez = JOptionPane.showConfirmDialog(SwingUtilities.getRoot((Component)((Object)this)), "Da li ste sigurni?!", "Brisanje", 0);
            if (rez == 0) {
                removed = this.remove(this.getSelectedRow(), this.getSelectedEntity().getClass(), key, fromDatabase);
            }
        } else {
            removed = this.remove(this.getSelectedRow(), this.getSelectedEntity().getClass(), key, fromDatabase);
        }
        return removed;
    }

    public boolean removeSelectedEntity(Object key, boolean ask, EntityManager em) {
        if (this.getSelectedEntity() == null) {
            return false;
        }
        boolean removed = false;
        if (ask) {
            int rez = JOptionPane.showConfirmDialog(SwingUtilities.getRoot((Component)((Object)this)), "Da li ste sigurni?!", "Brisanje", 0);
            if (rez == 0) {
                removed = this.remove(this.getSelectedRow(), this.getSelectedEntity().getClass(), key, em);
            }
        } else {
            removed = this.remove(this.getSelectedRow(), this.getSelectedEntity().getClass(), key, em);
        }
        return removed;
    }

    public boolean update(Integer index, PzEntity entity, boolean inDatabase) {
        try {
            if (inDatabase) {
                if (entity instanceof PzDokument) {
                    PzDokumentManager.getInstance().snimiDokument((PzDokument)entity, true, null);
                } else {
                    PzEntityManager.update(entity);
                }
            }
            this.updateGUI(index, entity);
            this.selectRow(index);
            return true;
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(SwingUtilities.getRoot((Component)((Object)this)), e);
            return false;
        }
    }

    public boolean update(Integer index, PzEntity entity, EntityManager em) {
        try {
            if (entity instanceof PzDokument) {
                PzDokumentManager.getInstance().snimiDokument((PzDokument)entity, true, null, em);
            } else {
                PzEntityManager.update(entity, em);
            }
            if (this.entitiesAdded == null) {
                this.entitiesAdded = new Vector();
            }
            this.entitiesAdded.addElement(entity);
            if (this.entitiesAddedIndexes == null) {
                this.entitiesAddedIndexes = new Vector();
            }
            this.entitiesAddedIndexes.addElement(index);
            return true;
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(SwingUtilities.getRoot((Component)((Object)this)), e);
            return false;
        }
    }

    public boolean updateSelectedEntity(PzEntity newEntity, boolean inDatabase) {
        try {
            if (inDatabase) {
                if (newEntity instanceof PzDokument) {
                    PzDokumentManager.getInstance().snimiDokument((PzDokument)newEntity, true, null);
                } else {
                    PzEntityManager.update(newEntity);
                }
            }
            this.updateGUI(this.getSelectedRow(), newEntity);
            return true;
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(SwingUtilities.getRoot((Component)((Object)this)), e);
            return false;
        }
    }

    public boolean updateSelectedEntity(PzEntity newEntity, EntityManager em) {
        try {
            return this.update((Integer)this.getSelectedRow(), newEntity, em);
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle(SwingUtilities.getRoot((Component)((Object)this)), e);
            return false;
        }
    }

    public void commitUpdate() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PzManageableTable.this.entitiesAdded != null) {
                    int i = 0;
                    while (i < PzManageableTable.this.entitiesAdded.size()) {
                        ((PzManageableTableModel)PzManageableTable.this.getModel()).update(PzManageableTable.this.convertRowIndexToModel((Integer)PzManageableTable.this.entitiesAddedIndexes.elementAt(i)), (PzEntity)PzManageableTable.this.entitiesAdded.elementAt(i));
                        ++i;
                    }
                    PzManageableTable.this.entitiesAdded.clear();
                    PzManageableTable.this.entitiesAdded = null;
                    PzManageableTable.this.entitiesAddedIndexes.clear();
                    PzManageableTable.this.entitiesAddedIndexes = null;
                }
                int row = PzManageableTable.this.getSelectedRow();
                ((PzManageableTableModel)PzManageableTable.this.getModel()).fireTableDataChanged();
                PzManageableTable.this.setRowSelectionInterval(row, row);
            }
        });
    }

    public void rollBack() {
        if (this.entitiesAdded != null) {
            this.entitiesAdded.clear();
            this.entitiesAdded = null;
        }
        if (this.entitiesAddedIndexes != null) {
            this.entitiesAddedIndexes.clear();
            this.entitiesAddedIndexes = null;
        }
    }

    public void setFilter(PzEntityFilter filter) {
        this.filter = filter;
        if (this.model != null) {
            this.model.setFilter(filter);
            this.model.fireTableStructureChanged();
            if (this.getRowCount() != 0) {
                this.setRowSelectionInterval(0, 0);
            }
        }
    }

    public PzEntityFilter getFilter() {
        return this.filter;
    }

    @Override
    public void setModel(TableModel model) {
        super.setModel(model);
        if (model instanceof PzManageableTableModel) {
            this.model = (PzManageableTableModel)model;
            if (this.filter != null) {
                ((PzManageableTableModel)model).setFilter(this.filter);
            }
            this.restoreState();
            if (this.getRowCount() != 0) {
                this.setRowSelectionInterval(0, 0);
            }
        }
    }

    public PzEntity getEntity(int index) {
        if (index != -1) {
            return ((PzManageableTableModel)this.getModel()).getEntity(this.convertRowIndexToModel(index));
        }
        return null;
    }

    public abstract void clear();

    @Override
    protected void initGUI() {
        super.initGUI();
        final PzManageableTable instance = this;
        this.getActionMap().put("ENTER", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((PzDialog)SwingUtilities.getRoot((Component)((Object)instance))).shouldCloseOnEnter()) {
                    PzTable.selectedEntity = PzManageableTable.this.getSelectedEntity();
                    PzManageableTable.this.closeDialog();
                }
            }
        });
        this.setMouseAction(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    PzManageableTable.this.getActionMap().get("ENTER").actionPerformed(new ActionEvent((Object)PzManageableTable.this, 123, null));
                }
            }
        });
    }

    public void switchIt() {
        if (this.model != null && this.model.getCheckBoxColumn() != -1 && this.getSelectedRow() != -1) {
            int[] selectedRows;
            int[] nArray = selectedRows = this.getSelectedRows();
            int n = selectedRows.length;
            int n2 = 0;
            while (n2 < n) {
                int row = nArray[n2];
                this.model.setRowChecked(this.convertRowIndexToModel(row), !this.model.isRowChecked(this.convertRowIndexToModel(row)));
                ++n2;
            }
        }
    }

    public synchronized void setRowChecked(int rowIndex, boolean checked) {
        if (this.model != null && this.model.getCheckBoxColumn() != -1) {
            this.model.setRowChecked(rowIndex, checked);
        }
    }

    public void setCheckboxColumn(int columnIndex, KeyStroke keyStroke) {
        this.columnIndex = columnIndex;
        if (this.getModel() instanceof PzManageableTableModel) {
            ((PzManageableTableModel)this.getModel()).setCheckBoxColumn(columnIndex);
        }
        this.getInputMap(1).put(keyStroke, "CHECKBOX_SWITCH");
        this.getActionMap().put("CHECKBOX_SWITCH", new AbstractAction(){
            private static final long serialVersionUID = -3143566263313007176L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PzManageableTable.this.switchIt();
            }
        });
        if (this.getColumn(this.convertColumnIndexToView(columnIndex)) != null) {
            this.getColumn(this.convertColumnIndexToView(columnIndex)).setMaxWidth(40);
            this.getColumn(this.convertColumnIndexToView(columnIndex)).setMinWidth(40);
            this.getColumn(this.convertColumnIndexToView(columnIndex)).setPreferredWidth(40);
        }
        this.setSelection();
    }

    public void setCheckboxColumn(int columnIndex, KeyStroke switchKS, KeyStroke checkAll, KeyStroke unCheckAll, KeyStroke inverse) {
        this.setCheckboxColumn(columnIndex, switchKS);
        this.getInputMap(1).put(checkAll, "CHECKBOX_CHECK_ALL");
        this.getActionMap().put("CHECKBOX_CHECK_ALL", new AbstractAction(){
            private static final long serialVersionUID = -8674121335496681667L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PzManageableTable.this.checkAll();
            }
        });
        this.getInputMap(1).put(unCheckAll, "CHECKBOX_UNCHECK_ALL");
        this.getActionMap().put("CHECKBOX_UNCHECK_ALL", new AbstractAction(){
            private static final long serialVersionUID = -8431106924756435830L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PzManageableTable.this.unCheckAll();
            }
        });
        this.getInputMap(1).put(inverse, "CHECKBOX_INVERSE");
        this.getActionMap().put("CHECKBOX_INVERSE", new AbstractAction(){
            private static final long serialVersionUID = 9145368122228254635L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PzManageableTable.this.inverseCheck();
            }
        });
    }

    public void setCheckboxColumn(int columnIndex) {
        this.setCheckboxColumn(columnIndex, KeyStroke.getKeyStroke(113, 0), KeyStroke.getKeyStroke(113, 512), KeyStroke.getKeyStroke(113, 128), KeyStroke.getKeyStroke(113, 640));
    }

    public int getCheckboxColumn() {
        if (this.getModel() instanceof PzManageableTableModel) {
            return ((PzManageableTableModel)this.getModel()).getCheckBoxColumn();
        }
        return this.columnIndex;
    }

    public boolean isRowChecked(int rowIndex) {
        if (this.getCheckboxColumn() != -1) {
            return (Boolean)this.model.getValueAt(rowIndex, this.getCheckboxColumn());
        }
        return false;
    }

    public List getCheckedEntities() {
        return this.model.getCheckedEntities();
    }

    public void checkAll() {
        if (this.getCheckboxColumn() != -1) {
            int i = 0;
            while (i < this.model.getRowCount()) {
                if (this.convertRowIndexToView(i) != -1) {
                    this.model.setRowChecked(i, true);
                }
                ++i;
            }
        }
    }

    public void unCheckAll() {
        if (this.getCheckboxColumn() != -1) {
            int i = 0;
            while (i < this.model.getRowCount()) {
                if (this.convertRowIndexToView(i) != -1) {
                    this.model.setRowChecked(i, false);
                }
                ++i;
            }
        }
    }

    public void inverseCheck() {
        if (this.getCheckboxColumn() != -1) {
            int i = 0;
            while (i < this.model.getRowCount()) {
                if (this.convertRowIndexToView(i) != -1) {
                    this.model.setRowChecked(i, !this.model.isRowChecked(i));
                }
                ++i;
            }
        }
    }

    public void addCheckboxListener(PzTableCheckboxListener listener) {
        if (this.model != null) {
            this.model.addCheckboxListener(listener);
        }
    }

    public void removeCheckboxListener(PzTableCheckboxListener listener) {
        if (this.model != null) {
            this.model.removeCheckBoxListener(listener);
        }
    }

    protected void setSelection() {
        try {
            this.setRowSelectionInterval(0, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

