/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.jdesktop.swingx.JXLabel;
import rs.pezar.swing.PzPanel;

public class PzExceptionPanel
extends PzPanel {
    private static final long serialVersionUID = -6897440378521365781L;
    private JScrollPane scrollPane;
    private String message;
    private Throwable throwable;
    private JTextArea textArea;
    private JXLabel lblGreska;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new PzExceptionPanel("", null));
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public PzExceptionPanel(String message, Throwable t) {
        this.message = message;
        this.throwable = t;
        this.initGUI();
    }

    private void initGUI() {
        this.setOpaque(false);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[2];
        gridBagLayout.rowHeights = new int[4];
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 1.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JButton btnNewButton = new JButton("Detaljno >");
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PzExceptionPanel.this.detaljno();
            }
        });
        this.lblGreska = new JXLabel(this.message);
        this.lblGreska.setTextAlignment(JXLabel.TextAlignment.LEFT);
        this.lblGreska.setLineWrap(true);
        this.lblGreska.setIcon((Icon)new ImageIcon(PzExceptionPanel.class.getResource("/rs/pezar/swing/resources/img/forbidden.png")));
        this.lblGreska.setText("Gre\u0161ka  asda  dsasdasda sadsasdad sasdasd dsadasd asdasd ");
        GridBagConstraints gbc_lblGreska = new GridBagConstraints();
        gbc_lblGreska.insets = new Insets(0, 0, 5, 0);
        gbc_lblGreska.fill = 2;
        gbc_lblGreska.gridx = 0;
        gbc_lblGreska.gridy = 0;
        this.add((Component)this.lblGreska, gbc_lblGreska);
        GridBagConstraints gbc_btnNewButton = new GridBagConstraints();
        gbc_btnNewButton.anchor = 13;
        gbc_btnNewButton.insets = new Insets(0, 0, 5, 0);
        gbc_btnNewButton.gridx = 0;
        gbc_btnNewButton.gridy = 1;
        this.add((Component)btnNewButton, gbc_btnNewButton);
        this.scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 2;
        this.add((Component)this.scrollPane, gbc_scrollPane);
        this.textArea = new JTextArea();
        this.scrollPane.setViewportView(this.textArea);
        this.scrollPane.setVisible(false);
        this.printStackTrace();
    }

    private void printStackTrace() {
        if (this.throwable == null) {
            return;
        }
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        this.throwable.printStackTrace(printWriter);
        this.textArea.setText(((Object)result).toString());
    }

    protected void detaljno() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzExceptionPanel.this.scrollPane.setVisible(!PzExceptionPanel.this.scrollPane.isVisible());
                PzExceptionPanel.this.validate();
            }
        });
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String msg) {
        this.message = msg;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzExceptionPanel.this.lblGreska.setText(PzExceptionPanel.this.message);
            }
        });
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setThrowable(Throwable t) {
        this.throwable = t;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzExceptionPanel.this.printStackTrace();
            }
        });
    }
}

