/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.swing;

import java.awt.Color;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.KeyStroke;

public class PzButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private InputMap map;
    private String shortcut;

    public PzButton() {
        this.registerKeyboardAction(this.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, false)), KeyStroke.getKeyStroke(10, 0, false), 0);
        this.registerKeyboardAction(this.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, true)), KeyStroke.getKeyStroke(10, 0, true), 0);
    }

    public PzButton(String text) {
        super(text);
        this.registerKeyboardAction(this.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, false)), KeyStroke.getKeyStroke(10, 0, false), 0);
        this.registerKeyboardAction(this.getActionForKeyStroke(KeyStroke.getKeyStroke(32, 0, true)), KeyStroke.getKeyStroke(10, 0, true), 0);
    }

    @Override
    public void setText(String text) {
        if (text == null) {
            return;
        }
        if (text.indexOf("|") != -1) {
            text = text.replaceAll("\\|", "<br/>");
        }
        text = "<html><body><center>" + text + "</center></body></html>";
        super.setText(text);
    }

    public void setShortcut(String keys) {
        this.shortcut = keys;
        String[] key = keys.split("\\+");
        String keyStrokeStr = "";
        String separator = " ";
        int i = 0;
        while (i < key.length) {
            if (i == key.length - 1) {
                separator = "";
            }
            if (key[i].equalsIgnoreCase("alt") || key[i].equalsIgnoreCase("ctrl") || key[i].equalsIgnoreCase("shift")) {
                if (key[i].equalsIgnoreCase("ctrl")) {
                    key[i] = "control";
                }
                key[i] = key[i].toLowerCase();
            } else {
                key[i] = key[i].equalsIgnoreCase("backspace") ? "BACK_SPACE" : key[i].toUpperCase();
            }
            key[i] = String.valueOf(key[i]) + separator;
            keyStrokeStr = String.valueOf(keyStrokeStr) + key[i];
            ++i;
        }
        this.map = this.getInputMap(2);
        KeyStroke stroke = KeyStroke.getKeyStroke(keyStrokeStr);
        this.map.put(stroke, keys);
        if (this.getActionListeners() != null && this.getActionListeners().length > 0) {
            this.getActionMap().put(keys, (Action)this.getActionListeners()[0]);
        }
    }

    @Override
    public void addActionListener(ActionListener arg0) {
        super.addActionListener(arg0);
        if (this.shortcut != null) {
            this.getActionMap().put(this.shortcut, (Action)this.getActionListeners()[0]);
        }
    }

    @Override
    public void setEnabled(boolean arg0) {
        if (arg0) {
            this.setForeground(new Color(0, 0, 0));
        } else {
            this.setForeground(new Color(128, 128, 128));
        }
        super.setEnabled(arg0);
    }
}

