/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Transient;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Kalkulacijazapisnik;
import rs.pezar.db.entity.Opstidokument;
import rs.pezar.db.entity.Tarifnagrupa;

@Entity
@DiscriminatorValue(value="ZAPISNIK_OTPREMNICE")
public class Zapisnik
extends Opstidokument
implements Serializable,
PzEntity {
    private static final long serialVersionUID = 1L;
    @Column(name="dbl1")
    private BigDecimal brutoIznos = new BigDecimal(0);
    @Column(name="dbl2")
    private BigDecimal uplata = new BigDecimal(0);
    @Column(name="dbl3")
    private BigDecimal printIndicator = new BigDecimal(0);
    @Column(name="str3")
    private String rBrDokumenta;
    @Column(name="str1")
    private String pdv;
    @Column(name="str2")
    private String oznKomitenta;
    @Column(name="int1")
    private int valuta;
    @Column(name="int2")
    private int kalkulacijaId;
    @Column(name="date1")
    private Date datFakture;
    @Column(name="date2")
    private Date datumDPO;
    @Transient
    private BigDecimal zatvaranje = new BigDecimal(0);

    public BigDecimal getBrutoIznos() {
        return this.brutoIznos;
    }

    public void setBrutoIznos(BigDecimal brutoIznos) {
        this.brutoIznos = brutoIznos;
    }

    public String getPdv() {
        return this.pdv;
    }

    public void setPdv(String pdv) {
        this.pdv = pdv;
    }

    public int getValuta() {
        return this.valuta;
    }

    public void setValuta(int valuta) {
        this.valuta = valuta;
    }

    public Date getDatFakture() {
        return this.datFakture;
    }

    public void setDatFakture(Date datFakture) {
        this.datFakture = datFakture;
    }

    public Date getDatumDPO() {
        return this.datumDPO;
    }

    public void setDatumDPO(Date datumDPO) {
        this.datumDPO = datumDPO;
    }

    public BigDecimal getUplata() {
        return this.uplata;
    }

    public void setUplata(BigDecimal uplate) {
        this.uplata = uplate;
    }

    public BigDecimal getZatvaranje() {
        return this.zatvaranje;
    }

    public void setZatvaranje(BigDecimal zatvaranje) {
        this.zatvaranje = zatvaranje;
    }

    public int getKalkulacijaId() {
        return this.kalkulacijaId;
    }

    public void setKalkulacijaId(int kalkulacijaId) {
        this.kalkulacijaId = kalkulacijaId;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"\u0160ifra dob.", "Naziv dob.", "Br. zapisnika", "Datum zapisnika", "Iznos", "RJ"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.getKomitent().getSfrKomitent(), this.getKomitent().getNaziv(), this.getOznDokumenta(), this.getDatum(), this.getBrutoIznos(), String.valueOf(this.getRadnajedinica().getId().getOznOgranak()) + "/" + this.getRadnajedinica().getId().getOznRj()};
    }

    public String[] getColumnArhivaNames() {
        return new String[]{"idDok", "Dokument", "Dobavlja\u010d", "Datum izrade", "Datum dokumenta", "Iznos dokumenta", "PDV"};
    }

    @Override
    public void formirajOznaku() {
    }

    @Override
    public void adjust() {
    }

    public void addKalkulacija(Kalkulacija k, BigDecimal fakturisano, Kalkulacijazapisnik kz) {
        EntityManager em = PzEntityManager.getEm();
        em.getTransaction().begin();
        try {
            Kalkulacija updateKalk = (Kalkulacija)em.find(Kalkulacija.class, (Object)k.getIdDok());
            updateKalk.setUkupnoFakturisano(updateKalk.getUkupnoFakturisano().add(fakturisano));
            em.getTransaction().commit();
            em.clear();
            em.close();
        }
        catch (Exception e) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            e.printStackTrace();
        }
    }

    public Kalkulacijazapisnik updateKalkulacija(Kalkulacijazapisnik kz, BigDecimal fakturisano) {
        EntityManager em = PzEntityManager.getEm();
        Kalkulacijazapisnik updateKZ = null;
        try {
            em.getTransaction().begin();
            updateKZ = (Kalkulacijazapisnik)em.find(Kalkulacijazapisnik.class, (Object)kz.getId());
            Kalkulacija updateKalk = (Kalkulacija)em.find(Kalkulacija.class, (Object)kz.getKalkulacija().getIdDok());
            updateKZ.setFakturisano(fakturisano);
            updateKalk.setUkupnoFakturisano(updateKalk.getUkupnoFakturisano().subtract(kz.getFakturisano()).add(fakturisano));
            em.getTransaction().commit();
            em.clear();
            em.close();
        }
        catch (Exception e) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            e.printStackTrace();
        }
        return updateKZ;
    }

    public void removeKalkulacija(Kalkulacijazapisnik kz) {
        EntityManager em = PzEntityManager.getEm();
        try {
            em.getTransaction().begin();
            Kalkulacijazapisnik removeKZ = (Kalkulacijazapisnik)em.find(Kalkulacijazapisnik.class, (Object)kz.getId());
            em.remove((Object)removeKZ);
            Kalkulacija kalk = (Kalkulacija)em.find(Kalkulacija.class, (Object)kz.getKalkulacija().getIdDok());
            kalk.setUkupnoFakturisano(kalk.getUkupnoFakturisano().subtract(kz.getFakturisano()));
            em.getTransaction().commit();
            em.clear();
            em.close();
        }
        catch (Exception e) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            e.printStackTrace();
        }
    }

    @Override
    public boolean obracunavaSePorez(Tarifnagrupa tg, String tip) {
        return false;
    }

    public void setOznKomitenta(String oznKomitenta) {
        this.oznKomitenta = oznKomitenta;
    }

    public String getOznKomitenta() {
        return this.oznKomitenta;
    }

    public BigDecimal getPrintIndicator() {
        return this.printIndicator;
    }

    public void setPrintIndicator(BigDecimal printIndicator) {
        this.printIndicator = printIndicator;
    }

    public String getrBrDokumenta() {
        return this.rBrDokumenta;
    }

    public void setrBrDokumenta(String rBrDokumenta) {
        this.rBrDokumenta = rBrDokumenta;
    }
}

