/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.eclipse.persistence.indirection.IndirectList;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Proizvod;
import rs.pezar.db.entity.Stavkafaktureusl;
import rs.pezar.db.entity.Tarifnagrupa;
import rs.pezar.db.entity.Uslugafaktura;

@Entity
@Table(name="Usluga")
public class Usluga
implements PzEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(unique=true, nullable=false, length=255)
    private String sfrProizvod;
    @Column(nullable=false)
    private double brNormaSati;
    @Column(nullable=false)
    private double cena;
    @Column(nullable=false, length=255)
    private String naziv;
    @OneToMany(mappedBy="usluga")
    private List<Uslugafaktura> uslugafakturas;
    @OneToMany(mappedBy="usluga")
    private List<Stavkafaktureusl> stavkafaktureusls;
    @ManyToMany
    @JoinTable(name="TGUsluga", joinColumns={@JoinColumn(name="sfrProizvod", nullable=false)}, inverseJoinColumns={@JoinColumn(name="oznTarGr", nullable=false)})
    private List<Tarifnagrupa> tarifnagrupas;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="sfrProizvod", nullable=false, insertable=false, updatable=false)
    private Proizvod proizvod;

    public Usluga(String sfrProizvod, double brNormaSati, double cena, String naziv, Tarifnagrupa tarifnagrupa, Proizvod proizvod) {
        this.sfrProizvod = sfrProizvod;
        this.brNormaSati = brNormaSati;
        this.cena = cena;
        this.naziv = naziv;
        this.tarifnagrupas = new IndirectList();
        this.tarifnagrupas.add(tarifnagrupa);
        this.proizvod = proizvod;
    }

    public Usluga() {
    }

    public String getSfrProizvod() {
        return this.sfrProizvod;
    }

    public void setSfrProizvod(String sfrProizvod) {
        this.sfrProizvod = sfrProizvod;
    }

    public double getBrNormaSati() {
        return this.brNormaSati;
    }

    public void setBrNormaSati(double brNormaSati) {
        this.brNormaSati = brNormaSati;
    }

    public double getCena() {
        return this.cena;
    }

    public void setCena(double cena) {
        this.cena = cena;
    }

    public String getNaziv() {
        return this.naziv;
    }

    public void setNaziv(String naziv) {
        this.naziv = naziv;
    }

    public List<Stavkafaktureusl> getStavkafaktureusls() {
        return this.stavkafaktureusls;
    }

    public void setStavkafaktureusls(List<Stavkafaktureusl> stavkafaktureusls) {
        this.stavkafaktureusls = stavkafaktureusls;
    }

    public List<Tarifnagrupa> getTarifnagrupas() {
        return this.tarifnagrupas;
    }

    public void setTarifnagrupas(List<Tarifnagrupa> tarifnagrupas) {
        this.tarifnagrupas = tarifnagrupas;
    }

    public List<Uslugafaktura> getUslugafakturas() {
        return this.uslugafakturas;
    }

    public void setUslugafakturas(List<Uslugafaktura> uslugafakturas) {
        this.uslugafakturas = uslugafakturas;
    }

    public Proizvod getProizvod() {
        return this.proizvod;
    }

    public void setProizvod(Proizvod proizvod) {
        this.proizvod = proizvod;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"\u0160ifra", "Naziv", "Cena", "Norma sati"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.sfrProizvod, this.naziv, this.cena, this.brNormaSati};
    }

    public Tarifnagrupa getTarifnaGrupa(String vrsta) {
        Tarifnagrupa result = null;
        for (Tarifnagrupa tgr : this.tarifnagrupas) {
            if (!tgr.getVrstatg().getOznVrstaTG().equals(vrsta)) continue;
            result = tgr;
            break;
        }
        return result;
    }

    public double getStopa(String vrsta) {
        Tarifnagrupa tgr = this.getTarifnaGrupa(vrsta);
        if (tgr == null) {
            return 0.0;
        }
        return tgr.getStopa();
    }

    public double getUkupnaStopa() {
        double result = 0.0;
        for (Tarifnagrupa tg : this.getTarifnagrupas()) {
            result += tg.getStopa();
        }
        return result;
    }
}

