/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.TaksainterniracunPK;
import rs.pezar.db.entity.Tarifnagrupa;

@Entity
@Table(name="TaksaInterniRacun")
public class Taksainterniracun
extends PzTaksaDokument
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private TaksainterniracunPK id;
    @Column(nullable=false)
    private BigDecimal iznos = new BigDecimal(0);
    @Column(nullable=false)
    private BigDecimal osnovica = new BigDecimal(0);
    @Column(nullable=false, length=15)
    private String vrsta;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idDok", nullable=false, insertable=false, updatable=false)
    private Interniracun interniracun;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="oznTarGr", nullable=false, insertable=false, updatable=false)
    private Tarifnagrupa tarifnagrupa;

    public Taksainterniracun() {
    }

    public Taksainterniracun(int idDok, String tip, String oznTarGr) {
        this.setId(new TaksainterniracunPK(oznTarGr, idDok, tip));
    }

    public TaksainterniracunPK getId() {
        return this.id;
    }

    public void setId(TaksainterniracunPK id) {
        this.id = id;
    }

    @Override
    public BigDecimal getIznos() {
        return this.iznos;
    }

    @Override
    public void setIznos(BigDecimal iznos) {
        this.iznos = iznos;
    }

    @Override
    public BigDecimal getOsnovica() {
        return this.osnovica;
    }

    @Override
    public void setOsnovica(BigDecimal osnovica) {
        this.osnovica = osnovica;
    }

    @Override
    public String getVrsta() {
        return this.vrsta;
    }

    @Override
    public void setVrsta(String vrsta) {
        this.vrsta = vrsta;
    }

    public Interniracun getInterniracun() {
        return this.interniracun;
    }

    public void setInterniracun(Interniracun interniracun) {
        this.interniracun = interniracun;
    }

    @Override
    public Tarifnagrupa getTarifnagrupa() {
        return this.tarifnagrupa;
    }

    @Override
    public void setTarifnagrupa(Tarifnagrupa tarifnagrupa) {
        this.tarifnagrupa = tarifnagrupa;
    }

    public BigDecimal getObracunatiIznos() {
        return this.iznos.add(this.osnovica);
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Tarifna grupa", "Stopa PDV-a", "Osnovica", "Iznos"};
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.tarifnagrupa.getOznTarGr(), this.tarifnagrupa.getStopa(), this.osnovica, this.iznos};
    }

    @Override
    public PzDokument getDokument() {
        return this.getInterniracun();
    }

    @Override
    public String getTip() {
        return this.id.getTip();
    }

    @Override
    public void setDokument(PzDokument dokument) {
        this.setInterniracun((Interniracun)dokument);
    }

    @Override
    public void setTip(String tip) {
        this.id.setTip(tip);
    }

    @Override
    public void setId(String oznTarGr, int idDok, String tip) {
        this.setId(new TaksainterniracunPK(oznTarGr, idDok, tip));
    }
}

