/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.persistence.annotations.PrivateOwned;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.ShemaPK;
import rs.pezar.db.entity.Stavkasheme;
import rs.pezar.globals.TipDokumentConfig;

@XmlRootElement
@Entity
public class Shema
implements Serializable,
PzEntity {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private ShemaPK id;
    private short abstrakt;
    private String cena;
    private String opis;
    private String opisKnjizenja;
    private Integer rBroj;
    private Integer zatvori;
    @OneToMany(mappedBy="shema", cascade={CascadeType.ALL})
    @PrivateOwned
    @OrderBy(value="id.rBroj ASC")
    private List<Stavkasheme> stavkashemes;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="shemanasledjuje", joinColumns={@JoinColumn(name="oznOgranak", referencedColumnName="OZNOGRANAK"), @JoinColumn(name="oznRj", referencedColumnName="OZNRJ"), @JoinColumn(name="podTipDok", referencedColumnName="PODTIPDOK"), @JoinColumn(name="ppTipRj", referencedColumnName="PPTIPRJ"), @JoinColumn(name="pTipRj", referencedColumnName="PTIPRJ"), @JoinColumn(name="tipDok", referencedColumnName="TIPDOK"), @JoinColumn(name="tipRj", referencedColumnName="TIPRJ")}, inverseJoinColumns={@JoinColumn(name="nadOznOgranak", referencedColumnName="OZNOGRANAK"), @JoinColumn(name="nadOznRj", referencedColumnName="OZNRJ"), @JoinColumn(name="nadPodTipDok", referencedColumnName="PODTIPDOK"), @JoinColumn(name="nadPpTiprj", referencedColumnName="PPTIPRJ"), @JoinColumn(name="nadPTipRj", referencedColumnName="PTIPRJ"), @JoinColumn(name="nadTipDok", referencedColumnName="TIPDOK"), @JoinColumn(name="nadTipRj", referencedColumnName="TIPRJ")})
    private List<Shema> nadSheme;
    @ManyToMany(mappedBy="nadSheme")
    private List<Shema> podSheme;

    @XmlElement
    public ShemaPK getId() {
        return this.id;
    }

    public void setId(ShemaPK id) {
        this.id = id;
    }

    public short getAbstrakt() {
        return this.abstrakt;
    }

    public void setAbstrakt(short abstrakt) {
        this.abstrakt = abstrakt;
    }

    public String getCena() {
        return this.cena;
    }

    public void setCena(String cena) {
        this.cena = cena;
    }

    @XmlElement
    public String getOpis() {
        return this.opis;
    }

    public void setOpis(String opis) {
        this.opis = opis;
    }

    @XmlElement
    public String getOpisKnjizenja() {
        return this.opisKnjizenja;
    }

    public void setOpisKnjizenja(String opisStav) {
        this.opisKnjizenja = opisStav;
    }

    @XmlElement
    public Integer getrBroj() {
        return this.rBroj;
    }

    public void setrBroj(Integer rbroj) {
        this.rBroj = rbroj;
    }

    @XmlElement
    public Integer getZatvori() {
        return this.zatvori;
    }

    public void setZatvori(Integer zatvori) {
        this.zatvori = zatvori;
    }

    @XmlElementWrapper
    @XmlElement(name="stavka")
    public List<Stavkasheme> getStavkashemes() {
        return this.stavkashemes;
    }

    public void setStavkashemes(List<Stavkasheme> stavkashemes) {
        this.stavkashemes = stavkashemes;
    }

    @XmlElement
    public List<Shema> getNadSheme() {
        return this.nadSheme;
    }

    public void setNadSheme(List<Shema> nadSheme) {
        this.nadSheme = nadSheme;
    }

    @XmlTransient
    public List<Shema> getPodSheme() {
        return this.podSheme;
    }

    public void setPodSheme(List<Shema> podSheme) {
        this.podSheme = podSheme;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Opis", "Tip dokumenta", "Podtip dokumenta", "Tip RJ", "Oznaka ogranka", "Oznaka RJ", "Zatvara nalog"};
    }

    @Override
    public Object[] getValues() {
        String zatvara = "NE";
        if (this.zatvori == 1) {
            zatvara = "DA";
        }
        return new Object[]{this.opis, TipDokumentConfig.getNameByValue(this.id.getTipDok(), null), TipDokumentConfig.getNameByValue(this.id.getTipDok(), this.id.getPodTipDok()), String.valueOf(this.id.getTipRj()) + this.id.getpTipRj() + this.id.getPpTipRj(), this.id.getOznOgranak(), this.id.getOznRj(), zatvara};
    }

    public String toString() {
        return this.opis;
    }

    public String getOpisknjizenjaFull() {
        String txt = this.getOpisKnjizenja();
        if (this.getNadSheme() != null && this.getNadSheme().size() > 0) {
            for (Shema ns : this.nadSheme) {
                txt = String.valueOf(ns.getOpisknjizenjaFull()) + txt;
            }
        }
        return txt;
    }
}

