/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.db.entity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Fakturausluga;
import rs.pezar.db.entity.PutniTrosakPK;

@Entity
@Table(name="PutniTrosak")
public class PutniTrosak
implements Serializable,
PzEntity {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    private PutniTrosakPK id;
    private Date datum;
    private BigDecimal kmOvamo;
    private BigDecimal kmTamo;
    private BigDecimal litarGoriva;
    private BigDecimal potrosnjaNa100;
    private String relacija;
    private BigDecimal vrednost;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="idDok", nullable=false, insertable=false, updatable=false)
    private Fakturausluga fakturausluga;

    public PutniTrosakPK getId() {
        return this.id;
    }

    public void setId(PutniTrosakPK id) {
        this.id = id;
    }

    public Date getDatum() {
        return this.datum;
    }

    public void setDatum(Date datum) {
        this.datum = datum;
    }

    public BigDecimal getKmOvamo() {
        return this.kmOvamo;
    }

    public void setKmOvamo(BigDecimal kmovamo) {
        this.kmOvamo = kmovamo;
    }

    public BigDecimal getKmTamo() {
        return this.kmTamo;
    }

    public void setKmTamo(BigDecimal kmtamo) {
        this.kmTamo = kmtamo;
    }

    public BigDecimal getLitarGoriva() {
        return this.litarGoriva;
    }

    public void setLitarGoriva(BigDecimal litargoriva) {
        this.litarGoriva = litargoriva;
    }

    public BigDecimal getPotrosnjaNa100() {
        return this.potrosnjaNa100;
    }

    public void setPotrosnjaNa100(BigDecimal potrosnjana100) {
        this.potrosnjaNa100 = potrosnjana100;
    }

    public String getRelacija() {
        return this.relacija;
    }

    public void setRelacija(String relacija) {
        this.relacija = relacija;
    }

    public BigDecimal getVrednost() {
        return this.vrednost;
    }

    public void setVrednost(BigDecimal vrednost) {
        this.vrednost = vrednost;
    }

    public Fakturausluga getFakturausluga() {
        return this.fakturausluga;
    }

    public void setFakturausluga(Fakturausluga fakturausluga) {
        this.fakturausluga = fakturausluga;
    }

    @Override
    public Object[] getValues() {
        return new Object[]{this.relacija, this.datum, this.kmTamo, this.kmOvamo, this.kmTamo.add(this.kmOvamo), this.litarGoriva, this.potrosnjaNa100, this.vrednost};
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Relacija", "Datum", "KM u odlasku", "KM u povratku", "<html>Ukupno KM <br> pre\u0111eno</html>", "<html>Cena litra <br> goriva</html>", "<html>Potro\u0161nja <br> na 100KM</html>", "Vrednost"};
    }

    public void calculateVrednost() {
        this.vrednost = this.kmTamo.add(this.kmOvamo).multiply(this.potrosnjaNa100.divide(new BigDecimal(100))).multiply(this.litarGoriva).setScale(2, 4);
    }
}

